/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	saio.h,v $
 * Revision 2.2  88/08/06  19:12:21  rpd
 * Reverted to ACIS version.
 * 
 */

#ifndef	_STANDCA_SAIO_H
#define	_STANDCA_SAIO_H	1

/* $Header: saio.h,v 2.2 88/08/06 19:12:21 rpd Exp $ */
/* $ACIS:saio.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/saio.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsaio = "$Header: saio.h,v 2.2 88/08/06 19:12:21 rpd Exp $";
#endif

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*	saio.h	6.2	9/23/83	*/
#ifndef F_READ		/* handle multiple includes */

/*
 * Header file for standalone package
 */

/*
 * Io block: includes an
 * inode, cells for the use of seek, etc,
 * and a buffer.
 */
struct iob {
	int i_flgs;		       /* see F_ below */
	struct inode i_ino;	       /* inode, if file */
	int i_unit;		       /* pseudo device unit */
	daddr_t i_boff;		       /* block offset on device */
	daddr_t i_cyloff;	       /* cylinder offset on device */
	off_t i_offset;		       /* seek offset in file */
	daddr_t i_bn;		       /* 1st block # of next read */
	char *i_ma;		       /* memory address of i/o buffer */
	int i_cc;		       /* character count of transfer */
	int i_error;		       /* error # return */
	int i_errcnt;		       /* error count for driver retries */
	int i_errblk;		       /* block # in error for error reporting */
	char i_buf[MAXBSIZE];	       /* i/o buffer */
	union {
		struct fs ui_fs;       /* file system super block info */
		char dummy[SBSIZE];
	} i_un;
};
#define i_fs i_un.ui_fs
#define NULL 0

/* portable flag bits */

#define F_READ		0x1	       /* file opened for reading */
#define F_WRITE		0x2	       /* file opened for writing */
#define F_ALLOC		0x4	       /* buffer allocated */
#define F_FILE		0x8	       /* file instead of device */
#define F_NBSF		0x10	       /* no bad sector forwarding */
#define F_SEVRE		0x80	       /* Severe burnin (no retries, no ECC) */

/* io types */

#define F_RDDATA        0x0100	       /* read data */
#define F_WRDATA        0x0200	       /* write data */

#ifdef ibm032
#define F_FORMAT        0x0400	       /* format track on next i/o */
#define F_VERIFY        0x0800	       /* verify data on next i/o */
#else
#define F_ECCLM         0x20	       /* limit # of bits in ecc correction */
#define F_SSI           0x40	       /* set skip sector inhibit */
#define F_HDR           0x0400	       /* include header on next i/o */
#define F_CHECK         0x0800	       /* perform check of data read/write */
#define F_HCHECK        0x1000	       /* perform check of header and data */
#endif ibm032

#define	F_TYPEMASK	0xff00

/*
 * Device switch.
 */
struct devsw {
	char *dv_name;
	int (*dv_strategy)();
	int (*dv_open)();
	int (*dv_close)();
	int (*dv_ioctl)();
};

struct devsw devsw[];

/*
 * Drive description table.
 * Returned from SAIODEVDATA call.
 * Passed to SAIOWDEVDATA ioctl.
 */
struct st {
	short nsect;		       /* # sectors/track */
	short ntrak;		       /* # tracks/surfaces/heads */
	short nspc;		       /* # sectors/cylinder */
	short ncyl;		       /* # cylinders */
	short steprate;		       /* Minimum stepping rate */
	short precompcyl;	       /* Cylinder at which to start precomp */
	short *off;		       /* partition offset table (cylinders) */
	short nbps;		       /* number of bytes/sector */
	char adap;		/* adapter type drive attached to */
};

/*
 * Request codes. Must be the same a F_XXX above
 */
#define	READ	1
#define	WRITE	2

#define	NBUFS	4

char b[NBUFS][MAXBSIZE];
daddr_t blknos[NBUFS];

#define	NFILES	4
struct iob iob[NFILES];

extern int errno;		       /* just like unix */

/* error codes */
#define	EBADF	1		       /* bad file descriptor */
#define	EOFFSET	2		       /* relative seek not supported */
#define	EDEV	3		       /* improper device specification on open */
#define	ENXIO	4		       /* unknown device specified */
#define	EUNIT	5		       /* improper unit specification */
#define	ESRCH	6		       /* directory search for file failed */
#define	EIO	7		       /* generic error */
#define	ECMD	10		       /* undefined driver command */
#define	EBSE	11		       /* bad sector error */
#define	EWCK	12		       /* write check error */
#define	EECC	13		       /* uncorrectable ecc error */
#define	EHER	14		       /* hard error */

/* ioctl's -- for disks just now */

#define SAIOFORMAT	(('d'<<8)|1)   /* next i/o formats a track */
#define SAIOVERIFY      (('d'<<8)|2)   /* next i/o verifies a track */
#define SAIONOBAD       (('d'<<8)|3)   /* inhibit bad sector forwarding */
#define SAIODOBAD       (('d'<<8)|4)   /* enable bad sector forwarding */
#define SAIODEVDATA     (('d'<<8)|5)   /* get device data */
#define SAIODEBUG       (('d'<<8)|6)   /* enable/disable debugging */
#define SAIOSEVRE       (('d'<<8)|7)   /* severe burnin, no ECC, no retries */
#define SAIONSEVRE      (('d'<<8)|8)   /* clear severe burnin */
#define SAIOECCMSGS     (('d'<<8)|9)   /* enable/disable printing of */
#define SAIOWDEVDATA    (('d'<<8)|10)  /* set device data */

/* bits defined for SAIOFORMAT */

#define	FMT_BAD		0x80
#define	FMT_HIDDEN	0x40

 /*   ECC error messages */

/* codes for sector header word 1 */
#define	HDR1_FMT22	0x1000	       /* standard 16 bit format */
#define	HDR1_OKSCT	0xc000	       /* sector ok */
#define	HDR1_SSF	0x2000	       /* skip sector flag */

#endif F_READ

#endif	_STANDCA_SAIO_H
