/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	sari.h,v $
 * Revision 2.2  88/08/06  19:12:47  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_SARI_H
#define	_STANDCA_SARI_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: sari.h,v 2.2 88/08/06 19:12:47 rpd Exp $ */
/* $ACIS:sari.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/sari.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsari = "$Header: sari.h,v 2.2 88/08/06 19:12:47 rpd Exp $";
#endif

/* sari.h -- standalone constants for the IBM RI */

#define CTL(x) ('x'&037)	/* get a control character */
#define min(x,y) x < y ? x : y
#define max(x,y) x > y ? x : y

#define IO_BASE 0xf0000000	       /* I/O base address */

#define in(port) * (( char *) (IO_BASE + (port)))
#define out(port,value) in(port) = value
 /* output a PC word (= short) */
#define inw(port) * (( short *) (IO_BASE + (port)))
#define outw(port,value) inw(port) = value

#define CRT_1 0x3b8		       /* crt port 1 */
#define PUT_SCR_REG(reg,value) out(0x3b4,reg); out(0x3b5,value);

#ifdef DEBUG
#define LOCAL			       /* make it external */
#else
#define LOCAL	static		       /* make it local */
#endif

#define    _CDB        0x8ce0	       /* Hex Display Register  */

#endif	_STANDCA_SARI_H
