/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	setvec.s
 *
 * HISTORY
 * $Log:	setvec.s,v $
 * Revision 2.2  88/08/06  19:14:17  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#include "asm.h"

 # /* $Header: setvec.s,v 2.2 88/08/06 19:14:17 rpd Exp $ */
 # /* $ACIS:setvec.s 9.0$ */
 # /* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/setvec.s,v $ */

	.data
rcsid:	.asciz	"$Header: setvec.s,v 2.2 88/08/06 19:14:17 rpd Exp $"
	.text

 #
 #
 # routine to service an interrupt
 #
	.set	INTSTACK , 0x40	 # register save + 3 args
	.set	vec3 , 0x130
	.globl _int3
_int3:
xint3:
	ai	r1,r1,-INTSTACK	 # make room on stack
	stm	r0,0(r1)	 # save all registers
	mfs	scr_mq,r10	 # get the mq
	l	r2,vec3(r0)
	l	r3,vec3+4(r0)
	cas	r4,r1,r0		 # saved registers
	j	addr3
	.align	2
addr3:	bala	0
	mts	scr_mq,r10	 # restore the MQ
	lm	r0,0(r1)		 # reload the registers
	ai	sp,sp,INTSTACK	 # adjust the stack
	lps	0,vec3(r0)		 # and return from interrupt
	.set	vec4 , 0x140
	.globl	_int4
_int4:
xint4:
	ai	r1,r1,-INTSTACK	 # make room on stack
	stm	r0,0(r1)	 # save all registers
	mfs	scr_mq,r10	 # get the mq
	l	r2,vec4(r0)
	l	r3,vec4+4(r0)
	cas	r4,r1,r0		 # saved registers
	j	addr4
	.align	2
addr4:	bala	0
	mts	scr_mq,r10	 # restore the MQ
	lm	r0,0(r1)		 # reload the registers
	ai	sp,sp,INTSTACK		 # adjust the stack
	lps	0,vec4(r0)		 # and return from interrupt

 # setvec(n,addr) set interrupt vector n to call "addr"
 # r2 = n
 # r3 = addr
eye_profil(setvec):
	bali	r4,1f
1:	.using	1b,r4
	oiu	r3,r0,0x8a00	 # a bala op code
	cis	r2,3
	jeq	set3
	cis	r2,4
	jeq	set4
	tgte	r2,r2		 # n is not 3 or 4
	br	r15
set3:
	st	r3,addr3
	cal	r0,xint3
	st	r0,vec3+8(r0)
	cal	r0,0x183(r0)
	st	r0,vec3+12(r0)
	br	r15

set4:	st	r3,addr4
	cal	r0,xint4
	st	r0,vec4+8(r0)
	cal	r0,0x184(r0)
	st	r0,vec4+12(r0)
	br	r15
