/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	sys3.c
 *
 * HISTORY
 * $Log:	sys3.c,v $
 * Revision 2.2  88/08/06  19:17:33  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: sys3.c,v 2.2 88/08/06 19:17:33 rpd Exp $ */
/* $ACIS:sys3.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/sys3.c,v $ */

#ifndef lint
static char *rcsid = "$Header: sys3.c,v 2.2 88/08/06 19:17:33 rpd Exp $";
#endif

/* Miscellaneous functions needed to support utilities added by 370
 * port group */
char *malloc(), *calloc();


/* Stand alone simple calloc. Returns pointer to requested zeroed space.
 * Add to program's data space by bumping
 * the break up.  Round the new break onto double word because we did
 * that on the 370.
 * one complication is that we want to skip over the 1meg hole in memory
 * on such systems.
 * we put end_addr into bss so that our pointer gets reset if bss
 * is recleared.
 */
char *end_addr;
int mem_hole;			/* if we have a hole in the head */
#define MEG_1	(char *) 0x100000
#define MEG_2	(char *) 0x200000

char *calloc(nelements, size_of_element)
	unsigned nelements, size_of_element;
{
	register char *old_end;
	extern char end;
	register char *cp;
	register int size = (nelements * size_of_element + 7) & ~7;
	register char *new_end;

	if (end_addr == 0)
		end_addr = &end;
	new_end = end_addr+size;
	if (new_end >= MEG_1 && new_end < MEG_2 && mem_hole) {
		end_addr = MEG_2;
		new_end = end_addr + size;
	}
	old_end = end_addr;
	/* bump the break after rounding up to double word */
	end_addr = new_end;
	for (cp = old_end; cp < new_end;) /* zero the new space */
		*cp++ = (char)0;
	return (old_end);	       /* return address of new space */
}


char *malloc(n)
	unsigned n;
{
	return (calloc(n, 1));
}
