/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	vtop.c
 *
 * HISTORY
 * $Log:	vtop.c,v $
 * Revision 2.2  88/08/06  19:20:02  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: vtop.c,v 2.2 88/08/06 19:20:02 rpd Exp $ */
/* $ACIS:vtop.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/vtop.c,v $ */

#ifndef lint
static char *rcsid = "$Header: vtop.c,v 2.2 88/08/06 19:20:02 rpd Exp $";
#endif


#define MMU_VTOP     0x810083
#define MMU_REALADDR 0x810013

int err_flag;

vtop(where)
	register int *where;
{
	register int paddr;

	iow(MMU_VTOP, where);
	paddr = ior(MMU_REALADDR);
	if (paddr < 0) {
		err_flag++;
		printf("bad virtual address\n");
	}
	return (paddr < 0 ? -1 : paddr);
}

