/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	File:	vm/vm_fault.h
 *
 *	Page fault handling module declarations.
 *
 * HISTORY
 * $Log:	vm_fault.h,v $
 * Revision 2.2  88/12/19  02:58:28  mwyoung
 * 	Fix include file referneces.
 * 	[88/12/19            mwyoung]
 * 	
 * 	Add vm_fault_page() and its return type.
 * 	[88/11/03  19:29:12  mwyoung]
 * 
 * 11-Feb-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created.
 *
 */

#ifndef	_VM_FAULT_
#define	_VM_FAULT_	1

#include <sys/kern_return.h>

/*
 *	Page fault handling based on vm_object only.
 */

typedef	int		vm_fault_return_t;
#define	VM_FAULT_SUCCESS	0
#define	VM_FAULT_RETRY		1
#define	VM_FAULT_INTERRUPTED	2
#define	VM_FAULT_MEMORY_SHORTAGE 3
#define	VM_FAULT_MEMORY_ERROR	4

vm_fault_return_t vm_fault_page();

/*
 *	Page fault handling based on vm_map (or entries therein)
 */

kern_return_t	vm_fault();
void		vm_fault_wire();
void		vm_fault_unwire();
void		vm_fault_copy_entry();

#endif	_VM_FAULT_
