/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	vm/vm_pageout.h
 *	Author:	Avadis Tevanian, Jr.
 *
 *	Copyright (C) 1986, Avadis Tevanian, Jr.
 *
 *	Header file for pageout daemon.
 *
 ************************************************************************
 * HISTORY
 * $Log:	vm_pageout.h,v $
 * Revision 2.4  89/01/15  16:43:45  rpd
 * 	Updated includes to the new style.
 * 	Updated macros to the new style.
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  15:35:15  rpd]
 * 
 * Revision 2.3  88/10/18  03:46:00  mwyoung
 * 	Add a declaration of vm_pageout_page for non-XP, so that the code
 * 	in vm/vm_object.c can be coalesced.
 * 	[88/09/22            mwyoung]
 * 
 * Revision 2.2  88/07/17  19:30:50  mwyoung
 * *** empty log message ***
 * 
 * Revision 2.1.1.2  88/07/04  16:55:06  mwyoung
 * Make new pageout daemon stuff conditional on MACH_XP.
 * 
 * Revision 2.1.1.1  88/06/28  21:15:45  mwyoung
 * Revamped how we wait for memory for new MACH_XP pageout daemon.
 * 
 *
 * 19-Jan-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Declare vm_pageout_page().
 *
 * 29-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Delinted.
 *
 * 15-May-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Converted to new include technology.
 *
 * 17-Feb-87  David Golub (dbg) at Carnegie-Mellon University
 *	Added lock (to avoid losing wakeups).  Moved VM_WAIT from
 *	vm_page.h to this file.
 *
 *  9-Mar-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created.
 ************************************************************************
 */

#include <mach_xp.h>

#if	!MACH_XP
#include <sys/lock.h>
#include <sys/sched_prim.h>

/*
 *	Exported data structures.
 */

extern int	vm_pages_needed;	/* should be some "event" structure */
decl_simple_lock_data(extern,vm_pages_needed_lock)


#endif	!MACH_XP
/*
 *	Exported routines.
 */

#if	MACH_XP
void	vm_pageout_page();
#else	MACH_XP
#define	vm_pageout_page(p, bool)	panic("vm_pageout_page");
#endif	MACH_XP

#if	MACH_XP
/* Get VM_WAIT macro from <vm/vm_page.h>, for compatibility */
#include <vm/vm_page.h>
#else	MACH_XP
#include <kern/macro_help.h>
/*
 *	Signal pageout-daemon and wait for it.
 */

#define	VM_WAIT						\
MACRO_BEGIN						\
	simple_lock(&vm_pages_needed_lock);		\
	thread_wakeup((int)&vm_pages_needed);		\
	thread_sleep((int)&vm_page_free_count,		\
		     &vm_pages_needed_lock, FALSE);	\
MACRO_END

#endif	MACH_XP
