*** isofs_lookup.c	Fri Oct 15 22:24:40 1993
--- orig/isofs_lookup.c	Sat Oct  2 15:28:34 1993
***************
*** 95,101 ****
  	register struct iso_node *dp;	/* the directory we are searching */
  	register struct iso_mnt *imp;	/* file system that directory is in */
  	struct buf *bp = 0;		/* a buffer of directory entries */
! 	register union cd_directory_record *ep;
  					/* the current directory entry */
  	int entryoffsetinblock;		/* offset of ep in bp's buffer */
  	enum {NONE, COMPACT, FOUND} slotstatus;
--- 95,101 ----
  	register struct iso_node *dp;	/* the directory we are searching */
  	register struct iso_mnt *imp;	/* file system that directory is in */
  	struct buf *bp = 0;		/* a buffer of directory entries */
! 	register struct iso_directory_record *ep;
  					/* the current directory entry */
  	int entryoffsetinblock;		/* offset of ep in bp's buffer */
  	enum {NONE, COMPACT, FOUND} slotstatus;
***************
*** 230,239 ****
  		 * Get pointer to next entry.
  		 */
  
! 		ep = (union cd_directory_record *)
  			(bp->b_un.b_addr + entryoffsetinblock);
  
! 		reclen = isonum_711 (ep->iso.length);
  		if (reclen == 0) {
  			/* skip to next block, if any */
  			ndp->ni_ufs.ufs_offset =
--- 230,239 ----
  		 * Get pointer to next entry.
  		 */
  
! 		ep = (struct iso_directory_record *)
  			(bp->b_un.b_addr + entryoffsetinblock);
  
! 		reclen = isonum_711 (ep->length);
  		if (reclen == 0) {
  			/* skip to next block, if any */
  			ndp->ni_ufs.ufs_offset =
***************
*** 242,248 ****
  			continue;
  		}
  
! 		if (reclen < sizeof (union cd_directory_record))
  			/* illegal entry, stop */
  			break;
  
--- 242,248 ----
  			continue;
  		}
  
! 		if (reclen < sizeof (struct iso_directory_record))
  			/* illegal entry, stop */
  			break;
  
***************
*** 253,261 ****
  		/*
  		 * Check for a name match.
  		 */
! 		namelen = isonum_711 (ep->iso.name_len);
  
! 		if (reclen < sizeof (union cd_directory_record) + namelen)
  			/* illegal entry, stop */
  			break;
  
--- 253,261 ----
  		/*
  		 * Check for a name match.
  		 */
! 		namelen = isonum_711 (ep->name_len);
  
! 		if (reclen < sizeof (struct iso_directory_record) + namelen)
  			/* illegal entry, stop */
  			break;
  
***************
*** 262,271 ****
  		if ((namelen == 1
  		     && ((ndp->ni_namelen == 1
  			  && ndp->ni_ptr[0] == '.'
! 			  && ep->iso.name[0] == 0)
! 			 || (ndp->ni_isdotdot && ep->iso.name[0] == 1)))
  		    || (namelen >= ndp->ni_namelen
! 			&& isofncmp(ndp->ni_ptr, ndp->ni_namelen, ep->iso.name,
  				namelen))) {
  			/*
  			 * Save directory entry's inode number and
--- 262,271 ----
  		if ((namelen == 1
  		     && ((ndp->ni_namelen == 1
  			  && ndp->ni_ptr[0] == '.'
! 			  && ep->name[0] == 0)
! 			 || (ndp->ni_isdotdot && ep->name[0] == 1)))
  		    || (namelen >= ndp->ni_namelen
! 			&& isofncmp(ndp->ni_ptr, ndp->ni_namelen, ep->name,
  				namelen))) {
  			/*
  			 * Save directory entry's inode number and
***************
*** 272,278 ****
  			 * reclen in ndp->ni_ufs area, and release
  			 * directory buffer.
  			 */
! 			ndp->ni_ufs.ufs_ino = isonum_733 (ep->iso.extent);
  			brelse(bp);
  			goto found;
  		}
--- 272,278 ----
  			 * reclen in ndp->ni_ufs area, and release
  			 * directory buffer.
  			 */
! 			ndp->ni_ufs.ufs_ino = isonum_733 (ep->extent);
  			brelse(bp);
  			goto found;
  		}
