*** isofs_vfsops.c	Fri Oct 15 22:32:34 1993
--- orig/isofs_vfsops.c	Fri Oct 15 22:20:55 1993
***************
*** 197,207 ****
  	int j;
  	int iso_bsize;
  	int iso_blknum;
! 	union cd_volume_descriptor *vdp;
! 	union cd_primary_descriptor *pri;
! 	union cd_directory_record *rootp;
  	int logical_block_size;
- 	int cdromtype=CDROMTYPE_ISO;
  
  	if (!ronly)
  		return (EROFS);
--- 197,206 ----
  	int j;
  	int iso_bsize;
  	int iso_blknum;
! 	struct iso_volume_descriptor *vdp;
! 	struct iso_primary_descriptor *pri;
! 	struct iso_directory_record *rootp;
  	int logical_block_size;
  
  	if (!ronly)
  		return (EROFS);
***************
*** 232,271 ****
  				   iso_bsize, NOCRED, &bp))
  			goto out;
  
! 		vdp = (union cd_volume_descriptor *)bp->b_un.b_addr;
! 		if (bcmp (vdp->iso.id, ISO_STANDARD_ID, sizeof vdp->iso.id) != 0) {
! 			if (bcmp (vdp->his.id, HIS_STANDARD_ID, sizeof vdp->his.id) != 0) {
! 				error = EINVAL;
! 				goto out;
! 			} else {
! 				cdromtype=CDROMTYPE_HIS;
! 			}
  		}
  
! 		if (isonum_711 (cdromtype==CDROMTYPE_ISO ?
! 				vdp->iso.type : vdp->iso.type) == ISO_VD_END) {
  			error = EINVAL;
  			goto out;
  		}
  
! 		if (isonum_711 (cdromtype==CDROMTYPE_ISO ?
! 				vdp->iso.type : vdp->his.type) == ISO_VD_PRIMARY) {
  			break;
- 		}
  		brelse(bp);
  	}
  
! 	if (isonum_711 (cdromtype==CDROMTYPE_ISO ?
! 			vdp->iso.type : vdp->his.type) != ISO_VD_PRIMARY) {
  		error = EINVAL;
  		goto out;
  	}
  	
! 	pri = (union cd_primary_descriptor *)vdp;
  
! 	logical_block_size = isonum_723 (cdromtype==CDROMTYPE_ISO ?
! 		(pri->iso.logical_block_size) :
! 		(pri->his.logical_block_size));
  
  	if (logical_block_size < DEV_BSIZE
  	    || logical_block_size >= MAXBSIZE
--- 231,260 ----
  				   iso_bsize, NOCRED, &bp))
  			goto out;
  
! 		vdp = (struct iso_volume_descriptor *)bp->b_un.b_addr;
! 		if (bcmp (vdp->id, ISO_STANDARD_ID, sizeof vdp->id) != 0) {
! 			error = EINVAL;
! 			goto out;
  		}
  
! 		if (isonum_711 (vdp->type) == ISO_VD_END) {
  			error = EINVAL;
  			goto out;
  		}
  
! 		if (isonum_711 (vdp->type) == ISO_VD_PRIMARY)
  			break;
  		brelse(bp);
  	}
  
! 	if (isonum_711 (vdp->type) != ISO_VD_PRIMARY) {
  		error = EINVAL;
  		goto out;
  	}
  	
! 	pri = (struct iso_primary_descriptor *)vdp;
  
! 	logical_block_size = isonum_723 (pri->logical_block_size);
  
  	if (logical_block_size < DEV_BSIZE
  	    || logical_block_size >= MAXBSIZE
***************
*** 274,296 ****
  		goto out;
  	}
  
! 	rootp = (union cd_directory_record *)(cdromtype==CDROMTYPE_ISO ?
! 		(pri->iso.root_directory_record) :
! 		(pri->his.root_directory_record));
  
  	isomp = (struct iso_mnt *)malloc(sizeof *isomp,M_UFSMNT,M_WAITOK);
  	isomp->logical_block_size = logical_block_size;
! 	isomp->volume_space_size = isonum_733 (cdromtype==CDROMTYPE_ISO ?
! 		(pri->iso.volume_space_size) :
! 		(pri->his.volume_space_size));
  	bcopy (rootp, isomp->root, sizeof isomp->root);
! 	isomp->root_extent = isonum_733 (rootp->iso.extent);
! 	isomp->root_size = isonum_733 (rootp->iso.size);
  
  	isomp->im_bsize = logical_block_size;
  	isomp->im_bmask = ~(isomp->im_bsize - 1);
  	isomp->im_bshift = 0;
- 	isomp->cdromtype=cdromtype;	/* BS */
  	while ((1 << isomp->im_bshift) < isomp->im_bsize)
  		isomp->im_bshift++;
  
--- 263,280 ----
  		goto out;
  	}
  
! 	rootp = (struct iso_directory_record *)pri->root_directory_record;
  
  	isomp = (struct iso_mnt *)malloc(sizeof *isomp,M_UFSMNT,M_WAITOK);
  	isomp->logical_block_size = logical_block_size;
! 	isomp->volume_space_size = isonum_733 (pri->volume_space_size);
  	bcopy (rootp, isomp->root, sizeof isomp->root);
! 	isomp->root_extent = isonum_733 (rootp->extent);
! 	isomp->root_size = isonum_733 (rootp->size);
  
  	isomp->im_bsize = logical_block_size;
  	isomp->im_bmask = ~(isomp->im_bsize - 1);
  	isomp->im_bshift = 0;
  	while ((1 << isomp->im_bshift) < isomp->im_bsize)
  		isomp->im_bshift++;
  
***************
*** 312,332 ****
  
  	devvp->v_specflags |= SI_MOUNTEDON;
  
- #ifdef GRIMMADEBUG
- 	printf("in " __FILE__ " @ %d !\n", __LINE__ );
- 	printf("logical_block_size %d\n", isomp->logical_block_size);
- 	printf("volume_space_size %d\n", isomp->volume_space_size);
- 	printf("im_ronly %d\n", isomp->im_ronly);
- 	printf("im_fmod %d\n", isomp->im_fmod);
- 	printf("im_bshift %d\n", isomp->im_bshift);
- 	printf("im_bmask %d\n", isomp->im_bmask);
- 	printf("im_bsize %d\n", isomp->im_bsize);
- 	printf("root_extent %d\n", isomp->root_extent);
- 	printf("root_size %d\n", isomp->root_size);
- 	printf("cdromtype %d\n", isomp->cdromtype);
- 	printf("root >%s<\n", isomp->root);
- 	printf("im_fsmnt >%s<\n", isomp->im_fsmnt);
- #endif
  	return (0);
  out:
  	if (bp)
--- 296,301 ----
***************
*** 428,434 ****
  	ip->i_vnode = &tvp;
  	ip->i_dev = imp->im_dev;
  	error = iso_iget(ip, imp->root_extent, &nip,
! 			 (union cd_directory_record *) imp->root);
  	if (error)
  		return (error);
  	*vpp = ITOV(nip);
--- 397,403 ----
  	ip->i_vnode = &tvp;
  	ip->i_dev = imp->im_dev;
  	error = iso_iget(ip, imp->root_extent, &nip,
! 			 (struct iso_directory_record *) imp->root);
  	if (error)
  		return (error);
  	*vpp = ITOV(nip);
***************
*** 498,504 ****
  	if (ifhp->ifid_lbn >= imp->volume_space_size)
  		return (EINVAL);
  
! 	if (ifhp->ifid_offset + sizeof (union cd_directory_record)
  	    >= imp->im_bsize)
  		return (EINVAL);
  
--- 467,473 ----
  	if (ifhp->ifid_lbn >= imp->volume_space_size)
  		return (EINVAL);
  
! 	if (ifhp->ifid_offset + sizeof (struct iso_directory_record)
  	    >= imp->im_bsize)
  		return (EINVAL);
  
