/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/debug.h,v 1.1 1992/11/09 15:14:16 md Exp $ */
/* $ACIS:debug.h 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/debug.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddebug = "$Header: /usr/src/sys/rt/RCS/debug.h,v 1.1 1992/11/09 15:14:16 md Exp $";
#endif

#if defined(KERNEL) || defined(STANDALONE)

/*
 * These debugging switches are defined here.  They are initialized
 * in conf.c in this same directory.
 */

extern int
	aeddebug,
	autodebug,	/* for autoconf debugging */
	cndebug,	/* Console (mono/keybrd) debug */
	ecdebug,
	fddebug,	/* for floppy driver */
	fpadebug,	/* for fpa debugging */
	fsdebug,	/* Unix file system */
	hddebug,	/* hard disk debug flag */
	indebug,	/* interrupt system */
	iodebug,	/* low level i/o */
	mc881debug,	/* for 881 debugging */
	nfldebug,	/* for NFL debugging */
	padebug,	/* paging system */
	pspdebug,	/* Planar Serial Port debugging flag */
	stdebug,	/* streaming tape device driver */
	svdebug,	/* svc traces */
	swdebug,	/* swapping system */
	sydebug,	/* syncronization */
	trdebug,	/* trap traces */
	ttydebug,	/* TTY (async) debug */
#ifdef ATR
	pcdebug,	/* PC debug */
	opdebug,	/* optical disk debug */
#endif ATR
	vmdebug;	/* virtual memory */

/* general debugging bit flags used in a number of routines */
#define SHOW_CHARS	0x00000001
#define SHOW_RDWR	0x00000002
#define SHOW_INTR	0x00000004
#define SHOW_INIT	0x00000008
#define SHOW_IO		0x00000010
#define SHOW_WAIT	0x00000020	       /* show wait */
#define SHOW_REGS	0x00000040
#define SHOW_OPEN	0x00000080
#define	SHOW_STATUS	0x00000100
#define	SHOW_DELAY	0x00000200
#define	SHOW_PCI	0x00000400

/* following are used by disk & tape drivers (as well as some of the above) */
#define SHOW_ENQ	0x00000001		/* ENQueues */
#define SHOW_DEQ	0x00000002		/* DEQueues */
#define SHOW_XFER	0x00000010		/* show transfers */
#define	SHOW_TIMEOUT	0x00000020	/* show wait st.c*/
#define SHOW_ORDWR	0x00000080		/* Open, ReaD, WRite */
#define SHOW_CONFIG	0x00002000		/* show configuration */
#define SHOW_DUMP	0x00004000		/* show dumping */
#define SHOW_SLEEP	0x00008000		/* show sleep calls */
#define	SHOW_LED	0x00000100	/* show unit in LEDs */
#define	SHOW_COUNT	0x00000200	/* show current count information */
#define	SHOW_BUF	0x00000200	/* show the current buf alloc info */
#define	SHOW_SWITCH	0x00000400	/* show switching of controllers (hd.c) */
#define	SHOW_BAD	0x00000800	/* show bad block forwarding */
#define	SHOW_SENSE	0x00000800	/* show sense data */
#define	SHOW_GO		0x00001000	/* show each command data */
#define	SHOW_DUMPIO	0x00008000	/* show dump I/O */
#define	SHOW_DMA	0x00010000	/* show DMA transfers */
#define	SHOW_RETRY	0x00010000	/* show retries */
#define	SHOW_PART	0x00020000	/* show partition */
#define	SHOW_TIMER	0x00400000
#define	SHOW_LOST	0x01000000	/* breakpoint lost ints */
#define	SHOW_STRAY_INTR	0x02000000	
#define	SHOW_DABUF	0x02000000	/* (DMA) adapter buffer usage */
#define	SHOW_DCMD	0x04000000	/* (DMA) command queue usage */
#define	SHOW_BOUNDARY	0x04000000	/* show debugs on boundary conditions */
#define	SHOW_DGO	0x08000000	/* (DMA) hddgo */
#define	SHOW_DATA	0x10000000
#define	SHOW_WRITECHECK	0x10000000	/* use w/ blocks of data which */
#define	SHOW_PAGET	0x40000000	/* show page table data */
#define	SHOW_TEXT	0x80000000	/* chasing all 0 text page */

/* the following are for padebug */
#define SHOW_PGIN	0x00000001
#define SHOW_SCAN	0x00000002
#define SHOW_CLEAN	0x00000004
#define SHOW_KLUST	0x00000008
#define SHOW_PUSH	0x00000010
#define SHOW_TAKE	0x00000020
#define SHOW_LOCK	0x00000040
#define SHOW_SKIP	0x00000080
#define SHOW_CKTEXT	0x00000100
#define SHOW_PROT	0x00000200
#define	SHOW_PROTSTATE	0x00000400	/* vm_machdep.c */
#define	SHOW_CHG_PROT	0x00000800	/* vm_machdep.c */
#define SHOW_PROTMUX	0x00001000	/* trap.c */

/* the following are for swdebug */
#define	SHOW_SWAP	0x00000001
#define	SHOW_SWDONE	0x00000002
#define	SHOW_SWIN	0x00000004
#define	SHOW_SWOUT	0x00000008

/* following are for sydebug */
#define SHOW_SWTCH	0x00000001
#define SHOW_SETRUN	0x00000002
#define SHOW_SETPRI	0x00000004
#define SHOW_UNSLEEP	0x00000010
#define SHOW_SIGNAL	0x00000100
#define SHOW_SIGREGS	0x00000200

/* following is for cndebug */
#define SHOW_PF		0x100

/* for trdebug */
#define	SHOW_TRAP_REGS	0x20000000	/* trdebug: show regs */
#define	SHOW_MUX2	0x40000000	/* trdebug: show apc_mux results */
#define	SHOW_MUX	0x80000000	/* trdebug: show apc_mux calls */

/* fsdebug uses the following plus INTR and SLEEP */
#define	SHOW_GETBLK	0x00000001
#define	SHOW_BLKFLUSH	0x00000002

#endif KERNEL

#ifdef DEBUG
#define DEBUGF(cond,stmt) if (cond) stmt	/* do the stmt (printf) */
#else
#define DEBUGF(cond,stmt) 		/* do nothing if not debugging */
#endif
