/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/dkio.h,v 1.3 1992/11/09 15:17:38 md Exp $ */
/* $ACIS:dkio.h 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/dkio.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidt = "$Header: /usr/src/sys/rt/RCS/dkio.h,v 1.3 1992/11/09 15:17:38 md Exp $";
#endif

/*	dkio.h	6.1	83/07/29	*/
/*
 * Structures and definitions for disk io control commands
 *
 */

/* disk io partition (and geometry) information format */

/*
 * Notes:
 * 1.	dk_size may be less than dk_cyl * dk_track * dk_sector
 *	since dk_size is the usable size (e.g. what you would specify
 *	to newfs/mkfs)
 * 2. everything except dk_size and dk_blocksize are optional - if the
 *	information isn't known then zero is returned.
 * 3. name should be in domain of types in /etc/disktab.
 * 4. start is starting block of this partition (0=start of disk)
 *	this could be used by a program to display current disk
 *	partitioning in a portable fashion.
 */

#define DK_MAXNAME 16		/* size of name field */

struct dkpart {
	u_long	dk_size;	/* disk partition size in blocksize units */
				/*  see following word */
	u_long	dk_blocksize;	/* block/sector size (in bytes) */
	u_long	dk_start;	/* starting block (in blocksize units) */
	u_long	dk_ncyl;	/* number of cylinders (if known) */
	u_long	dk_ntrack;	/* number of tracks per cylinder (if known) */
	u_long	dk_nsector;	/* number of sectors per track (if known) */
	char	dk_name[DK_MAXNAME];/* name of device (if known) (e.g. "hd40r") */
};

/* disk io control commands */
#define DKIOCHDR	_IO('d', 1)	/* next I/O will read/write header */
#define DKIOCGPART	_IOR('d', 2, struct dkpart)	/* get partition information */
#define DKIOCSTART	_IO('d', 3)	/* Start unit */
#define DKIOCSTOP	_IO('d', 4)	/* Stop unit */
#define DKIOCSAUTOSPIN	_IO('d', 5) 	/* Select auto spinup */
#define DKIOCSNOAUTOSPIN	_IO('d', 6) 	/* Select no auto spinup */
/* HW for interactive manipulation of SCSI disks */
#define DKIOCSMODESELECT        _IOW('d', 8,struct scsi_msc) /* SCSI Mode Select*/
                                /* intended to turn on/off Wren Caching */
#define DKIOCSMODESENSE      _IOR('d', 9,struct scsi_msiobuf) /* SCSI Mode Sense*/
#define DKIOCSSCSI              _IOW('d', 10, union scsi_cdb) /* SCSI Pass thru */
#define DKIOCGSCSISENSE		_IOR('d', 11, struct scsi_esense) /* Read SCSI sense */
#define	DKIOCDSR		_IO('d', 12) /* Disable driver retries on SCSI Pass thru */
#define	DKIOCESR		_IO('d', 13) /* Enable driver retries on SCSI pass thru */
