/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)machparam.h	7.16 (Berkeley) 5/10/90
 */

/*
 * Machine dependent constants for IBM RT.
 */
#define	MACHINE	"rt"

/*
 * Define the following only if the machine-dependent define(s) for
 * cpp should be different than above.
 */
#define	CPPMACHDEF	"ibmrt"
#define	ALTCPPMACHDEF	"ibm032"

#ifndef BYTE_ORDER
#include <rt/endian.h>
#endif

#include <rt/machlimits.h>

/*
 * Standard options.  These are used unless a NO-something appears
 * in the configuration file.
 *
 * This probably shouldn't be here.
 */
#if !defined(NOSHOW_LOAD) && !defined(SHOW_LOAD)
#define	SHOW_LOAD	1	/* show load in lights */
#endif

#if !defined(NOFPA) && !defined(FPA)
#define	FPA	1		/* assume FPA present */
#endif

#if !defined(NOROMPC) && !defined(ROMPC)
#define	ROMPC	1		/* assume ROMPC */
#endif

#if !defined(NOMC881) && !defined(MC881) && defined(ROMPC)
#define MC881	1		/* assume MC881 present */
#endif

#ifdef NOVOLATILE
#define	volatile		/* for pcc, should we ever use that */
#endif

/*
 * Round p (pointer or byte index) up to a correctly-aligned value
 * for all data types (int, long, ...).   The result is u_int and
 * must be cast to any desired pointer type.
 */
#define	ALIGN(p)	(((u_int)(p) + (sizeof(int) - 1)) &~ (sizeof(int) - 1))

#define	NBPG		2048		/* bytes/page */
#define	PGOFSET		(NBPG-1)	/* byte offset into page */
#define	PGSHIFT		11		/* LOG2(NBPG) */
#define	LOG2NBPG	11		/* LOG2(NBPG) */
#define	NPTEPG		(NBPG/(sizeof (struct pte)))

#define	KERNBASE	0xe0000000	/* start of kernel virtual */
#define	KERNTEXTOFF	KERNBASE	/* start of kernel text */
#define	BTOPKERNBASE	((u_long)KERNBASE >> PGSHIFT)

#define SYSBASE		((u_long)0xe0000000)  /* virt addr of system origin */

#define	DEV_BSIZE	512
#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define BLKDEV_IOSIZE	2048
/*
 * XXX This isn't quite right.  On the RT the maximum I/O transfer size
 * depends on the particular device you are writing to.  This number
 * is a minimum value.  Should make minphys query the device driver to
 * determine a more optimum value (someday).
 *
 * Minimum is 64kb less two pages
 */
#define	MAXPHYS		(60 * 1024)	/* max raw I/O transfer size */

#define	CLSIZE		1
#define	CLSIZELOG2	0

#define	SSIZE		1		/* initial stack size/NBPG */
#define	SINCR		1		/* increment of stack/NBPG */

#define	UPAGES		4		/* pages of u-area */

/*
 * Constants related to network buffer management.
 * MCLBYTES must be no larger than CLBYTES (the software page size), and,
 * on machines that exchange pages of input or output buffers with mbuf
 * clusters (MAPPED_MBUFS), MCLBYTES must also be an integral multiple
 * of the hardware page size.
 */

/*
 * On the RT, CLBYTES is 2048.  Set the mcluster size to 1024.
 */
#define	MSIZE		128		/* size of an mbuf */
#define	MCLBYTES	CLBYTES
#define	MCLSHIFT	CLSHIFT
#define	MCLOFSET	CLOFSET

#ifdef GATEWAY
#define	NMBCLUSTERS	512		/* map size, max cluster allocation */
#else
#define	NMBCLUSTERS	256		/* map size, max cluster allocation */
#endif

/*
 * Size of kernel malloc arena in CLBYTES-sized logical pages
 */ 
#ifndef NKMEMCLUSTERS
#define	NKMEMCLUSTERS	(512*1024/CLBYTES)
#endif

/*
 * Some macros for units conversion
 */
/* Core clicks (2048 bytes) to segments and vice versa */
#define	ctos(x)	(x)
#define	stoc(x)	(x)

/* Core clicks (2048 bytes) to disk blocks */
#define	ctod(x)	((x) << 2)
#define	dtoc(x)	(((x)+3) >> 2)
#define	dtob(x)	((x)<<9)

/* clicks to bytes */
#define	ctob(x)	((x)<<11)

/* bytes to clicks */
#define	btoc(x)	((((unsigned)(x)+2047)>>11))

#define	btodb(bytes)	 		/* calculates (bytes / DEV_BSIZE) */ \
	((unsigned)(bytes) >> DEV_BSHIFT)
#define	dbtob(db)			/* calculates (db * DEV_BSIZE) */ \
	((unsigned)(db) << DEV_BSHIFT)

/*
 * Map a ``block device block'' to a file system block.
 * This should be device dependent, and will be if we
 * add an entry to cdevsw/bdevsw for that purpose.
 * For now though just use DEV_BSIZE.
 */
#define	bdbtofsb(bn)	((bn) / (BLKDEV_IOSIZE/DEV_BSIZE))

/*
 * Macros to decode processor status word (interrupt control status on RT)
 */
#define	USERMODE(ps)	(((ps) & ICSCS_PROBSTATE) != 0)
#define	BASEPRI(ps)	(((ps) & ICSCS_PRIORITY) == ICSCS_PRIORITY)

#if defined(KERNEL) || defined(STANDALONE)
#define	DELAY_ADDR	0xf00080e0	/* IOCC delay location */
#define DELAY(n)	{ register int N = (n); \
			  while (--N >= 0) \
				* (char volatile *) DELAY_ADDR = 0xff; }
#else
#define	DELAY(n)	{ register int N = (n); while (--N > 0); }
#endif

/*
 * Some RT-specific limits.  Maximum physical memory size and
 * maximum buffer pages allocated.
 */
#define	MAXPHYSMEM	0x1000000	/* (bytes) no more than 16M real mem */
#define	MAXBUFFERPAGES	1024		/* 2M is virtual space allocated */

#ifdef KERNEL
#ifndef LOCORE
short rorootdev;		/* for read-only root device */
char ccr_default;		/* default value for CCR */

#define	splttl()	spl4()
#define	spltty()	spl4()
#define	splclock()	spl6()
#define	splbio()	_spl1()
#define	splsoftclock()	_spl6()

#define	spl0()	_spl7()		/* use CPU priority level 7 */
#define	spl1()	_spl6()		/* use CPU priority level 6 */
#define	spl2()	_spl5()		/* use CPU priority level 5 */
#define	spl3()	_spl4()		/* use CPU priority level 4 */
#define	spl4()	_spl3()		/* use CPU priority level 3 */
#define	spl5()	_spl2()		/* use CPU priority level 2 */
#define	spl6()	_spl1()		/* use CPU priority level 1 */
#define	spl7()	_spl0()		/* use CPU priority level 0 */

#define	splhigh() _spl0()	/* inhibit everything */
#define	fuibyte	fubyte
#define	fuiword	fuword
#define	suibyte	subyte
#define	suiword	suword

#endif
#define	ovbcopy	bcopy
#endif
