/*
 * Machine-dependent clock routines
 */

/*
 * timetick() is called in one spot, from the hardclock routine.  Unless
 * something really gross needs to be done it is probably (very slightly)
 * better to expand this in line to save the subroutine call overhead.
 *
 * This version should work on any machine which uses the time and uptime
 * globals and maintains them by counting clock interrupts.
 */
#define	timetick() \
	do { \
		extern struct timeadj timeslew; \
		register long delta = tick; \
		if (timeslew.ta_time.tv_usec != 0) { \
			register long rate = timeslew.ta_rate.tv_usec; \
			if (timeslew.ta_flags & ADJ_SLOW) { \
				if (timeslew.ta_time.tv_usec > rate) { \
					delta -= rate; \
					timeslew.ta_time.tv_usec -= rate; \
				} else if (timeslew.ta_time.tv_sec != 0) { \
					timeslew.ta_time.tv_sec--; \
					timeslew.ta_time.tv_usec += \
					    1000000 - rate; \
					delta -= rate; \
				} else { \
					delta -= timeslew.ta_time.tv_usec; \
					timeslew.ta_time.tv_usec = 0; \
				} \
			} else { \
				if (timeslew.ta_time.tv_usec > rate) { \
					delta += rate; \
					timeslew.ta_time.tv_usec += rate; \
				} else if (timeslew.ta_time.tv_sec != 0) { \
					timeslew.ta_time.tv_sec--; \
					timeslew.ta_time.tv_usec += \
					    1000000 - rate; \
					delta += rate; \
				} else { \
					delta += timeslew.ta_time.tv_usec; \
					timeslew.ta_time.tv_usec = 0; \
				} \
			} \
		} \
		uptime.tv_usec += delta; \
		if (uptime.tv_usec >= 1000000) { \
			uptime.tv_usec -= 1000000; \
			uptime.tv_sec++; \
		} \
		time.tv_usec = uptime.tv_usec + boottime.tv_usec; \
		time.tv_sec = uptime.tv_sec + boottime.tv_sec; \
		if (time.tv_usec > 1000000) { \
			time.tv_usec -= 1000000; \
			time.tv_sec++; \
		} \
	} while (0)

/*
 * On machines which don't have the hardware to sensibly implement
 * microtime() and microuptime(), these might be used.  I don't actually
 * believe that there is any benefit in trying to make sure the time
 * increases after every call.
 */
#ifdef notdef
#define	microtime(tv) \
	do { \
		register int s = splhigh(); \
		(tv)->tv_sec = time.tv_sec; \
		(tv)->tv_usec = time.tv_usec; \
		(void) splx(s); \
	} while (0)

#define	microuptime(tv)	\
	do { \
		register int s = splhigh(); \
		(tv)->tv_sec = uptime.tv_sec; \
		(tv)->tv_usec = uptime.tv_usec; \
		(void) splx(s); \
	} while (0)
#endif
