/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/rdb.h,v 1.2 1992/11/09 15:15:06 md Exp $ */
/* $ACIS:rdb.h 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/rdb.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidrdb = "$Header: /usr/src/sys/rt/RCS/rdb.h,v 1.2 1992/11/09 15:15:06 md Exp $";
#endif

/*
 * this file is included in rt/locore.c and rtstand/rdb.c
 * normally, and is processed by an unifdef and awk script in
 * ../conf/make.ws and in rtstand so that the values can be used 
 * in those shell scripts.
 * the 'values' MUST be of the form 0xvalue for this to work!
 * rules:
 * RDB_STACK	is the top of the debugger stack 
 * RDB_SYMTAB	is the base of the symbol table
 * RDB_SYMLEN	is the length of the symbol table
 * RDB_RELOC	is the base of the debugger and = RDB_SYMTAB + RDB_SYMLEN
 * RDB_END	is the end of the debugger (see output from make rdb.out
 *		in standca)
 */
#define RDB_STACK	0x2000		/* DEBUGGER stack top */
#define RDB_SYMTAB	0x7000		/* RDB symbol table */
/* SYMLEN must be RDB_RELOC - RDB_SYMTAB */
#define RDB_SYMLEN	0xc000		/* symbol table length */
#define RDB_RELOC	0x13000		/* start of RDB */

/*
 *	These confusing nested ifdefs were done on purpose
 *	to make unifdef happy.  Don't remove them.
 */
#ifdef IBMRTPC
#define RDB_END		0x32000		/* end of RDB (IBMRTPC) */
#else
#ifdef ATR
#define RDB_END		0x2a000		/* end of RDB (ATR) */
#else
#define RDB_END		0x32000		/* end of RDB (IBMRTPC) */
#endif ATR
#endif IBMRTPC

/* Parameters for POST */
#define POST_START	0x800		/* start of POST */
#define POST_SIZE	0x800		/* size of POST */
/* define for start of kernel */
#define KERNEL_START	0x1000		/* start address of kernel code */
