/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/vmparam.h,v 1.3 1990/10/16 02:15:00 dennis Exp $ */
/* $ACIS:vmparam.h 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/vmparam.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidca_vmparam = "$Header: /usr/src/sys/rt/RCS/vmparam.h,v 1.3 1990/10/16 02:15:00 dennis Exp $";
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)vmparam.h	7.1 (Berkeley) 6/5/86
 */

/*
 * Machine dependent constants for the RT
 */
/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the P0 region to the
 * beginning of the text and from the beginning of the P1 region to the
 * beginning of the stack respectively.
 */

#define ENDOFP1         0x20000000  /* first address past P1 */
#define P1PAGES         0x20000     /* number of pages in P1 region */
#define LOWPAGES        0           /* this is not implemented */
#define HIGHPAGES       (UPAGES+1)  /* 1 page for red zone */

#define	DATABASE	0x10000000  /* virtual address of data origin */
#define	BTOPDATABASE	(DATABASE>>PGSHIFT)
#define	SEGMENT_OFFSET	0x0fffffff  /* rt hardware segment offset */

#define USRTEXT         0
#define USRSTACK        (ENDOFP1-HIGHPAGES*NBPG) /* top of user stack */
#define	BTOPUSRSTACK	((ENDOFP1>>PGSHIFT)-HIGHPAGES)
#define USER_FPM	(USRSTACK-NBPG)		/* Where FP machine goes */
#define KERNSTACK	(ENDOFP1-sizeof(struct user)) /* top of kernel stack */
#define UAREA		(ENDOFP1-UPAGES*NBPG) /* start of u area */
#define REDZONE		(ENDOFP1-HIGHPAGES*NBPG) /* start of red zone */

#define uareabase(u)    ((caddr_t)(u)+sizeof(struct user)-UPAGES*NBPG)

/*
 * Virtual memory related constants, all in bytes
 */
#ifndef MAXTSIZ
#define	MAXTSIZ		(6*1024*1024)		/* max text size */
#endif
#ifndef DFLDSIZ
#define	DFLDSIZ		(6*1024*1024)		/* initial data size limit */
#endif
#ifndef MAXDSIZ
#define	MAXDSIZ		(16*1024*1024)		/* max data size */
#endif
#ifndef	DFLSSIZ
#define	DFLSSIZ		(512*1024)		/* initial stack size limit */
#endif
#ifndef	MAXSSIZ
#define	MAXSSIZ		MAXDSIZ			/* max stack size */
#endif

/*
 * Default sizes of swap allocation chunks (see dmap.h).
 * The actual values may be changed in vminit() based on MAXDSIZ.
 * With MAXDSIZ of 16Mb and NDMAP of 38, dmmax will be 1024.
 */
#define	DMMIN	32			/* smallest swap allocation */
#ifndef DMMAX
#define	DMMAX	4096			/* largest potential swap allocation */
#endif /* DMMAX */
#define	DMTEXT	1024			/* swap allocation for text */

/*
 * Sizes of the system and user portions of the system page table.
 */
/* SYSPTSIZE IS SILLY; IT SHOULD BE COMPUTED AT BOOT TIME */
#define SYSPTSIZE       ((20+MAXUSERS)*NPTEPG)
#define USRPTSIZE       (1*NPTEPG)

/*
 * PTEs for system V compatible shared memory.
 * This is basically slop for kmempt which we actually allocate (malloc) from.
 */
#define SHMMAXPGS	256

/*
 * Boundary at which to place first MAPMEM segment if not explicitly
 * specified.  Should be a power of two.  This allows some slop for
 * the data segment to grow underneath the first mapped segment.
 */
/*
 * XXX: This can't possibly work on an RT.  The MAPMEM stuff should
 * really get its own hardware segment.  If it were to go in the data
 * segment, however, it certainly couldn't be a power of 2.
 */
#define MMSEG		0x200000

/*
 * The size of the clock loop.
 */
#define LOOPPAGES       (maxfree - firstfree)

/*
 * The size of available memory.
 */
#define AVAILPAGES       (LOOPPAGES - holelength)

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time.  You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define MAXSLP          20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm.  Basically this says that if you are
 * swapped in you deserve some resources.  We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 * Note that each process has at least UPAGES+CLSIZE pages which are not
 * paged anyways (this is currently 8+2=10 pages or 5k bytes), so this
 * number just means a swapped in process is given around 25k bytes.
 * Just for fun: current memory prices are 4600$ a megabyte on VAX (4/22/81),
 * so we loan each swapped in process memory worth 100$, or just admit
 * that we don't consider it worthwhile and swap it out to disk which costs
 * $30/mb or about $0.75.
 */
#define SAFERSS         32              /* nominal ``small'' resident set size
					  protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define DISKRPM         60

/*
 * Klustering constants.  Klustering is the gathering
 * of pages together for pagein/pageout, while clustering
 * is the treatment of hardware page size as though it were
 * larger than it really is.
 *
 * KLMAX gives maximum cluster size in CLSIZE page (cluster-page)
 * units.  Note that KLMAX*CLSIZE must be <= DMMIN in dmap.h.
 *
 */
/* note that KLMAX are in units of PAGES, while DMMIN is in units
 * of blocks, this we need to adjust the limits to take into account
 * the fact that our pages are 4x greater than the Vax's.
 */
#define KLMAX   (8/CLSIZE)
#define KLSEQL  (4/CLSIZE)           /* in klust if vadvise(VA_SEQL) */
#define KLIN    (4/CLSIZE)           /* default data/stack in klust */
#define KLTXT   (4/CLSIZE)           /* default text in klust */
#define KLOUT   (8/CLSIZE)

/*
 * KLSDIST is the advance or retard of the fifo reclaim for sequential
 * processes data space.
 */
#define KLSDIST 3               /* klusters advance/retard for seq. fifo */

/*
 * Paging thresholds (see vm_sched.c).
 * Strategy of 12/03/87
 *	lotsfree is ~256k bytes, but at most 1/8 of memory
 *	desfree  is ~100k bytes, but at most 1/16 of memory
 *	minfree  is 64k bytes, but at most 1/2 of desfree
 *
 *	note that LOTSFREE and DESFREE depend upon MAXUSERS
 *	on the theory that a larger number of proceses should
 *	have a larger free pool available. A large MAXUSERS
 *	(e.g. 20) will give figures near to the original 4.3
 *	values, but smaller values give values more appropriate
 *	to a workstation environment.
 */
#define	LOTSFREE	((200 * 1024) + MAXUSERS * 10240)
#define LOTSFREEFRACT   8
#define DESFREE         ((80 * 1024) + MAXUSERS * 5120)
#define DESFREEFRACT    16
#define MINFREE         (64 * 1024)
#define MINFREEFRACT    2

#ifdef notdef
/*
 * Paged text files that are less than PGTHRESH bytes may be swapped
 * in instead of paged in.
 */
#define PGTHRESH		(100 * 1024)
#endif

/*
 * There are two clock hands, initially separated by HANDSPREAD bytes
 * (but at most all of user memory).  The amount of time to reclaim
 * a page once the pageout process examines it increases with this
 * distance and decreases as the scan rate rises.
 */
#define	HANDSPREAD	(2 * 1024 * 1024)

/*
 * The number of times per second to recompute the desired paging rate
 * and poke the pagedaemon.
 */
#define	RATETOSCHEDPAGING	4

/*
 * Believed threshold (in megabytes) for which interleaved
 * swapping area is desirable.
 */
#define	LOTSOFMEM	3
