/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtcons/RCS/aedtty.h,v 1.1 1990/10/10 20:40:22 rayan Exp $ */
/* $ACIS:aedtty.h 12.0$ */
/* $Source: /usr/src/sys/rtcons/RCS/aedtty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidaed_tty = "$Header: /usr/src/sys/rtcons/RCS/aedtty.h,v 1.1 1990/10/10 20:40:22 rayan Exp $";
#endif

#ifdef AEDDEBUG
#define aedrd(X,Y,Z)	{ if (aeddebug > 10)\
			    printf("aedrd %x -> %x (%d)\n",AED_BASE+Z,X,Y);\
			    aed_rd(AED_BASE+Z, X, Y);}

#define aedwr(X,Y,Z)	{ if (aeddebug > 10)\
			    printf("aedwr %x -> %x (%d)\n",X,AED_BASE+Z,Y);\
			    aed_wr(X, AED_BASE+Z, Y);}
#else
#define aedrd(X,Y,Z)	aed_rd(AED_BASE+Z, X, Y)
#define aedwr(X,Y,Z)	aed_wr(X, AED_BASE+Z, Y)
#endif

#ifdef ATR
/*
 * since the AED is at a fixed address we can optimize the aedrd
 * macros (once the 128k window is set we just use the offset)
 */
#define AED_MMAP	0x0a0000
#define AED_BASE ((char *) (AED_MMAP & MASK_128K))
#define AED_ENTER(xxx)	int window = get_128_window(); \
	xxx set_128_window(AED_MMAP);
#define AED_EXIT()	set_128_window(window)
#define MASK_128K	0x1ffff

#else

#define AED_MMAP	0xf40a0000
#define AED_BASE ((char *) AED_MMAP)
#define AED_ENTER(xxx)
#define AED_EXIT()
#define aed_rd(X,Y,Z) bcopy(X, Y, Z+Z)	/* use bcopy */
#define aed_wr(X,Y,Z) bcopy(X, Y, Z+Z)	/* use bcopy */

#endif ATR

#define AED_DELAY	DELAY(2)



#define term_mode	0x0200
#define setup_mode	0x0300
#define data_port	0x4000
#define status_port	0x4002


short *aed_data;
short *aed_status;
extern int delay_count;

#define AEDTMO (delay_count*256)
static	aed_to = 0;

#define vinit() aed_data = (short *)(AED_BASE + data_port);

#define vwait()	{register int tmo = aed_to ? 1 : AEDTMO;\
			while (GET_PC2B(*aed_data)) {\
				if(tmo-- < 0) {\
					if(aed_screen_init()) {\
						aed_to = 1;\
						break;\
					}\
					tmo = AEDTMO;\
					aed_to = 0; \
				}\
				AED_DELAY; \
			} }

#define vterm(c)	{ \
			vwait(); \
			AED_DELAY;\
			PUT_PC2B(*aed_data, (term_mode | c)); \
			AED_DELAY;}

#define vsetup(c)	{ while (GET_PC2B(*aed_data)) AED_DELAY; \
			AED_DELAY;\
			PUT_PC2B(*aed_data, (setup_mode | c)); \
			AED_DELAY; }
