/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtcons/RCS/buf_emul.h,v 1.2 1990/10/10 20:44:56 rayan Exp $ */
/* $ACIS:buf_emul.h 12.0$ */
/* $Source: /usr/src/sys/rtcons/RCS/buf_emul.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidbuf_emul = "$Header: /usr/src/sys/rtcons/RCS/buf_emul.h,v 1.2 1990/10/10 20:44:56 rayan Exp $";
#endif


#ifdef KERNEL
#include	"../rtcons/vgaio.h"
#else
#include	<machinecons/vgaio.h>
#endif
#define BUFSETWIND	_IOWR('b',0,unsigned)	/* 6152 only */
#define BUFINITVGA	_IOW('b',1,int)		/* 6152 only */
#define BUFINIT8514	_IO('b',2)		/* 6152 only */
#define BUF8514CTRL	_IOW('b',3,unsigned)	/* 6152 only */
#define BUFDISPINFO	_IOR('b',4,unsigned)	/* RT & 6152 */
#define CONSDISPINFO	BUFDISPINFO	/* ioctl moved to cons.c */
#define BUFGETSAVE	_IOR('b',5,int)		/* 6152 only */
#define BUFRESTOREDONE  _IO('b',6)		/* 6152 only */
#define BUFSAVEDONE	_IO('b',7)		/* 6152 only */
#define BUFSAVEWAIT	_IO('b',8)		/* 6152 only */

/*
 * valid fields for BUFDISPINFO
 *
 * bit 31 is the CPU type (1=6152 (ATR), 0=RTPC)
 * bits 23-16 on the 6152 is the pc_code type running on the 6152 
 * bits 3-0 on the RT is the EGA switch settings
 * bits 3,2 on the 6152 are the 8512 display type
 * bits 1,0 on the 6152 are the vga display type
 * All other fields are reserved
 */
#define	BUF_CPU		0x80000000	/* CPU field */
#define	 BUF_CPU_ATR	0x80000000	/* CPU is ATR */
#define	 BUF_CPU_RTPC	0x00000000	/* CPU is RTPC */
#define	 BUF_IS_ATR(x)	(((x) & BUF_CPU) == BUF_CPU_ATR)
#define	 BUF_IS_RTPC(x)	(((x) & BUF_CPU) == BUF_CPU_RTPC)
#define	BUF_8514_TYPE	0x0000000c	/* type of 8514 display */
#define BUF_8514_SHIFT	2
#define  BUF_GET_8514(x) (((x) & BUF_8514_TYPE) >> BUF_8514_SHIFT)
#define BUF_VGA_TYPE	0x00000003	/* type of VGA display */
#define  BUF_GET_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_EGA_TYPE	0x0000000f	/* ega switch settings */
#define  BUF_GET_EGA(x)	 ((x) & BUF_EGA_TYPE)
#define BUF_PCCODE_TYPE    0x00ff0000
#define BUF_PCCODE_SHIFT   16
#define  BUF_GET_PCCODE(x) (((x) & BUF_PCCODE_TYPE) >> BUF_PCCODE_SHIFT)
#ifdef KERNEL
#define	BUF_PUT_8514(x)	 (((x) << BUF_8514_SHIFT) & BUF_8514_TYPE)
#define BUF_PUT_VGA(x)	 ((x) & BUF_VGA_TYPE)
#define BUF_PUT_EGA(x)	 ((x) & BUF_EGA_TYPE)
#define BUF_PUT_PCCODE(x) (((x) << BUF_PCCODE_SHIFT) & BUF_PCCODE_TYPE)

/* buf _emul per screen softc structure */
struct buf_softc {
	struct clist	buf_cq;
	char	buf_flag;
	struct proc *buf_proc;
	int	buf_save_state;
};

/* buf_cq */
#define BUF_CMAX	2048	/* Size of circular buffer */

/* buf_flag */
#define BUF_ISOPEN	0x01	/* flag that buf_emul is open */
#define BUF_ISASLEEP	0x02	/* a process is asleep in background */
#define BUF_WILLRESTORE 0x04	/* process will restore the screen when awake*/

#endif

/* buf_save_state */
#define	BUF_SCREEN_OK	0	/* nothing needs to be done to the screen */
#define BUF_NEED_SAVE	1	/* screen needs to be saved */
#define BUF_IS_SAVE  	2	/* screen has been saved */
#define BUF_NEED_RESTORE 3	/* screen needs to be restored */
#define BUF_IS_RESTORE	4	/* screen has been restored */

