#!/bin/sh
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header: /sys/dist/etc/RCS/mask.sh,v 1.1 1988/12/09 22:53:21 md Exp $ 
# $ACIS:mask.sh 12.1$ 
# $Source: /sys/dist/etc/RCS/mask.sh,v $ 
# echo restore(8) commands to subset system
C=`basename $0`
case $# in
0|1)	echo "usage:$C partition mask ..." >&2
	exit 2;;
esac

P="$1";shift
for M
do
	case "$M" in
	nolocal)
		case "$P" in
		root)	echo 'delete	etc/ptmp
delete etc/*.pid';;
		esac;;
	nosite)
		case "$P" in
		root)	echo delete	site;;
		esac;;
	nomailconf)
		case "$P" in
		user)	echo delete	lib/sendmail.fc;;
		root)	echo delete	etc/sendmail.fc;;
		esac;;
	nodoc)	case "$P" in
		user)	echo delete	doc;;
		esac;;
	nonotes)
		case "$P" in
		user)	echo delete	spool/notes;;
		esac;;
	nosupport)
		case "$P" in
		user)	echo delete	sys/support;;
		esac;;
	noman)	case "$P" in
		user)	echo delete	man;;
		esac;;
	nofont)	case "$P" in
		user)	echo delete	lib/font/dev3812;;
		esac;;
	nolearn)
		case "$P" in
		user)	echo delete	lib/learn;;
		esac;;
	nokernel)
		case "$P" in
		user)	echo 'delete sys
add sys/*/*.h
add sys/machine*
add sys/dist*
delete sys/stand*';;
		esac;;
	noserver)	case "$P" in
		root)	echo 'delete vice
delete vicep*
delete etc/vfsck*
delete etc/vstab
delete etc/exports
delete etc/rmtab
delete ROOTVOLUME
delete UpdateLog
delete UpdateMonitor
delete pid
delete user';;
		user)	echo 'delete admin
delete vice';;
		esac;;
	nox11)	case "$P" in
		user)	echo 'delete bin/X11
delete include/X11
delete lib/*X*';;
		source)	echo 'delete X11';;
		esac;;
	noRT)	case "$P" in
		root)	echo 'delete dev/ttyaed
delete dev/aed
delete dev/msaed
delete dev/ttyap16
delete dev/apa16
delete dev/msapa16
delete dev/ttyap8c
delete dev/apa8c
delete dev/msapa8c
delete dev/ttyapa8
delete dev/apa8
delete dev/msapa8
delete dev/ttyega
delete dev/ega
delete dev/msega
delete dev/ttymono
delete dev/mono
delete dev/msmono
delete dev/ttympel
delete dev/mpel
delete dev/msmpel
delete boot
delete vmunix.rt';;
		esac;;
	noATR)	case "$P" in
		root)	echo 'delete dev/ttyvga
delete dev/vga
delete dev/msvga
delete dev/tty8514
delete dev/ibm8514
delete dev/ms8514
delete vmunix.atr';;
		esac;;
	nobe2src)
		case "$P" in
		/usr/andrew)
			echo 'delete be2
delete lib/be2
delete overhead';;
		esac;;
	*)	echo "$C:$M:unknown mask--known masks are:
	nodoc nofont nokernel nolearn noman nonotes nosupport noserver nox11
	noRT noATR nobe2src" >&2
		exit 1;;
	esac
done
