#!/bin/sh -
# $Header: /nfs-server/bsdreno/sys/rtdist/lib/RCS/install.driver.net.sh,v 1.2 1993/06/23 13:18:33 md Exp $ 
# $Source: /nfs-server/bsdreno/sys/rtdist/lib/RCS/install.driver.net.sh,v $ 

ask=/etc/ask

# This shouldn't be here.... should really bin in rc.
# But we'll put it here until netroot and miniroot have
# merged back together.
# stty erase "^H"

echo "
Do you wish to install from tape or over the network?

1 - tape
2 - network 
"
while :
do
	echo -n "Choice? "
	case "`onechar`" in
	[1tT])	tape=1; break;;

	[2nN])	tape=0; break;;

	"$ESC")	exit 1;;

	*)	echo "\
Press '1' to install system from tape,
      '2' to install system over the network, or
      '<ESC>' to return to the main menu.";;

	esac
done

# setup options

ROOT="hd0a"
USR="hd0g"
VAR="hd0e"

output=verbose
ooutput=terse
NETUSER=rtinst

onet=ethernet
net="token ring"

Oha=1
Ohg=2
Ohe=3

case $tape in
0)	Osh=4
	Oth=5
	Onm=6
	Orh=7
	Onp=8
	Onu=u
	Oop=v
	Opi=0;;
1)	Osh=XX
	Oth=XX
	Onm=XX
	Orh=XX
	Onp=XX
	Onu=XX
	Oop=v
	Opi=0;;
esac

RefreshMenu=1
change_defaults=1
until (exit $change_defaults)
#while :
do
	case $RefreshMenu in

	1)	echo "${CLEAR}
Choice		Description				Current Value

  $Opi	Proceed with installation.

  $Oha	Install / on partion:                   	$ROOT
  $Ohg	Install /usr on partion:                   	$USR
  $Ohe	Install /var on partion:                   	$VAR

`
	case $tape in 0)	echo \"\
  $Osh	Select source host.				$shost
  $Oth	Select target host.				$thost
  $Onm	Specify netmask.                                $netmask
  $Orh	Specify default router.                         $router
  $Onp	Change network preference to $onet.  	$net
  $Onu	Specify network user.                           $NETUSER
\";;
	esac`

  $Oop	Change output from $output to $ooutput.		$output
 ESC	Abort installation.

Type the number of the menu choice desired."
		;;

	*)	RefreshMenu=1;;
	esac


	echo -n "Choice? "
	case "`onechar`" in

	# general options

	$Opi)	
		change_defaults=0
		case $tape in
		0)
		    if [ -s "$shost" ] ; then
			echo "Source host MUST be defined for network install"
			change_defaults=1;
		    fi
		    if [ -s "$thost" ] ; then
			echo "Target host MUST be defined for network install"
			change_defaults=1;
		    fi
		    if [ -s "$NETUSER" ] ; then
			echo "NetUser MUST be defined for network install"
			change_defaults=1;
		    fi
		    ;;
		esac
		;;
		# break;;

	$Oop)	swap="$output";output="$ooutput";ooutput="$swap"
		;;

	$Oha)	echo -n "Enter ROOT partition name: "
		read newpart junk
		case "$newpart" in
		#null, contains space, contains tab
		hd[0-5]*)
			ROOT=$newpart;;

		*)
			echo "'$newpart' is an invalid partion"
			# XXX: bug in sh with continue !!!
			# eval $MENU
			# continue;;
			;;
		*)
		esac
		;;

	$Ohg)	echo -n "Enter USR partition name: "
		read newpart junk
		case "$newpart" in
		#null, contains space, contains tab
		hd[0-5]*)
			USR=$newpart;;

		*)
			echo "'$newpart' is an invalid partion"
			# XXX: bug in sh with continue !!!
			# eval $MENU
			# continue;;
			;;
		*)
		esac
		;;

	$Ohe)	echo -n "Enter VAR partition name: "
		read newpart junk
		case "$newpart" in
		#null, contains space, contains tab
		hd[0-5]*)
			VAR=$newpart;;

		*)
			echo "'$newpart' is an invalid partion"
			# XXX: bug in sh with continue !!!
			# eval $MENU
			# continue;;
			;;
		*)
		esac
		;;

	# network options
	$Onp)	swap="$net"
		net="$onet"
		onet="$swap";;

	$Osh)	echo -n "Enter source host ip-address: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid hostname"
			# XXX: bug in sh with continue !!!
			# eval $MENU
			# continue;;
			;;
		*)
			shost=$newhost;;
		esac
		# shost=$newhost;;
		;;

	$Oth)	echo -n "Enter target host ip-address: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid hostname"
			# eval $MENU
			# continue;;
			;;
		*)
			thost=$newhost;;
		esac
		# thost=$newhost;;
		;;

	$Onm)	echo -n "Enter netmask: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid netmask"
			# eval $MENU
			# continue;;
			;;
		*)
			netmask=$newhost;;
		esac
		# netmask=$newhost;;
		;;

	$Orh)	echo -n "Enter the default router ip-address: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid address"
			# eval $MENU
			# continue;;
			;;
		*)
			router=$newhost;;
		esac
		# router=$newhost;;
		;;

	$Onu)	echo -n "Enter the network install user name: "
		read newuser junk
		case "$newuser" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newuser' is an invalid user name"
			;;
		*)
			NETUSER=$newuser;;
		esac
		;;

	# general cleanup
	[qQ]) exit 1;;
	"$ESC")	exit 1;;

	"")	RefreshMenu=0;;

	*)	echo "Invalid option"
		RefreshMenu=0;;

	esac
done


# finish up by setting a bunch of env variables

export ROOT USR VAR

case $output in
verbose) 
	VERBOSE=-v
	export VERBOSE
	;;
esac

case $tape in
0)	
	#
	if [ -n "$shost" ] ; then
	    SHOST=$shost
	    export SHOST
	fi
	if [ -n "$thost" ] ; then
	    THOST=$thost
	    export THOST
	fi
	if [ -n "$router" ] ; then
	    ROUTER=$router
	    export ROUTER
	fi
	if [ -n "$netmask" ] ; then
	    NETMASK="netmask $netmask"
	    export NETMASK
	fi

	case $net in
	ethernet)	INTERFACE=ub0;;
	*)		INTERFACE=lan0;;
	esac
	export INTERFACE NETUSER

	# echo shost=$SHOST thost=$THOST router=$ROUTER netmask=$NETMASK
	# echo interface=$INTERFACE

	Command="restore.net"
	;;

1)	Command="restore.tape"
	;;
esac

# echo $Command

if eval $Command 
then
	echo "Installation was successful"
else
	echo "Installation was NOT successful"
fi

case $tape in
0)	
	# clean-up by removing the route and disabling the interface
	if [ -n "$router" ] ; then
		route delete 0 $router
	fi
	ifconfig $INTERFACE down
	;;
esac

exit 0
