/*
* 5713-AEQ COPYRIGHT IBM CORP 1989
* LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
*/
#include <sccs.h>
H_SCCSID(@(#)tkr.h	16.4	AIX)	/* Modified: 16:07:11 9/16/89 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/* adapter unit numbers */
#define ADAPTER0	0
#define ADAPTER1	1

/* masks for telling which adapter we have */
#define PRIMARY		0x1
#define ALTERNATE	0x2

/* Programmed I/O instructions for poking the board.
/* read the switch settings which returns an encoded value containing
 * the starting location of the ROM and the adaptor's interrupt level.
 */
#define READ_SETUP1(port)	inb(port)

/* These are only used on the ADAPTER/A for additional setup of I/O registers */
#define READ_SETUP2(port)	inb(port+0x2)	

/* used for initialization.  This is a two step process whereby the adapter
 * is given a reset command, which is latched.  After delaying for at least
 * 50 milliseconds, the adapter is released.
 */
#define A_RESET(port)		outb(port+0x1,1)
#define A_RELEASE(port)		outb(port+0x2,1)

/* resets and re-enables all adapter interrupt circuitry */
#define A_IRELEASE(port)	outb(port+0x3,1)

/* global interrupt release for ADAPTER I/II's */
#define GLOBAL_IREL(irq) outb(0x2f0+(irq),1)

#define	SETUP_INTBITS	0x03		/* mask to get interrupt level bits */
#define	MMIO_BIT19	0x01		/* SETUP_2 bit that is MMIO bit19 */

/* number to ticks that the board must be held in a reset state before it
 * can be unlatched.  The manual recommends 50 ms, but I set it to a 100ms
 * just for safety
 */
#define LATCH_TIME	(hz*100L/1000L + 1)

/* 
 * give the board INIT_WAITS * LATCH_TIME ms to complete initialization
 */
#define INIT_WAITS	100

/* defines for directing the tk_watch to reset and reopen the adapter */
#define OUTPUT_WATCH	0
#define REOPEN_ADAPTER	1

/*
 * This is a hardware dependent card identifier used to check to see if we
 * actually have token ring installed where the SWITCH_READ() told us that
 * it was
 */
#define CARD_ID_I	0x5049434fL	/* card id for ADAPTER/I */
/* in the future: don't know the card id for ADAPTER/II - using same as I */
#define CARD_ID_II	0x5049434fL	/* card id for ADAPTER/II */
#define CARD_ID_A	0x4d415253L	/* card id for ADAPTER/A */

#define	ADAPTER_NONE	0		/* card is not a token ring adapter */
#define	ADAPTER_I	1		/* card is adapter/I */
#define	ADAPTER_II	2		/* card is adapter/II */
#define	ADAPTER_A	3		/* card is adapter/A */


struct tkdevice {
	u_short hardwired;	/* hard-wired values stuck in the ROM */
	u_char length;
	u_char rom_entry;
	u_char rom[7675];
	u_char rom_checksum;
	u_char rrr_high;	/* high and low bytes of ram relocation */
	u_char rrr_low;		/* register */
	u_short wrb;		/* write region buffer */
	u_short wwo;		/* write window open */
	u_short wwc;		/* write window close */
	u_char isrp_high;	/* interrupt status register-PC/high byte */
	u_char isrp_low;	/* interrupt status register-PC/low byte */
	u_char isra_high;	/* interrupt status register-adapter/high byte*/
	u_char isra_low;	/* interrupt status register-adapter/low byte*/
	u_char tcr_high;	/* timer control register / high byte */
	u_char tcr_low;		/* timer control register / low byte */
	u_char tvr_high;	/* timer value register / high byte */
	u_char tvr_low;		/* timer value register / low byte */
	u_char hole1[24];
	u_char reset_isrp_high;	/* reset isrp - high byte */
	u_char reset_isrp_low;	/* reset isrp - low byte */
	u_char hole_high1;
	u_char reset_isra_low;	/* reset isra - low byte */
	u_char reset_tcr_high;	/* reset tcr - high byte */
	u_char hole3[27];
	u_char set_isrp_high;	/* set isrp - high byte */
	u_char set_isrp_low;	/* set isrp - low byte */
	u_char hole_high2;
	u_char set_isra_low;	/* set isra - low byte */
	u_char set_tcr_high;	/* set tcr - high byte */
	u_char padding1[179];
	u_char adapter_addr[24];/* nibbles: encoded adapter address */
	u_char adapter_addrc[24];/* nibbles 1s complement of adapter address */	
	u_char tk_id[16];	/* nibbles: token ring adapter identifier */
	u_char tk_id2[32];	/* nibbles: token ring adapter identifier 2 */
	u_char padding2[160];
};


#define RAM_WORD(ram,off)	(*(u_short far *)(ram + (off)))
#define FLIP(word) 	(u_short)( ((u_short)(word) >> 8) | ((word) << 8) )

/* 
 * Bit masks for ISRP - low register
 */
#define SSB_RESPONSE 	0x04
#define ARB_COMMAND	0x08
#define ASB_FREE	0x10
#define SRB_RESPONSE	0x20
#define ADAPTER_CHK	0x40

#define ISRP_LOW_BITS	"\20\7DEAD\6SRB_RESP\5ASB_FREE\4ARB_COM\3SSB_RESP"

/* 
 * Bit masks for the ISRP - high register 
 */
#define SHARED_INTR	0x02
#define ACCESS_INTR	0x04
#define ERROR_INTR	0x08
#define TIMER_INTR	0x10
#define INTR_ENABLE	0x40
#define NMI_INTRCTRL	0x80

#define ISRP_HIGH_BITS	"\20\7INTR_EN\5TIM_INTR\4ERR_INTR\3ACC_INTR\2SH_INTR"

/* 
 * Bit masks for the ISRA - low register
 */ 

#define SSB_FREE	0x01
#define ARB_FREE	0x02
#define ASB_FREE_REQ	0x04
#define SRB_FREE_REQ	0x08
#define ASB_RESPONSE	0x10
#define SRB_COMMAND	0x20

#define ISRA_LOW_BITS	\
	"\20\6SRB_COM\5ASB_RESP\4SRB_FREQ\3ASB_FREQ\2ARB_FREE\1SSB_FREE"

/*
 * Bit masks for the ISRA - high register
 */

#define SOFT_INTR_MASK	0x01
#define HARD_INTR_MASK	0x02
#define PROCESSOR_CHK	0x08
#define DEADMAN_TIMER	0x10
#define SEE_ACCESS_INTR	0x20
#define SEE_TIMER_INTR  0x40

#define ISRA_HIGH_BITS  \
	"\20\7SEE_TIMER\6SEE_ACCESS\5DEADMAN\4PROCESSOR_CHK\2HARD_MSK\1SOFT_MSK"

#define OPEN_OPTS_LOW		0x00
#define OPEN_OPTS_HIGH		0x00

/* receive open parameters for ADAPTER I */
#define NUM_RECV8		18
#define RECV_LEN8		256

/* receive open parameters for ADAPTER II/A */
#define RECV_LEN16		1032
#define NUM_RECV16		12

/* the size of the trasmit buffer is independent of the adapter type */
#define XMIT_LEN		2040
#define NUM_XMIT		1

/* asb queue definitions, should be as large as the largest number of
 *  receieve buffers possible
 */
#define ASB_QUEUE_SIZE		18

/* queue up all of the asb requests that can't immediately be serviced.  
 * dequeuing occurrs when an ASB_FREE interrupt is received
 */
struct asb_q {
	u_char  cmd;
	u_short response_data;
};

/* PC to adapter commands */
#define DIR_INTERUPT		0x00
#define DIR_MODIFY_OPEN_PARMS	0x01
#define DIR_RESTORE_OPEN_PARMS	0x02
#define DIR_OPEN_ADAPTER	0x03
#define DIR_CLOSE_ADAPTER	0x04
#define DIR_SET_GROUP_ADDR	0x06
#define DIR_SET_FUCTIONAL_ADDR	0x07
#define DIR_READ_LOG		0x08
#define DIR_SET_BRIDGE_PARMS	0x09
#define TRANSMIT_DIR_FRAME	0x0a
#define DIR_CONFIG_BRIDGE_RAM	0x0c

/* adapter to PC commands */
#define RECEIVED_DATA		0x81
#define RING_STATUS_CHANGE	0x84
#define TRANSMIT_DATA_REQUEST	0x82

/* where all messages are routed */
#define DIRECT_STATION		0x0000

/* 
 * Bit masks for Ring Commands that we might receive.
 */
#define SIGNAL_LOSS		0x8000
#define HARD_ERROR		0x4000
#define SOFT_ERROR		0x2000
#define TRANSMIT_BEACON 	0x1000
#define LOBE_WIRE_FAULT 	0x0800
#define AUTO_REMOVAL		0x0400
#define REMOVE_RECEIVED  	0x0100
#define COUNTER_OVERFLOW 	0x0080
#define SINGLE_STATION   	0x0040
#define RING_RECOVERY	 	0x0020

/* codes for when everything OK */
#define INIT_COMPLETE		0x80
#define SUCCESS			0x00

/* error codes that could occur at initialization or open */
#define PROCESSOR_FAIL		0x20
#define ROM_FAIL		0x22
#define RAM_FAIL		0x24
#define INSTRUCTION_FAIL	0x26
#define INTERRUPT_FAIL		0x28
#define MEMORY_FAIL		0x2a
#define PROTOCOL_FAIL		0x2c
#define TIMER_FAIL		0x40
#define WRITE_RAM_FAIL		0x42
#define READ_RAM_FAIL		0x44
#define RO_RAM_FAIL		0x46
#define INIT_TIMEOUT		0x48

#define INVALID_FAIL		0x01
#define OPEN_FAIL		0x03
#define PARAM_FAIL		0x05
#define CANCEL_FAIL		0x07
#define RBUF_FAIL		0x30
#define ADDR_FAIL		0x32
#define RBUF_LEN_FAIL		0x33
#define XBUF_LEN_FAIL		0x34
