
#define HC_BITFIELD_BUG

#ifndef lint
static char *rcsid = "$Header: /sys/rtif/RCS/if_tr.c,v 1.3 1994/04/26 15:12:48 roger Exp $";
#endif lint

/*
 * IBM PC Token Ring Adapter
 */

#include "tr.h"
#if NTR > 0

#include "rt/pte.h"

#include "param.h"
#include "systm.h"
#include "mbuf.h"
#include "buf.h"
#include "protosw.h"
#include "socket.h"
#include "vmmac.h"
#include "ioctl.h"
#include "errno.h"

#include "net/if.h"
#include "net/if_types.h"
#include "net/netisr.h"
#include "net/route.h"

#ifdef INET
#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/in_var.h"
#include "netinet/ip.h"
#include "netinet/if_ether.h"
#include "netinet/if_802_5.h"
#endif INET

#ifdef NS
#include "netns/ns.h"
#include "netns/ns_if.h"
#endif NS

#include "rt/io.h"
#include "if_trreg.h"
#include "rtio/ioccvar.h"
#include "rt/debug.h"

#if 0
#include "bpfilter.h"
#if NBPFILTER > 0
#include "net/bpf.h"
#include "net/bpfdesc.h"
#endif
#endif /* if_0 */

int	trint(), trprobe(), trattach();

caddr_t trstd[] = { (caddr_t) 0xf0000a20, (caddr_t) 0xf0000a24, 0 };

struct	iocc_device *trinfo[NTR];

int	trint(), trinit(), trioctl(), trreset(), trstart(), token_output();

struct	iocc_driver trdriver =
	{ trprobe, 0, trattach, 0, trstd, "tr", trinfo,
		0, 0, trint, 0x1 };

/*
 * Software status per adapter.
 */
struct	tr_softc {
	struct	arpcom tr_ac;		/* generic network interface stuff */
#define	tr_if	tr_ac.ac_if		/* ifnet struct */
#define	tr_addr	tr_ac.ac_enaddr		/* hardware (i.e. ethernet) address */
	caddr_t	tr_piobase;		/* base address of the card */
	u_long	tr_mmiobase;		/* base address of the mmio */

#define SRAM_BASE	0xE0000		/* XXX: should make this configurable*/
	u_long	tr_csrambase;		/* base address we tell the card */
	u_long	tr_srambase;		/* base address of shared ram */
	u_short	tr_srb;			/* system request buffer */
	u_short	tr_arb;			/* adapter request buffer */
	u_short	tr_ssb;			/* system status buffer */
	u_short	tr_asb;			/* adapter status buffer */
	u_short tr_dhb_addr;            /* location of the xmit buffer */
        u_char tr_comm_correlate;       /* id of outstanding xmit command */

        struct asb_q asb_req[ASB_QUEUE_SIZE];/* queue for saving asb requests */
        int asb_qhead;                   /* that can't immediately be serviced*/
        int asb_qtail;                  /* head and tail pointers */
        int asb_busy;                   /* asb being used? */

/*XXX*/ int tr_need_trans;               /* need to setup a transmit command? */

	u_char tr_flags;
#define TR_RATE_16		0x1	/* card is set at 16M */
#define TR_BROKEN		0x2	/* card wont initialize */
#define TR_OPEN			0x4	/* card is open */
#define TR_OC_IN_PROGRESS	0x8	/* open/close in progress */

	/* start informational section */
	u_long	tr_cardid;		/* card id */
	u_char	tr_ramsize;		/* switch settings for ram ?? */
#define TR_RAMMASK	0x6
#define TR_RAM8		0x0
#define TR_RAM16	0x2
#define TR_RAM32	0x4
#define TR_RAM64	0x6

	u_char	tr_info[7];		/* 7 bytes of info about the card */
#define TR_CARD_4	0xf		/* in info[1] */
#define TR_CARD_16	0xe
#define TR_CARD_4_16	0xd

	/* end informational section */
} tr_softc[NTR];

#ifdef DEBUG
char trdebug = 0;
#endif DEBUG

/*
 * probe the adapter.  Just enough duplicated code from trinitialize
 * to cause the adapter to generate an interrupt.  
 */
trprobe(p)
	register caddr_t p;
{
	register struct tr_pio *pio = (struct tr_pio *) p;
        register struct trdevice *mmaddr;
	u_long mmio_paddr;

/* 	printf ("in trprobe, p = 0x%x\n", p); */

	/* calculate the memory switch settings on the card */
	mmio_paddr = IOIN (&pio->setup);
	mmio_paddr = ((mmio_paddr & ~(3)) << 11) | 0x80000L;
	mmio_paddr += MEM_BASE;
	mmaddr = (struct trdevice *) mmio_paddr;

	/* reset the adapter */
	MM_OUT (&pio->latch, 0x1);
	delay (LATCH_TIME);
	MM_OUT (&pio->release, 0x1);

	/* enable interrupts */
	MM_OUT (&mmaddr->set_isrp_high, (INTR_ENABLE | NMI_INTRCTRL));

	/* wait for the interrupt */
	delay (LATCH_TIME * 30 /* INIT_WAITS */);

	/* disable interrupts */
	MM_OUT (&mmaddr->reset_isrp_high, (~INTR_ENABLE));

	return(PROBE_OK);
}

trattach(iod) 
register struct iocc_device *iod;
{
        register struct tr_softc *tr = &tr_softc[iod->iod_unit];
        register struct ifnet *ifp = &tr->tr_if;
        register struct trdevice *mmaddr;
	struct tr_srb *srb;
	u_long mmio_paddr, card_id;
        register int i, j;
	int irq = 0;
	u_short address_addr;

/* 	printf ("trattach called for unit %d\n", iod->iod_unit); */

	/* calculate the memory switch settings on the card */
	tr -> tr_piobase = iod -> iod_addr;
	tr->tr_mmiobase = IOIN (iod->iod_addr);
	tr->tr_mmiobase = ((tr->tr_mmiobase & ~(3)) << 11) | 0x80000L;
	tr->tr_mmiobase += MEM_BASE;
	mmaddr = (struct trdevice *) tr->tr_mmiobase;

	/* find out what type of card we have */
	tr->tr_cardid = 0;
	for (i = 0; i < sizeof (mmaddr->id); i += 2) {
	    tr->tr_cardid = (u_long) tr->tr_cardid << 4;
	    tr->tr_cardid += IOIN(&mmaddr->id[i]) & 0x0f;
	}

	/*
	 * this tells us how much shared memory the adapter thinks it
	 * is going to use (according to the switches on the board).
	 */
	tr->tr_ramsize = IOIN(&mmaddr->rrr_low);

	/* and some misc info that we might need ? */
	for (i = 0, j = 0; i < sizeof (mmaddr->adapter_info); i += 2, j++) {
	    tr->tr_info[j] = IOIN(&mmaddr->adapter_info[i]);
	}

	/* now start initializing some stuff */
	tr -> tr_csrambase = SRAM_BASE;		/* XXX */
	tr -> tr_srambase = tr -> tr_csrambase + MEM_BASE;

	if (trinitialize (iod->iod_unit) != 0)
	    return;

	/*
	 * Read the ethernet address off the board.
	 */
	srb = (struct tr_srb *) (tr->tr_srambase + tr->tr_srb);
	address_addr = IOINW (&srb -> encoded_address);
	{
	    char *sram = (char *) (tr->tr_srambase + address_addr);
#if 0
	    printf ("trattach: address_addr=0x%x, sram=%x\n", 
		address_addr, sram);
#endif
	    for (i = 0; i < TR_ADDR_SIZE; i++){
		tr->tr_addr[i] = IOIN (sram + i);
	    }
	}

	/* a little blurb about this card */
	switch (tr->tr_info[1]) {
	    case TR_CARD_4: 
		printf ("tr%d: 4 meg card\n", iod->iod_unit); 
		break;
	    case TR_CARD_16: 
		printf ("tr%d: 16 meg card\n", iod->iod_unit); 
		break;
	    case TR_CARD_4_16: 
		printf ("tr%d: 16/4 meg card set at %d meg speed\n",
			iod->iod_unit,
			(tr->tr_flags & TR_RATE_16) ? 16 : 4); 
		break;
	}
        printf("tr%d: hardware address %s\n", iod->iod_unit,
                ether_sprintf(tr->tr_addr));

	ifp->if_unit = iod->iod_unit;
	ifp->if_name = "tr";
	ifp->if_mtu = TR_MTU;
	ifp->if_init = trinit;
	ifp->if_reset = trreset;
	ifp->if_ioctl = trioctl;
	ifp->if_output = token_output;
        ifp->if_start = trstart;
	ifp->if_flags = IFF_BROADCAST|IFF_ALLCAST;
	ifp->if_addrlen = TR_ADDR_SIZE;
	ifp->if_type = IFT_ISO88025;
	ifp->if_snd.ifq_len = 0;

#if 0	/* NBPFILTER > 0 */
/* XXX: no bpf support yet */
	{
		static struct bpf_devp dev = 
			{ DLT_EN10MB, sizeof(struct ether_header) };
	    
		bpfattach(&us->us_bpf, ifp, &dev);
	}
#endif
	if_attach(ifp);
	token_ifattach(ifp);
}

/*
 * initialize the adapter.
 */
trinitialize (unit)
int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
	register struct tr_pio *pio = (struct tr_pio *) tr -> tr_piobase;
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	struct tr_srb *srb;
	int retry;
	u_short bring_up_code = 0;
	u_char init_code;

/* 	printf ("trinitialize called for unit %d\n", unit); */

	/* reset the adapter */
	MM_OUT (&pio->latch, 0x1);
	delay (LATCH_TIME);
	MM_OUT (&pio->release, 0x1);

	/* enable interrupts */
	MM_OUT (&mmaddr->set_isrp_high, (INTR_ENABLE | NMI_INTRCTRL));

	tr->tr_srb = tr->tr_arb = tr->tr_ssb = tr->tr_asb = 0;
	tr->tr_flags = 0;
	tr->asb_qhead = tr->asb_qtail = 0;

	for (retry = 0; retry < INIT_WAITS; retry ++) {
	    if (IOIN (&mmaddr->isrp_low) & SRB_RESPONSE)
		break;
	    delay (LATCH_TIME);
	}
/* 	printf ("trinitialize: delayed %d ticks\n", LATCH_TIME * retry); */

	/* disable interrupts */
	MM_OUT (&mmaddr->reset_isrp_high, (~INTR_ENABLE));

#if 1
	if (! (IOIN (&mmaddr->isrp_low) & SRB_RESPONSE) ) {
	    printf ("trinitialize: cannot init unit %d\n", unit);
	    return (-1);
	}
#endif

	/* clear response bit */
	MM_OUT (&mmaddr->reset_isrp_low, (~SRB_RESPONSE));

	/* set location of shared ram that the adapter will use */
	MM_OUT (&mmaddr->rrr_high, (tr -> tr_csrambase >> 12));

	/* check that this adapter initialized ok */
	tr->tr_srb = IOINW (&mmaddr->wrb);
	srb = (struct tr_srb *) (tr->tr_srambase + tr->tr_srb);
	init_code = IOIN (&srb->command);
	bring_up_code = IOINW (&srb->bring_up_code);

	if ((init_code != INIT_COMPLETE) || (bring_up_code)) {
	    printf ("trinitialize: init %d failed: init_code=0x%x, bring_up=0x%x\n",
		unit, init_code, bring_up_code);
	    return (-1);
	}

	tr->tr_flags |= (IOIN (&srb->init_status) & TR_RATE_16);

/* 	printf ("trattach: srpr=0x%x\n", IOINW(&mmaddr->srpr_high)); */

	return (0);
}

trreset(unit)
        register unsigned int unit;
{
        register struct iocc_device *iod;

        if (unit < NTR && (iod = trinfo[unit]) != 0 && iod->iod_alive != 0) {
                tr_softc[unit].tr_if.if_flags &= ~IFF_RUNNING;
                trinit(unit);
        }
}

/*
 *  trinit - initialize interface, enable packet reception, start any
 *  pending writes
 */
trinit(unit)
        register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct ifnet *ifp = &tr->tr_if;

        if (ifp->if_addrlist == (struct ifaddr *) 0){
                /* no address */
                return;
        }
        if ((ifp->if_flags & IFF_RUNNING) == 0){
	    if (trinitialize(unit) == 0) {
		ifp -> if_flags |= IFF_RUNNING;
	    }
	    else {
		tr->tr_flags |= TR_BROKEN;
		ifp -> if_flags &= ~(IFF_RUNNING|IFF_UP);
	    }
	}
        if (ifp -> if_flags & IFF_RUNNING) {
	    if ((tr->tr_flags & (TR_OPEN|TR_OC_IN_PROGRESS)) == 0) {
		tr_open_adapter(unit);  /* Open adapter */
	    }
        }
}

/*
 * tr_open_adapter()
 * -----------------
 * This routine sets up an open command for the adapter.  The adapter isn't
 * open until we receive an OPEN_COMPLETE interrupt which is handled in 
 * tr_open_complete()
 */
tr_open_adapter(unit)
        register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register int i;
	register u_short srb;

/* 	printf ("tr%d: tr_open_adapter called\n", unit); */
	tr->tr_flags |= TR_OC_IN_PROGRESS;
	srb = tr->tr_srb = IOINW (&mmaddr->wrb);

	 /* Interrupts will be enabled as long as the the adapter is open.
	  */
	MM_OUT (&mmaddr->set_isrp_high, (INTR_ENABLE | NMI_INTRCTRL));

	/* prepare the srb with the open command */
	MM_OUT (&sram[srb], DIR_OPEN_ADAPTER);
	MM_OUT (&sram[srb + 8], OPEN_OPTS_HIGH);
	MM_OUT (&sram[srb + 9], OPEN_OPTS_LOW);

	/* don't specify NODE, GROUP, and FUNCTIONAL addresses */
	for (i = 10; i < 24; ++i)
		MM_OUT (&sram[srb + i], 0);

	/*
	 * Based on the location of the SRB, (which is near the edge of RAM)
	 * determine if we have 16k or 8k of ram and set the number of 
	 * buffers accordingly.
	 */
	if (srb > (8 * 1024)) {	/* 16k of ram */
		MM_OUTW (&sram[srb + 24], NUM_RECV16);
		MM_OUTW (&sram[srb + 26], RECV_LEN16);
	}
	else {	/* 8k of ram */
		MM_OUTW (&sram[srb + 24], NUM_RECV8);
		MM_OUTW (&sram[srb + 26], RECV_LEN8);
	}

	/* the size of the transmit buffer is independent of the ram size */
	MM_OUTW (&sram[srb + 28], XMIT_LEN);
	MM_OUT (&sram[srb + 30], NUM_XMIT);

	for (i = 31; i < 60; i++)
		MM_OUT (&sram[srb + i], 0);

	/* interrupt the adapter */
	MM_OUT (&mmaddr->set_isra_low, SRB_COMMAND);
}

/* 
 * tr_open_complete
 * ---------------
 * Interrupt handler called when the adapter open has completed.  Sets the 
 * values of the asb, arb, ssb, and srb.  Calls the ethernet initialization
 * routines.
 */
tr_open_complete(unit)
int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
        register struct ifnet *ifp = &tr->tr_if;
	u_char retcode;
	int was_running;

	/* clear the interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, (~SRB_RESPONSE));

	tr->tr_flags &= ~TR_OC_IN_PROGRESS;
	if ((retcode = IOIN (&sram[tr->tr_srb + 2])) != SUCCESS) {
		u_short open_error = IOINW (&sram[tr->tr_srb + 6]);

		tr_open_error (unit, retcode, open_error);

		/* should be nice and attempt to re-insert ourselves in
		 * the ring at this point.  PS/2 driver did that here.
		 */
		ifp->if_flags &= ~(IFF_UP|IFF_RUNNING) ;
		return;
	}

	/* the open went fine.  Assign the command control blocks */

	tr->tr_flags |= TR_OPEN;
	tr->tr_asb = IOINW (&sram[tr->tr_srb + 8]);
	tr->tr_arb = IOINW (&sram[tr->tr_srb + 12]);
	tr->tr_ssb = IOINW (&sram[tr->tr_srb + 14]);
	tr->tr_srb = IOINW (&sram[tr->tr_srb + 10]);

	/*
	 * setup a transmit command ahead of time so that one will always
	 * be ready when ostart is called
	 */
	tr_setup_trans(unit);
	ifp->if_flags |= IFF_RUNNING;
}

/*
 * tr_close_adapter()
 * -----------------
 * This routine sets up an close command for the adapter.
 */
tr_close_adapter(unit)
        register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;

/* 	printf ("tr_close_adapter: tr%d\n", unit); */
	if (tr->tr_flags & TR_OC_IN_PROGRESS)
		return;
	tr->tr_flags |= TR_OC_IN_PROGRESS;

	/* prepare the srb with the close command */
	MM_OUT (&sram[tr->tr_srb], DIR_CLOSE_ADAPTER);
	tr->tr_need_trans = 0;
#if 0
	tk_board->init_done = 0;
#endif

	/* interrupt the adapter */
	MM_OUT (&mmaddr->set_isra_low, SRB_COMMAND);
	tr -> tr_if.if_flags &= ~(IFF_RUNNING|IFF_OACTIVE);
}

/*
 * tr_setup_trans
 * --------------
 * This routine is called so that we can always try and have a transmit
 * command outstanding when ostart is called.   That allows us to not have
 * to wait for the adapter to tell us that it is ready to transmit before 
 * data can actually be moved, hopefully speeding up response time.
 */
tr_setup_trans(unit)
        register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;

	/* set up transmit command. The adapter will interrupt us when it
	 * is ready to for us to place our data in shared ram.
	 */
	MM_OUT (&sram[tr->tr_srb], TRANSMIT_DIR_FRAME);
	MM_OUTW (&sram[tr->tr_srb + 4], DIRECT_STATION);

	/* interrupt the adapter */
	MM_OUT (&mmaddr->set_isra_low, SRB_COMMAND);

	/*
	 * various interrupt handlers will take care of actually sending
	 * the packet.  Return for now.
	 */

/* 	printf ("tr_setup_trans: tr%d: transmit command sent\n", unit); */
}

/* 
 * tr_trans_complete
 * --------------
 * Since the upper layer protocols aren't interested in the return code,
 * errors aren't reported.  The ostart active flag is reset here to allow
 * subsequent calls to that routine.
 */
tr_trans_complete(unit)
    register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;

	tr->tr_if.if_flags &= ~IFF_OACTIVE;     /* output not active */

	/* let the adapter know that the ssb is free and clear the interrupt*/
	MM_OUT (&mmaddr->reset_isrp_low, ~SSB_RESPONSE);
	MM_OUT (&mmaddr->set_isra_low, SSB_FREE);
}

/* 
 * tr_trans_ret
 * ---------
 * If a transmit command cannot be sent for some reason, print the error
 * and return after clearing the interrupt 
 */
tr_trans_ret(unit)
	register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	u_char return_code;

	return_code = IOIN (&sram[tr->tr_srb + 2]);

/*
	printf("bad return from TRANSMIT_DIR_COMMAND on tr%d: 0x%x\n", 
		unit, return_code);
*/

	/* clear interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, ~SSB_RESPONSE);
}

/* 
 * tr_trans_cmd
 * ---------
 * Handle the adapter transmit command by freeing the ARB and always
 * calling ostart.  It is the driver's responsibility to kick
 * the network code so that it can discover that there is no work to do.
 */
tr_trans_cmd(unit)
register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
        register struct ifnet *ifp = &tr->tr_if;
	register char *sram = (char *) tr->tr_srambase;
	register u_short arb = tr->tr_arb;

	tr->tr_need_trans = 0;

	tr->tr_comm_correlate = IOIN (&sram[arb + 1]);

	tr->tr_dhb_addr = IOINW (&sram[arb + 6]);

/*
	printf ("tr_trans_cmd: dhb_addr=0x%x comm_correlate=0x%x\n",
		tr->tr_dhb_addr, tr->tr_comm_correlate);
*/

	/* Clear the interrupt. */
	MM_OUT (&mmaddr->reset_isrp_low, ~ARB_COMMAND);

	/* Free the adapter's arb for further command processing */
	MM_OUT (&mmaddr->set_isra_low, ARB_FREE);
	
	/* kick the output routine if anything is queued */
	trstart(ifp);
}

/*
 * tr_adapter_chk
 * --------------
 * This is a serious error that implies that the ring will be closed.  There
 * are 14 bytes of data that could be interrogated to discover what the problem
 * was.  I'll do it later.
 */

tr_adapter_chk(unit)
	register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;

	/* clear the adapter check interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, ~ADAPTER_CHK);
}

/* 
 * tr_ring_cmd
 * -------------
 * Reports ring status changes on the console
 */
tr_ring_cmd(unit)
	register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register u_short ring_status;
	register u_short arb = tr->tr_arb;

	ring_status = IOINW(&sram [arb + 6]);

/* 	printf ("ring_status = 0x%x\n",ring_status); */

	if (ring_status & SIGNAL_LOSS)
		tr_err(unit, "SIGNAL_LOSS",	"can't detect any signal", 0);

	if (ring_status & HARD_ERROR)
		tr_err(unit, "HARD_ERROR",
			"Beacon frames are being received or transmitted", 0);

#if 0
	if (ring_status & SOFT_ERROR)
		tkr_softerr++;
#endif

	if (ring_status & TRANSMIT_BEACON)
		tr_err(unit, "TRANSMIT_BEACON",
			"Adapter is transmitting beacon frames", 0);

	if (ring_status & LOBE_WIRE_FAULT)
		tr_err(unit, "LOBE_WIRE_FAULT",
			"Open or short circuit detected.", 1);

	if (ring_status & AUTO_REMOVAL)
		tr_err(unit, "AUTO_REMOVAL",
			"Adapter hardware error detected", 1);

	if (ring_status & REMOVE_RECEIVED)
		tr_err(unit, "REMOVE_RECEIVED",
			"Remove MAC frame received.", 1);

#if 0
	if (ring_status & COUNTER_OVERFLOW) {

		/* prepare the srb with the read log command */
		tk_board->sram[tk_board->srb] = DIR_READ_LOG;

		/* interrupt the adapter */
		tk_board->mmio_addr->set_isra_low = SRB_COMMAND;
	}
#endif

	if (ring_status & SINGLE_STATION)
		tr_err(unit, "SINGLE_STATION",
			"No other sites detected", 0);

	if (ring_status & RING_RECOVERY)
		tr_err(unit, "RING_RECOVERY",
			"Adapter is receiving or transmitting contintion MAC frames", 0);

	/* clear and release the interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, ~ARB_COMMAND);
	
	/* Free the adapter's arb for further command processing */
	MM_OUT (&mmaddr->set_isra_low, ARB_FREE);
}

tr_err(unit, error, text, closed)
register int unit;
char *error, *text;
int closed;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct ifnet *ifp = &tr->tr_if;

/* 	printf("tr%d: %s error -- %s\n", unit, error, text); */

	if (closed && (ifp->if_flags & IFF_RUNNING)) {

		tr_close_adapter(unit);
		ifp->if_flags &= ~(IFF_UP|IFF_RUNNING) ;
#if 0
		timeout(if_down, (caddr_t)ifp, (time_t) 0);
		tk_board->oc_in_progress = FALSE;
		/* drop all wating pkts	*/
		while (ifp->if_snd.ifq_head) {
			register struct mbuf *m;

			IF_DEQUEUE(&ifp->if_snd, m);
			IF_DROP(&ifp->if_snd);
			m_freem(m);
		}
#endif
	}
}

/*
 * tr_qasb
 * -----------
 * Anytime either a transmit or receive command needs to inform the adapter
 * of some information via the asb, we queue the request here in this routine
 * for processing when the resource becomes available.  If the asb is already
 * free, then mark that there is one outstanding request (via asb_busy++),
 * and call tr_response directly.  If further requests arrive before this
 * one can be serviced, then they will be queued instead.
 */
tr_qasb(unit, cmd, response_data)
register int unit;
u_char cmd;
u_short response_data;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register struct asb_q *asb_req = tr->asb_req;
	register int asb_qtail = tr->asb_qtail;

	/* if no one is on the queue, respond immediately to the request */
	if (tr->asb_busy++ == 0) {
		tr_response(unit, cmd, response_data);
		return;
	}
#ifndef NOCHECKS
	else if (tr->asb_busy > ASB_QUEUE_SIZE) {
		printf("911-377 tk_qasb: number of asb queue elements =%d\n",
		       tr->asb_busy);
		panic("911-378 tr_qasb: asb queue overflow");
	}
#endif /* NOCHECKS */

	asb_req[asb_qtail].cmd = cmd;
	asb_req[asb_qtail].response_data = response_data;

	/* handle wrapping of tail pointer */
	tr->asb_qtail = (asb_qtail + 1) % ASB_QUEUE_SIZE;

	/* last ditch try to see if the asb is free */
	/* actually this ends up succeeding much of the time */
	if (IOIN(&mmaddr->isrp_low) & ASB_FREE) {
		/* De-queue any pending asb requests */
		tr_dqasb(unit);
		return;
	}
}


/*
 * tr_dqasb
 * -----------
 * Called in response to an ASB_FREE interrupt.  First we check to see if
 * there is anyone on the queue to remove.  The first request isn't queued,
 * so --asb_busy gives a true indication of how many elements are remaining
 * to be serviced.  If there are any elements to dequeue, then call 
 * tr_response() to respond with the delayed adapter command.
 */
tr_dqasb(unit)
register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register struct asb_q *asb_req = tr->asb_req;
	register int asb_qhead = tr->asb_qhead;
	u_char cmd;
	u_short response_data;

	/* clear the interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, ~ASB_FREE);
/* 	MM_OUT (&mmaddr->reset_isrp_low, ~ARB_FREE); */
/* 	MM_OUT (&mmaddr->reset_isrp_low, ~SSB_RESPONSE); */
#if 0
/* 	MM_OUT (&mmaddr->isra_low, (SSB_FREE) ); */
	{
	u_char isra_low = IOIN (&mmaddr->isra_low);
	isra_low &= ~(ASB_RESPONSE | ASB_FREE_REQ);
	MM_OUT (&mmaddr->isra_low, isra_low);
	}
#endif

	/* if no one is on the queue, return immediately */
#if 0
	if (tr->asb_busy == 0) {
		printf ("tr_dqasb: asb_busy was ZERO\n");
		tr_close_adapter(unit);
		return;
	}
	else 
#endif
	if (--tr->asb_busy == 0) {
		return;
	}
#ifndef NOCHECKS
	else if (tr->asb_busy < 0) {
		printf("911-379 tr_dqasb: number of asb queue elements =%d\n",
			tr->asb_busy);
		panic("911-380 tr_dqasb: asb queue inconsistent");
	}
#endif /* NOCHECKS */

	cmd = asb_req[asb_qhead].cmd;
	response_data = asb_req[asb_qhead].response_data;

	/* handle head pointer wrapping properly */
	tr->asb_qhead = (asb_qhead + 1) % ASB_QUEUE_SIZE;

	tr_response(unit,cmd,response_data);
}

/*
 * tr_response
 * -----------
 * Respond to an adapter command by setting codes in the asb.  When this
 * routine is called, we know that the asb is free, so there is no need for
 * checking any status.
 * 
 * If respond to a transmit command then flag that we are now expecting an 
 * output interrupt, and setup another transmit ahead of time.
 */
tr_response(unit,cmd,response_data)
register int unit;
u_char cmd;
u_short response_data;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register int asb = tr->tr_asb;

/*         printf ("tr%d: responding to command 0x%x\n", unit, cmd); */

	/* it is only possible to have one tranmit command outstanding at
	 * a time, thus only one comm_correlate is necessary
	 */
	if (cmd == TRANSMIT_DIR_FRAME)
		MM_OUT (&sram[asb + 1], tr->tr_comm_correlate);

	MM_OUT (&sram[asb], cmd);
	MM_OUT (&sram[asb + 2], SUCCESS);		/* return code */

	MM_OUTW (&sram[asb + 4], DIRECT_STATION);	/* station id */
	MM_OUTW (&sram[asb + 6], response_data);

	/* interrupt the adapter.  Tell it to let us know when the asb
	 * is free so we can clear the busy flag
	 */
	MM_OUT (&mmaddr->set_isra_low, (ASB_RESPONSE | ASB_FREE_REQ) );
/* 	MM_OUT (&mmaddr->isra_low, (ASB_RESPONSE | ASB_FREE_REQ) ); */

	if (cmd == TRANSMIT_DIR_FRAME) {
#if 0
		tk_board->oint = 1;		/* we are expecting a completion
						 * interrupt */
#endif
		tr->tr_need_trans = 1;		/* we are going to need */
						/* a transmit command now */
		tr_setup_trans(unit);
	}
}

/*
 *  ioctl - process an ioctl request.
 */
trioctl(ifp, cmd, data)
        register struct ifnet *ifp;
        register int cmd;
        register caddr_t data;
{
        register struct ifaddr *ifa = (struct ifaddr *)data;
        register int s = splimp();
        register int error = 0;

        switch (cmd){
        case SIOCSIFADDR:
		/* XXX: for arp handling */
		((struct in_ifaddr *) data)->ia_ifa.ifa_rtrequest = arp_rtrequest;
		((struct in_ifaddr *) data)->ia_ifa.ifa_flags |= RTF_CLONING;

                ifp->if_flags |= IFF_UP;

                switch (ifa->ifa_addr->sa_family){
#ifdef INET
                case AF_INET:
                        trinit(ifp->if_unit);   /* before arpwhohas */
			if (! (ifp->if_flags & IFF_RUNNING))
			    break;
                        ((struct arpcom *) ifp)->ac_ipaddr =
                          IA_SIN(ifa)->sin_addr;
                        arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
                        break;
#endif INET
#if 0 /* #ifdef NS */
                case AF_NS:
                    {
                        struct ns_addr *ina = &(IA_SNS(ifa)->sns_addr);
                        struct ub_softc *us = &ub_softc[ifp->if_unit];

                        if (ns_nullhost(*ina))
                                ina->x_host = *(union ns_host *)(us->us_addr);
                        else {
                                ifp->if_flags &= ~IFF_RUNNING;
                                bcopy((caddr_t) ina->x_host.c_host,
                                  (caddr_t) us->us_addr, sizeof(us->us_addr));
                                /*
                                 *  the ubinit will set the hardware address
                                 *  since the IFF_RUNNING flag is off
                                 */
                        }
                        ubinit(ifp->if_unit);
                        break;
                    }
#endif NS
                default:
                        trinit(ifp->if_unit);
                        break;
                }
                break;
        case SIOCSIFFLAGS:
                if ((ifp->if_flags & IFF_UP) == 0 && (ifp->if_flags &
                  IFF_RUNNING)){
			tr_close_adapter(ifp->if_unit);
                } else if ((ifp->if_flags & IFF_UP) && (ifp->if_flags &
                  IFF_RUNNING) == 0)
                        trinit(ifp->if_unit);
                break;
        default:
                error = EINVAL;
        }
        splx(s);
        return(error);
}
 
/*
 * tr_get - copy from driver receive buffers into mbuf's
 */
struct mbuf *
tr_get(faddr, totlen, unit, mac_len)
	u_short faddr;
	register unsigned short totlen;
	int unit;
	int mac_len;
{
	register struct mbuf *m;
	struct mbuf *top = 0;
	register struct mbuf **mp = &top;
	register unsigned short len, copylen;
	register u_char * cp;
	int first = 1;

#ifdef HC_BITFIELD_BUG
	int copy_mac = 1;
	int full_mac_len = sizeof (struct mac_hdr);
#endif

        register struct tr_softc *tr = &tr_softc[unit];
        register struct ifnet *ifp = &tr->tr_if;
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;

        u_short rbuf;           /* offset of next token ring receive buffer */
        register char *dest;    /* address to copy next group of bytes to */
        char *src;              /* address to copy next group of bytes from */
        u_short cardlen;        /* number of characters to copy from this
                                   buffer */
        int tlen = 0;           /* number of bytes copied into receive buf
                                   so far */

 
/* 	printf ("tr_get called\n"); */

	/* XXX: re-write the data references.  See page 7-68 in the manual */
        rbuf = faddr + 2;    			/* addr of next ptr */
	cardlen = IOINW (&sram[faddr + 6]);	/* length of this segment */
	src = &sram[faddr + 8];
/*        src = (char *) IOIN (&sram[faddr + 8]);	/* start of this segment */

#if 0
	printf ("tr_get: cardlen=%d, src=0x%x, totlen=%d, mac_len=%d\n", 
		cardlen, src, totlen, mac_len);
#endif

	cp = src;
#ifdef HC_BITFIELD_BUG
	/* pad out totlen to full_mac_hdr len (keeps mbuf lengths in-line) */
	totlen += full_mac_len - mac_len;
#endif
	while (totlen > 0) {
		char *mcp;
		int mlen;

		if (first) {
			first = 0;
			mlen = MHLEN;
			MGETHDR(m, M_DONTWAIT, MT_DATA);
			m->m_pkthdr.len = totlen;
			m->m_pkthdr.rcvif = ifp;
		} else {
			MGET(m, M_DONTWAIT, MT_DATA);
			mlen = MLEN;
		}

		if (m == 0)
			goto bad;
		len = totlen;
		if (len >= /* MCLBYTES */ MINCLSIZE ) {
			MCLGET(m, M_DONTWAIT);
			if (m->m_flags & M_EXT) {
				m->m_len = len = MIN(MCLBYTES, len);
			}
			else {
				m->m_len = len = MIN(mlen, len);
			}
		} else {
			m->m_len = len = MIN(mlen, len);
		}
		mcp = mtod(m, char *);

#ifdef HC_BITFIELD_BUG
		/* 
		 * Overcome the hc-bitfield bug.  bitfields MUST
		 * be long-word aligned.  If we copy in the media
		 * header first, then put m_data just past it to
		 * the start of the ip header, the first byte
		 * in the ip header will end up at offset 22 (assuming
		 * no routing info in the mac), which is not long-word
		 * aligned.  The result is incorrect ip_hl and ip_v
		 * values.  A full mac header (32 bytes) plus llc
		 * header (3 bytes) plus snap header (5 bytes)
		 * IS long-word aligned.  So we take care here
		 * to pad out the mac header to its full-blown size
		 * on the first copy.
		 * NOTE: the first mbuf is always a pkthdr, and
		 *	will always have room for the full_mac_hdr.
		 */
		if (copy_mac) {
		    bcopy (cp, mcp, mac_len);	/* copy just the mac_hdr */
		    cp += mac_len;		/* increment card buffer */
		    cardlen -= mac_len;		/* decrement this card buf */
		    totlen -= full_mac_len;	/* decrement total count */
		    mcp += full_mac_len;	/* pad out mbuf */
		    len -= full_mac_len;	/* decrement mbuf-left size */
		    copy_mac = 0;
		}
#endif

		/* copy from the current card receive buf into this mbuf */
copy_again:;
		copylen = MIN(len, cardlen);
#if 0
		printf ("tr_get: copy %d (%d:%d)[%d] bytes, cp=0x%x, mcp=0x%x\n",
			copylen, len, cardlen, totlen, cp, mcp);
#endif
		bcopy (cp, mcp, copylen);

		cardlen -= copylen;
		cp += copylen;
		totlen -= copylen;

		/* 
		 * if at the end of this card buf, move pointers to the next
		 * card buffer.
		 */
		if (cardlen == 0 && totlen) {	/* card buf was shorter */

		    len -= copylen;	/* decrement space left in mbuf */
		    mcp += copylen;	/* increment mbuf pointer */

		    /* rbuf is address of next buffer, plus 2 bytes. pg 7-68 */
		    /* XXX: todo: map into a structure !! */
		    rbuf = IOINW (&sram[rbuf]);
		    if (rbuf) {
			cardlen = IOINW (&sram[rbuf + 4]);/* length of segmnt */
			src = &sram[rbuf + 6];
			cp = src;

/*
			printf ("tr_get: cardlen=%d, src=0x%x\n", cardlen, src);
			dump_bytes (6, &sram[rbuf]);
			dump_bytes (cardlen, cp);
*/
			goto copy_again;
		    }
		    else if (totlen) {
			printf ("tr%d: tr_get short-read, totlen left=%d !!\n",
			    unit, totlen);
			goto out;
		    }
		}
		else if (cardlen < 0) {
		    printf ("tr%d: tr_get messup, cardlen = %d !!\n",
			unit, cardlen);
		    goto bad;
		}
#if 0
		bcopy(cp, mcp, len);
		cp += len;
#endif

		*mp = m;
		mp = &m->m_next;
	}
out:;
/* 	printf ("tr_get: done, returning mbuf 0x%x\n", top); */
	return (top);
 
bad:
	if (top != 0)
		m_freem(top);
	return (0);
}

/* 
 * tr_recv_intr
 * ------------
 * Process the adapter's receive interrupt command.  It is important to 
 * note that the interrupt needs to be cleared before the ARB_FREE bit 
 * is set.  This protects against an another ARB_COMMAND being presented
 * and unintentionaly cleared.  
 *
 * Processing consists of finding the beginning of the frame data and handing
 * it off to an upper layer, which will copy it into its private data space.
 * Once this has been done, the adapter is told via tk_response where to
 * begin freeing buffer space.
 */
tr_recv_intr(unit)
register int unit;
{
        register struct tr_softc *tr = &tr_softc[unit];
        register struct ifnet *ifp = &tr->tr_if;
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register u_short arb = tr->tr_arb;

	register int len;
/* 	spl_t	s; */
	int	lan_len, data_len;
/* 	struct ie2_llc_hdr *llcp; */
	struct mbuf *m = NULL;
/* 	char *kludgep; */
/* 	extern struct mbuf *tkget(); */
	u_short recv_buffer_addr = 0;		/* pointer to beginning of 
						 * receive buffers in shared 
						 * ram */

	/*
	 *  determine the length of the received packet.
	 */
	
	len = IOINW (&sram[arb + 10]);
	lan_len = IOIN (&sram[arb + 8]);		/* length of mac hdr*/
	data_len = len - lan_len;
	recv_buffer_addr = IOINW (&sram[arb + 6]);

/*
	printf ("tr_recv_intr: tr%d: len=%d hdr_len=%d recv_buffer_addr=0x%x\n",
		unit, len, lan_len, recv_buffer_addr);
*/

	/*  pull packet off interface.  */
	m = tr_get(recv_buffer_addr, len, unit, lan_len);

	/* clear the interrupt */
	MM_OUT (&mmaddr->reset_isrp_low, ~ARB_COMMAND);

	/* Free the adapter's arb for further command processing */
	MM_OUT (&mmaddr->set_isra_low, ARB_FREE);

	/* let the adapter know that these receive buffers are free */
	tr_qasb(unit, RECEIVED_DATA, recv_buffer_addr);

#if 0 /* NBPFILTER > 0 */
        /*
         * Check if there's a bpf filter listening on this interface.
         */
        if (us->us_bpf && m != 0)
                bpf_mtap(us->us_bpf, m, (caddr_t)eh);
#endif

	if (m) {
	    struct mac_hdr *mac = mtod(m, struct mac_hdr *);

	    ifp -> if_ipackets++;
	    ifp -> if_ibytes += len;

	    /* XXX: FIXME: remove headers */
	    m->m_data += sizeof (struct mac_hdr);
	    m->m_len -= sizeof (struct mac_hdr);
	    m->m_pkthdr.len -= sizeof (struct mac_hdr);
	    token_input(&tr->tr_if, mac, m);
	}
}

/* 
 * trint:
 * -------
 * As long a interrupts are pending, service them by dispatching the appropriate
 * handler routine.  The order in which interrupts are handled is critical.
 * ASB_FREE and SSB_RESPONSE's are handled first so that important adapter
 * resources may be freed.  RECEIVED_DATA and TRANSMIT_DATA_REQUEST commands
 * are of the next highest importance to handle since they free the arb for
 * further use and try to make use of the asb.  If we receive an unknown srb
 * response or an unknown arb command the interrupt is ignored and cleared.
 * If the interrupt is completely unrecognized, we panic.
 */

trint(unit)
int unit;
{
	register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register struct tr_pio *pio = (struct tr_pio *) tr -> tr_piobase;
	register u_char	isrp_low;
	register u_short srb;
	register u_short arb;
	u_char	isra_low, isra_high, isrp_high;
	extern int cold;	/* set during autoconf */
	int gotone = 0;

	if (cold)
	    return (1);		/* DONT respond to interrupt during autoconf */


	/* Loop until we determine that neither board has any pending 
	 * interrupts. Re-read the interrupt registers each time to check 
	 * for new interrupts that may have arrived.  Also note that if
	 * there isn't a token ring board, or there isn't an interrupt
	 * for us, we break out of the loop and exit the interrupt handler.
	 */
	isrp_low = IOIN (&mmaddr->isrp_low);
	isrp_high = IOIN(&mmaddr->isrp_high);
	isra_low = IOIN (&mmaddr->isra_low);
	isra_high = IOIN (&mmaddr->isra_high);

/*
	if (isrp_low)
	printf ("tr%d: trint: ", unit);
*/
	for (;;) {
#ifdef bogus
		if (!isrp_low) 
#endif
		if (!(isrp_low = IOIN (&mmaddr->isrp_low))) 
		{
#if 0 
			if (!gotone) {
			    printf ("NO INTERRUPT PENDING, isrp_high=0x%x\n",
					IOIN(&mmaddr->isrp_high));
			}
#else
			if (!gotone) {
			    if (isrp_high & ACCESS_INTR) {
/* 				printf ("tr%d: ACCESS_INTR\n", unit); */
				MM_OUT (&mmaddr->reset_isrp_high, ~ACCESS_INTR);
			    }
			    if (isrp_high & ERROR_INTR) {
/* 				printf ("tr%d: ERROR_INTR\n", unit); */
				MM_OUT (&mmaddr->reset_isrp_high, ~ERROR_INTR);
			    }
			}
#endif
			break; /* all done handling interrupts */
		}
		gotone++;

/*
		printf ("isrp_low=0x%x, isrp_high=0x%x, isra_low=0x%x, isra_high=0x%x\n", 
			isrp_low, isrp_high, isra_low, isra_high);
*/

		if (isrp_low & ASB_FREE) {
			u_char new_isrp_low;

#ifdef bogus
/* 			new_isrp_low = (isrp_low | ~ASB_FREE) & isrp_low; */
			isrp_low &= ~ASB_FREE;

			/* De-queue any pending asb requests */
/*
			printf ("trint: tr%d: ASB free, new isrp_low=0x%x\n", 
				unit, isrp_low);
*/
/* 			MM_OUT (&mmaddr->isrp_low, (isrp_low | ~ARB_FREE)); */
/* 			MM_OUT (&mmaddr->isrp_low, new_isrp_low); */
			MM_OUT (&mmaddr->isrp_low, isrp_low);
#endif
			/* De-queue any pending asb requests */
/* 			printf ("trint: tr%d: ASB_FREE\n", unit);  */

			tr_dqasb(unit);
			continue;
		}

		if (isrp_low & SSB_RESPONSE) {
/* 			printf ("trint: tr%d: TRANSMIT_RESULT\n", unit); */

#ifdef bogus
			isrp_low &= ~SSB_RESPONSE;
			MM_OUT (&mmaddr->isrp_low, isrp_low);
#endif

			tr_trans_complete(unit);
			continue;
		}

		if (isrp_low & SRB_RESPONSE) {
		    u_char srb_resp;
		    srb = tr->tr_srb;

#ifdef bogus
		    isrp_low &= ~SRB_RESPONSE;
		    MM_OUT (&mmaddr->isrp_low, isrp_low);
#endif

		    srb_resp = IOIN (&sram[srb]);
		    switch ((u_char) IOIN (&sram[srb])) {
			case DIR_OPEN_ADAPTER:
/* 			    printf ("trint: tr%d: OPEN_COMPLETE\n", unit); */
			    tr_open_complete(unit);
			    break;
			case TRANSMIT_DIR_FRAME:
/* 			    printf ("trint: tr%d: TRANSMIT_RET\n", unit); */
			    tr_trans_ret(unit);
			    break;
			case DIR_CLOSE_ADAPTER:
/* 			    printf ("trint: tr%d: CLOSE_COMPLETE\n", unit); */
			    tr->tr_srb = IOINW (&mmaddr->wrb);
			    MM_OUT (&mmaddr->reset_isrp_low, (~SRB_RESPONSE));
			    tr->tr_flags &= ~TR_OC_IN_PROGRESS;

			    /* disable interrupts */
			    MM_OUT (&mmaddr->reset_isrp_high, (~INTR_ENABLE));

#if 0
			    /* If the interface should be IFF_UP, then
			     * go issue an adapter open.
			     */
			    if (tk_board->softc.es_if.if_flags & IFF_UP)
				tk_open_adapter(tk_board);
#endif
			    break;
			case DIR_READ_LOG:
			    /*
			     * if we want to record the card error counters
			     * this is the place.
			     */
/* 			    printf ("trint: tr%d: READ_LOG\n", unit); */
			    MM_OUT (&mmaddr->reset_isrp_low, (~SRB_RESPONSE));
			    break;
			default:
			    /* these don't seem to be very interesting */
/*
			    printf("trint: tr%d: UNRECOGNIZED srb 0x%x\n",
				    unit, srb_resp);
*/
			    /* clear interrupt */
			    MM_OUT (&mmaddr->reset_isrp_low, (~SRB_RESPONSE));
			    break;
			}
		    continue;
		}

		if (isrp_low & ARB_COMMAND) {
		    u_char sram_arb;
		    arb = tr->tr_arb;

#ifdef bogus
		    isrp_low &= ~ARB_COMMAND;
		    MM_OUT (&mmaddr->isrp_low, isrp_low);
#endif

		    sram_arb = IOIN (&sram[arb]);
/*
		    printf ("trint: tr%d: arb=0x%x, sram_arb=0x%x\n", 
			    unit, arb, sram_arb);
*/

		    switch (sram_arb) {
			case TRANSMIT_DATA_REQUEST:
/* 			    printf ("trint: tr%d: TRANSMIT_CMD\n", unit); */
			    tr_trans_cmd(unit);
			    break;
			case RECEIVED_DATA:
/* 			    printf ("trint: tr%d: RECEIVED_CMD\n", unit); */
			    tr_recv_intr(unit);
			    break;
			case RING_STATUS_CHANGE:
/* 			    printf ("trint: tr%d: RING_CMD\n", unit); */
			    tr_ring_cmd(unit);
			    break;
			default:
			    /* these don't seem to be very interesting */
/*
			    printf("trint: tr%d: UNRECOGNIZED arb response 0x%x\n",
				    unit, sram_arb);
*/
			    /* Clear interrupt and free the adapter's arb
			     * for further command processing
			     */
			    MM_OUT (&mmaddr->reset_isrp_low, (~ARB_COMMAND));
			    MM_OUT (&mmaddr->set_isra_low, ARB_FREE);
			    break;
		    }
		    continue;
		}

		if (isrp_low & ADAPTER_CHK) {

#ifdef bogus
		    isrp_low &= ~ADAPTER_CHK;
		    MM_OUT (&mmaddr->isrp_low, isrp_low);
#endif

/* 		    printf ("trint: tr%d: ADAPTER_CHK_RET\n", unit); */
		    tr_adapter_chk(unit);
		    continue;
		}

#if 0
		printf("911-370 tkintr: tk_board = %p unit = %d\n", tk_board, unit);
		printf("911-371 isrp_low = %b, interrupt vector = 0x%x\n",
			isrp_low, ISRP_LOW_BITS, vec);
		panic("911-372 tkintr: UNRECOGNIZED interrupt.\n");
#else
/* 		printf ("tr%d: bogus interrupt\n", unit); */
		break;
#endif
	}

out:
	/* release interrupts since at this point we know
	 * that there aren't any pending interrupts 
	 */
#ifdef bogus
	if (gotone)
	    MM_OUT (&mmaddr->isra_low, (SSB_FREE) );
#endif
	MM_OUT (&pio->ie, 0x1);

	return (0);	/* no sharing of interrupts (for now) */
}

trstart(ifp)
        struct ifnet *ifp;
{
        int unit = ifp->if_unit;
        register struct tr_softc *tr = &tr_softc[unit];
        register struct trdevice *mmaddr = (struct trdevice *) tr->tr_mmiobase;
	register char *sram = (char *) tr->tr_srambase;
	register char *bp;
	int total_length = 0;
        struct mbuf *m, *mp;

/* 	printf ("trstart: "); */
	if ((tr->tr_flags & TR_OPEN) == 0) {
/* 		printf ("interface not open\n"); */
                return 0;
	}

        if ((ifp->if_flags & IFF_RUNNING) == 0) {
/* 		printf ("interface not running\n"); */
                return 0;
	}

        if (tr->tr_need_trans) {
/* 		printf ("NEED_TRANS\n"); */
		return 0;		/* XXX */
	}

	IF_DEQUEUE(&ifp->if_snd, m);
	if (m == 0) {
/* 		printf ("nothing queued\n"); */
		return (0);
	}

        ifp -> if_opackets++;

	/* copy mbufs to the card here.... */
	bp = sram + tr->tr_dhb_addr;
        for (mp = m; mp; mp = mp->m_next) {
                register int len = mp->m_len;

                bcopy(mtod(mp, char *), bp, len);
                bp += len;
                total_length += len;
        }
	ifp -> if_obytes += total_length;
/* 	printf ("wrote %d bytes\n", total_length); */

        m_freem(m);

        /* setup a response to the adapter */
        ifp -> if_flags |= IFF_OACTIVE;
        tr_qasb(unit, TRANSMIT_DIR_FRAME, total_length);

	return 0;
}

/*
 * tr_open_error
 * ----------
 * If an error occurred while trying to open the adapter, then print
 * out the information here.
 */

static char *phaserr[] = {
	"Phase error 0",
	"Lobe media test",
	"Physical insertion",
	"Address verification",
	"Roll call poll",
	"Request parameters"
};
static char *openerr[] = {
	"Open error 0",
	"Function failure",
	"Signal loss",
	"Wire fault",
	"Frequency error",
	"Timeout",
	"Ring failure",
	"Ring Beaconing",
	"Duplicate node address",
	"Parameter request",
	"Remove received",
	"ReservedB",
	"ReservedC"
};
	
tr_open_error(unit, ret_code, open_errcode)
register int unit;
unsigned short open_errcode;
u_char ret_code;
{
	int phnib,errnib;

	printf ("tr%d: ring_open failed: ", unit);
	switch(ret_code) {
	case INVALID_FAIL:
		printf("Invalid command code\n");
		break;

	case OPEN_FAIL:
		printf("Adapter open - should be closed\n");
		break;

	case PARAM_FAIL:
		printf("Required parameter(s) not provided\n");
		break;

	case CANCEL_FAIL:
		phnib = (open_errcode & 0xf0) >> 4;
		errnib = open_errcode & 0x0f;
		printf("Command canceled\n");
		printf("\t - unrecoverable failure: 0x%x%x\n", phnib, errnib);
		printf("\t - (%s : %s)\n", phaserr[phnib], openerr[errnib]);
		switch (open_errcode) {
			case 0x11:
			case 0x26:
			case 0x27:
			case 0x32:
			case 0x35:
			case 0x36:
			case 0x37:
			case 0x42:
			case 0x45:
			case 0x46:
			case 0x47:
			case 0x55:
			case 0x56:
			case 0x57:
			case 0x59:
				/* should retry the open in 30 seconds */
/* 				tk_board->open_retries++; */
				break;
		}
		break;

	case RBUF_FAIL:
		printf("Inadequate receive buffers for open\n");
		break;

	case ADDR_FAIL:
		printf("Invalid NODE_ADDRESS\n");
		break;

	case RBUF_LEN_FAIL:
		printf("Invalid adapter receive buffer len\n");
		break;

	case XBUF_LEN_FAIL:
		printf("Invalid adapter transmit buffer len\n");
		break;

	default:
		printf("Unknown failure\n");
		break;
	}
}

#endif /* NTR */
