
struct trdevice {
	u_short hardwired;	/* hard-wired values stuck in the ROM */
	u_char length;
	u_char rom_entry;
	u_char rom[7675];
	u_char rom_checksum;
	u_char rrr_high;	/* high and low bytes of ram relocation */
	u_char rrr_low;		/* register */
	u_short wrb;		/* write region buffer */
	u_short wwo;		/* write window open */
	u_short wwc;		/* write window close */
	u_char isrp_high;	/* interrupt status register-PC/high byte */
	u_char isrp_low;	/* interrupt status register-PC/low byte */
	u_char isra_high;	/* interrupt status register-adapter/high byte*/
	u_char isra_low;	/* interrupt status register-adapter/low byte*/
	u_char tcr_high;	/* timer control register / high byte */
	u_char tcr_low;		/* timer control register / low byte */
	u_char tvr_high;	/* timer value register / high byte */
	u_char tvr_low;		/* timer value register / low byte */
	u_char srpr_high;	/* shared ram page register / high byte */
	u_char srpr_low;	/* shared ram page register / low byte */
	u_char hole1[22];
	u_char reset_isrp_high;	/* reset isrp - high byte */
	u_char reset_isrp_low;	/* reset isrp - low byte */
	u_char hole_high1;
	u_char reset_isra_low;	/* reset isra - low byte */
	u_char reset_tcr_high;	/* reset tcr - high byte */
	u_char hole3[27];
	u_char set_isrp_high;	/* set isrp - high byte */
	u_char set_isrp_low;	/* set isrp - low byte */
	u_char hole_high2;
	u_char set_isra_low;	/* set isra - low byte */
	u_char set_tcr_high;	/* set tcr - high byte */
	u_char padding1[179];
	u_char adapter_addr[24];/* nibbles: encoded adapter address */
	u_char adapter_addrc[24];/* nibbles 1s complement of adapter address */	
	u_char id[16];		/* nibbles: token ring adapter identifier */
	u_char id2[32];		/* nibbles: token ring adapter identifier 2 */
	u_char chksum1;
	u_char padding2[63];
	u_char adapter_info[14];/* nibbles */
	u_char padding3[66];
	u_char chksum2;
	u_char padding4[15];
};

struct tr_pio {
	u_char setup;
	u_char latch;
	u_char release;
	u_char ie;		/* interrupt enable */
};

struct tr_srb {
	u_char command;
	u_char init_status;
	u_char padding[4];
	u_short bring_up_code;
	u_short encoded_address;
	u_short level_address;
	u_short adapter_address;
	u_short parms_address;
	u_short mac_address;
};

#define TR_ADDR_SIZE 6
#define TR_MTU	1492

/* number to ticks that the board must be held in a reset state before it
 * can be unlatched.  The manual recommends 50 ms, but I set it to a 100ms
 * just for safety
 */
#define LATCH_TIME      (100)

/*
 * give the board INIT_WAITS * LATCH_TIME ms to complete initialization
 */
#define INIT_WAITS      (100)

/* 
 * Bit masks for ISRP - low register
 */
#define SSB_RESPONSE 	0x04
#define ARB_COMMAND	0x08
#define ASB_FREE	0x10
#define SRB_RESPONSE	0x20
#define ADAPTER_CHK	0x40

#define ISRP_LOW_BITS	"\20\7DEAD\6SRB_RESP\5ASB_FREE\4ARB_COM\3SSB_RESP"

/* 
 * Bit masks for the ISRP - high register 
 */
#define SHARED_INTR	0x02
#define ACCESS_INTR	0x04
#define ERROR_INTR	0x08
#define TIMER_INTR	0x10
#define INTR_ENABLE	0x40
#define NMI_INTRCTRL	0x80

#define ISRP_HIGH_BITS	"\20\7INTR_EN\5TIM_INTR\4ERR_INTR\3ACC_INTR\2SH_INTR"

/* 
 * Bit masks for the ISRA - low register
 */ 

#define SSB_FREE	0x01
#define ARB_FREE	0x02
#define ASB_FREE_REQ	0x04
#define SRB_FREE_REQ	0x08
#define ASB_RESPONSE	0x10
#define SRB_COMMAND	0x20

#define ISRA_LOW_BITS	\
	"\20\6SRB_COM\5ASB_RESP\4SRB_FREQ\3ASB_FREQ\2ARB_FREE\1SSB_FREE"

/*
 * Bit masks for the ISRA - high register
 */

#define SOFT_INTR_MASK	0x01
#define HARD_INTR_MASK	0x02
#define PROCESSOR_CHK	0x08
#define DEADMAN_TIMER	0x10
#define SEE_ACCESS_INTR	0x20
#define SEE_TIMER_INTR  0x40

#define ISRA_HIGH_BITS  \
	"\20\7SEE_TIMER\6SEE_ACCESS\5DEADMAN\4PROCESSOR_CHK\2HARD_MSK\1SOFT_MSK"

#define OPEN_OPTS_LOW		0x00
#define OPEN_OPTS_HIGH		0x00

/* receive open parameters for ADAPTER I */
#define NUM_RECV8		18
#define RECV_LEN8		256

/* receive open parameters for ADAPTER II/A */
#define RECV_LEN16		1032
#define NUM_RECV16		12

/* the size of the trasmit buffer is independent of the adapter type */
#define XMIT_LEN		2040
#define NUM_XMIT		1

/* asb queue definitions, should be as large as the largest number of
 *  receieve buffers possible
 */
#define ASB_QUEUE_SIZE		18

/* queue up all of the asb requests that can't immediately be serviced.  
 * dequeuing occurrs when an ASB_FREE interrupt is received
 */
struct asb_q {
	u_char  cmd;
	u_short response_data;
};

/* PC to adapter commands */
#define DIR_INTERUPT		0x00
#define DIR_MODIFY_OPEN_PARMS	0x01
#define DIR_RESTORE_OPEN_PARMS	0x02
#define DIR_OPEN_ADAPTER	0x03
#define DIR_CLOSE_ADAPTER	0x04
#define DIR_SET_GROUP_ADDR	0x06
#define DIR_SET_FUCTIONAL_ADDR	0x07
#define DIR_READ_LOG		0x08
#define DIR_SET_BRIDGE_PARMS	0x09
#define TRANSMIT_DIR_FRAME	0x0a
#define DIR_CONFIG_BRIDGE_RAM	0x0c

/* adapter to PC commands */
#define RECEIVED_DATA		0x81
#define RING_STATUS_CHANGE	0x84
#define TRANSMIT_DATA_REQUEST	0x82

/* where all messages are routed */
#define DIRECT_STATION		0x0000

/* 
 * Bit masks for Ring Commands that we might receive.
 */
#define SIGNAL_LOSS		0x8000
#define HARD_ERROR		0x4000
#define SOFT_ERROR		0x2000
#define TRANSMIT_BEACON 	0x1000
#define LOBE_WIRE_FAULT 	0x0800
#define AUTO_REMOVAL		0x0400
#define REMOVE_RECEIVED  	0x0100
#define COUNTER_OVERFLOW 	0x0080
#define SINGLE_STATION   	0x0040
#define RING_RECOVERY	 	0x0020

/* codes for when everything OK */
#define INIT_COMPLETE		0x80
#define SUCCESS			0x00

/* error codes that could occur at initialization or open */
#define PROCESSOR_FAIL		0x20
#define ROM_FAIL		0x22
#define RAM_FAIL		0x24
#define INSTRUCTION_FAIL	0x26
#define INTERRUPT_FAIL		0x28
#define MEMORY_FAIL		0x2a
#define PROTOCOL_FAIL		0x2c
#define TIMER_FAIL		0x40
#define WRITE_RAM_FAIL		0x42
#define READ_RAM_FAIL		0x44
#define RO_RAM_FAIL		0x46
#define INIT_TIMEOUT		0x48

#define INVALID_FAIL		0x01
#define OPEN_FAIL		0x03
#define PARAM_FAIL		0x05
#define CANCEL_FAIL		0x07
#define RBUF_FAIL		0x30
#define ADDR_FAIL		0x32
#define RBUF_LEN_FAIL		0x33
#define XBUF_LEN_FAIL		0x34
 

/* XXX -- make the following generic */

#define LAN_SNAP_SAP		0xaa	/* Extended sap header present */
struct llc_hdr {
	char dsap;
	char ssap;
	char llc_ctl;
};
#define LAN_NPROT_ID	3
struct snap_hdr {
	char prot_id[LAN_NPROT_ID];
	char ether_type[2];
};
 
/* Logical Link Control Class 1 Definitions */
#define LAN_SNAP_TYPE		0x08	/* extended sap */
#define LAN_SNAP_IPTYPE		0x00	/* IP extended sap */
#define LAN_SNAP_ARPTYPE	0x06 /* ARP extended sap */
/* FOLLOWING FAKE VALUE WAS PENDING ARP NUMBER ASSIGNMENT */
/* NOW BEING RETAINED FOR COMPATIBILITY */
#define LAN_ARPTYPE		0x99	
#define LAN_IPTYPE		0x06	/* IP packet type */
#define LAN_UI_CMD		0x03
#define LAN_LLC_XID_CMD0	0xaf
#define LAN_LLC_XID_CMD1	0xbf
#define LAN_LLC_TEST_CMD0	0xe3
#define LAN_LLC_TEST_CMD1	0xf3
#define LAN_L_XID_RESP		3

#define LAN_PCF0	0x00	/* Physical Control Field 0 */
#define LAN_PCF1	0x40	/* Physical Control Field 1 (not mac) */

/* XXX -- */
