/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rtio/RCS/adunload.c,v 1.2 1994/05/12 14:26:48 roger Exp $ */
/* $ACIS:adunload.c 12.0$ */
/* $Source: /sys/rtio/RCS/adunload.c,v $ */

#ifdef IBMRTPC

#include <sys/cdefs.h>

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rtio/RCS/adunload.c,v 1.2 1994/05/12 14:26:48 roger Exp $";
#endif

typedef int hd_data_t;
#define HDXFERSIZE (sizeof (hd_data_t))

#define COUNT	12
 /*
  * this block read routine is used to copy data out of the adapter
  * for cases when 'buffaddr' is on a page boundary.
  * since it is on a page boundary it is also on a 32bit and a 16 bit
  * boundary.
  * flag = 0	for write
  * flag != 0 	for read
  */
adunload(buffaddr, adreg, hdcnt, flag)
	register hd_data_t * buffaddr;
	register int hdcnt;
	register hd_data_t volatile * adreg;
	register int flag;
{

/*	HDDEBUG(SHOW_COUNT,printf("addr=%x count=%d ",buffaddr,hdcnt)); */
	if (flag) {
		if (buffaddr == 0) {
			register int i;
			while ((hdcnt -= HDXFERSIZE) >= 0)
				i = *adreg;
			return;
		}
		for (; (hdcnt -= HDXFERSIZE * COUNT) >= 0;) {
			buffaddr[0] = *adreg;
			buffaddr[1] = *adreg;
			buffaddr[2] = *adreg;
			buffaddr[3] = *adreg;
			buffaddr[4] = *adreg;
			buffaddr[5] = *adreg;
			buffaddr[6] = *adreg;
			buffaddr[7] = *adreg;
			buffaddr[8] = *adreg;
			buffaddr[9] = *adreg;
			buffaddr[10] = *adreg;
			buffaddr[11] = *adreg;
			buffaddr += COUNT;
		}
		hdcnt += HDXFERSIZE * COUNT; /* correct overshoot */
		for (; hdcnt > 0; hdcnt -= HDXFERSIZE)
			*buffaddr++ = *adreg;
	} else {
		if (buffaddr == 0) {
			while ((hdcnt -= HDXFERSIZE) >= 0)
				*adreg = 0;
			return;
		}
		for (; (hdcnt -= HDXFERSIZE * COUNT) >= 0;) {
			*adreg = buffaddr[0];
			*adreg = buffaddr[1];
			*adreg = buffaddr[2];
			*adreg = buffaddr[3];
			*adreg = buffaddr[4];
			*adreg = buffaddr[5];
			*adreg = buffaddr[6];
			*adreg = buffaddr[7];
			*adreg = buffaddr[8];
			*adreg = buffaddr[9];
			*adreg = buffaddr[10];
			*adreg = buffaddr[11];
			buffaddr += COUNT;
		}
		hdcnt += HDXFERSIZE * COUNT; /* correct overshoot */
		for (; hdcnt > 0; hdcnt -= HDXFERSIZE)
			*adreg = *buffaddr++;
	}
}
#endif
