#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidaharegh = "$Header: /sys/rtio/RCS/ahareg.h,v 1.3 1993/03/30 20:11:46 md Exp $";
#endif
/*
 * Copyright (c) 1988, Christer Bernerus, Chalmers University of Technology,
 *                     Gothenburg, SWEDEN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright 
 * notice and this paragraph are  duplicated in all such forms 
 * and that any documentation, advertising materials,
 * and other materials related to such distribution
 * and use acknowledge that the software was developed
 * at Chalmers University of Technology, SWEDEN.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Adaptec AHA-1540A SCSI adapter ports.
 */

#define AHASTATISTICS

struct	aha_regs
{
    char	aha_csr;	/* Control and status 	*/
    char	aha_cd;		/* Command and data 	*/
    char	aha_iflgs;	/* Interrupt flags 	*/
};

/* 
 * Bits in aha_csr
 */

/* Write bits */
#define	AHCSR_HRST  0x80    /* Hard reset 			*/
#define	AHCSR_SRST  0x40    /* Soft reset 			*/
#define	AHCSR_IRST  0x20    /* Interrupt reset			*/
#define	AHCSR_SCRST 0x10    /* SCSI Bus Reset			*/
#define	AHCSR_RESVD 0x0F    /* Reserved bits, don't use		*/
/* Read bits */
#define	AHCSR_STST  0x80    /* Self test in progress		*/
#define	AHCSR_DIAGF 0x40    /* Internal diagnostig failure	*/
#define	AHCSR_INIT  0x20    /* Mailbox initialization required	*/
#define	AHCSR_IDLE  0x10    /* SCSI host adapter idle 		*/
#define	AHCSR_CDF   0x08    /* Command/data (out) port full 	*/
#define	AHCSR_DF    0x04    /* Data (in) port full 		*/
#define	AHCSR_RESV  0x02    /* Reserved 			*/
#define	AHCSR_INVDCMD 0x01  /* Invalid host adapter command 	*/

#define AHCSR_BITS "\02\10STST\07DIAGF\06INIT\05IDLE\04CDF\03DF\01INVDCMD\n"
#define AHCR_BITS "\02\10HRST\07SRST\06IRST\05SCRST\n"


/*
 * Bits in aha_intflags
 */
#define	AHIFLGS_INT	0x80    /* Any interrupt 			*/
#define	AHIFLGS_RS6	0x40    /* Reserved 				*/
#define	AHIFLGS_RS5	0x20    /* Reserved 				*/
#define	AHIFLGS_RS4	0x10    /* Reserved 				*/
#define	AHIFLGS_SCRD	0x08	/* SCSI reset detected 			*/
#define	AHIFLGS_HACC	0x04	/* Host adapter command complete 	*/
#define	AHIFLGS_MBOE	0x02	/* MBO empty interrupt 			*/
#define	AHIFLGS_MBIF	0x01	/* MBI full interrupt 			*/

#define AHIFLGS_BITS "\02\10INT\04SCRD\03HACC\02MBOE\01MBIF\n"

/* AHA-1540A Commands */
#define	AHACMD_NOP	    0x00    /* No operation		*/
#define	AHACMD_MBINIT	    0x01    /* Mailbox initialization	*/
#define	AHACMD_START_SCSI   0x02    /* Start SCSI Command	*/
#define	AHACMD_START_BIOS   0x03    /* Start PC/AT BIOS Command	*/
#define	AHACMD_INQ	    0x04    /* Adapter inquiry		*/
#define	AHACMD_MBOINT	    0x05    /* Set MBO interrupt enable	*/
#define	AHACMD_SSTO	    0x06    /* Set selection timeout	*/
#define	AHACMD_SBON_TIME    0x07    /* Set Bus-on time		*/
#define	AHACMD_SBOFF_TIME   0x08    /* Set Bus-off Time		*/
#define	AHACMD_SXFER_SPEED  0x09    /* Set transfer speed	*/
#define	AHACMD_RID	    0x0A    /* Return installed devices	*/
#define	AHACMD_RCD	    0x0B    /* Return config data	*/
#define AHACMD_TMODE	    0x0C    /* Control target mode      */
#define AHACMD_RSD	    0x0D    /* Return setup data	*/
#define AHACMD_WAC2BUF	    0x1A    /* Write adapter ch 2 bfr   */
#define AHACMD_RAC2BUF	    0x1B    /* Read adapter ch 2 bfr	*/
#define	AHACMD_WFIFO	    0x1C    /* Write adapter FIFO bfr	*/
#define	AHACMD_RFIFO	    0x1D    /* Read adapter FIFO bfr	*/
#define	AHACMD_ECHO	    0x1F    /* Echo command data	*/

/* Some args */
#define AHASPEED5	0	    /* Speed = 5 MB/s		*/
#define AHASPEED67	1	    /* Speed = 6.7 MB/s		*/
#define AHASPEED8	2	    /* Speed = 8 MB/s		*/
#define AHASPEED10	3	    /* Speed = 10 MB/s 	 	*/
#define AHASPEED57	4	    /* Speed = 5.7 MB/s		*/
#define AHASPEED_CUSTOM	0x80	    /* Custom speed bit		*/
#define AHASPEED_RP_100 0x00	    /* Read pulse width= 100 nS */
#define AHASPEED_RP_150 0x10	    /* Read pulse width= 150 nS */
#define AHASPEED_RP_200 0x20	    /* Read pulse width= 200 nS */
#define AHASPEED_RP_250 0x30	    /* Read pulse width= 250 nS */
#define AHASPEED_RP_300 0x40	    /* Read pulse width= 300 nS */
#define AHASPEED_RP_350 0x50	    /* Read pulse width= 350 nS */
#define AHASPEED_RP_400 0x60	    /* Read pulse width= 400 nS */
#define AHASPEED_RP_450 0x70	    /* Read pulse width= 450 nS */
#define AHASPEED_SO_100 0x00	    /* Strobe off time=  100 nS */
#define AHASPEED_SO_150 0x08	    /* Strobe off time=  150 nS */
#define AHASPEED_WP_100 0x00	    /* Write pulse width=100 nS */
#define AHASPEED_WP_150 0x01	    /* Write pulse width=150 nS */
#define AHASPEED_WP_200 0x02	    /* Write pulse width=200 nS */
#define AHASPEED_WP_250 0x03	    /* Write pulse width=250 nS */
#define AHASPEED_WP_300 0x04	    /* Write pulse width=300 nS */
#define AHASPEED_WP_350 0x05	    /* Write pulse width=350 nS */
#define AHASPEED_WP_400 0x06	    /* Write pulse width=400 nS */
#define AHASPEED_WP_450 0x07	    /* Write pulse width=450 nS */

#define AHAMBOINT_DISABLE	0   /* Disable MBO interrupt	*/
#define AHAMBOINT_ENABLE	1   /* Enable MBO interrupt	*/

#define AHASSTO_DISABLE		0   /* Disable Selection TO	*/
#define AHASSTO_ENABLE		1   /* Enable Selection TO	*/

#define AHATMC_DISABLE		0   /* Disable target mode	*/
#define AHATMC_ENABLE		0   /* Enable target mode	*/
#define AHATMC_LUMASK	     0xFF   /* LU Mask, all LU's on     */

/* #define AHA_HALFSPEED */

/* BUS ON and OFF times	*/
#ifndef AHA_HALFSPEED
#define AHABUS_ON	8	    /* 8 uS is Max allowed on RT/PC       */
#define AHABUS_OFF	2	    /* Figure grabbed, subject for tuning */
#else
#define AHABUS_ON	2	    /* 8 uS is Max allowed on RT/PC	  */
#define AHABUS_OFF	4	    /* Figure grabbed, subject for tuning */
#endif /* AHA_HALFSPEED */

/* Mailbox structure */
struct ahambox
{
	u_char	aha_csb;	     /* Command/status byte */
/* Mailbox-out command codes */
#define MBO_MAILBOX_FREE	0
#define	MBO_START_SCSI		1
#define MBO_ABORT_SCSI		2

/* Mailbox-in completion codes */
/* CCB Complete codes */
#define MBI_MAILBOX_FREE	0	/* MBI is free			*/
#define	MBI_NOERROR		1	/* CCB completed wtihout error	*/
#define	MBI_HOST_ABORTED	2	/* CCB aborted by host		*/
#define	MBI_NO_CCB		3	/* Aborted CCB not found	*/
#define	MBI_ERROR		4	/* CCB completed with error	*/
/* CCB Required codes */
#define MBI_CCB_REQUIRED	0x10	/* CCB not available for 	*/

/* Driver pseudo codes, not generated by the host adapter */
#define MBI_HOST_TIMEOUT	0x40    /* CCB timed out 		*/
	u_long aha_ccbp:24;	     /* Command control block pointer */
};

/* Command Control Block structure */

struct ahaccb
{
	u_char	aha_op;			/* Opcode */
/* Real adapter commands */
#define AHAOP_SCSI	0x00		/* SCSI Initiator command */
#define AHAOP_TMCMD	0x01		/* Target mode SCSI command */
#define AHAOP_SCSI_SG	0x02		/* SCSI Init. cmd w scatter/gather */
#define AHAOP_BDR	0x81		/* Bus device reset */
/* Driver pseudo codes for internal bookkeeping */
#define AHAOP_CCB_FREE	0xA5		/* CCB is free to be used */
#define AHAOP_CCB_RESERVED 0x5A		/* CCB is reserved */
	u_int	aha_id:3;		/* Target or initiator id */
	u_int	aha_dout:1;		/* Outbound data xfer */
	u_int	aha_din:1;		/* Incoming data xfer */
	u_int	aha_lun:3;		/* Logical unit no */
	u_char	aha_cmdlen;		/* SCSI Command length */
	u_char	aha_senselen;		/* Length of reserved data for sense */
	u_long	aha_dlen:24;		/* Data Length */
	u_char	aha_dptr[3];		/* Data pointer */
	u_char	aha_lptr[3];		/* Link pointer */
	u_char	aha_clid;		/* Command link ID */
	u_char	aha_hastat;		/* Host status */
#define AHAST_NOERROR	0x00	/* No error */
#define AHAST_LKCPL	0x0A	/* Linked command complete, no error */
#define AHAST_LKCPL_INT	0x0B	/* Linked command complete, no error, intrpt */
#define AHAST_SELTO	0x11	/* Selection Timeout */
#define AHAST_OUVR	0x12	/* Data over/under run */
#define AHAST_BUSFREE	0x13	/* Unexpected bus free */
#define AHAST_TGT_FAIL	0x14	/* Target bus phase sequence failure */
#define AHAST_MBO_CMD	0x15	/* MBO command wasn't MBO_{START,ABORT}_SCSI */
#define AHAST_CCB_OP	0x16	/* CCB opcode wasn't AHAOP_SCSI or AHAOP_BDR */
#define AHAST_INVD_LINK 0x17	/* Linked CCB doesn't have equal status bytes */
#define AHAST_INVD_PARM 0x18	/* Invalid CCB param rxd from host in tgt mode*/
#define AHAST_DUP_CCB	0x19	/* Duplicate CCB Rxd in target mode           */
#define AHAST_LINK_VIOL 0x20	/* Linking violation in target mode	      */
/* Following codes are pseudo, never set by AHA */
#define AHAST_BUFBUSY	0x80	/* The buffer for ahadoscsi was busy	     */
#define AHAST_RESERVED  0xA4	/* CCB is reserved */
#define AHAST_STARTED	0xA5	/* CCB is started but not completed by AHA ) */
#define AHAST_DONE	0xA7	/* CCB is done and processed by host */

	u_char	aha_tarstat;		/* Target status */
#define AHATGTST_GOOD	0x00	/* Target mode GOOD status 		     */
#define AHATGTST_CHECK	0x02	/* Target mode CHECK status		     */
#define AHATGTST_BUSY	0x08	/* Target mode LUN busy			     */
#define AHATGTST_RCONF	0x18	/* Target mode reservation conflict	     */
	u_char	aha_resvd2;		/* Reserved */
	u_char	aha_resvd3;		/* Reserved */
	union scsi_cdb aha_cdb;
	struct scsi_esense aha_sensedata; /* Sense data bytes */

	/* 
	 * The following isn't part of the hardware CCB but is kept here
         * in order to be able to administer interrupts 
	 */
	struct	xha_slave  *aha_xs;	/* Owner of this CCB */
	struct  buf	   *aha_bp;	/* Buffer associated with CCB */
	int		    aha_ttl;	/* Expected maximum duration of the */
				 	/* command (sec's -1) */
	struct ahaccb      *aha_fwd;	/* Link to next CCB */
	struct ahaccb	   *aha_bwd;	/* Link to previous CCB */
	struct ahambox	   *aha_mbo;	/* Pointer to associated MBO (if any) */
};

/* Scatter/gather list structure */
struct ahasgentry
{
	u_char	ahasg_dlen[3];		/* Data length  */
	u_char	ahasg_dptr[3];		/* Data pointer */
};

typedef long	ioaddr_t;

/*
 * Calculation of necessary number of Mboxes. We assume that a tape needs only
 * one mbox at a time.
 */

#include	"cs.h"
#include	"xt.h"
#include	"cd.h"
#define NTAPES NCS
#define NDISKS NXT
#define NCDS   NCD
#define NMBOX (NTAPES+NDISKS+NCDS)*4
#if NMBOX > 255
#define NMBOX 255
#endif
#define	NLINKSPERMBOX	1	/* 1  link per MBOX */
#define NCCB	NLINKSPERMBOX*NMBOX 	

/*
 * Administrative area for the controller. it is constantly mapped and never
 * released 
 */
struct ahaadm
{
    ioaddr_t        ioaddr;		/* I/O address of this member 	    */
    int		    move:1;		/* Interrupt has occurred	    */
    int             nokick:1;		/* Resetting aha, dont start it yet */
    int		    topending:1;	/* Timeout is pending 		    */
    int		    kicking:1;		/* Kick in progress		    */
    int		    skippedkick:1;	/* A kick was skipped last time	    */
    struct ahambox *freembi;	        /* May be pointing to next filled MBI */
    struct ahambox *freembo;		/* May be pointing to next free MBO */
    struct ahaccb  *freeccb;		/* May be pointing to next free CCB */
#ifdef AHASTATISTICS
    int             mbousage;		/* Current MBO usage		    */	
    int             mbiusage;		/* Last MBI count within a mbi scan */
    int             ccbusage;		/* Current CCB usage		    */
    int             maxmbousage;	/* Maximum MBO usage		    */
    int             maxmbiusage;	/* Maximum MBI count		    */
    int             maxccbusage;	/* Maximum CCB usage		    */
    int		    maxbufq;		/* Longest buffer queue		    */
    int		    mbihits;	        /* No of first MBI hits */
    int		    mbimisses;		/* No of MBI misses */
#endif /* AHASTATISTICS */
    int             cmdcmpl;    	/* Indicates HACC to ahacmd         */
#define CMPL_CC		1	    /* Command completion   	*/
#define	CMPL_INVD	-1	    /* INVDCMD			*/
#define	CMPL_NOTYET	0	    /* NOT COMPLETED YET 	*/
#define CMPL_ABORT	-2	    /* Command aborted 	 	*/
    struct buf	    iobuf;		/* Dummy i/o buffer for DMA code    */
    struct buf	    stbuf;		/* Single thread buffer for spec use */
    struct ahambox  mbo[NMBOX];		/* Outgoing Mailboxes		    */
    struct ahambox  mbi[NMBOX];		/* Ingoing Mailboxes		    */
    struct ahaccb   ccb[NCCB];		/* Command Control blocks	    */
};

/*
 * Return values from ahasccom and ahastart
 */
#define AHS_DONE	0	/* The request was started (if any) */
#define AHS_FAIL	1	/* Request couldn't be started, skip it */
#define AHS_RETRY	2	/* The request couldn't be started, try later */
/*
 * Flags to sent to ahaxstart()
 */
#define AHX_START	0	/* Start request immediately */
#define AHX_LINK	1	/* Just set up ccb and link eventually */
/* Function prototypes */
int     ahaprobe(caddr_t, struct iocc_ctlr *);
void    ahaattach(struct iocc_ctlr *);
int     ahaustart(struct xha_slave *);
struct ahaccb * ahaxsetup(struct xha_slave *, struct buf *, struct ahaccb *,
            union scsi_cdb *);
int     ahaint(int);
int     ahascanmbi(int,int);
int     ahacsbtodccode(int, struct ahambox *);
int     ahastattodccode(int, int, int);
int     ahalinkccb(int, struct ahaccb  *, struct ahaccb  *);
u_short ahadoscsi( struct xha_slave *, union scsi_cdb  *, caddr_t, int, int);
struct ahaccb *ahabdr(struct xha_slave * );
struct ahaccb *ahasetupccb( struct xha_slave *, union scsi_cdb  *,
             ioaddr_t, struct buf *) ;
void    ahastartmbo(int, struct ahaccb  *, struct ahambox *);
void    ahafillmbo(int, struct ahambox *, struct ahaccb  *);
void    ahafillccb(struct ahaccb *, union scsi_cdb *, ioaddr_t,
            int, struct xha_slave *, struct buf *);
struct ahambox *ahagetmbi(int);
struct ahaccb *ahanextccbp(struct ahaadm *, struct ahaccb *, int *);
struct ahambox *ahanextmbop(struct ahaadm *, struct ahambox *, int *);
struct ahambox *ahanextmbip(struct ahaadm *, struct ahambox *, int *);
struct ahaccb *ahagetccb(int);
struct ahambox *ahagetmbo(int);
void    ahafreeccb(int, struct ahaccb *);
void    ahafreembi(struct ahambox *);
void    ahafreembo(int, struct ahaccb *);
void    ahazapmbo(int, struct ahambox *);
int     aharesetha(struct aha_regs *);
int     ahareinit(struct iocc_ctlr *);
int     ahainit(struct iocc_ctlr *);
void    ahatout(int);
int     ahaget(struct aha_regs *, int);
void    ahascreset(struct aha_regs *);
void    ahakick(int);
int     ahacmd(struct aha_regs *, u_char, int, int);
void    ahainitmbox(int, struct ahambox *, int);
void    ahasetspeed(int, int);
void    ahawritefifo(char *, int);
void    ahareadfifo(caddr_t, int);
void    ahassto(int, int);
void    ahasetmboint(int, int);
void    ahasbontime(int, int);
int     ahasbofftime(int, int);
caddr_t ahvaddr(ioaddr_t, int);
ioaddr_t ahioaddr(caddr_t, int);

#ifdef DEBUG
void printccb(struct ahaccb  *);
void printcdb(union scsi_cdb *, int);
void printesense(struct scsi_esense *);
void printmbox(struct ahambox *, int, int);
#endif /* DEBUG */

