
/*
 * LOTS of development work, experimentation, and performance improvments.
 * The current set of defines below produces the fastest stable asy driver.
 * Be careful when reading comments in the code.... the comments may not
 * have not kept up with the development work.
 *
 * TODO: assuming the defines below are the "right" way to go, need
 *	to continue cleaning up the code, weeding out the old stuff.
 *	Will still have RCS to get back to old versions, if needed.
 */

/* #define HONEY_LIKE		/* handle receive's like Honeyman's asy.c */
/* #define FAST_INTERRUPTS	/* disable softasy() handling */
/* #define DO_HOTSTUFF		/* enable hot-board looping */
/* #define XMIT_QTOB		/* use q_to_b in asystart() */
#define MULTI_BOARD		/* enable multiple uarts on same IRQ */
#define ASY_EVENT		/* off-level w/timer instead of softasy() */
#define ASY_TXEVENT		/* do transmit buffering via asy_event() */
#define ASY_RXMALLOC		/* malloc the rx buffers */
#define ASY_TXMALLOC		/* malloc the tx buffers */
/* #define ASY_DEBUG		/* do some assert checking... */

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /usr/src/sys/rtio/RCS/asy.c,v 1.22 1994/04/05 19:59:22 roger Exp roger $";
#endif
/*
 * Multiport asynchronous driver
 */
#include "asy.h"
#include "asq.h"
#include "asx.h"
#if (NASY > 0) || (NASQ > 0) || (NASX > 0)

#include <sys/param.h>
#include <sys/conf.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <sys/tty.h>
#include <sys/systm.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/syslog.h>
#include "../rt/debug.h"

#include "../rtio/asyreg.h"
#include "../rtio/asyvar.h"
#include "../rt/io.h"
#include "buf.h"
#include "../rtio/ioccvar.h"
#include "kernel.h"

#include "../rt/softint.h"

#include "malloc.h"

#ifdef ASY_DEBUG
#define ASY_ASSERT(asy, EX) if(!(EX))assertfail((asy), "EX", __FILE__, __LINE__)
#else
#define ASY_ASSERT(x, y)
#endif

/*
 * Experience has shown that these cards don't share interrupts
 * well (you get a lot of spurious interrupts at least).  There is
 * a way to fix this so you could probably share interrupts between
 * asy cards, but I don't feel like doing this.  Define shared interrupts
 * at your own risk.
 */
#ifndef ASYSHAREDIRQ
#define	ASYSHAREDIRQ	0	/* don't do it */
#endif /* ASYSHAREDIRQ */

#define ASY_SETBAUD(addr, code) \
	do { \
		IOOUT( &(addr)->lcr, (IOIN( &(addr)->lcr ) | LCR_DLAB) );\
		IOOUT( &(addr)->dllsb, (code) & 0xff);\
		IOOUT( &(addr)->dlmsb, ((code)>>8) & 0xff);\
		IOOUT( &(addr)->lcr, (IOIN( &(addr)->lcr ) & ~LCR_DLAB) );\
	} while(0)

struct speedtab asyspeedtab[] = {
	{      0,	0x0000	},
	{     50,	0x0900	},
	{     75,	0x0600	},
	{    110,	0x0417	},
	{    134,	0x0359	},
	{    150,	0x0300	},
	{    300,	0x0180	},
	{    600,	0x00c0	},
	{   1200,	0x0060	},
	{   1800,	0x0040	},
	{   2000,	0x003a	},
	{   2400,	0x0030	},
	{   3600,	0x0020	},
	{   4800,	0x0018	},
	{   7200,	0x0010	},
	{   9600,	0x000c	},
	{  19200,	0x0006	},
	{  38400,	0x0003	},
	{  57600,	0x0002	},
	{ 115200,	0x0001	},
	{     -1,	  -1    }
};

/*
 * Magic bit to identify modem transitions.
 *
 * XXX This must be chosen not to collide with the TTY_* character
 * flags in sys/tty.h.
 */
#define	ASY_DCD_MAGIC	0x00010000

/*
 * If DCD is asserted when we're in open wait, we delay output for the
 * following length of time to give the port we are talking to time to
 * initialize itself fully.
 */
#define	ASYDCDDELAY	(hz/6)		/* 166 milliseconds */

/*
 * Common entry points used here
 */
int asystart(), asyprobe(), asyparam();
int ttrstrt();

#if NASY > 0
/*
 * asy ports are the old PC 8250-style ports.  There are at most
 * two of them in the system.  The minor device number is used as
 * the unit number (0 or 1).  The code here does test for the
 * presence of a 16550 in one of these, however, just in case
 * the chip has been swapped.
 */

#define	NYPORTS		1
#define	MAXYUNIT	(NASY * NYPORTS)

#define	ASYUNIT(ctlr)	(ctlr)
#define	ASYCTLR(unit)	(unit)

struct tty	asy_tty[MAXYUNIT];		/* asy tty structures */
struct asysoftc	asysoftc[MAXYUNIT];		/* asy soft structures */

int nasy = MAXYUNIT;				/* for pstat */

u_char asysoftCAR[NASY];			/* soft carrier state */

caddr_t asystd[] = {				/* standard device addresses */
	(caddr_t)0xf00003f8,			/* at IRQ 4 */
	(caddr_t)0xf00002f8,			/* at IRQ 3 */
	(caddr_t)0xf00003e8,			/* at IRQ 5 */
	(caddr_t)0xf00002e8,			/* at IRQ 9 */
	(caddr_t)0xf00001f8,			/* at IRQ ? */
	(caddr_t)0xf00001e8,			/* at IRQ ? */
	(caddr_t)0xf00002a8,			/* at IRQ ? */
	(caddr_t)0xf00001a8,			/* at IRQ ? */
		0
};

int asyattach(), asyint();

struct iocc_device *asydinfo[NASY];
struct iocc_driver asydriver = {
	/* probe, slave, attach, dgo, addr, dname, dinfo, mname, csr, intr */
	   asyprobe, 0, asyattach, 0, asystd, "asy", asydinfo, 0, 0, asyint
};

struct asystats asystats;

/*
 * Hack to identify adapter type from address
 */
#define	ISASYADDR(addr)		((((int)(addr)) & 0xfffffeff) == 0xf00002f8)
#else	/* NASY > 0 */
#define	ISASYADDR(addr)		(0)
#define	MAXYUNIT		(0)
#endif	/* NASY > 0 */

#if NASQ > 0
/*
 * asq ports are the quad cards.  There are at most 4 of these per
 * system, and they may either have 16450 (no FIFO) or 16550 (FIFO)
 * chips on them.  The controller number here is the minor device
 * number divided by four.
 */

#define	NQPORTS		4
#define	MAXQUNIT	(NASQ * NQPORTS)

#define	ASQUNIT(ctlr)	((ctlr) << 2)
#define	ASQCTLR(unit)	((unit) >> 2)

struct tty	asq_tty[MAXQUNIT];		/* asq tty structures */
struct asysoftc	asqsoftc[MAXQUNIT];		/* asq soft structures */

int nasq = MAXQUNIT;				/* for pstat */

u_char asqsoftCAR[NASQ];			/* soft carrier state */

caddr_t asqstd[] = {				/* standard device addresses */
	(caddr_t)0xf0001230,	       /* Multiport adapter 1 */
	(caddr_t)0xf0002230,	       /* Multiport adapter 2 */
	(caddr_t)0xf0003230,	       /* Multiport adapter 3 */
	(caddr_t)0xf0004230,	       /* Multiport adapter 4 */
		0
};

#ifdef MULTI_BOARD
#define asqint asyint
#endif
int asqattach(), asqint();

struct iocc_device *asqdinfo[NASQ];
struct iocc_driver asqdriver = {
	/* probe, slave, attach, dgo, addr, dname, dinfo, mname, csr, intr */
	   asyprobe, 0, asqattach, 0, asqstd, "asq", asqdinfo, 0, 0, asqint
};

struct asystats asqstats;

/*
 * Hack to identify adapter type from address
 */
#define	ISASQADDR(addr)		((((int)(addr)) & 0xffff8fff) == 0xf0000230)

/*
 * Sequence to reset shared interrupts
 */
#define	ASQRESET(v) \
	do { \
		IOOUT((caddr_t)(0xf00002f2), (v)); \
		IOOUT((caddr_t)(0xf00006f2), (v)); \
		IOOUT((caddr_t)(0xf00006f3), (v)); \
	} while (0)

#else	/* NASQ > 0 */
#define	ISASQADDR(addr)		(0)
#define	ASQRESET(v)		do {} while (0)
#define	MAXQUNIT		(0)
#endif	/* NASQ > 0 */

#if NASX > 0
/*
 * asx ports are the 8-port cards.  There can be 8 of these per
 * system (what a joke), and they all use the 16550 (FIFO)
 * as far as I know.  The controller number here is the minor device
 * number divided by eight.
 */

#define	NXPORTS		8
#define	MAXXUNIT	(NASX * NXPORTS)

#define	ASXUNIT(ctlr)	((ctlr) << 3)
#define	ASXCTLR(unit)	((unit) >> 3)

struct tty	asx_tty[MAXXUNIT];		/* asx tty structures */
struct asysoftc	asxsoftc[MAXXUNIT];		/* asx soft structures */

int nasx = MAXXUNIT;				/* for pstat */

u_char asxsoftCAR[NASX];			/* soft carrier state */

caddr_t asxstd[] = {				/* standard device addresses */
	(caddr_t)0xf0007160,	       /* 8 port multiplexor adapter 1 */
	(caddr_t)0xf0008160,	       /* 8 port multiplexor adapter 2 */
	(caddr_t)0xf0009160,	       /* 8 port multiplexor adapter 3 */
	(caddr_t)0xf000a160,	       /* 8 port multiplexor adapter 4 */
	(caddr_t)0xf000b160,	       /* 8 port multiplexor adapter 5 */
	(caddr_t)0xf000c160,	       /* 8 port multiplexor adapter 6 */
	(caddr_t)0xf000d160,	       /* 8 port multiplexor adapter 7 */
	(caddr_t)0xf000e160,	       /* 8 port multiplexor adapter 8 */
		0
};

#ifdef MULTI_BOARD
#define asxint asyint
#endif
int asxattach(), asxint();

struct iocc_device *asxdinfo[NASX];
struct iocc_driver asxdriver = {
	/* probe, slave, attach, dgo, addr, dname, dinfo, mname, csr, intr */
	   asyprobe, 0, asxattach, 0, asxstd, "asx", asxdinfo, 0, 0, asxint
};

struct asystats asxstats;

/*
 * Hack to identify adapter type from address
 */
#define	ISASXADDR(addr)		((((int)(addr)) & 0xffff0fff) == 0xf0000160)

/*
 * Sequence to reset shared interrupts
 */
#define	ASXRESET(v) \
	do { \
		/* I don't know these addresses.  The following may */ \
		/* do it if you put the card on IRQ 9, however */ \
		IOOUT((caddr_t)(0xf00002f2), (v)); \
		IOOUT((caddr_t)(0xf00002f3), (v)); \
		IOOUT((caddr_t)(0xf00002f4), (v)); \
	} while (0)

#else	/* NASX > 0 */
#define	ISASXADDR(addr)		(0)
#define	ASXRESET(v)		do {} while (0)
#define	MAXXUNIT		(0)
#endif	/* NASX > 0 */


/*
 * Given a device number, returns the appropriate tty structure
 */
#define	ASYTTY(dev)	(&(cdevsw[major(dev)].d_ttys[minor(dev)]))

/*
 * Transmitter software interrupt support.  We run the transmitters in
 * sort of a pseudo-DMA mode, and run asystart() from a software interrupt.
 * The idea here is to reduce transmitter processing at interrupt time
 * since we're polling multiple ports and the time spent dealing with
 * transmitter interrupts is time we're not processing the receiver
 * on subsequent ports.
 */
#ifdef ASY_EVENT

static int event_scheduled = 0;
static void asy_event();
static struct asysoftc *asy_list_head = (struct asysoftc *) 0;
static struct asysoftc *asy_list_tail = (struct asysoftc *) 0;

#define MAX_EVENT_TIME          10      /* in milli-seconds */

/* calculate EVENT_TIME from MAX_EVENT_TIME with regard to the
   clock tick granularity
*/
#define EVENT_TIME      ((((MAX_EVENT_TIME) * (HZ) / 1000)\
                                * 1000 + (HZ) - 1) / (HZ))
#if EVENT_TIME == 0
#undef EVENT_TIME
#define EVENT_TIME      ((1000 + (HZ) - 1) / (HZ))
#endif

#define	ASYSETSOFT(flag, asy, tp) \
	do { \
		(asy)->asy_softflags |= (flag); \
		if (!event_scheduled) { \
			event_scheduled = 1; \
			(void) timeout (asy_event, (caddr_t) NULL, 1); \
		} \
	} while (0)

#else

int asynumsoft;			/* number of ports needing soft int service */
struct tty *asysoftlist[MAXYUNIT+MAXQUNIT+MAXXUNIT];
				/* list of ports needing service */

#define	ASYSETSOFT(flag, asy, tp) \
	do { \
		if ((asy)->asy_softflags == 0) { \
			asysoftlist[asynumsoft++] = (tp); \
			if (asynumsoft == 1) \
				setsoftASY(); \
		} \
		(asy)->asy_softflags |= (flag); \
	} while (0)
#endif

/*
 * Here we deal with a few issues relating to the use of FIFOs on
 * the chips that have them.  The transmitter on a 16550 can have
 * up to 16 characters queued to it at once.  This can drop transmitter
 * interrupt overhead considerably.  The trouble with this is that
 * once the characters are loaded in the FIFO there is no way to
 * stop them from being transmitted (what is needed is a residual
 * count to tell you how many characters were in the FIFO if you
 * flush it.  This doesn't exist).
 *
 * At low speed this is unacceptable because of the length of time
 * it takes to respond to stop's (either CTS or typed).  At higher
 * speeds this isn't so good either, but the benefits in terms of
 * reduced overhead are much greater.  Unfortunately, the "right"
 * number is also somewhat dependent on the device attached to
 * the port.  There is no universal solution.
 *
 * The following table is used to decide on the number of characters
 * which are queued at each transmit, depending on speed.  It is
 * referenced every time the asyparam() routine is called.  The
 * only guiding principal is that we don't want to use the FIFO
 * at all at speeds at or less than maybe 1200 bps or so, but
 * want to be making maximal use of it at the highest speeds.
 * Feel free to vary this, just don't make any entry less than
 * 2 (I don't trust interrupts in this case) or greater than
 * 15.
 */

struct speedtab asyxmtfifotab[] = {
	{      0,	 2 },
	{     50,	 2 },
	{     75,	 2 },
	{    110,	 2 },
	{    134,	 2 },
	{    150,	 2 },
	{    300,	 2 },
	{    600,	 2 },
	{   1200,	 2 },
	{   1800,	 3 },
	{   2000,	 3 },
	{   2400,	 3 },
	{   3600,	 4 },
	{   4800,	 5 },
	{   7200,	 6 },
	{   9600,	16 },
	{  19200,	16 },
	{  38400,	16 },
	{  57600,	16 },
	{ 115200,	16 },
	{     -1,	-1 }
};
#define	ASYMINXMTFIFO	(2)

/*
 * The receiver is yet another problem.  If we set the FIFO trigger
 * greater than 1 we will suffer a 4 character delay in posting
 * receive interrupts on the input.  This is truely unacceptable
 * for character input at low speeds.  For stream input at high
 * speeds, however, setting the reciver fifo trigger level higher can
 * reduce the interrupt count a fair bit.
 *
 * The previous driver ripped off some support code from the VAX dz
 * driver for changing the fifo trigger level.  This was worse than
 * than the problem it needed to solve, however.  The scheme here is
 * to set the trigger to 1 and count the number of characters we
 * receive during a single interrupt.  If it is greater than or equal
 * to asybusycnt we assume the RT is falling behind a character stream,
 * and set the fifo trigger to asybusytrigger to reduce the load.  If
 * we subsequently get a character count timeout we drop the fifo trigger
 * to one again.
 *
 * I'm not sure I would set the fifo trigger to greater than 8 in any
 * case since the higher level (14) only leaves the RT two character times
 * to respond and avoid overflow, and at the higher speeds this is
 * probably asking too much.  You might try setting it to 8, though
 * I found this causes occasional overruns at 38400.
 */
#define	DEFASYBUSYCNT		(2)
#define	DEFASYBUSYTRIGGER	(FCR_FIFO_4)

int asybusycnt = DEFASYBUSYCNT;
u_char asybusytrigger = DEFASYBUSYTRIGGER;

#define MAXIRQ	16

#define BADD_ADDR (caddr_t) 0xeeeeeeee /* to catch bad IRQ number */
#define C (caddr_t)

caddr_t asyreset[MAXIRQ] = {
        BADD_ADDR, BADD_ADDR, BADD_ADDR, C 0xf00002f3, /* 0 - 3 */
        C 0xf00002f4, BADD_ADDR, BADD_ADDR, BADD_ADDR, /* 4 - 7 */
        BADD_ADDR, C 0xf00002f2, C 0xf00006f2, C 0xf00006f3, /* 8 - 11 */
        BADD_ADDR, BADD_ADDR, BADD_ADDR, BADD_ADDR, /* 12 - 15 */
};
#undef C

#ifdef MULTI_BOARD
#define C (struct asysoftc *)
struct asysoftc *asy_irq_table[MAXIRQ] = {
	C 0, C 0, C 0, C 0, C 0, C 0, C 0, C 0,
	C 0, C 0, C 0, C 0, C 0, C 0, C 0, C 0,
};
#undef C

extern int cold;
#endif

/*   asyprobe will try to generate an interrupt so that the system can
 *   determine whether or not the async ctlrs specified in the config
 *   file are truly present.  It will also try to determine the ctlrs
 *   interrupt request level (IRQ).  The interrupts are generated using 
 *   the loopback feature provided by the INS8250.
 */

asyprobe(addr)
	register caddr_t addr;
{
	register struct asydevice *asyp = (struct asydevice *)addr;
	char saveiir;

	if (ISASQADDR(asyp)) {
		IOOUT( &asyp->ppir, 0xff); /* initialize ppir - ONLY ONCE */
		/* reset all shared interrupts */
		ASQRESET(0);
	} else if (ISASXADDR(asyp)) {
		IOOUT( &asyp->ppir, 0xff); /* initialize ppir - ONLY ONCE */
		/* reset all shared interrupts */
		ASXRESET(0);
	}
#if 0
	/* 
	 * who cares !!!  Only the IBM 4-port and 8-port cards need 
	 * special treatment here....
	 */
	else if (!ISASYADDR(asyp)) {
		return (PROBE_BAD);	/* we don't know this device */
	}
#endif

	IOOUT(&asyp->ier, IER_MSR);     	/* enable modem status int. */
	IOOUT(&asyp->mcr, MCR_IEN);		/* enable modem ints (only */
	DELAY(1);				/* for COM card; does not */
						/* affect multiport cards) */
	IOOUT(&asyp->mcr, MCR_IEN | MCR_LOOP) ; /* enable LOOP mode */
	DELAY(1);
	IOOUT(&asyp->mcr, MCR_IEN); 		/* disable LOOP mode */
	PROBE_DELAY(100000);
	IOOUT(&asyp->ier,0);	        	/* disable all interrupts */
	saveiir = IOIN(&asyp->msr);		/* reset modem interrupts */

	/* reset all shared interrupts */
	if (ISASQADDR(asyp)) {
		ASQRESET(0);
		PROBE_DELAY(10000);
	} else if (ISASXADDR(asyp)) {
		ASXRESET(0);
		PROBE_DELAY(10000);
	}

	return (PROBE_OK);
}


/*
 * Multi-board handling (aka: IRQ sharing) is accomplished by
 * maintaining a list of UARTs on a particular IRQ level.
 * Side effect here is that we've squashed the interrupt handler
 * down to 1 routine for COM, quad, and 8-port boards.
 */
asyinsert (irq, asy, tp)
	int irq;
	struct asysoftc *asy;
	struct tty *tp;
{
#ifdef MULTI_BOARD
	struct asysoftc *asyp = asy_irq_table[irq];

	asy->asy_next_uart = (struct asysoftc *) 0;
	if (asyp) {
	    /* walk the irq chain till the end */
	    for (;asyp->asy_next_uart; asyp = asyp->asy_next_uart)
		;
	    asyp->asy_next_uart = asy;
	}
	else {
	    /* first entry in the irq table. */
	    asy_irq_table[irq] = asy;
	}
#endif

#ifdef ASY_EVENT
	asy -> asy_next_list = (struct asysoftc *) 0;
	if (asy_list_head == (struct asysoftc *) 0) {
	    asy_list_head = asy;
	}
	else {
	    asy_list_tail -> asy_next_list = asy;
	}
	asy_list_tail = asy;
#endif
	asy->asy_tty = tp;		/* save for the intrpt handler */
}

#if NASY > 0
/*
 * Initialize data structures for asy-type ports
 */
asyattach(iod)
	register struct iocc_device *iod;
{
	register int unit = iod->iod_unit;
	register struct asysoftc *asy = &asysoftc[unit];

	/*
	 * Initialize the software state.  Assume everything else is zero fill
	 */
	asy->asyaddr = (struct asydevice *)(iod->iod_addr);
	asy->asy_softCAR = &(asysoftCAR[unit]);
	asy->asy_xmitlevel = ASYDEFXMITNOFIFO;
	asy->asy_stats = &asystats;
	asy->asy_hardware = ASYH_ISCOM;
	asy->asy_type = 'y';
	asy->asy_unit = unit;
	asy->asy_port = 0x1;

#ifdef ASY_RXMALLOC
	MALLOC(asy->asy_rxbuf, u_int *, (sizeof (u_int) * ASYRXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
	asy->asy_recv_ring_put_ptr = asy->asy_rxbuf;
	asy->asy_recv_ring_take_ptr = asy->asy_rxbuf;
	asy->asy_recv_ring_cnt = 0;
#ifdef ASY_TXEVENT
#ifdef ASY_TXMALLOC
	MALLOC(asy->asy_txbuf, u_char *, (sizeof (u_char) * ASYTXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
	asy->asy_xmit_ring_put_ptr = asy->asy_txbuf;
	asy->asy_xmit_ring_take_ptr = asy->asy_txbuf;
	asy->asy_xmit_ring_cnt = 0;
	asy->asy_xmit_ring_size = ASYTXBUFSIZE;		/* XXX: tune later? */
#endif

	/*
	 * Set the address of the soft structure into the tty struct
	 */
	asy_tty[unit].t_addr = (caddr_t)asy;
	asy_tty[unit].t_state = 0;

	/*
	 * Save the soft DCD flags
	 */
	asysoftCAR[unit] = iod->iod_flags;

	/*
	 * Try out the FIFO by turning it on.  This should have
	 * no effect on a non-FIFO card.  First clear the FIFOs,
	 * then turn them on.  If the iir has the top bits set
	 * we've got a good one.
	 */
 	IOOUT(&(asy->asyaddr->fcr), FCR_ENBFIFO|FCR_FLUSH|FCR_FIFO_14);
	DELAY(50);
	if (IOIN(&(asy->asyaddr->iir)) & (IIR_FIFO1|IIR_FIFO2))
		asy->asy_hardware |= ASYH_HASFIFO;

	asyinsert (iod->iod_irq, asy, &asy_tty[unit]);
}


/*
 * device-specific open code for asy-style devices
 */
asyopen(dev, flag)
	dev_t dev;
	int flag;
{
	register struct iocc_device *iod;
	register int unit;

	unit = minor(dev);
	if (unit >= MAXYUNIT)
		return ENXIO;
	iod = asydinfo[unit];
	if (iod == 0 || iod->iod_alive == 0)
		return ENXIO;
	return asydoopen(dev, flag);
}
#endif	/* NASY > 0 */

#if NASQ > 0
/*
 * Initialize data structures for asq-type ports.  Determine whether they're
 * buffered or not.
 */
asqattach(iod)
	register struct iocc_device *iod;
{
	register struct asydevice *addr = (struct asydevice *)(iod->iod_addr);
	register struct tty *tp = &(asq_tty[ASQUNIT(iod->iod_unit)]);
	register struct asysoftc *asy = &(asqsoftc[ASQUNIT(iod->iod_unit)]);
	register int port;
	register u_char *softCAR = &(asqsoftCAR[iod->iod_unit]);

	/*
	 * Save the config flags
	 */
	*softCAR = iod->iod_flags;

	/*
	 * Initialize all ports.  While we needn't check for a 16550 beyond
	 * the first port, we will anyway.
	 */
	for (port = 0; port < NQPORTS; port++, addr++, tp++, asy++) {
		/*
		 * Save the DCD flags
		 */
		/*
		 * First the software state.  We assume zero fill here.
		 */
		asy->asyaddr = addr;
		asy->asy_softCAR = softCAR;
		asy->asy_stats = &asqstats;
		asy->asy_type = 'q';
		asy->asy_unit = ASQUNIT(iod->iod_unit) + port;
		asy->asy_port = (1 << port);

#ifdef ASY_RXMALLOC
		MALLOC(asy->asy_rxbuf, u_int *, (sizeof (u_int) * ASYRXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
		asy->asy_recv_ring_put_ptr = asy->asy_rxbuf;
		asy->asy_recv_ring_take_ptr = asy->asy_rxbuf;
		asy->asy_recv_ring_cnt = 0;
#ifdef ASY_TXEVENT
#ifdef ASY_TXMALLOC
		MALLOC(asy->asy_txbuf, u_char *, (sizeof (u_char) * ASYTXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
		asy->asy_xmit_ring_put_ptr = asy->asy_txbuf;
		asy->asy_xmit_ring_take_ptr = asy->asy_txbuf;
		asy->asy_xmit_ring_cnt = 0;
		asy->asy_xmit_ring_size = ASYTXBUFSIZE;	/* XXX: tune later? */
#endif

		/*
		 * Save the address of the soft structure in the tty struct
		 */
		tp->t_addr = (caddr_t)asy;

		/*
		 * Try out the FIFO by turning it on.  This should have
		 * no effect on a non-FIFO card.  First clear the FIFOs,
		 * then turn them on.  If the iir has the top bits set
		 * we've got a good one.
		 */
 		IOOUT(&addr->fcr, FCR_ENBFIFO|FCR_FLUSH|FCR_FIFO_14);
		DELAY(50);
		if (IOIN(&addr->iir) & (IIR_FIFO1|IIR_FIFO2))
			asy->asy_hardware |= ASYH_HASFIFO;

		asyinsert (iod->iod_irq, asy, tp);
	}
}


/*
 * device-specific open code for asq-style devices
 */
asqopen(dev, flag)
	dev_t dev;
	int flag;
{
	register struct iocc_device *iod;
	register int unit;

	unit = minor(dev);
	if (unit >= MAXQUNIT)
		return ENXIO;
	iod = asqdinfo[ASQCTLR(unit)];
	if (iod == 0 || iod->iod_alive == 0)
		return ENXIO;
	return asydoopen(dev, flag);
}
#endif /* NASQ > 0 */

#if NASX > 0
/*
 * Initialize data structures for asx-type ports.  While the only
 * eight-port cards I've ever seen are buffered, we test for this anyway.
 * This was copied from above, it really isn't a whole lot of code.
 */
asxattach(iod)
	register struct iocc_device *iod;
{
	register struct asydevice *addr, *baddr = (struct asydevice *)(iod->iod_addr);
	register struct tty *tp = &(asx_tty[ASXUNIT(iod->iod_unit)]);
	register struct asysoftc *asy = &(asxsoftc[ASXUNIT(iod->iod_unit)]);
	register int port;
	register u_char *softCAR = &(asxsoftCAR[iod->iod_unit]);

	/*
	 * Save the config flags
	 */
	*softCAR = iod->iod_flags;

	/*
	 * Initialize all ports.  While we needn't check for a 16550 beyond
	 * the first port, we will anyway.
	 */
/* 	addr = baddr; */
	for (port = 0; port < NXPORTS; port++, /* addr++, */ tp++, asy++) {
		/*
		 * Save the DCD flags
		 */
		/*
		 * First the software state.  We assume zero fill here.
		 */
		addr = baddr + ((port/2) * 0x80) + (port % 2);
/* 		printf ("asxattach: port=%x addr=%x\n", port, addr); */
		asy->asyaddr = addr;
		asy->asy_softCAR = softCAR;
		asy->asy_stats = &asxstats;
		asy->asy_type = 'x';
		asy->asy_unit = ASXUNIT(iod->iod_unit) + port;
		asy->asy_port = (1 << port);

#ifdef ASY_RXMALLOC
		MALLOC(asy->asy_rxbuf, u_int *, (sizeof (u_int) * ASYRXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
		asy->asy_recv_ring_put_ptr = asy->asy_rxbuf;
		asy->asy_recv_ring_take_ptr = asy->asy_rxbuf;
		asy->asy_recv_ring_cnt = 0;
#ifdef ASY_TXEVENT
#ifdef ASY_TXMALLOC
		MALLOC(asy->asy_txbuf, u_char *, (sizeof (u_char) * ASYTXBUFSIZE), M_DEVBUF, M_WAITOK);
#endif
		asy->asy_xmit_ring_put_ptr = asy->asy_txbuf;
		asy->asy_xmit_ring_take_ptr = asy->asy_txbuf;
		asy->asy_xmit_ring_cnt = 0;
		asy->asy_xmit_ring_size = ASYTXBUFSIZE;	/* XXX: tune later? */
#endif

		/*
		 * Save the address of the soft structure in the tty struct
		 */
		tp->t_addr = (caddr_t)asy;
		tp->t_state = 0;

		/*
		 * Try out the FIFO by turning it on.  This should have
		 * no effect on a non-FIFO card.  First clear the FIFOs,
		 * then turn them on.  If the iir has the top bits set
		 * we've got a good one.
		 */
 		IOOUT(&addr->fcr, FCR_ENBFIFO|FCR_FLUSH|FCR_FIFO_14);
		DELAY(50);
		if (IOIN(&addr->iir) & (IIR_FIFO1|IIR_FIFO2))
			asy->asy_hardware |= ASYH_HASFIFO;
#if 0
		port++;
		addr = baddr + ((port/2) * 0x80);
		if (((port + 2) % 2))
		    addr++;
/* 		addr += (port % 2) ? 0x8 : 0; */
#endif

		asyinsert (iod->iod_irq, asy, tp);
	}
}


/*
 * device-specific open code for asx-style devices
 */
asxopen(dev, flag)
	dev_t dev;
	int flag;
{
	register struct iocc_device *iod;
	register int unit;

	unit = minor(dev);
	if (unit >= MAXXUNIT)
		return ENXIO;
	iod = asxdinfo[ASXCTLR(unit)];
	if (iod == 0 || iod->iod_alive == 0)
		return ENXIO;
	return asydoopen(dev, flag);
}
#endif /* NASX > 0 */


/*
 * the real open code.  By the time this is called it is already known
 * that the unit number is in range and the device is alive.
 */
asydoopen(dev, flag)
	dev_t dev;
{
	register struct tty *tp;
	register struct asysoftc *asy;
	register int unit = minor(dev);
	register int s, error;
	register struct asydevice *asyaddr;
	struct termios t;

	tp = ASYTTY(dev);
	if (tp->t_state & TS_XCLUDE && u.u_uid != 0)
		return (EBUSY);

	asy = (struct asysoftc *)tp->t_addr;
	asyaddr = asy->asyaddr;

	if (asy->asy_flags & ASYF_CLOSING) {
		s = spl_asy();
		if (asy->asy_flags & ASYF_CLOSING) {
			error = ttywait(tp);		/* wait til complete */
		} else {
			error = 0;
		}
		(void) splx(s);
		if (error)
			return (error);
	}

	/* if this is first open, initialize tty state to defaults */
	if ((tp->t_state & TS_ISOPEN) == 0) {
		s = spl_asy();
		asy->asy_flags = 0;
#ifdef FAST_INTERRUPTS
		asy->asy_flags |= (ASYF_FASTINT|ASYF_FASTTXINT);/* XXX */
#endif
#if	defined(ASY_EVENT) && !defined(ASY_TXEVENT)
		/* transmitter event stuff not coded yet */
		asy->asy_flags |= (ASYF_FASTTXINT);	/* XXX */
#endif
		asy->asy_recv_ring_take_ptr = asy->asy_recv_ring_put_ptr;
		asy->asy_recv_ring_cnt = 0;
#ifdef ASY_TXEVENT
		asy->asy_xmit_ring_take_ptr = asy->asy_xmit_ring_put_ptr
			= asy->asy_txbuf;
		asy->asy_xmit_ring_cnt = 0;
#endif
		asy->asy_mcr = MCR_IEN|MCR_DTR|MCR_RTS;
		tp->t_state |= TS_WOPEN;
		ttychars(tp);
		tp->t_oproc = asystart;
		tp->t_param = asyparam;
		tp->t_dev = dev;
		tp->t_iflag = TTYDEF_IFLAG;
		tp->t_oflag = TTYDEF_OFLAG;
		tp->t_lflag = TTYDEF_LFLAG;
		tp->t_cflag = 0;
		t.c_cflag = TTYDEF_CFLAG;
		tp->t_ospeed = tp->t_ispeed = 0;
		t.c_ospeed = t.c_ispeed = TTYDEF_SPEED;
		if (asy->asy_hardware & ASYH_HASFIFO) {
#ifdef HONEY_LIKE
			IOOUT(&asyaddr->fcr, FCR_FIFO_4|FCR_FLUSH);
#else
			IOOUT(&asyaddr->fcr, FCR_FIFO_8|FCR_FLUSH);
#endif
		}
		asyparam(tp, &t);	/* sets ASYF_NOINPUT as side effect */
		ttsetwater(tp);
		/*
		 * Enable all interrupts and turn on dtr and rts.  Initialize
		 * the modem status bits from the hardware.
		 */
		IOOUT(&asyaddr->ier, IER_DR | IER_LSR | IER_MSR | IER_THRE);
		IOOUT(&asyaddr->mcr, asy->asy_mcr);
		asy->asy_msr = IOIN(&asyaddr->msr);
		if ((asy->asy_msr & MSR_DCD)
		    || (*(asy->asy_softCAR) & asy->asy_port)) {
 			tp->t_state |= TS_CARR_ON;
			asy->asy_flags &= ~ASYF_NOINPUT;
		}
		(void) splx(s);
	}

	s = spl_asy();
	while (!(flag & O_NONBLOCK) && !(tp->t_cflag & CLOCAL) &&
	    (tp->t_state & TS_CARR_ON) == 0) {
		tp->t_state |= TS_WOPEN;
		if (error = ttysleep(tp, (caddr_t)&tp->t_rawq, TTIPRI | PCATCH,
		    ttopen, 0)) {
			/* XXX do we need an asyclose in case of errors? */
			tp->t_state &= ~TS_WOPEN;
			(void) splx(s);
			return (error);
		}
	}
	(void) splx(s);
	error = (*linesw[tp->t_line].l_open)(dev, tp);
	return (error);
}


/*ARGSUSED*/
asyclose(dev, flag, mode)
	dev_t dev;
	int flag;
	int mode;
{
	register struct tty *tp = ASYTTY(dev);
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	register struct asydevice *asyaddr = asy->asyaddr;
	register int error;
	int s;
	void asycls();
	void asydcdtmo();

	s = spl_asy();

	/*
	 * If we're closing already this means someone else is hanging
	 * waiting for the output to flush.  We'll wait for this as well,
	 * then return.   XXX This probably shouldn't happen.
	 */
	if (asy->asy_flags & ASYF_CLOSING) {
		error = ttywait(tp);
		return (error);
	}
	
	/*
	 * If we're in the middle of a carrier time out, do away with
	 * it.  It doesn't matter now anyway.
	 */
	if (asy->asy_flags & ASYF_DCDTMO) {
		asy->asy_flags &= ~ASYF_DCDTMO;
		untimeout(asydcdtmo, tp);	/* cancel the timeout */
	}

	/*
	 * Now mark that we're closing, set a timeout to make sure
	 * we don't hang forever and call the line-specific close
	 * (which probably does a ttywflush() to wait for output to
	 * complete.
	 */
	if (tp->t_outq.c_cc > 0) {
		asy->asy_flags |= ASYF_CLOSING;
		timeout(asycls, tp, asyouttime(tp));
	}
	(*linesw[tp->t_line].l_close)(tp);
	if (asy->asy_flags & ASYF_CLOSING)
		untimeout(asycls, tp);		/* cancel the timeout */

	/*
	 * Shut down the hardware and turn off the break bit.  If we
	 * need to hang up on close, do that too.
	 *
	 * XXX All the other drivers I have shut down the hardware if the
	 * TS_WOPEN bit is set.  I'm not quite why this is since I
	 * would have done exactly the opposite.  I'll punt and not
	 * do anything.
	 */
	IOOUT(&asyaddr->lcr, IOIN(&asyaddr->lcr) & ~LCR_SETB);  /* clr break */
	IOOUT(&asyaddr->ier, IOIN(&asyaddr->ier) & ~(IER_DR|IER_LSR|IER_MSR));
	if (asy->asy_hardware & ASYH_HASFIFO)
 		IOOUT(&asyaddr->fcr, FCR_RFLUSH);
	if (tp->t_cflag & HUPCL || (tp->t_state & TS_ISOPEN) == 0) {
		if (asy->asy_hardware & ASYH_ISCOM)
			IOOUT(&asyaddr->mcr, MCR_IEN);
		else
			IOOUT(&asyaddr->mcr, 0);
	}
	asy->asy_flags = 0;
	asy->asy_softflags = 0;

	(void) splx(s);
	error = ttyclose(tp);
	return error;
}

/*
 * return an overestimate of the number of clock ticks it will take
 * to output the remaining output after close has started
 * the multiplcation by 32 gives a 320% overestimate plus hz gives an
 * additional second just in case.
 */

asyouttime(tp)
register struct tty *tp;
{
	if (tp->t_ospeed == 0)
		return (hz);
	return (hz * (1 + ((tp->t_outq.c_cc << 5) / tp->t_ospeed)));
}

/*
 * routine called when close takes longer than it should to flush output
 * and get things going again
 */
void
asycls(tp)
register struct tty *tp;
{
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	register int s = spl_asy();

	if (asy->asy_flags & ASYF_CLOSING) {	/* if close in progress */
		ttyflush(tp, FREAD|FWRITE);
		asy->asy_flags &= ~ASYF_CLOSING;
	}
	(void) splx(s);
}


/*ARGSUSED*/
asyread(dev, uio, flag)
	dev_t dev;
	struct uio *uio;
	int flag;
{
	register struct tty *tp = ASYTTY(dev);

	return ((*linesw[tp->t_line].l_read)(tp, uio, flag));
}


/*ARGSUSED*/
asywrite(dev, uio, flag)
	dev_t dev;
	struct uio *uio;
	int flag;
{
	register struct tty *tp = ASYTTY(dev);

	return ((*linesw[tp->t_line].l_write)(tp, uio, flag));
}



/*ARGSUSED*/
asyioctl(dev, cmd, data, flag)
	dev_t dev;
	int cmd;
	caddr_t data;
	int flag;
{
	register struct tty *tp = ASYTTY(dev);
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
	register int mode;
	register int error, s;

	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, data, flag);
	if (error >= 0)
		return (error);

	asy = (struct asysoftc *)tp->t_addr;
	asyaddr = asy->asyaddr;

	s = spl_asy();
	switch (cmd) {
	case TIOCSBRK:		       /* Set break */
		IOOUT(&asyaddr->lcr, IOIN(&asyaddr->lcr) | LCR_SETB);
		break;

	case TIOCCBRK:		       /* Clear break */
		IOOUT(&asyaddr->lcr, IOIN(&asyaddr->lcr) & ~LCR_SETB);
		break;

	case TIOCSDTR:		       /* Set DTR */
		asy->asy_mcr |= MCR_DTR;
		IOOUT(&asyaddr->mcr, asy->asy_mcr);
		break;

	case TIOCCDTR:		       /* Clear DTR */
		asy->asy_mcr &= ~MCR_DTR;
		IOOUT(&asyaddr->mcr, asy->asy_mcr);
		break;

	case TIOCMSET:
	case TIOCMODS:
	case TIOCMBIS:
	case TIOCMBIC:
		mode = 0;
		if (*(int *)data & TIOCM_DTR)
			mode |= MCR_DTR;
		if ((*(int *)data & TIOCM_RTS)
		    /* && !(asy->asy_flags & ASYF_RTSCTL) */ )
			mode |= MCR_RTS;

		switch (cmd) {
		case TIOCMBIS:
			asy->asy_mcr |= mode;
			break;

		case TIOCMBIC:
			asy->asy_mcr &= ~mode;
			break;

		default:
			/*
			if (asy->asy_flags & ASYF_RTSCTL)
				asy->asy_mcr &= ~MCR_DTR;
			else
			*/
				asy->asy_mcr &= ~(MCR_DTR|MCR_RTS);
			asy->asy_mcr |= mode;
			break;
		}

		IOOUT(&asyaddr->mcr, asy->asy_mcr);
		break;

	case TIOCMGET:
	case TIOCMODG:
		mode = 0;
		if (asy->asy_mcr & MCR_DTR)
			mode |= TIOCM_DTR;
		if (asy->asy_mcr & MCR_RTS)
			mode |= TIOCM_RTS;
		if (asy->asy_msr & MSR_CTS)
			mode |= TIOCM_CTS;
		if (asy->asy_msr & MSR_DSR)
			mode |= TIOCM_DSR;
		if (asy->asy_msr & MSR_RI)
			mode |= TIOCM_RI;
		if (asy->asy_msr & MSR_DCD)
			mode |= TIOCM_CD;
                *(int *)data = mode;
                break;

	default:
		(void) splx(s);
		return (ENOTTY);
	}
	(void) splx(s);
	return (0);
}


asyparam(tp, t)
	register struct tty *tp;
	register struct termios *t;
{
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	register struct asydevice *asyaddr = asy->asyaddr;
	register int cflag = t->c_cflag;
	register int ospeed;
	register u_char lcr = 0;
	int xmitlevel;
	int s;

	/*
	 * Make sure we've got a recognized speed.  If not, throw up.
	 */
	ospeed = ttspeedtab(t->c_ospeed, asyspeedtab);
	if (ospeed < 0 || (t->c_ispeed && t->c_ispeed != t->c_ospeed))
		return (EINVAL);


	/*
	 * Figure out the new line control register setting state
	 */
	switch (cflag & CSIZE) {
	case CS5:
		lcr = LCR_5BIT;
		break;
	case CS6:
		lcr = LCR_6BIT;
		break;
	case CS7:
		lcr = LCR_7BIT;
		break;
	case CS8:
		lcr = LCR_8BIT;
		break;
	}

	if (cflag & PARENB) {
		lcr |= LCR_PEN;
		if ((cflag & PARODD) == 0)
			lcr |= LCR_EPS;
	}

	if (cflag & CSTOPB)
		lcr |= LCR_STB;

	/* set the transmit level according to output speed.
	 * NOTE: non-fifo chips will always be set to 1.
	 */
	if (asy->asy_hardware & ASYH_HASFIFO) {
	    xmitlevel = ttspeedtab(t->c_ospeed, asyxmtfifotab);
	    if (xmitlevel < 0)
		xmitlevel = ASYMINXMTFIFO;
	}
	else
	    xmitlevel = ASYDEFXMITNOFIFO;

#ifdef ASY_TXEVENT
	/* dynamically adapt xmit buffer size to baud rate to prevent 
	 * long buffer drains at low speeds.  Drain time
	 * is about 2 seconds with continuous character flow.
	 * XXX: these calculations were based on an xmit buf size
	 *	of 10k.  Now the buffer size is at 1k, we'll use 
	 *	the entire buffer most of the time.  But thats ok....
	 */

	if ((asy->asy_xmit_ring_size = (t->c_ospeed/5)) < ASYDEFXMITFIFO * 2)
	    asy->asy_xmit_ring_size = ASYDEFXMITFIFO * 2;
	if (asy->asy_xmit_ring_size > ASYTXBUFSIZE)
	    asy->asy_xmit_ring_size = ASYTXBUFSIZE;
#endif

	/*
	 * Okay, save all the state that concerns us and set the
	 * hardware to match.  If the speed was zero hang up the line
	 */
	s = spl_asy();
	if (cflag & CLOCAL) {
		asy->asy_flags &= ~ASYF_NOINPUT;
	} else if ((tp->t_state & TS_CARR_ON) == 0) {
		asy->asy_flags |= ASYF_NOINPUT;
	}

	tp->t_cflag = cflag;
	asy->asy_xmitlevel = xmitlevel;
	lcr |= IOIN(&asyaddr->lcr) & LCR_SETB;	/* retain state of break bit */
	IOOUT(&asyaddr->lcr, lcr);

	tp->t_ispeed = t->c_ispeed;
	if (t->c_ospeed != tp->t_ospeed) {
		tp->t_ospeed = t->c_ospeed;
		if (ospeed == 0)
			IOOUT(&asyaddr->mcr, MCR_IEN); /* hang up DTR,RTS =0 */
		else
			ASY_SETBAUD(asyaddr, ospeed);
	}

	/*
	 * Couple of bits of grot.  If he's turned off CTS flow control and
	 * we're stopped for CTS we'll hang forever if we don't start it here.
	 * If we were previously doing RTS input flow control and we're not
	 * now, we'd better turn RTS on too.
	 */
	if ((asy->asy_flags & ASYF_CTSSTOP) &&
	    (tp->t_cflag & CCTS_OFLOW) == 0) {
		asy->asy_flags &= ~ASYF_CTSSTOP;
#ifdef ASY_TXEVENT
		asy_xproc(asy);
#else
		asystart(tp);
#endif
	}

	if (((tp->t_cflag & CRTS_IFLOW) != 0)
	    ^ ((asy->asy_flags & ASYF_RTSCTL) != 0)) {
		asy->asy_mcr |= MCR_RTS;
		IOOUT(&asyaddr->mcr, asy->asy_mcr);
		if (tp->t_cflag & CRTS_IFLOW) {
			asy->asy_flags |= ASYF_RTSCTL;
		}
		else {
			asy->asy_flags &= ~ASYF_RTSCTL;
		}
	}

	(void) splx(s);

	return (0);
}

#ifdef MULTI_BOARD
/*
 * Interrupt handler for PC-style cards
 */
asyint(ctlr, irq)
	int ctlr, irq;
{
	register struct tty *tp;
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
	register unsigned char iir;
	register int c, n;
	int need_reset = 0;

	if (cold) {
	    return (1);		/* DONT respond to interrupts during autoconf*/
	}

	/*
	 * Set us up to do this
	 */
	if ((asy = asy_irq_table[irq]) == (struct asysoftc *) 0) { /* safety */
	    printf("asyint%d: bogus interrupt on irq %d\n", ctlr, irq);
	    return (0);
	}

	do {
	    register u_char lsr;
loop1:;
	    tp = asy->asy_tty;
	    asyaddr = asy->asyaddr;

	    /*
	     * quickly drain the receivers IF 1) we are accepting input
	     * from this uart, 2) somebody has it open, and 3) there
	     * is data in the uart waiting for us.
	     */
	    if (((asy)->asy_flags & ASYF_NOINPUT) ||
		    !(tp->t_state & (TS_CARR_ON|TS_WOPEN|TS_ISOPEN)) ||
		    !((lsr = IOIN(&asyaddr->lsr)) & LSR_DR)) { 
		if (asy = asy->asy_next_uart)
		    goto loop1;
		break;
	    }

	    /* XXX: should probably combine asylint and asyrint */
	    if (lsr & (LSR_PE|LSR_FE|LSR_OR|LSR_BI))
		asylint(tp, asy, asyaddr);
	    else
		asyrint(tp, asy, asyaddr);
	    asy = asy->asy_next_uart;
	} while (asy);

	asy = asy_irq_table[irq];	/* back to begining of irq chain */

	/*
	 * loop thru all uarts on the irq chain to pickup other (slower)
	 * interrupt events.
	 */
	for (;;) {
loop2:;
	    tp = asy->asy_tty;
	    asyaddr = asy->asyaddr;

	    /*
	     * Get the interrupt ID register contents.  If nothing pending
	     * move to the next uart, or return.
	     */
	    iir = IOIN(&asyaddr->iir);
	    if (iir & IIR_PEND) { 
		    /*
		     * if there is another board on this interrupt level,
		     * check if it interrupted.
		     */
		    if (asy = asy->asy_next_uart)
			goto loop2;

		    /* all done.  Issue a reset if needed */
		    if (need_reset)
			IOOUT(asyreset[irq], 0);/* acknowledge the interrupt */
		    return (0);
	    }
	    if (!(asy->asy_hardware & ASYH_ISCOM))	/* not a COM card? */
		need_reset ++;	/* need to ack the intrpt for 4/8 port cards */

	    /*
	     * Process interrupts as they come.
	     */
	    do {
		    switch (iir & IIR_MASK) {

		    case IIR_CTI:
			    /*
			     * Character time out.  This is noted, then
			     * treated like a receive with no error.
			     */
			    (asy->asy_stats->asychartmo)++;

			    /* FALL-THRU */

		    case IIR_RXB:
			    asyrint(tp, asy, asyaddr);
			    break;

		    case IIR_LSR:
			    /*
			     * Receive with an error.  We have a subroutine
			     * to deal with this.
			     */
			    asylint(tp, asy, asyaddr);
			    break;

		    case IIR_TXB:
			    asyxint(tp, asy, asyaddr);
			    break;

		    case IIR_MSR:
			    asymint(tp, asy, asyaddr);
			    break;

		    default:
			    printf("asy%d: iir=%x\n", ctlr, iir);
			    break;
		    }
	    } while (((iir = IOIN(&asyaddr->iir)) & IIR_PEND) == 0);

	}
	/* NOTREACHED */
}
#else

#if NASY > 0
/*
 * Interrupt handler for PC-style cards
 */
asyint(ctlr, irq)
	int ctlr, irq;
{
	register struct tty *tp;
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
	register unsigned char iir;
	register int c, n;

	/*
	 * Set us up to do this
	 */
	tp = &asy_tty[ctlr];
	asy = (struct asysoftc *)tp->t_addr;
	asyaddr = asy->asyaddr;

	/*
	 * Get the interrupt ID register contents.  If nothing pending
	 * return 1.
	 */
	iir = IOIN(&asyaddr->iir);
	if (iir & IIR_PEND) { 
		asystats.asybogons++;
		return (ASYSHAREDIRQ);
	}

	/*
	 * Process interrupts as they come.
	 */
	do {
		switch (iir & IIR_MASK) {

		case IIR_CTI:
			/*
			 * Character time out.  This is noted, then
			 * treated like a receive with no error.
			 */
			asystats.asychartmo++;

			/* FALL-THRU */

		case IIR_RXB:
			asyrint(tp, asy, asyaddr);
     			break;

     		case IIR_LSR:
			/*
			 * Receive with an error.  We have a subroutine
			 * to deal with this.
			 */
			asylint(tp, asy, asyaddr);
     			break;

     		case IIR_TXB:
			asyxint(tp, asy, asyaddr);
			break;

     		case IIR_MSR:
     			asymint(tp, asy, asyaddr);
     			break;

		default:
			printf("asy%d: iir=%x\n", ctlr, iir);
			break;
		}
	} while (((iir = IOIN(&asyaddr->iir)) & IIR_PEND) == 0);

	return (0);
}
#endif /* NASY > 0 */

#if NASQ > 0
/*
 * Interrupt handler for (possibly buffered) quad cards
 */
asqint(ctlr, irq)
	int ctlr, irq;
{
    register struct tty *tp;
    register struct asysoftc *asy;
    register struct asydevice *asyaddr;
    register int c, n;
    register unsigned char iir;
    int portmask, port;
    int result = ASYSHAREDIRQ, hot = 0;

#ifdef DO_HOTSTUFF
    /* loop on this card if its hot... */
    do {
#endif

	/*
	 * Set us up to do this
	 */
	tp = &asq_tty[ASQUNIT(ctlr)];
	asy = (struct asysoftc *)tp->t_addr;
	asyaddr = asy->asyaddr;

	/*
	 * Get the pending port interupt mask.  If nothing to do, return.
	 */
	portmask = IOIN(&asyaddr->ppir) & 0xf;
	if (!portmask)		/* wasn't us, or we're done */
	    goto out;

	/*
	 * Go around in a hurry testing consecutive ports.  Process anything
	 * that is pending.
	 */
	for (port = 0x1; portmask; tp++, asy++, asyaddr++, port <<= 1) {

	    /*
	     * If not this port, continue.  If the interrupt ID register
	     * doesn't think there's a problem, continue as well.
	     */
	    if (!(portmask & port))
		continue;
	    portmask &= ~port;
	    if (result)
		result = 0;

	    iir = IOIN(&asyaddr->iir);
	    if (iir & IIR_PEND) { 
		asqstats.asybogons++;
		continue;
	    }

	    do {
		switch (iir & IIR_MASK) {

		case IIR_CTI:
		    /*
		     * Character time out.  This is noted, then
		     * treated like a receive with no error.
		     */
		    asqstats.asychartmo++;

		    /* FALL-THRU */

		case IIR_RXB:
		    asyrint(tp, asy, asyaddr);
		    break;

		case IIR_LSR:
		    /*
		     * Receive with an error.  We have a subroutine
		     * to deal with this.
		     */
		    asylint(tp, asy, asyaddr);
		    break;

		case IIR_TXB:
		    asyxint(tp, asy, asyaddr);
		    break;

		case IIR_MSR:
		    asymint(tp, asy, asyaddr);
		    break;

		default:
		    printf("asq%d: iir=%x\n", asy->asy_unit, iir);
		    break;
		}
	    } while (((iir = IOIN(&asyaddr->iir)) & IIR_PEND) == 0);
	}
#ifdef DO_HOTSTUFF
    } while (++hot < MAXHOTINT);
#endif

out:;

#ifdef DO_HOTSTUFF
    /* gather some stats if we were hot.... */
    if (hot >= MAXHOTINT)
	asqstats.asymaxhotint++;	/* too hot! */
    else if (hot > 1)
	asqstats.asyhotint++;		/* hot... */
#endif

    IOOUT(asyreset[irq], 0);		/* acknowledge the interrupt */
    return (result);
}
#endif /* NASQ > 0 */

#if NASX > 0
/*
 * Interrupt handler for eight port multiport cards.  We assume these
 * always have buffered chips
 */
asxint(ctlr)
	int ctlr;
{
    register struct tty *tp;
    register struct asysoftc *asy;
    register struct asydevice *asyaddr;
    register int c, n;
    register unsigned char iir;
    int portmask, port;
    int result = ASYSHAREDIRQ, hot = 0;

#ifdef DO_HOTSTUFF
    /* loop on this card if its hot... */
    do {
#endif
	/*
	 * Set us up to do this
	 */
	tp = &asx_tty[ASXUNIT(ctlr)];
	asy = (struct asysoftc *)tp->t_addr;
	asyaddr = asy->asyaddr;

	/*
	 * Get the pending port interupt mask.  If nothing to do, return.
	 */
    	portmask = IOIN(&asyaddr->ppir) & 0xff;
	if (!portmask)		/* wasn't us, or we're done */
	    goto out;

	/*
	 * Go around in a hurry testing consecutive ports.  Process anything
	 * that is pending.
	 */
	for (port = 0x80; portmask != 0; tp++, asy++, port >>= 1) {
	    asyaddr = asy->asyaddr;
	    /*
	     * If not this port, continue.  If the interrupt ID register
	     * doesn't think there's a problem, continue as well.
	     */
	    if (!(portmask & port))
		continue;
	    portmask &= ~port;
	    if (result)
		result = 0;

	    iir = IOIN(&asyaddr->iir);
	    if (iir & IIR_PEND) { 
		asxstats.asybogons++;
		continue;
	    }

	    do {
		switch (iir & IIR_MASK) {

		case IIR_CTI:
		    /*
		     * Character time out.  This is noted, then
		     * treated like a receive with no error.
		     */
		    asxstats.asychartmo++;

		    /* FALL-THRU */

		case IIR_RXB:
		    asyrint(tp, asy, asyaddr);
		    break;

		case IIR_LSR:
		    /*
		     * Receive with an error.  We have a subroutine
		     * to deal with this.
		     */
		    asylint(tp, asy, asyaddr);
		    break;

		case IIR_TXB:
		    asyxint(tp, asy, asyaddr);
		    break;

		case IIR_MSR:
		    asymint(tp, asy, asyaddr);
		    break;

		default:
		    printf("asx%d: iir=%x\n", asy->asy_unit, iir);
		    break;
		}
	    } while (((iir = IOIN(&asyaddr->iir)) & IIR_PEND) == 0);
	}
#ifdef DO_HOTSTUFF
    } while (++hot < MAXHOTINT);
#endif

out:;
#ifdef DO_HOTSTUFF
    /* gather some stats if we were hot.... */
    if (hot >= MAXHOTINT)
	asxstats.asymaxhotint++;	/* too hot! */
    else if (hot > 1)
	asxstats.asyhotint++;		/* hot... */
#endif
    return (result);
}
#endif /* NASX > 0 */

#endif /* MULTI_BOARD */

/* transfer received characters to the next level up */
int
asy_rxfer(tp, asy)
	register struct tty *tp;
	register struct asysoftc *asy;
{
    register int num_to_xfer;
    register u_int *cp;
    int num_save, s, input_ok, partial, n;

    /* anything to transfer? */
again:;
    s = spl_asy();
    if (!(num_to_xfer = asy->asy_recv_ring_cnt))
	return (0);

    if (asy->asy_flags & ASYF_RXFER)	/* already being serviced ? */
	return (1);			/* signal for another softasy () */
    asy->asy_flags |= ASYF_RXFER;	/* serialization start */
    (void) splx(s);			/* enable interrupts */
    
    /* determine how many characters are in 1 contiguous block */
    partial = 0;
    if (&asy->asy_rxbuf[ASYRXBUFSIZE] - asy->asy_recv_ring_take_ptr <
	    (u_int) num_to_xfer) {
	num_to_xfer = &asy->asy_rxbuf[ASYRXBUFSIZE] - 
		asy->asy_recv_ring_take_ptr;
	partial ++;
    }
    num_save = num_to_xfer;

    /* do the transfer */
    /* NOTE: if input_ok drops to zero, it implies that carrier dropped.
     *       The result is that we throw away all buffered characters.
     *	     XXX: Is this correct?
     */
    input_ok = 1;
    do {
	cp = asy->asy_recv_ring_take_ptr++;
	if (*cp & ASY_DCD_MAGIC) {
	    input_ok = asydcdchange(asy, tp, *cp & TTY_CHARMASK);
	}
	else if (input_ok) {
	    (*linesw[tp->t_line].l_rint)(*cp, tp);
	}
    } while (--num_to_xfer);

    if (asy->asy_recv_ring_take_ptr == &asy->asy_rxbuf[ASYRXBUFSIZE])
	asy->asy_recv_ring_take_ptr = &asy->asy_rxbuf[0];

    /* stats */
    n = num_save/ASYRXSTATDIV;
    if (n < RCVXBUCKETS)
	(asy->asy_stats->asyrcvxcnt[n])++;	/* see how efficient we are */

    s = spl_asy();
    asy->asy_recv_ring_cnt -= num_save;

    asy->asy_flags &= ~ASYF_RXFER;	/* serialization clear */
    (void) splx(s);

    /* XXX: check for wrap condition if in fast interrupt mode. */
    if (asy->asy_flags & ASYF_FASTINT && partial)
	goto again;
    return (partial);
}

/*
 * Process a receive interrupt 
 */
asyrint(tp, asy, asyaddr)
	register struct tty *tp;
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
{
	register int c, n;

#ifdef HONEY_LIKE
	char buf[32];

	for (n = 0; n < 32 && (IOIN(&asyaddr->lsr) & LSR_DR); n++)
	    buf[n] = IOIN(&asyaddr->rxb);
	for (c = 0; c < n; c++)
	    (*linesw[tp->t_line].l_rint)(buf[c],tp);

#else
	/*
	 * Receive with no error.  Read whatever you
	 * can get and process it.
	 */
	n = 0;
	do {
		c = IOIN(&asyaddr->rxb);
		ASYPUTC(c, asy);
		n++;
	} while (IOIN(&asyaddr->lsr) & LSR_DR);

	if (asy->asy_flags & ASYF_FASTINT)
		asy_rxfer(tp, asy);
	else {
		if (ASYISFULL(asy))
		    ASYRTSOFF(asy, asyaddr);
		ASYSETSOFT(ASYS_RECV, asy, tp);
	}
#endif

	if (n > MAXRCVCNT)	/* impossible! (well, not really) */
		n = 0;
	(asy->asy_stats->asyrcvcnt[n])++;
	(asy->asy_stats->asyrcvints)++;
}


/*
 * Process a receive interrupt where there are known to be errors
 */
asylint(tp, asy, asyaddr)
	register struct tty *tp;
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
{
	register int c, n;
	register u_char lsr;

	n = 0;
	while ((lsr = IOIN(&asyaddr->lsr)) & LSR_DR) {
		c = IOIN(&asyaddr->rxb);
		if ((asy->asy_flags & ASYF_NOINPUT) == 0) {
			if (lsr & (LSR_PE|LSR_FE|LSR_OR|LSR_BI)) {
				if (lsr & LSR_PE)
					c |= TTY_PE;
				if (lsr & (LSR_FE|LSR_BI))
					c |= TTY_FE;
				if (lsr & LSR_OR) {
					log(LOG_WARNING, "as%c%d: overrun\n",
					    asy->asy_type, asy->asy_unit);
					(asy->asy_stats->asyoverrun)++;
				}
			}

			if (asy->asy_flags & ASYF_FASTINT) {
				(*linesw[tp->t_line].l_rint)(c, tp);
			} else {
				ASYPUTC(c, asy);
				n++;
			}
		}
	}

	if (n)
		ASYSETSOFT(ASYS_RECV, asy, tp);
}


/*
 * Called when we've run out of characters to send.  We schedule a soft
 * interrupt to start the whole thing again.
 */
/*ARGSUSED*/
asyxint(tp, asy, asyaddr)
	register struct tty *tp;
	register struct asysoftc *asy;
	struct asydevice *asyaddr;
{
	void asywbusy ();
	int asycouttime ();

	(asy->asy_stats->asyxmtint)++;	/* count tranmit interrupts */

	/* check anyway.... */
 	if ((IOIN(&asyaddr->lsr) & LSR_THRE) == 0) {	/* still busy ? */

	    (asy->asy_stats->asyxmtxbusy)++;

	    /* schedule a timeout, if needed */
	    if ((asy->asy_flags & ASYF_WBUSY) == 0) {
		asy->asy_flags |= ASYF_WBUSY;
		timeout(asywbusy, (caddr_t)tp, asycouttime(tp));
	    }
	    return;
	}

	/*
	 * Do some checks.  Mostly for debugging
	 */
	if ((tp->t_state & TS_BUSY) == 0) {
		(asy->asy_stats->asyxmtnotbusy)++;
	}
	tp->t_state &= ~(TS_BUSY|TS_FLUSH);

	/*
	 * softasy() currently does nothing right now, as far as the
	 * transmitter is concerned.  So just kick the output routine 
	 * instead.
	 */
	/* scratch the above comment.  We cant stay in the interupt
	 * handler this long, so schedule the tranmit instead.
	 * receives need to take priority over transmits, or we
	 * will drop characters.
	 */
	if (asy->asy_flags & ASYF_FASTTXINT) {
	    if (tp->t_line) 
		(*linesw[tp->t_line].l_start)(tp);
	    else
		asystart(tp);
	}
	else {
#ifdef ASY_TXEVENT
	    asy_xproc (asy);
#else
	    ASYSETSOFT(ASYS_XMIT, asy, tp);
#endif
	}
}


/*
 * Called when the modem status changes.  We pay attention to
 * CTS and/or DCD at times.
 */
asymint(tp, asy, asyaddr)
	register struct tty *tp;
	register struct asysoftc *asy;
	register struct asydevice *asyaddr;
{
	register u_char msr;

	/*
	 * Fetch new modem status.  Save it for other use.
	 */
	msr = IOIN(&asyaddr->msr);
	asy->asy_msr = msr;

	/*
	 * If we're doing RTS-CTS handshaking check for state changes in
	 * CTS.  If so we may have to stop output (if we're busy and CTS
	 * drops) or restart output (if CTS is up and we have a prior stop
	 * in place).
	 */
	if ((msr & MSR_DCTS) && (tp->t_cflag & CCTS_OFLOW)) {
		if (msr & MSR_CTS) {
			/*
			 * CTS is high but we're stopped.  If we aren't
			 * busy, start us up again.
			 */
			if (asy->asy_flags & ASYF_CTSSTOP) {
			    asy->asy_flags &= ~ASYF_CTSSTOP;
			}
			if ((tp->t_state & TS_BUSY) == 0) {
			    if (asy->asy_flags & ASYF_FASTTXINT) {
#if 0
				asyxint(tp, asy, asyaddr);
#else
				if (tp->t_line) 
				    (*linesw[tp->t_line].l_start)(tp);
				else
				    asystart(tp);
#endif
			    }
			    else {
#ifdef ASY_TXEVENT
				asy_xproc (asy);
#else
				ASYSETSOFT(ASYS_XMIT, asy, tp);
#endif
			    }
			}
		} else if ((asy->asy_flags & ASYF_CTSSTOP) == 0) {
			/*
			 * Here CTS has dropped and we aren't already
			 * stopped.  If we're busy make sure we stop
			 * soon.
			 */
			asy->asy_flags |= ASYF_CTSSTOP;
		}
	}
	if ((msr & MSR_DDCD) && (*(asy->asy_softCAR) & asy->asy_port) == 0) {
		register int cookie;
		/*
		 * Stuff a magic cookie into the receive buffer.  Make
		 * sure it fits, even if the buffer is full.
		 */
		if (msr & MSR_DCD)
			cookie = ASY_DCD_MAGIC|1;
		else
			cookie = ASY_DCD_MAGIC|0;

		/* if ignoring input anyway, handle the DCD change NOW */
		if (asy->asy_flags & (ASYF_FASTINT|ASYF_NOINPUT)) {
			(void) asydcdchange(asy, tp, cookie & TTY_CHARMASK);
		} else {
			/* XXX! */
			if (asy->asy_recv_ring_cnt == ASYRXBUFSIZE) {
			    *asy->asy_recv_ring_put_ptr = cookie;
			    asy->asy_flags |= ASYF_OVERFLOW;
			    (asy->asy_stats->asyrcvbufoflow)++; 
			}
			else {
			    ASYPUTC(cookie, asy);
			}

			ASYSETSOFT(ASYS_RECV, asy, tp);
		}
	}
}


/*
 * Routine to deal with carrier transitions.  This inserts a delay
 * to carrier recognition if the state of the carrier was previously
 * off and we're in open wait state.
 */
int
asydcdchange(asy, tp, state)
	struct asysoftc *asy;
	struct tty *tp;
	int state;
{
	int input_ok;
	int s;
	void asydcdtmo();

	s = spl_asy();
	if (state && (tp->t_state & TS_WOPEN)) {
		/*
		 * DCD came up and we were in open wait.  Delay a bit if
		 * someone isn't already.
		 */
		if ((asy->asy_flags & ASYF_DCDTMO) == 0) {
			asy->asy_flags |= ASYF_DCDTMO;
			timeout(asydcdtmo, (caddr_t)tp, ASYDCDDELAY);
		}
	}

	input_ok = (*linesw[tp->t_line].l_modem)(tp, state);
	if (input_ok)
		asy->asy_flags &= ~ASYF_NOINPUT;
	else 
		asy->asy_flags |= ASYF_NOINPUT;

	if (state == 0) {
		/*
		 * DCD dropped.  If we're holding output, cancel the
		 * time out and restart us.
		 */
		if (asy->asy_flags & ASYF_DCDTMO) {
			asy->asy_flags &= ~ASYF_DCDTMO;
			untimeout(asydcdtmo, tp);	/* cancel the timeout */
			if (input_ok)
				asystart(tp);
		}
	}
	(void) splx(s);

	return (input_ok);
}


/*
 * Timeout routine for carrier changes.  Tell the world that DCD has
 * been asserted.
 */
void
asydcdtmo(tp)
	register struct tty *tp;
{
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	int s;

	s = spl_asy();
	if (asy->asy_flags & ASYF_DCDTMO) {
		asy->asy_flags &= ~ASYF_DCDTMO;
		asystart(tp);
	}
	(void) splx(s);
}


/*
 * Soft interrupt routine.  This provides interrupt completion without
 * blocking additional hardware interrupts for longer than we can avoid.
 */
softasy()
{
#ifndef ASY_EVENT
	register struct tty *tp;
	register struct asysoftc *asy;
	register int i, *cp;
	register int input_ok;
	int n, s;
	struct tty *tps[MAXYUNIT+MAXQUNIT+MAXXUNIT];
	unsigned char softflags[MAXYUNIT+MAXQUNIT+MAXXUNIT];

	/*
	 * Copy the entire list to be done.  Empty the list for
	 * future interruptors.
	 */
	s = spl_asy();
	n = asynumsoft;
	for (i = 0; i < n; i++) {
		tp = asysoftlist[i];
		tps[i] = tp;
		asy = (struct asysoftc *)tp->t_addr;
		softflags[i] = asy->asy_softflags;
		asy->asy_softflags = 0;
	}
	asynumsoft = 0;
	(void) splx(s);

	/*
	 * Now go around again.  Empty the receive buffer, reset
	 * the transmitter buffer, and report any modem control
	 * changes.
	 */
	for (i = 0; i < n; i++) {
		tp = tps[i];
		asy = (struct asysoftc *)tp->t_addr;

		if (softflags[i] & ASYS_RECV) {

			/*
			 * Transfer buffered characters up.
			 * Schedule another soft interupt if
			 * we didnt transfer our entire part of
			 * the receive buffer (ie, we wrapped the
			 * buffer) 
			 */
			if (asy_rxfer (tp, asy)) {
			    s = spl_asy();
			    ASYSETSOFT(ASYS_RECV, asy, tp);
			    (void) splx(s);
			}

			if (asy->asy_flags & ASYF_OVERFLOW) {
				asy->asy_flags &= ~ASYF_OVERFLOW;
				log(LOG_WARNING, "as%c%d: rxbuf overrun",
					    asy->asy_type, asy->asy_unit);
			}
			/*
			 * turn back on RTS if we crossed the low water
			 * mark, but only if we arent being blocked upstream
			 */
			if ((asy->asy_flags & ASYF_RTSCTL)
			    && (asy->asy_mcr & MCR_RTS) == 0
			    && !(tp->t_state & TS_TBLOCK)
			    && asy->asy_recv_ring_cnt < ASYRXLOWATER) {
				asy->asy_mcr |= MCR_RTS;
				IOOUT(&(asy->asyaddr->mcr), asy->asy_mcr);
			}
		}

		if (softflags[i] & ASYS_XMIT) {
			if (tp->t_line)
				(*linesw[tp->t_line].l_start)(tp);
			else
				asystart(tp);
		} 
	}
#endif
}

/* 
 * time for one character to completely leave the transmitter shift register 
 * compliments of fas.c
 */

asycouttime(tp)
register struct tty *tp;
{
        /* HZ*15/38400+2 */

	if (tp->t_ospeed == 0)
		return (1);
	return (hz * 15/tp->t_ospeed + 2);
}

/*
 * wait-for-busy to clear.  Its possible to miss the TXB
 * interrupt, especially at high speeds.  So we implement
 * this timeout check to (hopefully) cure that.
 */

void
asywbusy(tp)
register struct tty *tp;
{
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	register struct asydevice *asyaddr = asy->asyaddr;
	register int s = spl_asy();	/* hold asy interrupts */

	(asy->asy_stats->asyxmttimeout)++;	/* count timeout calls */

	/* somebody else cancelled us already (??) */
	if ((asy->asy_flags & ASYF_WBUSY) == 0) {
	    (void) splx(s);
	    return;
	}

	/* transmitter is still busy !!! */
 	if ((IOIN(&asyaddr->lsr) & LSR_THRE) == 0) {

	    /* schedule a new timeout */

	    (asy->asy_stats->asyxmttobusy)++;
	    (asy->asy_stats->asyxmttoset)++;
	    timeout(asywbusy, (caddr_t)tp, asycouttime(tp));
	    (void) splx(s);
	    return;
	}

	/* debugging */
	if (tp->t_state & TS_BUSY) {
	    (asy->asy_stats->asyxmttotsbusy)++;
	}

	asy->asy_flags &= ~ASYF_WBUSY;
	tp->t_state &= ~(TS_BUSY|TS_FLUSH);

	(void) splx(s);

	/* kick output */
#ifdef ASY_TXEVENT
	asy_xproc (asy);
#else
	if (tp->t_line) 
		(*linesw[tp->t_line].l_start)(tp);
	else 
		asystart(tp);
#endif
}

#if !defined(ASY_TXEVENT)

asystart(tp)
	register struct tty *tp;
{
	register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
	register struct asydevice *asyaddr = asy->asyaddr;
 	register int c;
 	register int i, n, s;

	/*
	 * Must hold interrupts to prevent state of the tp
	 * from changing
	 */
	s = spl_asy();

#if 1
	/* XXX: HACK!! */
 	if ((tp->t_state & TS_BUSY) && (IOIN(&asyaddr->lsr) & LSR_THRE)) {
		(asy->asy_stats->asystartnb)++;
/* 		tp->t_state &= ~TS_BUSY; */
	}
#endif

	/*
	 * if it's currently active, or delaying, or stopped for one
	 * reason or another, nothing to do.
	 */
	if ((tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP)) ||
	    (asy->asy_flags & (ASYF_CTSSTOP|ASYF_DCDTMO))) {
		(void) splx(s);
		return;
	}

	/*
	 * we may be called from above, or from softasy(), and
	 * end up in the transmitter code twice.  Lock out multiple
	 * occurances of that here.....
	 */
	tp->t_state |= TS_BUSY;

#if 0
	/*
	 * XXX It is impossible for the transmitter holding register
	 * not to be empty here.  Check it anyway.
	 */
 	if ((IOIN(&asyaddr->lsr) & LSR_THRE) == 0) {
		log(LOG_ERR, "as%c%d: totally fucked",
		    asy->asy_type, asy->asy_unit);
		(void) splx(s);
		return;
	}
#endif

	/*
	 * Now dump some characters out to get things running.  How
	 * we do this depends on whether the unit is buffered or not.
	 */
	if ((asy->asy_flags & ASYF_DODELAY) == 0) {
		i = 0;
		if (asy->asy_hardware & ASYH_HASFIFO) {
#ifdef XMIT_QTOB
			char buf[20];
			register char *cp;

			/* XXX: for performance.  NOTE: does not do
			 *	terminal delays....
			 */
			cp = buf;
			n = q_to_b (&tp->t_outq, cp, asy->asy_xmitlevel);
			while (i++ < n) {
			    IOOUT (&asyaddr->txb, *cp++);
			}
#else
			n = asy->asy_xmitlevel;
			do {
				c = getc(&tp->t_outq);
				if (c == -1)
					break;
				if (c & TTY_QUOTE) {
					asy->asy_flags |= ASYF_DODELAY;
					asy->asy_delayc = (u_char)c;
					break;
				}
       				IOOUT(&asyaddr->txb, c);
				i++;
			} while (i < n);
#endif

			/* 
			 * if we didn't transmit anything, or we did
			 * and the transmitter holding register is empty,
			 * clear the busy (lock) flag.
			 */
			if (i == 0 || (IOIN(&asyaddr->lsr) & LSR_THRE))
				tp->t_state &= ~TS_BUSY;
		} else {
			n = LSR_THRE;
			do {
				c = getc(&tp->t_outq);
				if (c == -1)
					break;
				if (c & TTY_QUOTE) {
					asy->asy_flags |= ASYF_DODELAY;
					asy->asy_delayc = (u_char)c;
					break;
				}
       				IOOUT(&asyaddr->txb, c);
				i++;
			} while ((n = IOIN(&asyaddr->lsr)) & LSR_THRE);

			/* 
			 * if we didn't transmit anything, or we did
			 * and the transmitter holding register is empty,
			 * clear the busy (lock) flag.
			 */
			if (i == 0 || (n & LSR_THRE))
				tp->t_state &= ~TS_BUSY;
		}
	} else {
		/* didnt do anything yet, must not be busy. */
		tp->t_state &= ~TS_BUSY;
	}

	/*
	 * If we are busy, schedule a timeout to check the
	 * holding register (and clear TS_BUSY?), b/c we 
	 * can miss interrupts at high speeds.
	 */
	if (tp->t_state & TS_BUSY) {

		/* is a timeout already running? */
		if ((asy->asy_flags & ASYF_WBUSY) == 0) {
			asy->asy_flags |= ASYF_WBUSY;
			(asy->asy_stats->asyxmttoset)++;
			timeout(asywbusy, (caddr_t)tp, asycouttime(tp));
		}
		else {	/* debugging */
			(asy->asy_stats->asyxmttorun)++;
		}
	}
	else {	/* debugging */
		(asy->asy_stats->asystartenb)++;
	}

	/*
	 * Now that's out of the way, wake any sleepers
	 */
	if (tp->t_outq.c_cc <= tp->t_lowat) {
		if (tp->t_state & TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t) &tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}

	/*
	 * If we're still not busy, check to see if we need to delay.  If
	 * so, do it now.
	 */
	if ((tp->t_state & TS_BUSY) == 0) {
		if (asy->asy_flags & ASYF_DODELAY) {
			timeout(ttrstrt, (caddr_t)tp,
			    (asy->asy_delayc & 0177) + 6);
			tp->t_state |= TS_TIMEOUT;
			asy->asy_flags &= ~ASYF_DODELAY;
		}
		/* Just return, nothing more to do */
		(void) splx(s);
		return;
	}

	/* this code is nice for performance, but doesnt handle flow
	 * control conditions when we output these characters
	 * in the interrupt routine.  Software flow would be
	 * easy to add (a check for TTSTOP), but hardware flow
	 * would have to be inserted in-line (???), ala DCDMAGIC,
	 * which means this code is broken.
	 */
#if 0
	/*
	 * If we're still here we have written some characters and
	 * busied the port.  `c' still contains the last character
	 * we got.  If the last character wasn't a delay, or a -1,
	 * there still might be more to get.  If so, set up the
	 * pointers for the transmitter interrupt.
	 *
	 * XXX the reno ndqb has no way to detect delays.  It should
	 * return -1 if the next character is a delay, the character
	 * count otherwise.  The code is written this way.
	 */
	if (c != -1 && (asy->asy_flags & ASYF_DODELAY) == 0) {
		if ((n = ndqb(&tp->t_outq, 0)) > 0) {
			asy->asy_firstc = asy->asy_nextc = tp->t_outq.c_cf;
			asy->asy_endc = tp->t_outq.c_cf + n;
		}
	}
#endif

	/*
	 * Done, I hope.
	 */
	(void) splx(s);
}
#endif	/* !ASY_TXEVENT */

/*
 * Stop output on a line.  This is called both when we're stopping and
 * when we've been flushed.  In the latter case we have to remember this
 * so we don't ndflush() an output queue which has gone away.
 */
asystop(tp)
	register struct tty *tp;
{
	register struct asysoftc *asy;
	register int s;

	s = spl_asy();
	if (tp->t_state & TS_BUSY) {
		asy = (struct asysoftc *)tp->t_addr;
		if ((tp->t_state & TS_TTSTOP) == 0)
			tp->t_state |= TS_FLUSH;
	}
	(void) splx(s);
}


asyselect(dev, rw)
	dev_t dev;
	int rw;
{
	return ttselect(dev, rw);
}

#ifdef ASY_EVENT

#if defined(ASY_TXEVENT)
/* hook for kernel upper level code to kick off output in asy */
asystart(tp)
    register struct tty *tp;
{
    register struct asysoftc *asy = (struct asysoftc *)tp->t_addr;
    register struct asydevice *asyaddr = asy->asyaddr;
    register int c, num_to_output;
    int s = spl_asy();

    /*
     * if it's currently active, or delaying, or stopped for one
     * reason or another, or we actively have transmit data
     * queued up, then there is nothing to do right now.
     */
    if ((tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP)) ||
	    (asy->asy_flags & (ASYF_CTSSTOP|ASYF_DCDTMO)) ||
	    (asy->asy_xmit_ring_cnt) ||
	    (asy->asy_softflags & ASYS_XMIT)) {
	goto sched;
    }

    asy_xxfer(asy);	/* transfer characters down */
    asy_xproc(asy);	/* output characters to the uart */

sched:;

    ASYSETSOFT(ASYS_XMIT, asy, tp);
    (void) splx(s);
}

/* output to a uart */
static
asy_xproc(asy)
    register struct asysoftc *asy;
{
    register struct tty *tp = asy->asy_tty;
    register struct asydevice *asyaddr = asy->asyaddr;
    register u_char *ring_ptr;
    register int num_to_output;
    int s;

    /*
     * Must hold interrupts to prevent state of the tp
     * from changing
     */
    s = spl_asy();

    /*
     * if it's currently active, or delaying, or stopped for one
     * reason or another, nothing to do.
     */
    if ((tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP)) ||
	    (asy->asy_flags & (ASYF_CTSSTOP|ASYF_DCDTMO))) {
/* 	(void) splx(s); */
	goto sched;
    }

    /* determine how many characters to put into the transmitter register */
    num_to_output = asy->asy_xmitlevel;
    if (asy->asy_xmit_ring_cnt < num_to_output)
	num_to_output = asy->asy_xmit_ring_cnt;
    if (!num_to_output) {
	goto sched;
    }

    (void) splhigh();		/* XXX !!! */

    /* signal that the transmitter is (about to be) busy now */
    tp->t_state |= TS_BUSY;

    /* output the characters */
    /* XXX: possibly FIXME: we do nothing with delays here. */
    asy->asy_xmit_ring_cnt -= num_to_output;
    ring_ptr = asy->asy_xmit_ring_take_ptr;
    do {
	do {
	    IOOUT(&asyaddr->txb, *ring_ptr);
	    if (++ring_ptr == &asy->asy_txbuf[ASYTXBUFSIZE])
		break;
	} while (--num_to_output);
	if (!num_to_output)
	    break;
	ring_ptr = &asy->asy_txbuf[0];
    } while (--num_to_output);

    asy->asy_xmit_ring_take_ptr = ring_ptr;

    /*
     * If we are busy, schedule a timeout to check the
     * holding register (and clear TS_BUSY?), b/c we 
     * can miss interrupts at high speeds.
     */
    /* is a timeout already running? */
    if ((asy->asy_flags & ASYF_WBUSY) == 0) {
	asy->asy_flags |= ASYF_WBUSY;
	(asy->asy_stats->asyxmttoset)++;
	timeout(asywbusy, (caddr_t)tp, asycouttime(tp));
    }
    else {	/* debugging */
	(asy->asy_stats->asyxmttorun)++;
    }

    /* schedule an asy_xxfer() if there are more characters to
     * transfer into the trasmitter ring buffer.
     */
sched:;
    if (!(asy->asy_softflags & ASYS_XMIT) &&
	    (asy->asy_xmit_ring_size > asy->asy_xmit_ring_cnt) && 
	    tp->t_outq.c_cc) {
	ASYSETSOFT(ASYS_XMIT, asy, tp);
    }
    (void) splx(s);
}

/* transfer characters down into asy */
static int
asy_xxfer(asy)
    struct asysoftc *asy;
{
    register struct tty *tp = asy->asy_tty;
    register u_int xmit_ring_cnt, num_to_xfer;
    u_char *cp;
    int n, s;

    s = spl_asy();
    if (asy->asy_flags & ASYF_XXFER)	/* already being serviced ? */
	return (1);			/* signal for another softasy () */
    asy->asy_flags |= ASYF_XXFER;	/* serialization start */
    splx(s);

    for (;;) {
	/*
	 * check if the output queue is emtpy.  If so, kick the line output
	 * routine (note: termios l_start does nothing but call o_proc(),
	 * which is asystart.  So we dont bother calling it)
	 */
	if (!tp->t_outq.c_cc) {
	    if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	    if (!tp->t_outq.c_cc) {
		goto wake_up;
	    }
	}

	/* return if the transmitter ring buffer is full. */
	if (asy->asy_xmit_ring_size <= (xmit_ring_cnt=asy->asy_xmit_ring_cnt)){
	    (asy->asy_stats->asystartenb)++;	/* XXX */
	    goto wake_up;
	}

	/* set maximum limit */
	s = spl_asy();		/* paranoid */
	num_to_xfer = asy->asy_xmit_ring_size - xmit_ring_cnt;

	/* determine how many characters are available at this time */
	if (tp->t_outq.c_cc < num_to_xfer) 
	    num_to_xfer = tp->t_outq.c_cc;
	/* (XXX: is this needed?) limit by number of contiguous characters */
	if ((n = ndqb(&tp->t_outq, 0)) < num_to_xfer)
	    num_to_xfer = n;
	if ((u_int) (&asy->asy_txbuf[ASYTXBUFSIZE] - asy->asy_xmit_ring_put_ptr)
		< num_to_xfer)
	    num_to_xfer = (u_int) (&asy->asy_txbuf[ASYTXBUFSIZE] - 
				    asy->asy_xmit_ring_put_ptr);
	splx (s);

        if (!num_to_xfer) {	 /* invalid count, shouldn't happen */
#ifdef ASY_DEBUG
	    printf ("asy_xxfer: as%c%d: nothing to xfer. %d:%d:%d:%d\n",
		asy->asy_type, asy->asy_unit,
		asy->asy_xmit_ring_size - xmit_ring_cnt,
		tp->t_outq.c_cc,
		n,
		(u_int) (&asy->asy_txbuf[ASYTXBUFSIZE] - 
			    asy->asy_xmit_ring_put_ptr));
#endif
	    goto wake_up;
	}
 
	cp = (char *) asy->asy_xmit_ring_put_ptr;
	n = q_to_b (&tp->t_outq, cp, num_to_xfer);	/* transfer... */

	s = spl_asy();		/* paranoid */
	asy->asy_xmit_ring_put_ptr += n;
	if (asy->asy_xmit_ring_put_ptr == &asy->asy_txbuf[ASYTXBUFSIZE])
	    asy->asy_xmit_ring_put_ptr = &asy->asy_txbuf[0];
	asy->asy_xmit_ring_cnt += n;
	splx(s);

	/* if we didn't xfer as many characters as we wanted, return */
	if (n != num_to_xfer)
	    goto wake_up;
    }

wake_up:;
    /* wake any sleepers */
    if (tp->t_outq.c_cc <= tp->t_lowat) {
	    if (tp->t_state & TS_ASLEEP) {
		    tp->t_state &= ~TS_ASLEEP;
		    wakeup((caddr_t) &tp->t_outq);
	    }
	    if (tp->t_wsel) {
		    selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
		    tp->t_wsel = 0;
		    tp->t_state &= ~TS_WCOLL;
	    }
    }

    s = spl_asy();
    asy->asy_flags &= ~ASYF_XXFER;	/* serialization clear */
    splx(s);
    return (0);
}
#endif	/* ASY_TXEVENT */

/*
 * asy_event():
 * 	Scan all asy structures looking for queue'd up work to do.
 */
static void
asy_event ()
{
    register struct asysoftc *asy;
    register struct tty *tp;
    int s, idle = 1;

    s = spl0();		/* allow all interrupts */

    /* loop thru all asy structures */
    for (asy = asy_list_head; asy; asy = asy -> asy_next_list) {

loop3:;
#ifdef ASY_DEBUG
	/* somewhere we are overruning a buffer boundry. (I think).
	 * we'll try to trap there here first before adding asserts
	 * in the xfer routines 
	 */
	ASY_ASSERT(asy, asy->asy_xmit_ring_cnt <= ASYTXBUFSIZE);
	ASY_ASSERT(asy, asy->asy_xmit_ring_cnt >= 0);
	ASY_ASSERT(asy, asy->asy_xmit_ring_put_ptr >= &asy->asy_txbuf[0]);
	ASY_ASSERT(asy, asy->asy_xmit_ring_put_ptr < &asy->asy_txbuf[ASYTXBUFSIZE]);
	ASY_ASSERT(asy, asy->asy_xmit_ring_take_ptr >= &asy->asy_txbuf[0]);
	ASY_ASSERT(asy, asy->asy_xmit_ring_take_ptr < &asy->asy_txbuf[ASYTXBUFSIZE]);

	ASY_ASSERT(asy, asy->asy_recv_ring_cnt <= ASYRXBUFSIZE);
	ASY_ASSERT(asy, asy->asy_recv_ring_cnt >= 0);
	ASY_ASSERT(asy, asy->asy_recv_ring_put_ptr >= &asy->asy_rxbuf[0]);
	ASY_ASSERT(asy, asy->asy_recv_ring_put_ptr < &asy->asy_rxbuf[ASYRXBUFSIZE]);
	ASY_ASSERT(asy, asy->asy_recv_ring_take_ptr >= &asy->asy_rxbuf[0]);
	ASY_ASSERT(asy, asy->asy_recv_ring_take_ptr < &asy->asy_rxbuf[ASYRXBUFSIZE]);
#endif
	if (!asy->asy_softflags) {	/* nope, nothing here */
	    if (asy = asy -> asy_next_list)
		goto loop3;
	    break;
	}

	/* we have something to do */
	idle = 0;
	tp = asy->asy_tty;

	if (asy->asy_softflags & ASYS_RECV) {

	    (void) spl_asy();	/* paranoid */
	    asy->asy_softflags &= ~ASYS_RECV;
	    (void) spl0();

	    /*
	     * Transfer buffered characters up.
	     * Schedule another soft interupt if
	     * we didnt transfer our entire part of
	     * the receive buffer (ie, we wrapped the
	     * buffer) 
	     */
	    if (asy_rxfer (tp, asy)) {
		(void) spl_asy();	/* paranoid */
		asy->asy_softflags |= ASYS_RECV;
		(void) spl0();
	    }

	    if (asy->asy_flags & ASYF_OVERFLOW) {
		asy->asy_flags &= ~ASYF_OVERFLOW;
		log(LOG_WARNING, "as%c%d: rxbuf overrun",
				asy->asy_type, asy->asy_unit);
	    }
	    /*
	     * turn back on RTS if we crossed the low water
	     * mark, but only if we arent being blocked upstream
	     */
	    if ((asy->asy_flags & ASYF_RTSCTL)
		    && (asy->asy_mcr & MCR_RTS) == 0
		    && !(tp->t_state & TS_TBLOCK)
		    && asy->asy_recv_ring_cnt < ASYRXLOWATER) {
		asy->asy_mcr |= MCR_RTS;
		IOOUT(&(asy->asyaddr->mcr), asy->asy_mcr);
	    }
	}
	if (asy->asy_softflags & ASYS_XMIT) {
	    (void) spl_asy();	/* paranoid */
	    asy->asy_softflags &= ~ASYS_XMIT;
	    (void) spl0();
#if defined(ASY_TXEVENT)
	    /* Do we have carrier? */
	    if ((tp->t_state & TS_CARR_ON) || (tp->t_cflag & CLOCAL)) {
		if (asy_xxfer(asy)) {	/* transfer characters down */
		    (void) spl_asy();	/* paranoid */
		    asy->asy_softflags |= ASYS_XMIT;
		    (void) spl0();
		}
		asy_xproc(asy);	/* output characters to the uart */
	    }
	    else { 			/* else punt and drain characters */
		ttyflush(tp, FWRITE);
	    }
#endif
	}
    }

    /*
     * If idle is zero, then we processed at least 1 event.
     * Chances are we will have something to do again in a short while
     * from now, so just re-sched the event.
     * We only completely drop out of this routine if 
     * we make a complete pass of all asy struct's and had nothing to do.
     */
    if (!idle) {
	(void) timeout (asy_event, (caddr_t) 0, (EVENT_TIME) * (HZ) / 1000);
    }
    else
	event_scheduled = 0;
    (void) splx(s);
}
#endif /* ASY_EVENT */

#ifdef ASY_DEBUG
assertfail(asy, str1, str2, line)
struct asysoftc *asy;
char *str1, *str2;
int line;
{
    printf ("ASSERT FAIL: as%c%d: %s FILE: %s LINE: %d\n", 
	    asy->asy_type, asy->asy_unit,
	    str1, str2, line);
    DELAY(10000);	/* all hell is about to break loose... */
}
#endif

#endif /* NASY */
