
/*
 * The receiver feeds into an intermediate buffer which is unloaded
 * at software interrupt time.  This is the size of the buffer.  We
 * also include a buffer full level which, when reached, will cause
 * RTS to be de-asserted.  The latter is done sloppy, so the margin
 * should be left a little large.
 *
 * XXX: should allocate space for this dynamically.
 */
#ifndef ASY_EVENT
#define	ASYRXBUFSIZE	250
#define ASYRXLOWATER	125
#define ASYRXHIWATER	200
#define ASYRXSTATDIV	10
#else
    /* time-to-tune: bump up the values for asy_event() */
    /* XXX: testing (w/16550 chips) shows these could be cut in half */
#define	ASYRXBUFSIZE	1000
#define ASYRXLOWATER	500
#define ASYRXHIWATER	800
#define ASYRXSTATDIV	40
#endif

#define ASYTXBUFSIZE	1000

/* put a character in the receive ring buffer. */
#define	ASYPUTC(c, asy) \
    do { \
	if (!((asy)->asy_flags & ASYF_NOINPUT)) { \
	    if ((asy)->asy_recv_ring_cnt < ASYRXBUFSIZE) { \
		(asy)->asy_recv_ring_cnt++; \
		*((asy)->asy_recv_ring_put_ptr) = (c); \
		if (++((asy)->asy_recv_ring_put_ptr) == \
			&(asy)->asy_rxbuf[ASYRXBUFSIZE]) \
		    (asy)->asy_recv_ring_put_ptr = &((asy)->asy_rxbuf[0]); \
	    } \
	    else {\
		((asy)->asy_stats->asyrcvbufoflow)++; \
		(asy)->asy_flags |= ASYF_OVERFLOW; \
	    } \
	} \
    } while (0)

#define	ASYISFULL(asy) \
    ((asy)->asy_recv_ring_cnt >= ASYRXHIWATER)

/* NOTE: we dont support software flow in at this level.
 *	If we aren't configured for hardware flow, and
 *	the receiver is pumping fast, end result is that
 *	we chuck some characters.
 */
#define	ASYRTSOFF(asy, asyaddr) \
    do { \
	    ((asy)->asy_stats->asyrcvhiwater)++; \
	    if ((asy)->asy_flags & ASYF_RTSCTL) { \
		(asy)->asy_mcr &= ~MCR_RTS; \
		IOOUT(&(asyaddr)->mcr, (asy)->asy_mcr); \
	    } \
    } while (0)

/*
 * asy software state.  We run the both the transmitter and receiver
 * interrupts in sort of a pseudo-DMA mode to try to cut the overhead
 * at interrupt time.  Calls to asystart() are deferred to a software
 * interrupt routine.  This supports that state, as well as various
 * bits of software state which the tty struct doesn't seem to have room for.
 */
struct asysoftc {
	struct asydevice *asyaddr;	/* hardware address */
	u_char *asy_softCAR;		/* softCAR for this controller */
	struct asystats *asy_stats;	/* stats structure for device */
	u_char asy_hardware;		/* hardware flags */
#define	ASYH_ISCOM	0x01		/* is a PC-style card */
#define	ASYH_HASFIFO	0x02		/* has FIFO buffered chip */
	u_short asy_flags;		/* various soft flags */
#define	ASYF_CLOSING	0x01		/* port is closing */
#define	ASYF_CTSSTOP	0x02		/* stopped by CTS */
#define	ASYF_DODELAY	0x04		/* next character is a delay */
#define	ASYF_OVERFLOW	0x08		/* overflowed the rx buffer */
#define	ASYF_RTSCTL	0x10		/* use RTS to control input */
#define	ASYF_FASTINT	0x20		/* give chars to l_rint now */
#define	ASYF_NOINPUT	0x40		/* ignore all input */
#define	ASYF_DCDTMO	0x80		/* DCD time out routine called */
#define ASYF_RXFER	0x100		/* asy_rxfer serialization */
#define ASYF_WBUSY	0x200		/* wait-for-busy-to-clear */
#define	ASYF_FASTTXINT	0x400		/* transmit chars right now */
#define ASYF_XXFER	0x800		/* asy_xxfer serialization */
	u_char asy_msr;			/* soft copy of msr */
	u_char asy_xmitlevel;		/* number of chars to xmit at once */
	u_char asy_softflags;		/* set to indicate soft int needed */
#define	ASYS_XMIT	0x01		/* needs transmitter service */
#define	ASYS_RECV	0x02		/* needs receiver service */
	char asy_type;			/* 'y', 'q' or 'x' */
	u_char asy_unit;		/* unit for this device */
	u_char asy_port;		/* port mask bit for this unit */
	u_char asy_delayc;		/* delay character */
	u_char asy_mcr;			/* soft copy of mcr */

	u_int asy_recv_ring_cnt;	/* receiver ring buffer counter */
	u_int *asy_recv_ring_put_ptr;	/* recv ring put ptr */
	u_int *asy_recv_ring_take_ptr;	/* recv ring take ptr */
#ifdef ASY_RXMALLOC
	u_int *asy_rxbuf;		/* input character buffer */
#else
	u_int asy_rxbuf[ASYRXBUFSIZE];	/* input character buffer */
#endif

/* #ifdef ASY_TXEVENT */
	u_int asy_xmit_ring_size;	/* transmitter ring buffer size */
	u_int asy_xmit_ring_cnt;	/* transmitter ring buffer counter */
	u_char *asy_xmit_ring_put_ptr;	/* xmit ring put ptr */
	u_char *asy_xmit_ring_take_ptr;	/* xmit ring take ptr */
#ifdef ASY_TXMALLOC
	u_char *asy_txbuf;		/* output character buffer */
#else
	u_char asy_txbuf[ASYTXBUFSIZE];	/* output character buffer */
#endif
/* #endif */

	struct tty *asy_tty;		/* saved for the interrupt routine */

/* #ifdef MULTI_BOARD */
	struct asysoftc *asy_next_uart;	/* IRQ chain */
/* #endif */

/* #ifdef ASY_EVENT */
	struct asysoftc *asy_next_list;	/* asy list for asy_event() */
/* #endif */
};

#define	ASYDEFXMITNOFIFO	1	/* with no fifo, no extra chars */
#define	ASYDEFXMITFIFO		10	/* with a fifo, 10 at once by default */

/*
 * Per-device-type stat counter structure  XXX DEBUG
 */
struct asystats {
	int asybogons;		/* interrupts that weren't */
	int asyrcvints;		/* receive interrupts */
	int asygotbusy;		/* rcv ints with more than asybusycnt chars */
	int asychartmo;		/* character time out interupts */
	int asyxmtnotbusy;	/* xmit interrupt with no TS_BUSY */
	int asyoverrun;		/* card complaining about overruns */
#define	MAXRCVCNT	16
	int asyrcvcnt[MAXRCVCNT+1];	/* mapping of receive char count */
	int asyhotint;		/* looping on a hot card */
#define MAXHOTINT	10	/* conservative */
	int asymaxhotint;	/* card was too hot! */
	int asyrcvhiwater;	/* crossed the receive hi water mark */
	int asyrcvbufoflow;	/* overflowed our receive buffer */
	int asyxmtint;		/* transmit complete interrupt */
	int asyxmttimeout;	/* transmit busy timeout kicked */
	int asyxmttoset;	/* transmit busy timeout set */
	int asyxmttoclr;	/* transmit busy timeout cleared */
	int asystartnb;		/* in asystart, TS_BUSY set, but not busy */
	int asyxmttobusy;	/* transmit timeout kicked, but still busy */
#define	RCVXBUCKETS	(ASYRXBUFSIZE/ASYRXSTATDIV)
	int asyrcvxcnt[RCVXBUCKETS+1];	/* mapping of receive char xfer count */
	int asyxmtxbusy;	/* xmit done interrupt kicked, but still busy */
	int asyxmttotsbusy;	/* transmit timeout kicked, AND ts_busy */
	int asyxmttorun;	/* in asystart(), but timer already running */
	int asystartenb;	/* end of asystart, we didnt set TS_BUSY */
};

