/*
 * Written by Julian Elischer (julian@tfs.com)
 * for TRW Financial Systems for use under the MACH(2.5) operating system.
 *
 * TRW Financial Systems, in accordance with their agreement with Carnegie
 * Mellon University, makes this software available to CMU to distribute
 * or use in any manner that they see fit as long as this message is kept with
 * the software. For this reason TFS also grants any other persons or
 * organisations permission to use or modify this software.
 *
 * TFS supplies this software to be publicly redistributed
 * on the understanding that TFS is not responsible for the correct
 * functioning of this software in any circumstances.
 *
 */

/*
 * Ported to run under 4.3BSD Reno by Mark Dapoz (md@bsc.no) April 1993
 */

/* RCS header and log section
 * $Log: cdio.h,v $
 * Revision 1.1  1993/04/03  19:08:51  md
 * Initial revision
 *
 *
 * Revision 1.1  1992/09/26  22:17:19  julian
 * Initial revision
 *
 */

/* Shared between kernel & process */

struct cd_toc_entry {
	u_char	:8;
	u_char	addr_type:4;
	u_char	control:4;
	u_char  track;
	u_char	:8;
	u_char	addr[4];
};

struct cd_sub_channel_header {
	u_char	:8;   
	u_char	audio_status; 
#define CD_AS_AUDIO_INVALID        0x00
#define CD_AS_PLAY_IN_PROGRESS     0x11
#define CD_AS_PLAY_PAUSED          0x12
#define CD_AS_PLAY_COMPLETED       0x13
#define CD_AS_PLAY_ERROR           0x14
#define CD_AS_NO_STATUS            0x15
	u_char	data_len[2];
};

struct cd_sub_channel_position_data {
	u_char	data_format;
	u_char	addr_type:4;
	u_char	control:4;
	u_char	track_number;
	u_char	index_number;
	u_char	absaddr[4];
	u_char	reladdr[4];
};

struct cd_sub_channel_media_catalog {
        u_char  data_format;
        u_char  :8;
        u_char  :8;
        u_char  :8;
        u_char  mc_valid:1;
        u_char  :7;
        u_char  mc_number[15]; 
};

struct cd_sub_channel_track_info {
        u_char  data_format;
        u_char  :8;
        u_char  track_number;
        u_char  :8;
        u_char  ti_valid:1;   
        u_char  :7;
        u_char  ti_number[15]; 
};

struct cd_sub_channel_subq_data {
	u_char	data_format;
	u_char	addr_type:4;
	u_char	control:4;
	u_char	track_number;
	u_char	index_number;
	u_char	absaddr[4];
	u_char	reladdr[4];
        u_char  mc_valid:1;
        u_char  :7;
        u_char  mc_number[15]; 
        u_char  ti_valid:1;   
        u_char  :7;
        u_char  ti_number[15]; 
};

struct cd_sub_channel_info {
	struct cd_sub_channel_header header;
	union {
		struct cd_sub_channel_position_data position;
		struct cd_sub_channel_media_catalog media_catalog;
		struct cd_sub_channel_track_info track_info;	
		struct cd_sub_channel_subq_data subq_data;	
	} what;
};

/***************************************************************\
* Ioctls for the CD drive					*
\***************************************************************/
struct ioc_play_track
{
	u_char	start_track;
	u_char	start_index;
	u_char	end_track;
	u_char	end_index;
};

#define	CDIOCPLAYTRACKS	_IOW('C',1,struct ioc_play_track)
struct ioc_play_blocks
{
	int	blk;
	int	len;
};
#define	CDIOCPLAYBLOCKS	_IOW('C',2,struct ioc_play_blocks)

struct ioc_read_subchannel {
	u_char address_format;
#define CD_LBA_FORMAT	1
#define CD_MSF_FORMAT	2
	u_char data_format;
#define CD_SUBQ_DATA		0
#define CD_CURRENT_POSITION	1
#define CD_MEDIA_CATALOG	2
#define CD_TRACK_INFO		3
	u_char track;
	int	data_len;
	struct  cd_sub_channel_info *data;
};
#define CDIOCREADSUBCHANNEL _IOWR('C', 3 , struct ioc_read_subchannel )


struct ioc_toc_header {
	u_short len;
	u_char  starting_track;
	u_char  ending_track;
};

#define CDIOREADTOCHEADER _IOR('C',4,struct ioc_toc_header)

struct ioc_read_toc_entry {
	u_char	address_format;
	u_char	starting_track;
	u_short	data_len;
	struct  cd_toc_entry *data;
};
#define CDIOREADTOCENTRYS _IOWR('C',5,struct ioc_read_toc_entry)

struct	ioc_patch
{
	u_char	patch[4];	/* one for each channel */
};
#define	CDIOCSETPATCH	_IOW('C',9,struct ioc_patch)
struct	ioc_vol
{
	u_char	vol[4];	/* one for each channel */
};
#define	CDIOCGETVOL	_IOR('C',10,struct ioc_vol)
#define	CDIOCSETVOL	_IOW('C',11,struct ioc_vol)
#define	CDIOCSETMONO	_IO('C',12)
#define	CDIOCSETSTERIO	_IO('C',13)
#define	CDIOCSETMUTE	_IO('C',14)
#define	CDIOCSETLEFT	_IO('C',15)
#define	CDIOCSETRIGHT	_IO('C',16)
#define	CDIOCSETDEBUG	_IO('C',17)
#define	CDIOCCLRDEBUG	_IO('C',18)
#define	CDIOCPAUSE	_IO('C',19)
#define	CDIOCRESUME	_IO('C',20)
#define	CDIOCRESET	_IO('C',21)
#define	CDIOCSTART	_IO('C',22)
#define	CDIOCSTOP	_IO('C',23)
#define	CDIOCEJECT	_IO('C',24)


#define	CDIOCSMODESELECT _IO('C',25)
#define	CDIOCSMODESENSE	_IO('C',26)
