#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidscsi = "$Header: /usr/src/sys/rtio/RCS/scsi.h,v 1.5 1994/03/25 09:48:58 md Exp $";
#endif
/*
 * Copyright (c) 1988, Christer Bernerus, Chalmers University of Technology,
 *                     Gothenburg, SWEDEN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright 
 * notice and this paragraph are  duplicated in all such forms 
 * and that any documentation, advertising materials,
 * and other materials related to such distribution
 * and use acknowledge that the software was developed
 * at Chalmers University of Technology, SWEDEN.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * COMMON DEFINITIONS FOR SCSI AS OF ANSI X2.131-1986
 */

/* SCSI	COMMANDS		     COMMON/DASD    SEQ     PRT     CD */
#define	SC0_TEST_UNIT_READY		    0x00
#define	SC0_REZERO_UNIT			    0x01
#define	SC0_REWIND				    0x01
#define	SC0_REQUEST_SENSE		    0x03
#define	SC0_FORMAT_UNIT			    0x04
#define	SC0_FORMAT					    0x04
#define	SC0_READ_BLOCK_LIMITS				    0x05
#define	SC0_REASSIGN_BLOCKS		    0x07
#define	SC0_READ			    0x08
#define	SC0_WRITE			    0x0A
#define	SC0_PRINT					    0x0A
#define	SC0_SEEK			    0x0B
#define	SC0_TRACK_SELECT			    0x0B
#define	SC0_SLEW_AND_PRINT				    0x0B
#define	SC0_READ_REVERSE			    0x0F
#define	SC0_WRITE_FILEMARKS			    0x10
#define	SC0_FLUSH_BUFFER				    0x10
#define	SC0_SPACE				    0x11
#define	SC0_INQUIRY			    0x12
#define	SC0_VERIFY				    0x13
#define	SC0_RECOVER_BUFFERED_DATA		    0x14
#define	SC0_MODE_SELECT			    0x15
#define	SC0_RESERVE			    0x16
#define	SC0_RESERVE_UNIT			    0x16
#define	SC0_RELEASE			    0x17
#define	SC0_RELEASE_UNIT			    0x17
#define	SC0_COPY			    0x18
#define	SC0_ERASE				    0x19
#define	SC0_MODE_SENSE			    0x1A
#define	SC0_START_STOP_UNIT		    0x1B
#define	SC0_LOAD_UNLOAD				    0x1B
#define	SC0_STOP_PRINT					    0x1B
#define	SC0_RECEIVE_DIAGNOSTIC_RESULTS	    0x1C
#define	SC0_SEND_DIAGNOSTIC		    0x1D
#define	SC0_PREVENT_ALLOW_MEDIUM_REMOVAL    0x1E
#define	SC1_READ_CAPACITY		    0x25
#define	SC1_READ			    0x28
#define	SC1_WRITE			    0x2A
#define	SC1_SEEK			    0x2B
#define	SC1_WRITE_AND_VERIFY		    0x2E
#define	SC1_VERIFY			    0x2F
#define	SC1_SEARCH_DATA_HIGH		    0x30
#define	SC1_SEARCH_DATA_EQUAL		    0x31
#define	SC1_SEARCH_DATA_LOW		    0x32
#define	SC1_SET_LIMITS			    0x33
#define	SC1_COMPARE			    0x39
#define	SC1_COPY_AND_VERIFY		    0x3A
#define	SC2_PAUSE_RESUME_UNIT				            0x4B
#define	SC2_PLAY_AUDIO						    0x45
#define	SC2_PLAY_AUDIO_MSF					    0x47
#define	SC2_PLAY_TRACK_INDEX					    0x48
#define	SC2_PLAY_TRACK_RELATIVE					    0x49
#define	SC2_READ_SUBCHANNEL					    0x42
#define	SC2_READ_TOC						    0x43
#define	SC2_READ_HEADER						    0x44
#define	SC2_TOSHIBA_EJECT					    0xC4
#define	SC2_TOSHIBA_READ_DISC_INFORMATION			    0xC7

/* Fundamental SCSI constants */
#define MAXSCSITARGETS	8
#define MAXSCSILUNS	8

extern int scsigrplen[8];

#define SCSICMDGRP(op) (op>>5&7)
#define SCSICMDLEN(x) (scsigrplen[SCSICMDGRP(x)])

typedef struct _int24 { u_char _val[3]; } int24;
typedef struct _int21 { u_char :3; u_char _lba2:5; u_char lba1, lba0; } int21;

/* CDB control byte definition */

typedef struct _sccb {
	u_char	sc_vu1:1;
	u_char	sc_vu0:1;
	u_char	sc_resvd:4;
	u_char	sc_flag:1;
	u_char	sc_link:1;
} sccb;

struct scsi_cdb6
{
	u_char  sc_op;
	u_char	sc_lun:3;
	u_char	sc_lbaMSB:5;
	u_char  sc_lbarest[2];
	u_char	sc_xflen[1];
	sccb	sc_control;
};

struct scsi_cdb10
{
	u_char	sc_op;
	u_char  sc_lun:3;
        u_char  sc_resvd1:4;
        u_char  sc_reladr:1;
        u_char  sc_lba[4];
	u_char	sc_resvd2;
	u_char	sc_xflen[2];
	sccb	sc_control;
};

struct scsi_cdb12
{
	u_char	sc_op;
	u_char   sc_lun:3;
        u_char   sc_resvd1:4;
        u_char   sc_reladr:1;
        u_char  sc_lba[4];
	u_char	sc_resvd2;
	u_char	sc_resvd3;
	u_char	sc_resvd4;
	u_char	sc_xflen[2];
	sccb	sc_control;
};

union scsi_cdb
{
	struct scsi_cdb6 cdb_6;
	struct scsi_cdb10 cdb_10;
	struct scsi_cdb12 cdb_12;
};

struct scsi_bd
{
	u_char	sbd_density;	/* Density code */
	u_long	sbd_nblocks:24;	/* No of blocks */
	u_char	sbd_resvd1;	/* Reserved */
	u_long	sbd_blklen:24;	/* Block length */
};

struct scsi_modeselect
{
	u_char	sms_resvd1;	/* Reserved */
	u_char	sms_resvd2;	/* Reserved */
	u_char	sms_resvd3:1;	/* Reserved */
	u_char	sms_bufmode:3;	/* Buffered mode code */
	u_char	sms_speed:4;	/* Speed code */
	u_char	sms_bdl;	/* Block descriptor length */
	struct	scsi_bd	sms_bdarr[1];	/* Block descriptor 1 */
	/* Could be more block descriptors here */
};
#define SIZEOF_MODESELECT	12	/* Since the compiler can't figure it out OK */
#define SIZEOF_MODESENSE	12	/* Since the compiler can't figure it out OK */

struct scsi_modesense
{
	u_char	sm_length;	/* Sense data length */
	u_char	sm_mtype;	/* Medium type */
	u_char	sm_wp:1;	/* Write-protect */
	u_char  sm_bufmode:3;	/* Buffered mode */
	u_char	sm_speed:4;	/* Speed code */
	u_char	sm_bdl;		/* Block descriptor length */
	struct	scsi_bd sm_bdarr[1];	/* Block descriptor 1 */
	/* Could be more block descriptors here */
};

struct scsi_msiobuf
{
        /* The size shouldn't be greater than 127 !!!!! */
	u_char msio[127];	/* Mode sense I/O buffer, non structured */
};

struct scsi_mspghd		/* Mode sense page header */
{
	u_char pghd_ps:1;	/* parameter savable */
	u_char pghd_rsrv:1;	/* Reserved */
	u_char pghd_pcode:6;	/* Page code */
	u_char pghd_plen;	/* Page length */
} pghd;

#define SCMS_CURRENT 	0x00		/* Report current values */
#define SCMS_CHANGEABLE	0x40		/* Report changeable values	*/
#define SCMS_DEFAULT	0x80		/* Report default values	*/
#define SCMS_SAVED	0xE0		/* Report saved values		*/

#define SCMS_ERP	0x01		/* Error recovery page		*/
#define SCMS_COP	0x02		/* Disconnect/Reconnect page	*/
#define SCMS_DAF	0x03		/* Direct access format page	*/
#define SCMS_RDG	0x04		/* Rigid disk geometries page	*/
#define SCMS_CDR	0x0D		/* CD ROM parameters page	*/
#define SCMS_ACP	0x0E		/* CD Audio control page	*/
#define SCMS_SCP	0x20		/* CD Speed control page	*/
#define SCMS_CSH        0x38            /* HW Wren Cache control page   */
#define SCMS_ALL	0x3F		/* All pages			*/

struct scsi_mserppage		/* Error recovery page	(1)		*/
{
	u_char	erp_ps:1;	/* parameter savable 	*/
	u_char	erp_rsrv:1;	/* reserved		*/
	u_char	erp_pcode:6;	/* Page code		*/

	u_char	erp_plen;	/* Page length		*/

	u_char	erp_awre:1;	/* Automatic write reallocation enable	*/
	u_char	erp_arre:1;	/* Automatic read reallocation enable	*/
	u_char	erp_tb:1;	/* Transfer block with error		*/
	u_char	erp_rc:1;	/* Read continous			*/
	u_char	erp_eec:1;	/* Enable early correction		*/
	u_char	erp_per:1;	/* Post error				*/
	u_char	erp_dte:1;	/* Disable transfer on error		*/
	u_char	erp_dcr:1;	/* Disable correction			*/

	u_char	erp_rrtcnt;	/* Read retry count			*/

	u_char	erp_cspan;	/* Correction span			*/

	u_char	erp_hoffset;	/* Head offset count			*/

	u_char	erp_dsoffset;	/* Data strobe offset count		*/

	u_char	erp_rtl;	/* Recovery time limit			*/

	u_char	erp_wrtcnt;	/* Write retry count			*/

	u_char	erp_resvd[3];	/* Reserved 				*/
};

struct scsi_msconnpage		/* Disconnect/Reconnect page  (2)	*/
{
	u_char	cop_ps:1;	/* parameter savable 	*/
	u_char	cop_rsrv:1;	/* reserved		*/
	u_char	cop_pcode:6;	/* Page code		*/

	u_char	cop_plen;	/* Page length		*/

	u_char	cop_bfr;	/* Buffer full ratio	*/

	u_char	cop_ber;	/* Buffer empty ratio	*/

	u_short	cop_bil;	/* Bus inactivity limit	*/

	u_short	cop_dtl;	/* Disconnect time limit	*/

	u_short	cop_ctl;	/* Connect time limit	*/

	u_char	cop_resvd[6];	/* Reserved		*/
};
struct scsi_msdadfpage		/* Direct access device fmt parm page (3) */
{
	u_char	daf_ps:1;	/* parameter savable 	*/
	u_char	daf_rsrv:1;	/* reserved		*/
	u_char	daf_pcode:6;	/* Page code		*/

	u_char	daf_plen;	/* Page length		*/

	u_short	daf_tpz;	/* Tracks per zone	*/

	u_short daf_altspz;	/* Alternate sectors per zone	*/

	u_short	daf_atttpz;	/* Alternate tracks per zone	*/

	u_short	daf_alttpv;	/* Alternate tracks per volume	*/

	u_short	daf_spt;	/* Sectors per track		*/

	u_short	daf_nbps;	/* No of bytes per sector	*/

	u_short	daf_intrlve;	/* Interleave factor		*/

	u_short daf_tskew;	/* Track skew			*/

	u_short daf_cskew;	/* Cylinder skew		*/

	u_char	daf_ssec:1;	/* Soft sector format		*/
	u_char	daf_hsec:1;	/* Hard sector format		*/
	u_char	daf_rmb:1;	/* Removable media		*/
	u_char	daf_surf:1;	/* Format by surface		*/
	u_char	daf_ins:1;	/* ????				*/
	u_char	daf_resvd:3;	/* reserved			*/

	u_char	daf_resv2[3];	/* Reserved			*/
};

struct scsi_msrigidpage		/* Rigid disk drive geometry page (4)	*/
{
	u_char	rdg_ps:1;	/* parameter savable 		*/
	u_char	rdg_rsrv:1;	/* Reserved			*/
	u_char	rdg_pcode:6;	/* Page code			*/

	u_char	rdg_plen;	/* Page length			*/

	u_char	rdg_maxcyl[3];	/* Maximum no of cylinders	*/

	u_char	rdg_hmaxheads;	/* Maximum no of heads		*/

	u_char	rdg_scwpc[3];	/* Starting cylinder - write precompensation */

	u_char	rdg_scrwc[3];	/* Starting cylinder - reduced write current */

	u_short	rdg_dsr;	/* Drive step rate		*/

	u_char	rdg_lzone[3];	/* landing zone cylinder	*/

	u_char	rdg_resvd[7];	/* Reserved			*/
};

struct scsi_msracache		/* Read ahead cache control page (8) */
{
	u_char	rac_ps:1;	/* parameter savable		*/
	u_char	rac_rsrv:1;	/* reserved			*/
	u_char	rac_pcode:6;	/* page code			*/

	u_char  rac_plen;	/* Page length			*/

	u_char  rac_resvd1:6;	/* reserved			*/
	u_char	rac_ms:1;	/* Multiple selection		*/
	u_char	rac_rcd:1;	/* Read cache disable		*/

	u_char	rac_resvd2;	/* reserved			*/

	u_short rac_suppr;	/* Cache suppression		*/

	u_short	rac_min_pre;	/* Minimum prefetch		*/

	u_short	rac_max_pre;	/* Maximum prefetch		*/
	u_short rac_max_pre_restr;	/* Max prefetch restriction */
};

/* HW Wren cache control */
struct scsi_mscachepage         /* CDC Wren Cache control page (56) */
{
        u_char  csh_ps:1;       /* parameter savable            */
	u_char	csh_rsrv:1;	/* reserved			*/
        u_char  csh_pcode:6;    /* Page code                    */

        u_char  csh_plen;       /* Page length                  */

        u_char  csh_rsv1:1;     /* reserved                     */
        u_char  csh_wie:1;      /* Write Index Enable           */
        u_char  csh_rsv2:1;     /* reserved                     */
        u_char  csh_ce:1;       /* Cache Enable                 */
        u_char  csh_cts:4;      /* Cache Table Size             */

        u_char  csh_pt;         /* Prefetch Threshold           */

        u_char  csh_max_pre;    /* Maximum Prefetch             */

        u_char  csh_max_pre_m;  /* Maximum Prefetch multiplier */

        u_char  csh_min_pre;    /* Miniumum Prefetch             */

        u_char  csh_min_pre_m;  /* Miniumum Prefetch multiplier */

        u_char  csh_resv3[8];   /* reserved */

};

struct scsi_msatconnpage	/* Adaptec dis/reconecct page (32) */
{
	u_char	atc_ps:1;	/* Parameter savable		*/
	u_char	atc_rsrv:1;	/* Reserved			*/
	u_char	atc_pcode:6;	/* Page code			*/
	u_char	atc_plen;	/* Page length			*/
	u_char	atc_hroh;	/* Host reconnect overhead	*/
	u_char	atc_bpfill;	/* Buffer Pre-fill on Write	*/
	u_char	atc_resvd:7;	/* Reserved			*/
	u_char	atc_mdp;	/* Modify data pointer OK	*/
};

struct scsi_msverpage		/* Verify error recovery page (7) */
{
	u_char	ver_ps:1;	/* Parameter savable		*/
	u_char	ver_rsrv:1;	/* Reserved			*/
	u_char	ver_pcode:6;	/* Page code			*/

	u_char	ver_plen;	/* Page length			*/

	u_char	ver_resv1:4;	/* reserved			*/
	u_char	ver_eer:1;	/* enable early recovery	*/
	u_char	ver_per:1;	/* Post error			*/
	u_char	ver_dte:1;	/* Disable transfer on error	*/
	u_char	ver_dcr:1;	/* Disable correction		*/

	u_char	ver_vrtc;	/* Retry count at verify	*/

	u_char	ver_cbl;	/* Correctable bit length	*/
	
	u_char	ver_resv2[7];	/* Reserved			*/
};
	
struct scsi_msaerpage		/* Additional error recovery page (33) */
{
	u_char	aer_ps:1;	/* Parameter savable		*/
	u_char	aer_rsrv:1;	/* Reserved			*/
	u_char	aer_pcode:6;	/* Page code			*/

	u_char	aer_plen;	/* Page length			*/
	
	u_char	aer_dced:1;	/* Disable command exec. delay	*/
	u_char	aer_pser:1;	/* Post SCSI error		*/
	u_char	aer_resv1:2;	/* Reserved			*/
	u_char	aer_srtc:4;	/* Seek retry count		*/

	u_char	aer_resv2;	/* Reserved			*/
};

struct scsi_rtcpage		/* Reconnection timing page (34)	*/
{
	u_char	rtc_ps:1;	/* Parameter savable		*/
	u_char	rtc_rsrv:1;	/* Reserved			*/
	u_char	rtc_pcode:6;	/* Page code			*/

	u_char	rtc_plen;	/* Page length			*/

	u_char	rtc_resv1;	/* Reserved			*/

	u_char	rtc_resv2;	/* Reserved			*/
};

struct scsi_audioctrlpage	/* CD-ROM audio control page (14) */
{
	u_char	aud_ps:1;	/* Parameter savable		*/
	u_char	aud_rsrv:1;	/* Reserved			*/
	u_char	aud_pcode:6;	/* Page code			*/

	u_char	aud_plen;	/* Page length			*/

	u_char	aud_resv1:5;	/* Reserved			*/
	u_char	aud_immed:1;	/* Immediate bit		*/
	u_char	aud_sotc:1;	/* Stop on track crossing	*/
	u_char	aud_resv2:1;	/* Reserved			*/

	u_char	aud_resv3;	/* Reserved			*/

	u_char	aud_resv4;	/* Reserved			*/

	u_char	aud_aprval:1;	/* Audio playback rate valid	*/
	u_char	aud_resv5:3;	/* Reserved			*/
	u_char	aud_ldbafmt:4;	/* Format of logical block addrs*/

	u_char	aud_lba[2];	/* Logical blocks per second	*/

	struct  aud_pctrl {	/* Audio port control		*/
	   u_char  aud_resv:4;	/* Reserved			*/
	   u_char  aud_chnl:4;	/* Port channel selection	*/

	   u_char  aud_vol;	/* Port volume			*/
	} aud_port[4];
};

struct scsi_cdromparampage	/* CD-ROM parameters page (13)	*/
{
	u_char	cd_ps:1;	/* Parameter savable		*/
	u_char	cd_rsrv:1;	/* Reserved			*/
	u_char	cd_pcode:6;	/* Page code			*/

	u_char	cd_plen;	/* Page length			*/

	u_char	cd_resv2;	/* Reserved			*/

	u_char	cd_resv3:4;	/* Reserved			*/
	u_char	cd_itm:4;	/* Inactivity timer multiplier	*/

	u_char	cd_stom[2];	/* MSF S units per MSF M units	*/

	u_char	cd_ftos[2];	/* MSF F units per MSF S units	*/
};

struct scsi_speedctrlpage	/* CD-ROM speed control page (32) */
{
	u_char	spd_ps:1;	/* Parameter savable		*/
	u_char	spd_rsrv:1;	/* Reserved			*/
	u_char	spd_pcode:6;	/* Page code			*/

	u_char	spd_plen;	/* Page length			*/

	u_char	spd_resv1:7;	/* Reserved			*/
	u_char	spd_speed:1;	/* speed bit			*/
};

struct  scsi_ms /* SCSI Mode sense all pages */
{
    struct scsi_modesense       sms_hd;
    struct scsi_mserppage       sms_erp;
    struct scsi_msconnpage      sms_cop;
    struct scsi_msdadfpage      sms_daf;
    struct scsi_msrigidpage     sms_rdg;
    struct scsi_mscachepage     sms_csh;
    struct scsi_msracache	sms_rac;
    struct scsi_msatconnpage	sms_atc;
    struct scsi_msverpage	sms_ver;
    struct scsi_msaerpage	sms_aer;
    struct scsi_rtcpage		sms_rtc;
    struct scsi_audioctrlpage	sms_aud;
    struct scsi_cdromparampage	sms_cd;
    struct scsi_speedctrlpage	sms_spd;

} ;

struct  scsi_msc /* HW SCSI Mode sense/select cache  page */
{
    struct scsi_modesense       sms_hd;
    struct scsi_msracache       sms_rac;
} ;

struct scsi_capdata
{
	u_long	cd_blocks;	/* No of blocks */
	u_long	cd_blklen;	/* Logical block length */
};

struct scsi_esense 
{
	u_int	es_valid:1;	/* Data valid		*/
	u_int	es_eclass:3;	/* Error class		*/
	u_int	es_ecode:4;	/* Error code		*/
	u_char	es_segno;	/* Segment number	*/
	u_int	es_fmark:1;	/* File mark		*/
	u_int	es_eom:1;	/* End of medium	*/
	u_int	es_ili:1;	/* Illegal length ind   */
	u_int	es_res1:1;	/* Reserved		*/
	u_int	es_key:4;	/* Sense key		*/
	u_char	es_info[4];	/* Info bytes		*/
	u_char	es_addlen;	/* Additional sense len	*/
/* From Fujitsu M2263S IDD OEM Manual */
	u_char	es_cii[4];	/* Command inherent info */
	u_char	es_scode;	/* Sense code		*/
	u_char	es_subscode;	/* Subsense code	*/
/* From Maxtor XT4000S OEM Manual	*/
	u_char	es_fru;		/* Field replaceable unit ?? */
	u_char	es_fpv:1;	/* Sense key inherent info valid */
	u_char	es_cd:1;	/* CDB or data ? */
	u_char	es_resv1:1;	/* Reserved */
	u_char	es_bpv:1;	/* Bit pointer valid */
	u_char	es_bp:3;	/* Bit pointer */
	u_short	es_fp;		/* Field pointer */
/* From Fujitsu */
	u_char	es_resv2:1;	/* Reserved */
	u_char	es_target:3;	/* SCSI target */
	u_char	es_lun:4;	/* SCSI LUN */
	u_char	es_op;		/* CDB op code */

	/* Fuji here has another 27 bytes reserved for Field engineering
	 * which aren't described in the manual
	 */
};
#define SCES_KEY_NO_SENSE		0
#define SCES_KEY_RECOVERED_ERROR	1
#define SCES_KEY_NOT_READY		2
#define SCES_KEY_MEDIUM_ERROR		3
#define SCES_KEY_HARDWARE_ERROR		4
#define SCES_KEY_ILLEGAL_REQUEST	5
#define SCES_KEY_UNIT_ATTENTION		6
#define SCES_KEY_DATA_PROTECT		7
#define SCES_KEY_BLANK_CHECK		8
#define SCES_KEY_VENDOR_UNIQUE		9
#define SCES_KEY_COPY_ABORTED		10
#define SCES_KEY_ABORTED_COMMAND	11
#define SCES_KEY_EQUAL			12
#define SCES_KEY_VOLUME_OVERFLOW	13
#define SCES_KEY_MISCOMPARE		14
#define SCES_KEY_RESERVED		15

#define SCTS_GOOD			0x00
#define SCTS_CHECK_CONDITION		0x02
#define	SCTS_CONDITION_MET		0x04
#define SCTS_BUSY			0x08
#define SCTS_INT_GOOD			0x10
#define SCTS_INT_CONDITION_MET		0x14
#define SCTS_RES_CONFL			0x18
#define SCTS_DRV_FAIL			0x7F

struct scsi_inqblk
{
	u_char	sinq_qual:3;
#define SCQUAL_OK	0x0
#define SCQUAL_WRONG_LUN 0x1
#define SCQUAL_NO_LUN	0x3
	u_char	sinq_pdt:5;
#define SCPDT_DASD	0x00
#define SCPDT_SASD	0x01
#define SCPDT_PRINTER	0x02
#define SCPDT_PROCESSOR	0x03
#define SCPDT_WORM	0x04
#define SCPDT_RODA	0x05
#define SCPDT_NO_LUN	0x7F
	u_int	sinq_rmb:1;
	u_int	sinq_dtq:7;

	u_char  sinq_isoversion:2;
	u_char  sinq_ecmaversion:3;
	u_char	sinq_ansiversion:3;

	u_char	sinq_aenc:1;
	u_char	sinq_resvd:3;
	u_char	sinq_rdd:4;

	u_char	sinq_addlen;
	u_char	sinq_rqsenselen;
	u_char	sinq_resvd2;

	u_char	sinq_reladr:1;
	u_char	sinq_wbus32:1;
	u_char	sinq_wbus16:1;
	u_char	sinq_sync:1;
	u_char	sinq_linked:1;
	u_char	sinq_resvd3:1;
	u_char	sinq_cmdque:1;
	u_char	sinq_sftre:1;

	u_char	sinq_vid[8];
	u_char	sinq_pid[16];
	u_char	sinq_fwrev[4];
	u_char	sinq_fwdate[8];
};

struct scsi_cmdinfo
{
	char	**cmdarr;
	int	arrmax;
};
