/* Include other HA routines device count header files here as well */
#include "aha.h"
#if NAHA > 0

/*
 * Copyright (C) 1988, 1989 Christer Bernerus, 
 *		 Chalmers University of Technology, Gothenburg, SWEDEN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright 
 * notice and this paragraph are  duplicated in all such forms 
 * and that any documentation, advertising materials,
 * and other materials related to such distribution
 * and use acknowledge that the software was developed
 * at Chalmers University of Technology, SWEDEN.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * SCSI adapter driver, device independent parts.
 * 
 * $Source: /usr/src/sys/rtio/RCS/xha.c,v $ 
 * $Revision: 1.4 $ 
 * $Author: md $ $State: Exp $
 *
 * $Log: xha.c,v $
 * Revision 1.4  1994/05/07  15:07:45  md
 * Change #include statements to use system search path instead of absolute.
 *
 * Revision 1.3  1993/03/30  20:56:12  md
 * change %X to be %x in printf's
 *
 * Revision 1.2  1992/12/09  09:02:20  md
 * Add back in debugging hooks.
 *
 * Revision 1.1  1992/11/05  20:26:55  md
 * Initial revision
 *
 * Revision 3.0  90/02/08  09:46:24  bernerus
 * February 1990 release.
 * 
 * Revision 1.1  90/02/06  17:11:20  bernerus
 * Initial revision
 * 
 * 
 */

/*********************** STATIC DATA SECTION **********************************/
#define PARANOID

#include <sys/param.h>
#include <sys/dkstat.h>
#include <sys/vm.h>
#include <sys/buf.h>
#include <sys/types.h>

#include <rtio/ioccvar.h>
#include <rtio/scsi.h>
#include <rtio/xhavar.h>
#include <rtio/dmavar.h>
#include <rt/debug.h>

#ifdef DEBUG
int             xhadebug = 	 0;
int		xhatrace =	 0;
int             xhanotice = 	 0;
int             xhacstartdebug = 0;
int		xharequeuedebug = 0;
void		printmbox(), printccb();
#endif /* DEBUG */
/* #define DSPL		/* show status on LED's */
#ifndef DSPL
#define dsplbio(x) splbio()
#define dsplx(x,y) splx(x)
#define dsplhigh(x) splhigh()
#else
#define TRACEBUFSIZ 100
int spltraceindex;
struct spltrace
{
	int	tpoint;
	int	type;
	int	lastlevel;
	int	newlevel;
} spltraces[TRACEBUFSIZ];
dsplbio(x)
{
	int s;
	struct spltrace *tp = &spltraces[spltraceindex];
	s = splbio();
	if((x < 33) || (x > 41))
	    display(0x80+x);
	tp->tpoint=x;
	tp->type=0xB;
	tp->lastlevel=s;
	tp->newlevel=1;
	if(++spltraceindex >= TRACEBUFSIZ)
		spltraceindex = 0;
	return s;
}
dsplx(x,y)
{
	int s;
	struct spltrace *tp = &spltraces[spltraceindex];
	if((y < 33) || (y > 41))
	    display(0x00+y);
	tp->tpoint=y;
	tp->type=0x0;
	tp->newlevel=x;
	s = getspl();
	tp->lastlevel=s;
	splx(x);
	if(++spltraceindex >= TRACEBUFSIZ)
		spltraceindex = 0;
	return;
}
dsplhigh(x)
{
	int s;
	struct spltrace *tp = &spltraces[spltraceindex];
	s = splhigh();
	if((x < 33) || (x > 41))
	    display(0xc0+x);
	tp->tpoint=x;
	tp->type=0xF;
	tp->lastlevel=s;
	tp->newlevel=0;
	if(++spltraceindex >= TRACEBUFSIZ)
		spltraceindex = 0;
	return s;
}
dgetspl(x)
{
	int	s;
	struct spltrace *tp = &spltraces[spltraceindex];
	s = getspl();
	if((x < 33) || (x > 41))
	    display(0x40+x);
	tp->tpoint=x;
	tp->type=0x1;
	tp->lastlevel=-1;
	tp->newlevel=s;
	if(++spltraceindex >= TRACEBUFSIZ)
		spltraceindex = 0;
	return s;
}

#endif /* DSPL */

#ifdef DEBUG
void		xhdump();
#endif /* DEBUG */

/*
/*************** TOP I/O FUNCTIONS SECTION *********************/
/*
 * The Channel start routine. This one will enter the unit xs into the
 * device queue and then start all devices on the corresponding channel.
 */
void 
xhacstart(struct xha_slave *xs)
{
	if(xs)
	{
	    DEBUGF(xhatrace,printf("xha%d: Xhacstart: xs=%x\n",xs->xs_ctlr,xs););
	}
	else
	{
	    DEBUGF(xhatrace,printf("xha?: Xhacstart: xs=NULL\n"););
	    return ;
	}
	xhaqdevice(xs);
	xhastartdevices(xs->xs_xi->xi_hd);
}

void
xhaqdevice(struct xha_slave *xs)
{
    register struct xha_hd     *xh = xs->xs_xi->xi_hd;
    register int                s;

    DEBUGF(xhatrace,printf("xha%d: Xhaqdevice: xs=%x\n",xs->xs_ctlr,xs););
    /*
     * First some validity checks
     */
    if(!xs)
    {
	printf("Xhaqdevice: xs == NULL\n");
	return;
    }
    if(!xs->xs_xi)
    {
	printf("Xhaqdevice: xs->xs_xi == NULL, xs=%x\n",xs);
	return;
    }
    xh = xs->xs_xi->xi_hd;
    if(!xh)
    {
	printf("Xhaqdevice: xh == NULL\n");
	return;
    }
    if(xs->xs_alive == 0)
    {
	printf("Xhaqdevice: xs->xs_alive == NULL,xs=%x\n",xs);
	return;
    }
    /*
     * Queue the device on the xha_hd structure for processing
     * Since this device could already be queued, we check the
     * queue first.
     */
    s = dsplbio(1);
    if(!xs->xs_inq)
    {
	DEBUGF(xhacstartdebug,
	    printf("Xhaqdevice: xs=%x entered\n",xs););
	xs->xs_forw = NULL;
	if (xh->xh_actf == NULL)	/* I.e. first item in Q */
	{
	    xh->xh_actf = xs;		/* Q header points to item */
	    xs->xs_back = NULL;		/* Back ptr indicates head of Q */
	}
	else				/* Not first item in q : */
	{
	    xh->xh_actl->xs_forw = xs;	/* Fwd ptr of last elem points to new */
	    xs->xs_back = xh-> xh_actl;/* Back ptr of item points to q tail */
	}
	xh->xh_actl = xs;		/* Q tail is now the new item */
	xs->xs_inq = 1;			/* Device is now in q */
    }
    dsplx(s,2);
}


/*
 * Devices start routine, this one will start all devices on the device q.
 */
void
xhastartdevices(struct xha_hd *xh)
{
    register struct xha_slave *xs;
    register int                s;
    register int		loopcnt;
    struct xhac_driver		*xc;

    DEBUGF(xhatrace,printf("Xhastartdevices: xh=%x\n",xh););
    /* Loop through the device queue and start all devices */
    s = dsplbio(3);
    /* 
     * We first check if there is anything to do or if someone else is
     * already working on it, if so we have nothing to do 
     */
    if(((xs = xh->xh_actf) == NULL) || xh->xh_active ) /* Anything to do ? */
    {
	dsplx(s,4);
        /* DEBUGF(xhaerrdebug,printf("Xhastartdevices: nothing to do:\n");); */
	return;			 /* NO, skip it */
    }
    xh->xh_active = 1;	/* Note to others that I'm working on it */
    dsplx(s,5);

    xc  = xs->xs_xi->xi_hadriver;

    DEBUGF(xhacstartdebug,printf("Xhastartdevices: starting targets: xs=%x\n",xs););
    /* Now start working through the targets */
    for(loopcnt=0;loopcnt<100;loopcnt++)
    {
    	switch((*xc->xhc_ustart)(xs))	/* Start all requests for the unit */
	{
	case XHS_DONE:		/* I.E. all requests started OK */
	    /*
	     * Here  outstanding requests may have
	     * been started so the device might be unqueued from the
	     * device queue if the request queue is empty.
	     */
	    s=dsplbio(6);
	    if(! xs->xs_tab.b_actf)	/* Nothing there now ? */
	    {
		/* Unqueue the device */
		if(xs->xs_back)/* dependin on whether wer'e the first element*/
		{
		   xs->xs_back->xs_forw =  /* Previous elements fwd ptr      */
		     xs->xs_forw;	    /* inherits my old fwd pointer    */
		}
		else			    /* or */
		{
		   xh->xh_actf =	    /* the Q header pointer 	      */
		     xs->xs_forw;	    /* inherits my old fwd pointer    */
		}

		if(xs->xs_forw)/* depending on whether wer'e the last element*/
		{
		   xs->xs_forw->xs_back =  /* Next elem's back pointer or    */
		     xs->xs_back;	    /* inherits my old back pointer   */
		}
		else			    /* or */
		{
		   xh->xh_actl =	    /* the Q tail pointer 	      */
		     xs->xs_back;	    /* inherits my old back pointer   */
		}

		xs->xs_inq = 0;	    /* Now wer'e no longer in the Q   */
	    }

	    xs = xs->xs_forw;		    /* Pick the next target */

	    if(xs)			    /* Was there anything ? */
	    {
		dsplx(s,7);		    /* Yes, reset priority and */	
		continue;	       	    /* process it	       */
	    }
	    
	    /* Nothing left in the Q	*/

	    xh->xh_active = 0; /* Note to others that we aren't processing
				 * this channel anymore 
				 */
	    dsplx(s,8);
	    return;
	case XHS_RETRY:		/* Too bad, hope they will be started later */
	case XHS_FAIL:
	    s = dsplbio(9);
	    
	    xs = xs->xs_forw;               /* Pick the next target */

            if(xs)                          /* Was there anything ? */
            {
                dsplx(s,10);                 /* Yes, reset priority and */
                continue;                   /* process it              */
            }

	    xh->xh_active = 0; /* Note to others that we aren't processing
				 * this channel anymore 
				 */
	    dsplx(s,11);
	    return;
	}
    }
    printf("%s%d: xhastartdevices: Max loop count exceeded:xs=%x, forw=%x\n",
	   xs->xs_driver->xd_dname,xs->xs_unit,
		xs,xs->xs_forw);
    xh->xh_active = 0;
}
/* */
xharequeue(struct xha_slave *xs,struct buf *bp)
{
    struct buf *ap,*dp;
    int	s;
    int	loopcnt;

    DEBUGF(xharequeuedebug | xhatrace,
	printf("%s%d: Xharequeue: bp=%x\n",
	    xs->xs_driver->xd_dname,xs->xs_unit, bp););
    s = dsplbio(19);
    dp = &xs->xs_tab;
    if(!bp)
    {
	DEBUGF(xharequeuedebug | xhanotice | xhatrace,
	    printf("%s%d: Xharequeue: bp=%x cannot be entered.\n",
		xs->xs_driver->xd_dname,xs->xs_unit, bp););
	dsplx(s,20);
	return 1;
    }
    if (dp->b_actf == NULL)
    {
	DEBUGF(xharequeuedebug,
	    printf("%s%d: Xharequeue: bp=%x, entered into empty Q\n", 
			xs->xs_driver->xd_dname,xs->xs_unit, bp););
	bp->av_forw = NULL;
	dp->b_actf = bp;
    }
    else
    {
	for(ap=dp,loopcnt=0;ap;ap = ap->av_forw)
	{
	    if(++loopcnt > 1000000)
	    {
		dsplx(s,21);
		printf("%s%d: Xharequeue: max loop count exceeded\n",
		    xs->xs_driver->xd_dname, xs->xs_unit);
		return 1;
	    }
			    
	    if(ap == bp)
	    {
		DEBUGF(xharequeuedebug | xhanotice,
		    printf("%s%d: Xharequeue: Buffer %x not reentered\n",
			xs->xs_driver->xd_dname,xs->xs_unit, bp););
		dsplx(s,22);
		return 1;
	    }
	}
	bp->av_forw = NULL;
	DEBUGF(xharequeuedebug,
	    printf("%s%d: Xharequeue bp=%x entered into Q after %x\n",
		xs->xs_driver->xd_dname, xs->xs_unit, bp, dp->b_actl););
	dp->b_actl->av_forw = bp;
    }
    dp->b_actl = bp;
    dsplx(s,23);
    return 0;
}
/*
/******************** DMA INTERFACE ROUTINES **********************************/
/* 
 * Combine three bytes into an unsigned
 */
unsigned
xhaget3(u_char p[])
{
    return ((*p & 0xFF) << 16) | ((p[1] & 0xFF) << 8) | (p[2] & 0xFF);
}

/*
 * Split an unsigned long into three bytes
 */
void
asgn3(u_char *p, u_long v)
{
    *p++ = v >> 16 & 0xFF;
    *p++ = v >> 8 & 0xFF;
    *p = v & 0xFF;
}

/*
 * The dgo routine doesn't have to do anything since we're using
 * 3'rd party DMA
 */
void
xhadgo(dm, len, ioaddr, bp) 
struct iocc_ctlr *dm; unsigned ioaddr; struct buf *bp;
{
}

/*
 * Xhaiodone, 
 * If B_HEAD, we just mark it done, else
 * we call iodone to wake up waiters etc.
 */
xhaiodone(struct buf *bp,char *string)
{
    int rv = 0;

    if(bp->b_flags & B_DONE)
    {
	printf("Xhaiodone: DUP BIODONE NR %s, bp=0x%x, flags=0x%x\n",
	    string,bp,bp->b_flags);
	rv=1;
    }
    if(bp->b_flags & B_HEAD)
	bp->b_flags |= B_DONE;
    else
	iodone(bp);
    return rv;
}

/*
/***************** DEBUGGING ROUTINES *****************************************/

#ifdef DEBUG
char *
xcstr(u_char c) 
{
    static char     outstr[3];
    char           *convstr = "0123456789abcdef";

    outstr[0] = convstr[(c >> 4) & 0xf];
    outstr[1] = convstr[c & 0xf];
    outstr[2] = '\0';

    return outstr;
}

void
xhdump(u_char *cp, int n)
{
    int             i = 0;

    while (n--)
    {
	printf("%s", xcstr(*cp++));
	++i;
	if ((i % 32) == 0)
	{
	    printf("\n");
	}
	else
	{
	    if ((i % 4) == 0)
	    {
		printf(" ");
	    }
	}
    }
    if (i % 32)
    {
	printf("\n");
    }
}

#endif /* DEBUG */
#endif /* NAHA */
