#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidxhavarh = "$Header: /usr/src/sys/rtio/RCS/xhavar.h,v 1.1 1990/05/28 07:30:41 md Exp $";
#endif
/*
 * Copyright (c) 1988, Christer Bernerus, Chalmers University of Technology,
 *                     Gothenburg, SWEDEN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright 
 * notice and this paragraph are  duplicated in all such forms 
 * and that any documentation, advertising materials,
 * and other materials related to such distribution
 * and use acknowledge that the software was developed
 * at Chalmers University of Technology, SWEDEN.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Kernel structures involving the SCSI adapter.
 * each SCSI adapter has an xha_hd structure.
 * each SCSI target has an xha_device structure.
 * each SCSI device has an xha_slave structure.
 */
/* Per SCSI controller structure */
struct xha_hd
{
        struct  iocc_driver *xh_driver;     /* driver structure */
	short		     xh_hatype;	    /* Type of ctrlr */
#define HATYPE_NONE	0	  /* Initial value, structure unused */
#define HATYPE_AHA	1	  /* Adaptec AHA-1540 */
#define HATYPE_IBM	2	  /* IBM SCSI Adapter */
        short                xh_active;     /* set if xha is active */
        short                xh_ndrive;     /* number of devices */
	caddr_t 	     xh_xha;        /* virt addr of xha */
	char		    *xh_haname;	    /* Name of host adapter */
        struct  xha_device  *xh_xhip[8];    /* attached ctrlrs */
        struct  iocc_ctlr   *xh_iocc;       /* Backptr */
        struct  xha_slave  *xh_actf;       /* xfer q head */
        struct  xha_slave  *xh_actl;       /* xfer q tail */
};


/* Per target structure */

struct xha_device 
{
	struct	xha_driver  *xi_driver;	
	short		     xi_unit;	/* System's unit no */
	short		     xi_ctlr;	/* SCSI ctrl it is on */
	short		     xi_target;	/* Target no on scsi bus */
	short		     xi_hatype;	/* Type of ctlr it is on */
	short		     xi_alive;	/* Target exists */
	u_long		     xi_type;	/* Unit type */
	struct xha_slave    *xi_slaves[8]; /* Pointers to slave structs */
	struct xhac_driver  *xi_hadriver;  /* Pointers to ha's driver routines */
	/* Short cuts */
	caddr_t  	     xi_xha;
        struct  xha_hd      *xi_hd;

};

struct	xha_slave	
{
	struct	xha_driver  *xs_driver;
	short		     xs_unit;	/* Which unit to system */
	short		     xs_ctlr;	/* Which SCSI it is on */
	short		     xs_target;	/* Which target on SCSI bus */
	short		     xs_lun;	/* Which logical unit (LUN)*/
	short		     xs_alive;	/* Device alive */
	short		     xs_dk;	/* Driver no for iostat */
        struct buf           xs_tab;    /* Head of Q for this dev */
        short                xs_inq;    /* True if the device is in q */
	short		     xs_flags;	/* Some flags:		*/
#define	XSFL_EXOPEN	1		/* Device is exclusively opened */
#define XSFL_SPECSCSI	2		/* Special SCSI command follows	*/
#define XSFL_HASSENSE	4		/* Sense data saved */
	int		     xs_ocnt;	/* Open count */
	union	scsi_cdb     xs_cdb;	/* SCSI cmd to emit on next I/O */
	struct	scsi_esense  xs_esense; /* Sense data of last spec scsi */
        struct xha_slave    *xs_forw;   /* Ptr to next device in q */
        struct xha_slave    *xs_back;   /* Ptr to prev device in q */
	/* Short cut back */
	struct xha_device   *xs_xi; /* Pointer to formatter device struct */
};

/* Per device type structure */

struct xha_driver
{
    int		        (*xd_probe)(caddr_t, struct xha_device *);
    int		        (*xd_slave)(struct xha_slave *, caddr_t);
    int		        (*xd_attach)(struct xha_slave *);
    int		        (*xd_ustart)(struct xha_slave *);
    union scsi_cdb *    (*xd_start)(struct xha_slave *, struct buf *, 
				    union scsi_cdb *);
    int		        (*xd_int)(struct xha_slave *, struct buf *,
				  int, struct scsi_esense *, u_char);
    char	         *xd_dname;	    	/* Device name */
    char	         *xd_sname;	    	/* Slave name */
    struct  xha_device	**xd_dinfo;  		/* Backpointers */
    struct  xha_slave	**xd_sinfo;  		/* Backpointers */
    int		        (*xd_ttl)(union scsi_cdb *); 
    int			  xd_flags;		/* Driver flags */
};

/* Per host adapter type structure */
struct xhac_driver
{
	u_short	(*xhc_doscsi)(struct xha_slave *, union scsi_cdb *, 
			      caddr_t, int, int);
	void	(*xhc_cstart)(struct xha_slave *);
	int     (*xhc_ustart)(struct xha_slave *);
};

/* Minor device numbering convention */

#ifdef notyet
#define XHAMIN_PART(dev)   (minor(dev)&0x07)		/* Part'n no	     */
#define XHAMIN_LUN(dev)	   (minor(dev)>>3&0x07)		/* Logical unit no   */
#define XHAMIN_TARGET(dev) (((dev)>>6)&0x07)            /* Target Number     */
#define XHAMIN_NOREW(dev)  (((dev)>>2)&0x1)  		/* No rewind (tapes) */
#define XHAMIN_CHAN(dev)   (((dev)>>9)&0x3)		/* SCSI channel no   */
#define XHAUNIT(dev)       (((dev)>>3)&0xFF)		/* System's unit no  */
#else
#define XHAMIN_PART(dev)    (minor(dev) & 0xF)	      /* Partition # (disks) */
#define XHAMIN_LUN(dev)	   ((0))	     /* Logical Unit no (always zero)*/
#define XHAMIN_TARGET(dev) ((minor(dev) >> 4) & 0x7)  /* Target Number       */
#define XHAMIN_NOREW(dev)  ((minor(dev) >> 3) & 0x1)  /* No rewind (tapes)   */
#define XHAUNIT(dev)	   ((minor(dev) >> 4) & 0xF)  /* System's unit no    */
#endif /* notyet */


/* Command completion codes sent to device interrupt routine */

#define XHI_CMPL	0	/* Command completed, no error */
#define XHI_ERR		1	/* Command completed with error */
#define XHI_TIMEOUT	2	/* Command not completed, controller timeout */
#define XHI_OUVR	3	/* Command generated Data Over/Under run */
#define XHI_SELTO	4	/* Command not completed, target sel. timeout */
#define XHI_BUSFAIL	5	/* Command aborted due to a bus failure */
#define XHI_HASWFAIL	6	/* Command aborted, (Bug in XHA driver code) */
#define XHI_SCSIRESET	7	/* Command aborted by a SCSI reset condition */
#define XHI_NEXT	8	/* No command found, skip it */

 
/* Return values from device ustart routine */

#define	XHU_NEXT	0	/* Skip to next op */
#define XHU_DODATA	1	/* Data xfer ready, start host adapter */
#define XHU_STARTED	2	/* Non data xfer started */
#define XHU_DOLINKS	3	/* Start all xfers using SCSI linked cmds */

/* Return values from device interrupt routine */

#define XHD_DONE	0	/* Data xfer complete	*/
#define XHD_RETRY	1	/* Error occurred, pse retry */
#define XHD_RESTARTED	2	/* Driver restarted i/o itself */
#define XHD_REPOSITION	3	/* Driver started unit, no data xfer */
#define XHD_RESETRETRY  4	/* Bus device reset and retry */
#define XHD_SCRESETRETRY  5	/* SCSI Bus reset and retry */


/* SCSI status */

#define XHS_GOOD	0	/* Status = GOOD */
#define XHS_CHECK	2	/* Check condition */
#define XHS_BUSY	8	/* Busy	*/
#define XHS_IGOOD	16	/* Intermediate good */
#define XHS_RCONF	24	/* Reservation conflict */


/* Command codes for command sending routine */

#define XCMD_DONTWAIT	0	/* Don't wait for completion */
#define XCMD_WAIT	1	/* Wait for command completion */
/*
 * Return values from xhaustart
 */
#define XHS_DONE	0	/* The request was started (if any) */
#define XHS_FAIL	1	/* Request couldn't be started, skip it */
#define XHS_RETRY	2	/* The request couldn't be started, try later */

#ifndef NIHA 
#define NIHA 0
#endif /* NIHA */
#ifndef NAHA
#define NAHA 0
#endif /* NAHA */

#define NXHA (NAHA+NIHA)

#ifdef KERNEL
#if NXHA > 0 
struct	xha_hd	xha_hd[NXHA];
extern struct	xha_device xhdinit[];
extern struct	xha_slave  xhsinit[];
unsigned	xhaget3(u_char []);
void 		xhadgo(),	
		xhacstart(struct xha_slave *),	
		asgn3(u_char *, u_long),
		xhdump(u_char *, int),
		xhaqdevice(struct xha_slave *),	
		xhastartdevices(struct xha_hd *);
int		xharequeue(struct xha_slave *,struct buf *p),
		xhaiodone(struct buf *,char *);
int	numaha;
int	numiha;
#endif /* NXHA  */
#endif /* KERNEL */
