#include "cs.h"
#include "xt.h"
#include "cd.h"
#include "aha.h"
#if NCS > 0 || NXT > 0 || NCD > 0 || NAHA > 0
/*
 * Copyright (c) 1989, Christer Bernerus, Chalmers University of Technology,
 *                     Gothenburg, SWEDEN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright
 * notice and this paragraph are  duplicated in all such forms
 * and that any documentation, advertising materials,
 * and other materials related to such distribution
 * and use acknowledge that the software was developed
 * at Chalmers University of Technology, SWEDEN.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * SCSI generic driver support routines.
 *
 * $Source: /usr/src/sys/rtio/RCS/xxc.c,v $
 * $Revision: 1.8 $ $Date: 1994/05/12 20:24:55 $
 * $Author: roger $ $State: Exp $
 *
 * $Log: xxc.c,v $
 * Revision 1.8  1994/05/12  20:24:55  roger
 * removed dir.h.
 *
 * Revision 1.7  1994/05/07  16:10:30  md
 * Change #include statements to use system search path instead of absolute.
 *
 * Revision 1.6  1994/03/25  19:04:55  md
 * Changes to support multisession PhotoCD discs.
 *
 * Revision 1.5  1994/03/17  16:20:10  md
 * Define scsi command group 10 to be a 10 byte cdb for the Toshiba 3401
 * vendor specific commands.
 *
 * Revision 1.4  1993/04/03  13:02:16  md
 * changes needed for cd-rom support for iso filesystem
 *
 * Revision 1.3  1992/12/09  10:57:48  md
 * change reference of machineio to rtio.
 *
 * Revision 1.2  1992/12/09  10:27:50  md
 * Add back in debugging hooks.
 *
 * Revision 1.1  1992/11/01  20:13:36  md
 * Initial revision
 *
 * Revision 3.1  90/03/05  15:42:07  bernerus
 * xxprobe now tries to reach a target 3 times before giving up, waiting
 * a while between each attempt to make it possible for any device to complete
 * any self tests initiated by the SCSI reset sent out by HA attach routine.
 * 
 */

#include <rt/pte.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/vm.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/user.h>
#include <sys/ioctl.h>
#include <sys/cmap.h>
#include <sys/uio.h>
#include <sys/tty.h>
#include <sys/mtio.h>
#include <rt/dkio.h>
#include <rtio/ioccvar.h>
#include <rtio/scsi.h>
#include <rtio/xhavar.h>
#include <rt/debug.h>

#ifdef DEBUG
int             xxdebug = 0;
int             xxtrace = 0;
int		xxioctldebug = 0;
#endif

union scsi_cdb xx_cdbblks[NAHA][MAXSCSITARGETS][MAXSCSILUNS];
char *scsi_cmd_dasd[] =
{
	"SC0_TEST_UNIT_READY",
	"SC0_REZERO_UNIT",
	"SC0_VU/02",
	"SC0_REQUEST_SENSE",
	"SC0_FORMAT_UNIT",
	"SC0_VU/05",
	"SC0_VU/06",
	"SC0_REASSIGN_BLOCKS",
	"SC0_READ",
	"SC0_VU/09",
	"SC0_WRITE",
	"SC0_SEEK",
	"SC0_VU/0C",
	"SC0_VU/0D",
	"SC0_VU/0E",
	"SC0_VU/0F",
	"SC0_VU/10",
	"SC0_VU/11",
	"SC0_INQUIRY",
	"SC0_VU/13",
	"SC0_VU/14",
	"SC0_MODE_SELECT",
	"SC0_RESERVE",
	"SC0_RELEASE",
	"SC0_COPY",
	"SC0_VU/19",
	"SC0_MODE_SENSE",
	"SC0_START_STOP_UNIT",
	"SC0_RECEIVE_DIAGNOSTIC_RESULTS",
	"SC0_SEND_DIAGNOSTIC",
	"SC0_PREVENT_ALLOW_MEDIUM_REMOVAL",
	"SC0_RESERVED/1F",
	"SC1_VU/20",
	"SC1_VU/21",
	"SC1_VU/22",
	"SC1_VU/23",
	"SC1_VU/24",
	"SC1_READ_CAPACITY"
	"SC1_VU/26",
	"SC1_VU/27",
	"SC1_READ",
	"SC1_VU/29",
	"SC1_WRITE",
	"SC1_SEEK",
	"SC1_VU/2C",
	"SC1_VU/2D",
	"SC1_WRITE_AND_VERIFY",
	"SC1_VERIFY",
	"SC1_SEARCH_DATA_HIGH",
	"SC1_SEARCH_DATA_EQUAL",
	"SC1_SEARCH_DATA_LOW",
	"SC1_SET_LIMITS",
	"SC1_RESERVED/34",
	"SC1_RESERVED/35",
	"SC1_RESERVED/36",
	"SC1_RESERVED/37",
	"SC1_RESERVED/38",
	"SC1_COMPARE",
	"SC1_COPY_AND_VERIFY",
	"SC1_RESERVED/3B",
	"SC1_RESERVED/3C",
	"SC1_RESERVED/3D",
	"SC1_RESERVED/3E",
	"SC1_RESERVED/3F",
};
char *scsi_cmd_sasd[] =
{
	"SC0_TEST_UNIT_READY",
	"SC0_REWIND",
	"SC0_VU/02",
	"SC0_REQUEST_SENSE",
	"SC0_VU/04",
	"SC0_READ_BLOCK_LIMITS",
	"SC0_VU/06",
	"SC0_VU/07",
	"SC0_READ",
	"SC0_VU/09",
	"SC0_WRITE",
	"SC0_TRACK_SELECT",
	"SC0_VU/0C",
	"SC0_VU/0D",
	"SC0_VU/0E",
	"SC0_READ_REVERSE",
	"SC0_WRITE_FILEMARKS",
	"SC0_SPACE",
	"SC0_INQUIRY",
	"SC0_VERIFY",
	"SC0_RECOVER_BUFFERED_DATA",
	"SC0_MODE_SELECT",
	"SC0_RESERVE_UNIT",
	"SC0_RELEASE_UNIT",
	"SC0_COPY",
	"SC0_ERASE",
	"SC0_MODE_SENSE",
	"SC0_LOAD_UNLOAD",
	"SC0_RECEIVE_DIAGNOSTIC_RESULTS",
	"SC0_SEND_DIAGNOSTIC",
	"SC0_PREVENT_ALLOW_MEDIUM_REMOVAL",
	"SC0_RESERVED/1F",
};

struct scsi_cmdinfo scsi_cmdinfo[] =

{
	scsi_cmd_dasd, (sizeof(scsi_cmd_dasd) / sizeof (char *)) - 1, /* DASD COMMANDS */
	scsi_cmd_sasd, (sizeof(scsi_cmd_sasd) / sizeof (char *)) - 1, /* SASD COMMANDS */
};

int	scsi_cmdinfomax = sizeof(scsi_cmdinfo) / sizeof (struct scsi_cmdinfo) -1;
char *scsi_esense_keys[] = {
	"No sense",
	"Recovered error",
	"Not ready",
	"Medium error",
	"Hardware error",
	"Illegal request",
	"Unit attention",
	"Data protect",
	"Blank check",
	"Vendor unique",
	"Copy aborted",
	"Aborted command",
	"Equal",
	"Volume overflow",
	"Miscompare",
	"Reserved",
};

struct scsi_esense_codeinfo 
{
	char	key, code, qual;
	char *etext;
#define	XX	-1	/* Value not applicable */
#define NN	-2	/* Print the value, */
} scsi_esense_cinfo [] =
{
	XX,	0,	0,	"No additional info",
	4,	1,	0,	"No index/sector signal",
	4,	2,	0,	"No seek complete",
	4,	3,	0,	"Peripheral device write fault",
	2,	4,	0,	"LUN not ready",
	2,	4,	4,	"LUN not ready",
	4,	9,	0,	"Track following error",
	1,	12,	1,	"Write error recovered with auto realloc",
	XX,	12,	2,	"Write error auto realloc failed",
	XX,	16,	0,	"ID CRC or ECC error",
	3,	11,	0,	"Unrecovered read error",
	3,	11,	4,	"Unrecovered read error, realloc failed",
};


/* Functions predeclarations */
#include "../rtio/xxc.h"

xxprobe(struct xha_device *xi, struct xha_driver *drv, int pdt)
{
    struct xha_slave    *xs;
    struct scsi_inqblk  iqbuf;
    struct scsi_inqblk  *iq = &iqbuf;
    struct xha_slave    xstmp;
    short               lun;
    int			i;

    DEBUGF(xxtrace,
        printf("%s%d: Xxprobe: xi=%x, xi_unit=%d, xi_ctlr=%d,xi_target=%d\n",
		xi->xi_driver->xd_dname,xi->xi_unit,
                xi,xi->xi_unit,xi->xi_ctlr,xi->xi_target);
        );

    /* Walk through all possible lun's */
    for(i=0;i<3;i++)	/* Scan through 3 times, since in can take time
			   to recover after reset */
    {
	for(lun=0;lun<8;lun++)
	{
	     /* Set up a temporary slave struct */
	     xs = &xstmp;

	     xs->xs_driver  = drv;
	     xs->xs_unit    = xi->xi_unit;
	     xs->xs_ctlr    = xi->xi_ctlr;
	     xs->xs_target  = xi->xi_target;
	     xs->xs_lun     = lun;
	     xs->xs_alive   = 0;
	     xs->xs_xi      = xi;
	     xs->xs_tab.b_actf = 0;
	     xs->xs_forw    = xs->xs_back   = 0;

	    if(xxinquiry(xs,iq) != 0)
		continue;	/* Nothing there, test next lun */
	    if(iq->sinq_pdt == pdt)
		return PROBE_NOINT;
	}
	DELAY(2000);	/* Wait a while */
    }
    return PROBE_BAD;
}

xxslave(struct xha_slave *xs, struct xha_driver *drv, int pdt)
{
    struct xha_device   *xi = xs->xs_xi;
    struct scsi_inqblk  iqbuf;
    struct scsi_inqblk  *iq = &iqbuf;

    DEBUGF(xxtrace, printf("%s%d:Xxslave: xs=%x, drv=%x, pdt=%d\n",
		xs->xs_driver->xd_sname,xs->xs_unit, xs, drv, pdt););
    if(xs->xs_driver != drv)
        return 0;

    if(xi && (xxinquiry(xs, iq) == 0) && iq->sinq_pdt == pdt) {
	DEBUGF(xxtrace, printf("%s%d:Xxslave: inquiry succeded\n",
		xs->xs_driver->xd_sname,xs->xs_unit););
        return 1;
    }
    DEBUGF(xxtrace, printf("%s%d:Xxslave: inquiry failed\n",
	xs->xs_driver->xd_sname,xs->xs_unit););
    return 0;
}

xxinquiry(struct xha_slave *xs, struct scsi_inqblk *iq)
{
        iq->sinq_pdt = SCPDT_NO_LUN;
        return xxscsicmd(xs,SC0_INQUIRY,(caddr_t) iq,sizeof *iq,B_READ);
}

xxtur(struct xha_slave *xs)
{
	DEBUGF(xxtrace, printf("%s%d:Xxtur: xs=%x, lun=%d\n",
		xs->xs_driver->xd_sname, xs->xs_unit, xs, xs->xs_lun););
        return xxscsicmd(xs,SC0_TEST_UNIT_READY,0,0,B_READ);
}

xxscsicmd(struct xha_slave *xs, int cmd, caddr_t addr, long length, int read)
{
        register union scsi_cdb *scb;

        DEBUGF(xxtrace,
            printf("Xxscsicmd: xs=%x, cmd=%d, addr=%x, length=%d, read=%d\n",
                xs,cmd,addr,length,read););
        scb = xxgetscbuf(xs);
        return xxdoscsi(xs, scb, cmd, addr, length, read);
}

xxdoscsi(struct xha_slave *xs, union scsi_cdb *scb, int op, caddr_t addr,
         long length, int read)
{
    /*
     * Do a SCSI command with a provided and eventually prefilled CDB;
     */
    DEBUGF(xxtrace,
        printf("Xxdoscsi: xs=%x, scb=%x, cmd=%d, addr=%x, length=%d, read=%d\n",
            xs,scb,op,addr,length,read););
    xxfillscbuf(scb, xs->xs_lun, op, length);
    if(((*xs->xs_xi->xi_hadriver->xhc_doscsi) (xs, scb, addr, length, read)) ==
         ((XHI_CMPL << 8) + SCTS_GOOD))
    {
        return 0;
    }
    return -1;
}

union scsi_cdb *
xxgetscbuf(struct xha_slave *xs)
{
    union scsi_cdb *scp;

    scp = (union scsi_cdb *)
            &xx_cdbblks[xs->xs_ctlr][xs->xs_target][xs->xs_lun];
    bzero(scp,sizeof *scp);
    return scp;
}

#define SCSICMDGRP(op) (op>>5&7)
int scsigrplen[8] = { 6, 10, 10, 0, 0, 12, 10, 0 };
#define SCSICMDLEN(x) (scsigrplen[SCSICMDGRP(x)])

void
xxfillscbuf(union scsi_cdb *scp,int lun,int op,int xflen)
{

    switch(SCSICMDGRP(op))
    {
    case 0:
        scp->cdb_6.sc_op = op;
        scp->cdb_6.sc_lun = lun;
        scp->cdb_6.sc_xflen[0]=xflen;
        break;
    case 1:
    case 2:
        scp->cdb_10.sc_op = op;
        scp->cdb_10.sc_lun = lun;
        scp->cdb_10.sc_xflen[0] = xflen>>8;
        scp->cdb_10.sc_xflen[1] = xflen&0xFF;
        break;
    case 5:
        scp->cdb_12.sc_op = op;
        scp->cdb_12.sc_lun = lun;
        scp->cdb_12.sc_xflen[0] = xflen>>8;
        scp->cdb_12.sc_xflen[1] = xflen&0xFF;
        break;
    case 6:     /* Toshiba specific command group */
        scp->cdb_10.sc_op = op;
        scp->cdb_10.sc_lun = lun;
        break;
    default:
        printf("Unsupported scsi command group %d, op=%x\n", SCSICMDGRP(op),op);
/*      panic("SCSI op code"); */
        break;
    }
}

xxfillmspages(u_char *from, struct scsi_ms *to)
{
        u_char *fromstart = from;
        struct scsi_mspghd *pghdp;
        int bavail = 0;

        bcopy(from,(char *) to, 4); /* Copy header, beleived to be constant */
        from += 4;

        /* Copy one Block descriptor */
        bcopy(from, (char *) to->sms_hd.sm_bdarr,
                MIN(to->sms_hd.sm_bdl,sizeof(struct scsi_bd)));

        from += to->sms_hd.sm_bdl;

        while(from < (fromstart + to->sms_hd.sm_length))
        {
                pghdp = (struct scsi_mspghd *) from;
                bavail = pghdp->pghd_plen + sizeof (struct scsi_mspghd);

                switch(pghdp->pghd_pcode)
                {
                case 1:         /* errpage */
                        bcopy(from, &to->sms_erp,
                                MIN(sizeof(struct scsi_mserppage), bavail));
                        from += bavail;
                        continue;
                case 2: 	/* connpage */
                        bcopy(from, &to->sms_cop,
                                MIN(sizeof(struct scsi_msconnpage), bavail));
                        from += bavail;
                        continue;
                case 3: 	/* dadfpage */
                        bcopy(from, &to->sms_daf,
                                MIN(sizeof(struct scsi_msdadfpage), bavail));
                        from += bavail;
                        continue;
                case 4: 	/* rigidpage */
                        bcopy(from, &to->sms_rdg,
                                MIN(sizeof(struct scsi_msrigidpage), bavail));
                        from += bavail;
                        continue;
                case 8:		/* Ra cache page */
			bcopy(from, &to->sms_rac,
                                MIN(sizeof(struct scsi_msracache), bavail));
                        from += bavail;
                        continue;
                case 56: 	/* CDC Wren cache page */
                        bcopy(from, &to->sms_csh,
                                MIN(sizeof(struct scsi_mscachepage), bavail));
                        from += bavail;
                        continue;
                case 34:	/* reconnection timing page */
                        bcopy(from, &to->sms_rtc,
                                MIN(sizeof(struct scsi_rtcpage), bavail));
                        from += bavail;
                        continue;
                case 33:	/* additional error recovery page */
                        bcopy(from, &to->sms_aer,
                                MIN(sizeof(struct scsi_msaerpage), bavail));
                        from += bavail;
                        continue;
                case 32:	/* Adaptec dis/reconecct page  */
                        bcopy(from, &to->sms_atc,
                                MIN(sizeof(struct scsi_msatconnpage), bavail));
                        from += bavail;
                        continue;
                case 7:		/* Verify error recovery page */
                        bcopy(from, &to->sms_ver,
                                MIN(sizeof(struct scsi_msverpage), bavail));
                        from += bavail;
                        continue;
                case 13:	/* CD-ROM parameters page */
                        bcopy(from, &to->sms_cd,
                                MIN(sizeof(struct scsi_cdromparampage),bavail));
                        from += bavail;
                        continue;
                case 14:	/* CD-ROM audio control param page */
                        bcopy(from, &to->sms_aud,
                                MIN(sizeof(struct scsi_audioctrlpage), bavail));
                        from += bavail;
                        continue;
                default:
                        printf("Unknown mode sense page code 0x%x, length=%d bytes\n",
                                pghdp->pghd_pcode, pghdp->pghd_plen);
                        from += bavail;
                        continue;
                }
        }

}

xxioctl(struct xha_slave *xs, int cmd, caddr_t data, int flag)
{

    DEBUGF(xxioctldebug | xxtrace,
	printf("%s%d: Xxioctl: cmd = %d, data=%x\n",
	xs->xs_xi->xi_driver->xd_sname, xs->xs_unit, cmd););

    switch(cmd)
    {

    case DKIOCSSCSI: 		/* Prepare for SCSI pass through */
	if(xs->xs_ocnt != 1 || ((xs->xs_flags & XSFL_EXOPEN) == 0) )
	{
		uprintf("%s%d: Not exclusively opened\n",
			xs->xs_xi->xi_driver->xd_sname, xs->xs_unit);
		return -1;
	}
	bcopy(data,&xs->xs_cdb, sizeof xs->xs_cdb);
	/* Fill in LUN here since the user program has no notion about LUN's */
	xs->xs_cdb.cdb_6.sc_lun = xs->xs_lun; 
	xs->xs_flags |= XSFL_SPECSCSI;
	return 0;
	
    default:
	return -1;
    }
}

#ifdef DEBUG
char *
xxcstr(c)
u_char c;
{
    static char     outstr[3];
    char           *convstr = "0123456789abcdef";

    outstr[0] = convstr[(c >> 4) & 0xf];
    outstr[1] = convstr[c & 0xf];
    outstr[2] = '\0';

    return outstr;
}

void
xxhdump(cp, n)
u_char         *cp;
int             n;
{
    int             i = 0;

    while (n--)
    {
        printf("%s", xxcstr(*cp++));
        ++i;
        if ((i % 32) == 0)
        {
            printf("\n");
        }
        else
        {
            if ((i % 4) == 0)
            {
                printf(" ");
            }
        }
    }
    if (i % 32)
    {
        printf("\n");
    }
}

xxdumpscbuf(union scsi_cdb *scp)
{
    xxhdump((u_char *) scp,SCSICMDLEN(scp->cdb_6.sc_op));

    switch(SCSICMDGRP(scp->cdb_6.sc_op))
    {
        case 0:
            printf("Op=%s\nLun=%d, lbaMSB=%x, lba=%x, xflen=%d, vu1=%d, vu0=%d, flag=%d, link=%d\n",
                scsi_cmd_dasd[scp->cdb_6.sc_op],
                scp->cdb_6.sc_lun,
                scp->cdb_6.sc_lbaMSB,
                scp->cdb_6.sc_lbaMSB<<16+
                   scp->cdb_6.sc_lbarest[0]<<8+
                   scp->cdb_6.sc_lbarest[0],
                scp->cdb_6.sc_xflen[0],
                scp->cdb_6.sc_control.sc_vu1,
                scp->cdb_6.sc_control.sc_vu0,
                scp->cdb_6.sc_control.sc_flag,
                scp->cdb_6.sc_control.sc_link);
            break;
        case 1:
            printf("Op=%s\nLun=%d, reladr=%d, lba=%x, xflen=%d, vu1=%d, vu0=%d, flag=%d, link=%d\n",
                scsi_cmd_dasd[scp->cdb_10.sc_op],
                scp->cdb_10.sc_lun,
                scp->cdb_10.sc_reladr,
                scp->cdb_10.sc_lba[0]<<24+
                   scp->cdb_10.sc_lba[1]<<16+
                   scp->cdb_10.sc_lba[2]<<8+
                   scp->cdb_10.sc_lba[3],
                scp->cdb_10.sc_xflen[0]<<8+
                   scp->cdb_10.sc_xflen[1],
                scp->cdb_10.sc_control.sc_vu1,
                scp->cdb_10.sc_control.sc_vu0,
                scp->cdb_10.sc_control.sc_flag,
                scp->cdb_10.sc_control.sc_link);
            break;
        case 5:
            printf("Op=%x\nLun=%d, reladr=%d, lba=%x, xflen=%d, vu1=%d, vu0=%d, flag=%d, link=%d\n",
                scp->cdb_12.sc_op,
                scp->cdb_12.sc_lun,
                scp->cdb_12.sc_reladr,
                scp->cdb_12.sc_lba[0]<<24+
                   scp->cdb_12.sc_lba[1]<<16+
                   scp->cdb_12.sc_lba[2]<<8+
                   scp->cdb_12.sc_lba[3],
                scp->cdb_12.sc_xflen[0]<<8+
                   scp->cdb_12.sc_xflen[1],
                scp->cdb_12.sc_control.sc_vu1,
                scp->cdb_12.sc_control.sc_vu0,
                scp->cdb_12.sc_control.sc_flag,
                scp->cdb_12.sc_control.sc_link);
            break;
        default:
            printf("Invalid SCSI CMD GROUP %d op=%x\n",SCSICMDGRP(scp->cdb_6.sc_op)
,scp->cdb_6.sc_op);
            break;
    }
}
#endif DEBUG


#endif NCS || NXT || NCD
