/*
 *	isofs_util.c,v 1.7 1993/10/28 17:38:48 ws Exp
 */
#include "types.h"

#include "iso.h"

int
isonum_711 (p)
unsigned char *p;
{
	return (*p);
}

int
isonum_712 (p)
signed char *p;
{
	return (*p);
}

int
isonum_721 (p)
unsigned char *p;
{
	return *p|((char)p[1] << 8);
}

int
isonum_722 (p)
unsigned char *p;
{
	return ((char)*p << 8)|p[1];
}

int
isonum_723 (p)
unsigned char *p;
{
	return isonum_721(p);
}

int
isonum_731 (p)
unsigned char *p;
{
	return *p|(p[1] << 8)|(p[2] << 16)|(p[3] << 24);
}

int
isonum_732 (p)
unsigned char *p;
{
	return (*p << 24)|(p[1] << 16)|(p[2] << 8)|p[3];
}

int
isonum_733 (p)
unsigned char *p;
{
	return isonum_731(p);
}

/*
 * translate and compare a filename
 * Note: Version number plus ';' may be omitted.
 */
int
isofncmp(unsigned char *fn,int fnlen,unsigned char *isofn,int isolen)
{
	int i, j;
	char c;
	
	while (--fnlen >= 0) {
		if (--isolen < 0)
			return *fn;
		if ((c = *isofn++) == ';') {
			switch (*fn++) {
			default:
				return *--fn;
			case 0:
				return 0;
			case ';':
				break;
			}
			for (i = 0; --fnlen >= 0; i = i * 10 + *fn++ - '0') {
				if (*fn < '0' || *fn > '9') {
					return -1;
				}
			}
			for (j = 0; --isolen >= 0; j = j * 10 + *isofn++ - '0');
			return i - j;
		}
		if (c != *fn) {
			if (c >= 'A' && c <= 'Z') {
				if (c + ('a' - 'A') != *fn) {
					if (*fn >= 'a' && *fn <= 'z')
						return *fn - ('a' - 'A') - c;
					else
						return *fn - c;
				}
			} else
				return *fn - c;
		}
		fn++;
	}
	if (isolen > 0) {
		switch (*isofn) {
		default:
			return -1;
		case '.':
			if (isofn[1] != ';')
				return -1;
		case ';':
			return 0;
		}
	}
	return 0;
}

/*
 * translate a filename
 */
void
isofntrans(unsigned char *infn,int infnlen,
	   unsigned char *outfn,unsigned short *outfnlen,
	   int original,int assoc)
{
	int fnidx = 0;
	
	if (assoc) {
		*outfn++ = ASSOCCHAR;
		fnidx++;
	}
	for (; fnidx < infnlen; fnidx++) {
		char c = *infn++;
		
		if (!original && c >= 'A' && c <= 'Z')
			*outfn++ = c + ('a' - 'A');
		else if (!original && c == '.' && *infn == ';')
			break;
		else if (!original && c == ';')
			break;
		else
			*outfn++ = c;
	}
	*outfnlen = fnidx;
}
