/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution is only permitted until one year after the first shipment
 * of 4.4BSD by the Regents.  Otherwise, redistribution and use in source and
 * binary forms are permitted provided that: (1) source distributions retain
 * this entire copyright notice and comment, and (2) distributions including
 * binaries display the following acknowledgement:  This product includes
 * software developed by the University of California, Berkeley and its
 * contributors'' in the documentation or other materials provided with the
 * distribution and in all advertising materials mentioning features or use
 * of this software.  Neither the name of the University nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)vfs_conf.c	7.3 (Berkeley) 6/28/90
 */

#include "param.h"
#include "mount.h"

/*
 * This specifies the filesystem used to mount the root.
 * This specification should be done by /etc/config.
 */
extern int ufs_mountroot();
int (*mountroot)() = ufs_mountroot;

/*
 * These define the root filesystem and device.
 */
struct mount *rootfs;
struct vnode *rootdir;

/*
 * Set up the filesystem operations for vnodes.
 * The types are defined in mount.h.
 */

#define	FFS				/* always present in Reno */
#ifdef FFS
extern	struct vfsops ufs_vfsops;
#define	UFS_VFSOPS	&ufs_vfsops
#else
#define	UFS_VFSOPS	NULL
#endif

#ifdef LFS
extern	struct vfsops lfs_vfsops;
#define	LFS_VFSOPS	&lfs_vfsops
#else
#define	LFS_VFSOPS	NULL
#endif

#ifdef MFS
extern	struct vfsops mfs_vfsops;
#define	MFS_VFSOPS	&mfs_vfsops
#else
#define	MFS_VFSOPS	NULL
#endif

#ifdef NFS
extern	struct vfsops nfs_vfsops;
#define	NFS_VFSOPS	&nfs_vfsops
#else
#define	NFS_VFSOPS	NULL
#endif

#ifdef LOFS
extern	struct vfsops lofs_vfsops;
#define	LOFS_VFSOPS	&lofs_vfsops
#else
#define	LOFS_VFSOPS	NULL
#endif

#ifdef FDESC
extern	struct vfsops fdesc_vfsops;
#define	FDESC_VFSOPS	&fdesc_vfsops
#else
#define	FDESC_VFSOPS	NULL
#endif

#ifdef PORTAL
extern	struct vfsops portal_vfsops;
#define	PORTAL_VFSOPS	&portal_vfsops
#else
#define	PORTAL_VFSOPS	NULL
#endif

#ifdef NULLFS
extern	struct vfsops null_vfsops;
#define NULL_VFSOPS	&null_vfsops
#else
#define NULL_VFSOPS	NULL
#endif

#ifdef UMAPFS
extern	struct vfsops umap_vfsops;
#define UMAP_VFSOPS	&umap_vfsops
#else
#define UMAP_VFSOPS	NULL
#endif

#ifdef KERNFS
extern	struct vfsops kernfs_vfsops;
#define KERNFS_VFSOPS	&kernfs_vfsops
#else
#define KERNFS_VFSOPS	NULL
#endif

#ifdef ISOFS
extern	struct vfsops isofs_vfsops;
#define ISOFS_VFSOPS	&isofs_vfsops
#else
#define ISOFS_VFSOPS	NULL
#endif

#ifdef MSDOSFS
extern	struct vfsops msdosfs_vfsops;
#define MSDOSFS_VFSOPS	&msdosfs_vfsops
#else
#define MSDOSFS_VFSOPS	NULL
#endif

struct vfsops *vfssw[] = {
	NULL,			/* 0 = MOUNT_NONE */
	UFS_VFSOPS,		/* 1 = MOUNT_UFS */
	NFS_VFSOPS,		/* 2 = MOUNT_NFS */
	MFS_VFSOPS,		/* 3 = MOUNT_MFS */
	MSDOSFS_VFSOPS,		/* 4 = MOUNT_MSDOS */
	ISOFS_VFSOPS,		/* 5 = MOUNT_ISOFS */
	KERNFS_VFSOPS,		/* 6 = MOUNT_KERNFS */
	LFS_VFSOPS,		/* 7 = MOUNT_LFS */
	LOFS_VFSOPS,		/* 8 = MOUNT_LOFS */
	FDESC_VFSOPS,		/* 9 = MOUNT_FDESC */
	PORTAL_VFSOPS,		/* 10 = MOUNT_PORTAL */
	NULL_VFSOPS,		/* 11 = MOUNT_NULL */
	UMAP_VFSOPS,		/* 12 = MOUNT_UMAP */
	0
};
