/*
 * Written by Paul Popelka (paulp@uts.amdahl.com)
 * 
 * You can do anything you want with this software, just don't say you wrote
 * it, and don't remove this notice.
 * 
 * This software is provided "as is".
 * 
 * The author supplies this software to be publicly redistributed on the
 * understanding that the author is not responsible for the correct
 * functioning of this software in any circumstances and is not liable for
 * any damages caused by this software.
 * 
 * October 1992
 * 
 *	$Id: bpb.h,v 1.1 1993/08/13 11:35:30 cgd Exp $
 */

/*
 * BIOS Parameter Block (BPB) for DOS 3.3
 */
struct bpb33 {
	u_short bpbBytesPerSec;	/* bytes per sector */
	u_char bpbSecPerClust;	/* sectors per cluster */
	u_short bpbResSectors;	/* number of reserved sectors */
	u_char bpbFATs;		/* number of FATs */
	u_short bpbRootDirEnts;	/* number of root directory entries */
	u_short bpbSectors;	/* total number of sectors */
	u_char bpbMedia;	/* media descriptor */
	u_short bpbFATsecs;	/* number of sectors per FAT */
	u_short bpbSecPerTrack;	/* sectors per track */
	u_short bpbHeads;	/* number of heads */
	u_short bpbHiddenSecs;	/* number of hidden sectors */
};

/*
 * BPB for DOS 5.0 The difference is bpbHiddenSecs is a short for DOS 3.3,
 * and bpbHugeSectors is not in the 3.3 bpb.
 */
struct bpb50 {
	u_short bpbBytesPerSec;	/* bytes per sector */
	u_char bpbSecPerClust;	/* sectors per cluster */
	u_short bpbResSectors;	/* number of reserved sectors */
	u_char bpbFATs;		/* number of FATs */
	u_short bpbRootDirEnts;	/* number of root directory entries */
	u_short bpbSectors;	/* total number of sectors */
	u_char bpbMedia;	/* media descriptor */
	u_short bpbFATsecs;	/* number of sectors per FAT */
	u_short bpbSecPerTrack;	/* sectors per track */
	u_short bpbHeads;	/* number of heads */
	u_long bpbHiddenSecs;	/* number of hidden sectors */
	u_long bpbHugeSectors;	/* number of sectrs if bpbSectors == 0 */
};

/*
 * The following structures represent how the bpb's look on disk.  shorts
 * and longs are just character arrays of the appropriate length.  This is
 * because the compiler forces shorts and longs to align on word or
 * halfword boundaries.
 */
#include <machine/endian.h>
#if BYTE_ORDER == LITTLE_ENDIAN
#define	getushort(x)	*((u_short *)(x))
#define	getulong(x)	*((u_long *)(x))
#define	putushort(p, v)	(*((u_short *)(p)) = (v))
#define	putulong(p, v)	(*((u_long *)(p)) = (v))
#define ShortToMachine(x)	x
#define MachineToShort(x)	x
#define LongToMachine(x)	x
#define MachineToLong(x)	x
#else
extern u_short getushort(u_char *);
extern u_long  getulong(u_char *);
extern putushort(u_char *, u_short);
extern putulong(u_char *, u_long);
extern u_short ShortToMachine(u_short);
extern u_short MachineToShort(u_short);
extern u_long  LongToMachine(u_long);
extern u_long  MachineToLong(u_long);
#endif

/*
 * BIOS Parameter Block (BPB) for DOS 3.3
 */
struct byte_bpb33 {
	u_char bpbBytesPerSec[2];	/* bytes per sector */
	u_char bpbSecPerClust;		/* sectors per cluster */
	u_char bpbResSectors[2];	/* number of reserved sectors */
	u_char bpbFATs;			/* number of FATs */
	u_char bpbRootDirEnts[2];	/* number of root directory entries */
	u_char bpbSectors[2];		/* total number of sectors */
	u_char bpbMedia;		/* media descriptor */
	u_char bpbFATsecs[2];		/* number of sectors per FAT */
	u_char bpbSecPerTrack[2];	/* sectors per track */
	u_char bpbHeads[2];		/* number of heads */
	u_char bpbHiddenSecs[2];	/* number of hidden sectors */
};

/*
 * BPB for DOS 5.0 The difference is bpbHiddenSecs is a short for DOS 3.3,
 * and bpbHugeSectors is not in the 3.3 bpb.
 */
struct byte_bpb50 {
	u_char bpbBytesPerSec[2];	/* bytes per sector */
	u_char bpbSecPerClust;		/* sectors per cluster */
	u_char bpbResSectors[2];	/* number of reserved sectors */
	u_char bpbFATs;			/* number of FATs */
	u_char bpbRootDirEnts[2];	/* number of root directory entries */
	u_char bpbSectors[2];		/* total number of sectors */
	u_char bpbMedia;		/* media descriptor */
	u_char bpbFATsecs[2];		/* number of sectors per FAT */
	u_char bpbSecPerTrack[2];	/* sectors per track */
	u_char bpbHeads[2];		/* number of heads */
	u_char bpbHiddenSecs[4];	/* number of hidden sectors */
	u_char bpbHugeSectors[4];	/* number of sectrs if bpbSectors == 0*/
};
