#include <sys/types.h>
#include <machine/endian.h>

#if BYTE_ORDER == BIG_ENDIAN

#define	BYTE(x)	((x) & 0xff)

u_short getushort(p)
u_char *p;
{
    return((u_short)(BYTE(*p) + (BYTE(*(p+1))<<8)));
}

putushort(p, v)
u_char *p;
u_short v;
{
    *p     = (u_char)(BYTE(v));		/* low byte */
    *(p+1) = (u_char)(BYTE(v>>8));	/* high byte */
}

u_long getulong(p)
u_char *p;
{
    return((u_long)(BYTE(*p) + (BYTE(*(p+1))<<8)  +
			       (BYTE(*(p+2))<<16) +
   			       (BYTE(*(p+3))<<24)));
}

putulong(p, v)
u_char *p;
u_long v;
{
    *p     = (u_char)(BYTE(v));		/* low byte */
    *(p+1) = (u_char)(BYTE(v>>8));
    *(p+2) = (u_char)(BYTE(v>>16));
    *(p+3) = (u_char)(BYTE(v>>24));	/* high byte */
}

u_short ShortToMachine(v)
u_short v;
{
    return((u_short)((BYTE(v)<<8) + (BYTE(v>>8))));
}

u_short MachineToShort(v)
u_short v;
{
    return((u_short)((BYTE(v)<<8) + (BYTE(v>>8))));
}

u_long LongToMachine(v)
u_long v;
{
    return((u_long)((BYTE(v)<<24) +
		   ((BYTE(v>>8))<<16) +
		   ((BYTE(v>>16))<<8) +
		    (BYTE(v>>24))));
}

u_long MachineToLong(v)
u_long v;
{
    return((u_long)((BYTE(v)<<24) +
		   ((BYTE(v>>8))<<16) +
		   ((BYTE(v>>16))<<8) +
		    (BYTE(v>>24))));
}
#endif
