/*
 * Copyright (c) 1982, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if_ethersubr.c	8.1 (Berkeley) 6/10/93
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <sys/syslog.h>

#include <machine/cpu.h>

#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <net/if_llc.h>
#include <net/if_dl.h>
#include <net/if_types.h>

#ifdef INET
#include <netinet/in.h>
#include <netinet/in_var.h>
#endif
#include <netinet/if_ether.h>
#include <netinet/if_802_5.h>

#ifdef NS
#include <netns/ns.h>
#include <netns/ns_if.h>
#endif

#ifdef ISO
#include <netiso/argo_debug.h>
#include <netiso/iso.h>
#include <netiso/iso_var.h>
#include <netiso/iso_snpac.h>
#endif

#ifdef LLC
#include <netccitt/dll.h>
#include <netccitt/llc_var.h>
#endif

#if defined(LLC) && defined(CCITT)
extern struct ifqueue pkintrq;
#endif

extern	struct ifnet loif;
#define senderr(e) { error = (e); goto bad;}

/*
 * generic token-ring output routine.
 * Encapsulate a packet of type family for the local net.
 * Assumes that ifp is actually pointer to arpcom structure.
 */

token_output(ifp, m0, dst, rt0)
        register struct ifnet *ifp;
        struct mbuf *m0;
        struct sockaddr *dst;
        struct rtentry *rt0;
{
        short type;
        int s, error = 0;
        u_char edst[24];	/* room for hdwr address + routing bytes */
        struct in_addr idst;
        register struct mbuf *m = m0;
	register struct rtentry *rt;
        struct mbuf *mcopy = (struct mbuf *)0;
        int usetrailers; /* not used */
        u_short rcf = 0;
        u_short rseg[MAX_BRIDGE];
        register struct mac_hdr *mac;
        register struct llc *llc;
        int i, ri_len, hdr_len, llc_len;
	struct arpcom *ac = (struct arpcom *)ifp;

        if ((ifp->if_flags & (IFF_UP|IFF_RUNNING)) != (IFF_UP|IFF_RUNNING)) 
		senderr(ENETDOWN);
        ifp->if_lastchange = time;
	if (rt = rt0) {
		if ((rt->rt_flags & RTF_UP) == 0) {
			if (rt0 = rt = rtalloc1(dst, 1))
				rt->rt_refcnt--;
			else 
				senderr(EHOSTUNREACH);
		}
		if (rt->rt_flags & RTF_GATEWAY) {
			if (rt->rt_gwroute == 0)
				goto lookup;
			if (((rt = rt->rt_gwroute)->rt_flags & RTF_UP) == 0) {
				rtfree(rt); rt = rt0;
			lookup: rt->rt_gwroute = rtalloc1(rt->rt_gateway, 1);
				if ((rt = rt->rt_gwroute) == 0)
					senderr(EHOSTUNREACH);
			}
		}
		if (rt->rt_flags & RTF_REJECT)
			if (rt->rt_rmx.rmx_expire == 0 ||
			    time.tv_sec < rt->rt_rmx.rmx_expire)
				senderr(rt == rt0 ? EHOSTDOWN : EHOSTUNREACH);
	}

        switch (dst->sa_family) {

#ifdef INET
	case AF_INET:
		bzero((caddr_t)edst, sizeof(edst));
		if (!arpresolve(ac, rt, m, dst, edst))
			return (0);	/* if not yet resolved */
		/* If broadcasting on a simplex interface, loopback a copy */
		if ((m->m_flags & M_BCAST) && (ifp->if_flags & IFF_SIMPLEX))
			mcopy = m_copy(m, 0, (int)M_COPYALL);
                type = ETHERTYPE_IP;
		llc_len = LLC_SNAPLEN;

		/* routing info is stored with the hardware address.  Copy
		 * it off now.... (XXX: change this later to avoid double copy)
		 */
		bcopy((caddr_t)edst + IE8025_ADDRLEN, (caddr_t)&rcf, sizeof (short));
		bcopy((caddr_t)edst + IE8025_ADDRLEN + sizeof (short), (caddr_t)rseg, MAX_BRIDGE);
		
		/*
		 * set broadcast bits and frame size in rcf, if needed.
		 * XXX: frame size should not be limited to 2k
		 */
		if ((m->m_flags & M_BCAST) && (ifp -> if_flags & IFF_ALLCAST)){
			/* all rings broadcast */
			rcf = (((sizeof(rcf)) << 8) & RCF_LEN_MASK)
				| RCF_FRAME2
				| RCF_ALL_BROADCAST; 
                }

		/* Add token-ring header */
		ri_len = rcf ? ((rcf & RCF_LEN_MASK) >> 8) : 0;
		hdr_len = MIN_MAC_HDR_SIZE + ri_len + llc_len;

		M_PREPEND(m, hdr_len, M_DONTWAIT);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}

		/* now fill the header */
		mac = mtod(m, struct mac_hdr *);
		mac->acf = ACF_PRIORITY3;
		mac->fcf = FCF_LLC_FRAME;
		bcopy((caddr_t)edst, (caddr_t)mac->to_addr, IE8025_ADDRLEN);
		bcopy((caddr_t)ac->ac_enaddr, (caddr_t)mac->from_addr, IE8025_ADDRLEN); 

		if (rcf) {
			mac->from_addr[0] |= RI_PRESENT;
			mac->rcf = rcf;
			bcopy ((caddr_t) rseg, mac->rseg, (ri_len - sizeof(rcf)));
		}
		llc = (struct llc *)((int)(mac) + MIN_MAC_HDR_SIZE + ri_len);

		llc->llc_dsap = LLC_SNAP_LSAP;
		llc->llc_ssap = LLC_SNAP_LSAP;
		for (i=0; i<3; i++) {
			llc->llc_org_code[i] = 0;
		}
		llc->llc_ether_type = type;
		llc->llc_control = LLC_UI;	/* XXX */
		break;
#endif

	/* 
	 * we expect to be passed a *completed* header here (mac + llc) in
	 * a sockaddr_dl (actually sockaddr_dl_8025, which has enough room).
	 */
        case AF_UNSPEC:
	    {
		register caddr_t hdrp, hdrp2;

		hdrp = LLADDR((struct sockaddr_dl *) dst);
		hdr_len = ((struct sockaddr_dl *) dst) -> sdl_alen;

		M_PREPEND(m, hdr_len, M_DONTWAIT);
		if (m == 0) {
		    error = ENOBUFS;
		    goto bad;
		}

		/* now fill the header */
		hdrp2 = mtod(m, caddr_t);
		bcopy(hdrp, hdrp2, hdr_len);
                break;
	    }

        default:
                printf("%s%d: can't handle af%d\n", ifp->if_name, ifp->if_unit,
                        dst->sa_family);
                error = EAFNOSUPPORT;
                goto bad;
	}

        /*
         * Queue message on interface, and start output if interface
         * not yet active.
         */
        s = splimp();
        if (IF_QFULL(&ifp->if_snd)) {
                IF_DROP(&ifp->if_snd);
                splx(s);
                error = ENOBUFS;
                goto bad;
        }
        IF_ENQUEUE(&ifp->if_snd, m);
        if ((ifp->if_flags & IFF_OACTIVE) == 0)
                (*ifp->if_start)(ifp);
        splx(s);
        if (mcopy)
                (void) looutput(&loif, mcopy, dst, rt);
        if (edst[0] & 1)
                ifp->if_omcasts++;
        return (error);

bad:
        if (mcopy)
                m_freem(mcopy);
        if (m)
                m_freem(m);
	return (error);
}

/*
 * Process a received Token-ring packet;
 * the packet is in the mbuf chain m without
 * the ether header, which is provided separately.
 *
 * TODO: deal with test & XID requests, etc.
 */
token_input(ifp, mac, m)
        struct ifnet *ifp;
        struct mac_hdr *mac;
        struct mbuf *m;
{
        register struct ifqueue *inq;
        register struct llc *llc;
	int ri_len, mac_hdr_len, snap_len, layer1_hdr_len;
	char type;
        int s;

        if ((ifp->if_flags & IFF_UP) == 0) {
                m_freem(m);
                return;
        }
        ifp->if_lastchange = time;
	ri_len = HAS_ROUTE(mac) ? ROUTE_BYTES(mac) : 0;
        ifp->if_ibytes += m->m_pkthdr.len + MIN_MAC_HDR_SIZE + ri_len;
        if (bcmp((caddr_t)etherbroadcastaddr, (caddr_t)mac->to_addr,
            sizeof(etherbroadcastaddr)) == 0)
                m->m_flags |= M_BCAST;
        else if (mac->to_addr[0] & 1)
                m->m_flags |= M_MCAST;
        if (m->m_flags & (M_BCAST|M_MCAST))
                ifp->if_imcasts++;

	llc = mtod(m, struct llc *);
	switch (llc->llc_dsap) {

	case LLC_SNAP_LSAP:

		/* XXX: remove snap-llc header */
		m->m_data += LLC_SNAPLEN;
		m->m_len -= LLC_SNAPLEN;
		m->m_pkthdr.len -= LLC_SNAPLEN;

		switch (llc->llc_ether_type) {
#ifdef INET
		case ETHERTYPE_IP:
			schednetisr(NETISR_IP);
			inq = &ipintrq;
			break;

		case ETHERTYPE_ARP:
		    {
			struct mac_hdr *macp;

			/*
 			 * XXX: in the arp handling routine, we MUST
			 *	bring with us the routing info.
			 *	we could just copy the routing bytes,
			 *	and not the whole header, but we'll keep
			 *	it simple and easy to understand for now....
			 */
			M_PREPEND(m, sizeof (struct mac_hdr), M_DONTWAIT);
			if (m == 0) {
				goto dropanyway;
			}

			/* now copy the header */
			macp = mtod(m, struct mac_hdr *);
			bcopy((caddr_t)mac, (caddr_t)macp, sizeof (struct mac_hdr));

			schednetisr(NETISR_ARP);
			inq = &arpintrq;
			break;
		    }
		default:
			goto dropanyway;
#endif
		}
		break;

	default:
dropanyway:;
		m_freem(m);
		return;
	}

        s = splimp();
        if (IF_QFULL(inq)) {
                IF_DROP(inq);
                m_freem(m);
        } else 
                IF_ENQUEUE(inq, m);
        splx(s);
}

/*
 * Perform common duties while attaching to interface list
 */
void
token_ifattach(ifp)
	register struct ifnet *ifp;
{
	register struct ifaddr *ifa;
	register struct sockaddr_dl *sdl;

	ifp->if_type = IFT_ISO88025;
	ifp->if_addrlen = IE8025_ADDRLEN;
	ifp->if_hdrlen = 40;	/* XXX: mac + snap-llc */
	ifp->if_mtu = IE8025_MTU;
	for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next)
		if ((sdl = (struct sockaddr_dl *)ifa->ifa_addr) &&
		    sdl->sdl_family == AF_LINK) {
			sdl->sdl_type = IFT_ISO88025;
			sdl->sdl_alen = ifp->if_addrlen;
			bcopy((caddr_t)((struct arpcom *)ifp)->ac_enaddr,
			      LLADDR(sdl), ifp->if_addrlen);
			break;
		}
}

dump_bytes (len, s)
int len;
char *s;
{
    register char *cp = s;
    register int i;

    printf ("dump_bytes: len=%d, cp=0x%x\n", len, cp);
    for (i = 0; i < len; i++)
	    printf ("%x ", cp[i]);
    printf ("\n");
}
