/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/netinet/RCS/if_lan.h,v 1.1 1992/04/03 00:14:09 md Exp $ */
/* $ACIS:if_lan.h 12.0$ */
/* $Source: /usr/src/sys/netinet/RCS/if_lan.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidif_lan = "$Header: /usr/src/sys/netinet/RCS/if_lan.h,v 1.1 1992/04/03 00:14:09 md Exp $";
#endif


/* Bridge and routing field parameters */
#define ACF_PRIORITY3           0x00    /* priority level 3             */
#define ACF_TOKEN               0x10    /* token                        */
#define FCF_LLC_FRAME           0x40    /* for frame control field      */
#define RCF_ALL_BROADCAST       0x8000  /* all routes broadcast         */
#define RCF_LOCAL_BROADCAST     0x4000  /* single route broadcast       */
#define RCF_DIRECTION           0x0080  /* direction                    */
#define RCF_FRAME0              0x0000  /*  516 max LLC pkt             */
#define RCF_FRAME0_MAX          516
#define RCF_FRAME1              0x0010  /* 1500 max LLC pkt             */
#define RCF_FRAME1_MAX          1500
#define RCF_FRAME2              0x0020  /* 2052 max LLC pkt             */
#define RCF_FRAME2_MAX          2052
#define RCF_FRAME3              0x0030  /* 4472 max LLC pkt             */
#define RCF_FRAME3_MAX          4472
#define RCF_FRAME4              0x0040  /* 8144 max LLC pkt             */
#define RCF_FRAME4_MAX          8144
#define RCF_FRAME5              0x0050  /* 11407 max LLC pkt            */
#define RCF_FRAME5_MAX          11407
#define RCF_FRAME6              0x0060  /* 17800 max LLC pkt            */
#define RCF_FRAME6_MAX          17800
#define RCF_FRAME_MASK          0x0070  /* mask for frame bits          */
#define RI_PRESENT              0x80    /* turn on bit 0 of byte 0 src addr */

#define MAX_BRIDGE		8	/* maximum hop count */
#define RCF_LEN_MASK 		0x1f00	/* length field in routing control */

#define IE8025_ADDRLEN	6	/* address size */
#define IE8025_MTU	1492	/* Default maximum transmission unit */

#define IFF_ALLCAST	IFF_LINK0

/* Lan header includes control fields, source and destination
 addresses, and llc fields: */
struct mac_hdr {
	char acf;
	char fcf;
	char to_addr[IE8025_ADDRLEN];
	char from_addr[IE8025_ADDRLEN];
	unsigned short rcf;
	unsigned short rseg[MAX_BRIDGE];
};

#define MIN_MAC_HDR_SIZE 14	/* mac header size if no routing info */

#define ROUTE_BYTES(mac)        (((mac)->rcf & RCF_LEN_MASK) >> 8)
#define HAS_ROUTE(mac)          ((mac)->from_addr[0] & RI_PRESENT)
#define MAC_SIZE(mac) \
	(MIN_MAC_HDR_SIZE + (HAS_ROUTE(mac) ? ROUTE_BYTES(mac) : 0))

/*
 * 802.5 data-link sockaddr.  Contains enough room for complete mac + llc.
 * use "real" sockaddr_dl for casting.  This one for easy size calculations.
 */
struct sockaddr_dl_8025 {
	u_char	sdl_len;	/* Total length of sockaddr */
	u_char	sdl_family;	/* AF_DLI */
	u_short	sdl_index;	/* if != 0, system given index for interface */
	u_char	sdl_type;	/* interface type */
	u_char	sdl_nlen;	/* interface name length, no trailing 0 reqd. */
	u_char	sdl_alen;	/* link level address length */
	u_char	sdl_slen;	/* link layer selector length */
	char	sdl_data[46];	/* minimum work area, can be larger;
				   contains both if name and ll address */
};

