/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtcons/RCS/ega_init.h,v 1.1 1990/10/10 20:40:56 rayan Exp $ */
/* $ACIS:ega_init.h 12.0$ */
/* $Source: /usr/src/sys/rtcons/RCS/ega_init.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidega_init = "$Header: /usr/src/sys/rtcons/RCS/ega_init.h,v 1.1 1990/10/10 20:40:56 rayan Exp $";
#endif


/*
 * initialization arrays for ega modes on the RT
 */

volatile char ega_tmp;

/* flag to say read from register rather than write to */
#define READ	0

/* initialization structure */
struct ega_reg {
	volatile char *addr_addr; /* base address of address register */
	volatile char *io_addr;	 /* data register */
	char reg_addr;	 /* value to be stuffed into addr_addr */
	char value;	 /* value to be stuffed into io_addr */
};


/*
 * EGA Enhanced display alpha/numeric mode (mode 3*)
 */
struct ega_reg ega_reg_3star[] = {
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x01},	/* Reset */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x01,	0x01},	/* Clock Mode */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x02,	0x03},	/* Map Mask */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x03,	0x00},	/* Char Gen Sel */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x04,	0x03},	/* Memory Mode */
	{MISCELLANEOUS, &ega_tmp,	0xa7,	0x00},
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x03},	/* Reset */
	{CRT_ADDR,	CRT_REG,	0x00,	0x5b},	/* Horiz Total */
	{CRT_ADDR,	CRT_REG,	0x01,	0x4f},	/* Hrz Disp End */
	{CRT_ADDR,	CRT_REG,	0x02,	0x53},	/* Strt Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x03,	0x37},	/* End Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x04,	0x51},	/* Strt Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x05,	0x5b},	/* End Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x06,	0x6c},	/* Vert Total */
	{CRT_ADDR,	CRT_REG,	0x07,	0x1f},	/* Overflow */
	{CRT_ADDR,	CRT_REG,	0x08,	0x00},	/* Preset Row SC */
	{CRT_ADDR,	CRT_REG,	0x09,	0x0d},	/* Max Scan Line */
	{CRT_ADDR,	CRT_REG,	0x0a,	0x0b},	/* Cursor Start */
	{CRT_ADDR,	CRT_REG,	0x0b,	0x0c},	/* Cursor End */
	{CRT_ADDR,	CRT_REG,	0x0c,	0x00},	/* Strt Addr Hi */ 
	{CRT_ADDR,	CRT_REG,	0x0d,	0x00},	/* Strt Addr Lo */
	{CRT_ADDR,	CRT_REG,	0x0e,	0x00},	/* Cursor LC Hi */
	{CRT_ADDR,	CRT_REG,	0x0f,	0x00},	/* Cursor LC Lo */
	{CRT_ADDR,	CRT_REG,	0x10,	0x5e},	/* Vrt Retr Strt */
	{CRT_ADDR,	CRT_REG,	0x11,	0x2b},	/* Vrt Retr End */
	{CRT_ADDR,	CRT_REG,	0x12,	0x5d},	/* Vrt Disp End */
	{CRT_ADDR,	CRT_REG,	0x13,	0x28},	/* Offset */
	{CRT_ADDR,	CRT_REG,	0x14,	0x0f},	/* Underline Loc */
	{CRT_ADDR,	CRT_REG,	0x15,	0x5e},	/* Strt Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x16,	0x0a},	/* End Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x17,	0xa3},	/* Mono Control */
	{CRT_ADDR,	CRT_REG,	0x18,	0xff},	/* Line Compare */
	{READ,		ATTRIBUTE_ADDR,	0x00,	0x00},	/* reset attribute FF */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x00,	0x00},	/* Pallette 0 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x01,	0x01},	/* Pallette 1 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x02,	0x02},	/* Pallette 2 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x03,	0x03},	/* Pallette 3 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x04,	0x04},	/* Pallette 4 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x05,	0x05},	/* Pallette 5 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x06,	0x14},	/* Pallette 6 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x07,	0x07},	/* Pallette 7 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x08,	0x38},	/* Pallette 8 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x09,	0x39},	/* Pallette 9 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0a,	0x3a},	/* Pallette a */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0b,	0x3b},	/* Pallette b */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0c,	0x3c},	/* Pallette c */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0d,	0x3d},	/* Pallette d */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0e,	0x3e},	/* Pallette e */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0f,	0x3f},	/* Pallette f */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x10,	0x08},	/* Mode Control */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x11,	0x00},	/* Overscan */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x12,	0x0f},	/* Color Plane */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x13,	0x00},	/* Hrz Panning */
	{ATTRIBUTE_REG,	&ega_tmp,	0x20,	0x00},	/* enable scanning */
	{GRAPHIX_I_POS,	GRAPHIX_II_POS,	0x00,	0x01},
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x00,	0x00},	/* Set Reset */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x01,	0x00},	/* Enable S/R */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x02,	0x00},	/* Color Compare */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x03,	0x00},	/* Data Rotate */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x04,	0x00},	/* Read Map Sel */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x05,	0x10},	/* Mode Register */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x06,	0x0e},	/* Miscellaneous */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x07,	0x00},	/* Color No Care */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x08,	0xff},	/* Bit Mask */
};
/*
 * EGA mono display alpha/numeric mode (mode 7)
 */
struct ega_reg ega_reg_7[] = {
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x01},	/* Reset */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x01,	0x00},	/* Clock Mode */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x02,	0x03},	/* Map Mask */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x03,	0x00},	/* Char Gen Sel */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x04,	0x03},	/* Memory Mode */
	{MISCELLANEOUS, &ega_tmp,	0xa7,	0x00},
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x03},	/* Reset */
	{CRT_ADDR,	CRT_REG,	0x00,	0x60},	/* Horiz Total */
	{CRT_ADDR,	CRT_REG,	0x01,	0x4f},	/* Hrz Disp End */
	{CRT_ADDR,	CRT_REG,	0x02,	0x56},	/* Strt Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x03,	0x3a},	/* End Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x04,	0x51},	/* Strt Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x05,	0x60},	/* End Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x06,	0x70},	/* Vert Total */
	{CRT_ADDR,	CRT_REG,	0x07,	0x1f},	/* Overflow */
	{CRT_ADDR,	CRT_REG,	0x08,	0x00},	/* Preset Row SC */
	{CRT_ADDR,	CRT_REG,	0x09,	0x0d},	/* Max Scan Line */
	{CRT_ADDR,	CRT_REG,	0x0a,	0x0b},	/* Cursor Start */
	{CRT_ADDR,	CRT_REG,	0x0b,	0x0c},	/* Cursor End */
	{CRT_ADDR,	CRT_REG,	0x0c,	0x00},	/* Strt Addr Hi */ 
	{CRT_ADDR,	CRT_REG,	0x0d,	0x00},	/* Strt Addr Lo */
	{CRT_ADDR,	CRT_REG,	0x0e,	0x00},	/* Cursor LC Hi */
	{CRT_ADDR,	CRT_REG,	0x0f,	0x00},	/* Cursor LC Lo */
	{CRT_ADDR,	CRT_REG,	0x10,	0x5e},	/* Vrt Retr Strt */
	{CRT_ADDR,	CRT_REG,	0x11,	0x2e},	/* Vrt Retr End */
	{CRT_ADDR,	CRT_REG,	0x12,	0x5d},	/* Vrt Disp End */
	{CRT_ADDR,	CRT_REG,	0x13,	0x28},	/* Offset */
	{CRT_ADDR,	CRT_REG,	0x14,	0x0d},	/* Underline Loc */
	{CRT_ADDR,	CRT_REG,	0x15,	0x5e},	/* Strt Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x16,	0x6e},	/* End Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x17,	0xa3},	/* Mono Control */
	{CRT_ADDR,	CRT_REG,	0x18,	0xff},	/* Line Compare */
	{READ,		ATTRIBUTE_ADDR,0x00,	0x00},	/* reset attribute FF */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x00,	0x00},	/* Pallette 0 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x01,	0x08},	/* Pallette 1 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x02,	0x08},	/* Pallette 2 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x03,	0x08},	/* Pallette 3 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x04,	0x08},	/* Pallette 4 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x05,	0x08},	/* Pallette 5 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x06,	0x08},	/* Pallette 6 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x07,	0x08},	/* Pallette 7 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x08,	0x10},	/* Pallette 8 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x09,	0x18},	/* Pallette 9 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0a,	0x18},	/* Pallette a */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0b,	0x18},	/* Pallette b */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0c,	0x18},	/* Pallette c */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0d,	0x18},	/* Pallette d */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0e,	0x18},	/* Pallette e */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0f,	0x18},	/* Pallette f */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x10,	0x0e},	/* Mode Control */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x11,	0x00},	/* Overscan */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x12,	0x0f},	/* Color Plane */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x13,	0x08},	/* Hrz Panning */
	{ATTRIBUTE_REG,	&ega_tmp,	0x20,	0x00},	/* enable scanning */
	{GRAPHIX_I_POS,	GRAPHIX_II_POS,	0x00,	0x01},
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x00,	0x00},	/* Set Reset */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x01,	0x00},	/* Enable S/R */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x02,	0x00},	/* Color Compare */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x03,	0x00},	/* Data Rotate */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x04,	0x00},	/* Read Map Sel */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x05,	0x10},	/* Mode Register */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x06,	0x0e},	/* Miscellaneous */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x07,	0x00},	/* Color No Care */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x08,	0xff},	/* Bit Mask */
};

/*
 * EGA color display alpha/numeric mode (mode 3)
 */
struct ega_reg ega_reg_3[] = {
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x01},	/* Reset */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x01,	0x01},	/* Clock Mode */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x02,	0x03},	/* Map Mask */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x03,	0x00},	/* Char Gen Sel */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x04,	0x03},	/* Memory Mode */
	{MISCELLANEOUS, &ega_tmp,	0xa3,	0x00},
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x03},	/* Reset */
	{CRT_ADDR,	CRT_REG,	0x00,	0x70},	/* Horiz Total */
	{CRT_ADDR,	CRT_REG,	0x01,	0x4f},	/* Hrz Disp End */
	{CRT_ADDR,	CRT_REG,	0x02,	0x5C},	/* Strt Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x03,	0x2f},	/* End Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x04,	0x5f},	/* Strt Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x05,	0x07},	/* End Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x06,	0x04},	/* Vert Total */
	{CRT_ADDR,	CRT_REG,	0x07,	0x11},	/* Overflow */
	{CRT_ADDR,	CRT_REG,	0x08,	0x00},	/* Preset Row SC */
	{CRT_ADDR,	CRT_REG,	0x09,	0x07},	/* Max Scan Line */
	{CRT_ADDR,	CRT_REG,	0x0a,	0x06},	/* Cursor Start */
	{CRT_ADDR,	CRT_REG,	0x0b,	0x07},	/* Cursor End */
	{CRT_ADDR,	CRT_REG,	0x0c,	0x00},	/* Strt Addr Hi */ 
	{CRT_ADDR,	CRT_REG,	0x0d,	0x00},	/* Strt Addr Lo */
	{CRT_ADDR,	CRT_REG,	0x0e,	0x00},	/* Cursor LC Hi */
	{CRT_ADDR,	CRT_REG,	0x0f,	0x00},	/* Cursor LC Lo */
	{CRT_ADDR,	CRT_REG,	0x10,	0xd5},	/* Vrt Retr Strt */
	{CRT_ADDR,	CRT_REG,	0x11,	0x24},	/* Vrt Retr End */
	{CRT_ADDR,	CRT_REG,	0x12,	0xc7},	/* Vrt Disp End */
	{CRT_ADDR,	CRT_REG,	0x13,	0x28},	/* Offset */
	{CRT_ADDR,	CRT_REG,	0x14,	0x08},	/* Underline Loc */
	{CRT_ADDR,	CRT_REG,	0x15,	0xd4},	/* Strt Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x16,	0xf0},	/* End Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x17,	0xa3},	/* Mono Control */
	{CRT_ADDR,	CRT_REG,	0x18,	0xff},	/* Line Compare */
	{READ,		ATTRIBUTE_ADDR,	0x00,	0x00},	/* reset attribute FF */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x00,	0x00},	/* Pallette 0 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x01,	0x01},	/* Pallette 1 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x02,	0x02},	/* Pallette 2 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x03,	0x03},	/* Pallette 3 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x04,	0x04},	/* Pallette 4 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x05,	0x05},	/* Pallette 5 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x06,	0x06},	/* Pallette 6 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x07,	0x07},	/* Pallette 7 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x08,	0x10},	/* Pallette 8 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x09,	0x11},	/* Pallette 9 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0a,	0x12},	/* Pallette a */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0b,	0x13},	/* Pallette b */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0c,	0x14},	/* Pallette c */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0d,	0x15},	/* Pallette d */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0e,	0x16},	/* Pallette e */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0f,	0x17},	/* Pallette f */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x10,	0x08},	/* Mode Control */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x11,	0x00},	/* Overscan */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x12,	0x0f},	/* Color Plane */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x13,	0x00},	/* Hrz Panning */
	{ATTRIBUTE_REG,	&ega_tmp,	0x20,	0x00},	/* enable pallette */
	{GRAPHIX_I_POS,	GRAPHIX_II_POS,	0x00,	0x01},
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x00,	0x00},	/* Set Reset */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x01,	0x00},	/* Enable S/R */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x02,	0x00},	/* Color Compare */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x03,	0x00},	/* Data Rotate */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x04,	0x00},	/* Read Map Sel */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x05,	0x10},	/* Mode Register */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x06,	0x0e},	/* Miscellaneous */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x07,	0x00},	/* Color No Care */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x08,	0xff},	/* Bit Mask */
};

/*
 * mode to load a font into page 2 (note this uses address 0xA0000. The AED
 * starts at 0xA4000, so fonts can only be loaded into the first two pages
 * (16K).
 */
struct ega_reg ega_reg_c[] = {
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x00},	/* Reset */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x01,	0x00},	/* Clock Mode */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x02,	0x04},	/* Map Mask */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x03,	0x00},	/* Char Gen Sel */
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x04,	0x07},	/* Memory Mode */
	{MISCELLANEOUS, &ega_tmp,	0xa6,	0x00},
	{SEQUENCE_ADDR,	SEQUENCE_REG,	0x00,	0x03},	/* Reset */
	{CRT_ADDR,	CRT_REG,	0x00,	0x60},	/* Horiz Total */
	{CRT_ADDR,	CRT_REG,	0x01,	0x4f},	/* Hrz Disp End */
	{CRT_ADDR,	CRT_REG,	0x02,	0x56},	/* Strt Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x03,	0x3a},	/* End Hrz Blk */
	{CRT_ADDR,	CRT_REG,	0x04,	0x51},	/* Strt Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x05,	0x60},	/* End Hrz Retr */
	{CRT_ADDR,	CRT_REG,	0x06,	0x70},	/* Vert Total */
	{CRT_ADDR,	CRT_REG,	0x07,	0x1f},	/* Overflow */
	{CRT_ADDR,	CRT_REG,	0x08,	0x00},	/* Preset Row SC */
	{CRT_ADDR,	CRT_REG,	0x09,	0x0d},	/* Max Scan Line */
	{CRT_ADDR,	CRT_REG,	0x0a,	0x0b},	/* Cursor Start */
	{CRT_ADDR,	CRT_REG,	0x0b,	0x0c},	/* Cursor End */
	{CRT_ADDR,	CRT_REG,	0x0c,	0x00},	/* Strt Addr Hi */ 
	{CRT_ADDR,	CRT_REG,	0x0d,	0x00},	/* Strt Addr Lo */
	{CRT_ADDR,	CRT_REG,	0x0e,	0x00},	/* Cursor LC Hi */
	{CRT_ADDR,	CRT_REG,	0x0f,	0x00},	/* Cursor LC Lo */
	{CRT_ADDR,	CRT_REG,	0x10,	0x5e},	/* Vrt Retr Strt */
	{CRT_ADDR,	CRT_REG,	0x11,	0x2e},	/* Vrt Retr End */
	{CRT_ADDR,	CRT_REG,	0x12,	0x5d},	/* Vrt Disp End */
	{CRT_ADDR,	CRT_REG,	0x13,	0x28},	/* Offset */
	{CRT_ADDR,	CRT_REG,	0x14,	0x0d},	/* Underline Loc */
	{CRT_ADDR,	CRT_REG,	0x15,	0x5e},	/* Strt Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x16,	0x6e},	/* End Vert Blk */
	{CRT_ADDR,	CRT_REG,	0x17,	0xa3},	/* Mono Control */
	{CRT_ADDR,	CRT_REG,	0x18,	0xff},	/* Line Compare */
	{READ,		ATTRIBUTE_ADDR,	0x00,	0x00},	/* reset ATTRIBUTE FF */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x00,	0x00},	/* Pallette 0 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x01,	0x00},	/* Pallette 1 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x02,	0x00},	/* Pallette 2 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x03,	0x00},	/* Pallette 3 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x04,	0x00},	/* Pallette 4 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x05,	0x00},	/* Pallette 5 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x06,	0x00},	/* Pallette 6 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x07,	0x00},	/* Pallette 7 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x08,	0x00},	/* Pallette 8 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x09,	0x00},	/* Pallette 9 */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0a,	0x00},	/* Pallette a */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0b,	0x00},	/* Pallette b */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0c,	0x00},	/* Pallette c */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0d,	0x00},	/* Pallette d */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0e,	0x00},	/* Pallette e */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x0f,	0x00},	/* Pallette f */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x10,	0x0e},	/* Mode Control */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x11,	0x00},	/* Overscan */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x12,	0x0f},	/* Color Plane */
	{ATTRIBUTE_REG,	ATTRIBUTE_REG,	0x13,	0x08},	/* Hrz Panning */
	{ATTRIBUTE_REG,	&ega_tmp,	0x00,	0x00},	/* disable pallette */
	{GRAPHIX_I_POS,	GRAPHIX_II_POS,	0x00,	0x01},
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x00,	0x00},	/* Set Reset */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x01,	0x00},	/* Enable S/R */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x02,	0x00},	/* Color Compare */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x03,	0x00},	/* Data Rotate */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x04,	0x00},	/* Read Map Sel */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x05,	0x00},	/* Mode Register */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x06,	0x04},	/* Miscellaneous */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x07,	0x00},	/* Color No Care */
	{GRAPHICS_ADDR,	GRAPHICS_REG,	0x08,	0xff},	/* Bit Mask */
};

/* the pointer to all the initialization modes */
struct ega_mode {
	struct ega_reg *array_addr;
	unsigned array_length;
} ega_mode_init[] = {
#define EGA_MONO 0
	{ega_reg_7,sizeof(ega_reg_7)/sizeof(struct ega_reg)},
#define EGA_COLOR 1
	{ega_reg_3,sizeof(ega_reg_3)/sizeof(struct ega_reg)},
#define EGA_ENHANCED 2
	{ega_reg_3star,sizeof(ega_reg_3star)/sizeof(struct ega_reg)},
#define LOAD_FONT 3
	{ega_reg_c,sizeof(ega_reg_c)/sizeof(struct ega_reg)},
};
