/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtcons/RCS/ibm_emul.h,v 1.1 1990/10/10 20:41:02 rayan Exp $ */
/* $ACIS:ibm_emul.h 12.0$ */
/* $Source: /usr/src/sys/rtcons/RCS/ibm_emul.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidmono_tcap = "$Header: /usr/src/sys/rtcons/RCS/ibm_emul.h,v 1.1 1990/10/10 20:41:02 rayan Exp $";
#endif

/*
 * the following defines specify the escape sequences used by the
 * ibm3101 emulator (used for ibmconsole, ibmapa8, ibmapa16 devices)
 * The cryptic codes are (generally) the termcap names for the particular
 * function.
 */

#define ESC_FOUND 0x100 	       /* flag for escape found */
#define ESC_(x) ESC_FOUND+'x'           /* ESC + x */

#define UP_CHAR ESC_(A) 		/* ESC A cursor up */
#define CL_CHAR ESC_(K) 		/* ESC K clear screen */
#define ND_CHAR ESC_(C) 		/* ESC C non-destructive space */
#define CD_CHAR ESC_(J) 		/* ESC J clear to end of screen */
#define CE_CHAR ESC_(I) 		/* ESC I clear to end of line */
#define HO_CHAR ESC_(H) 		/* ESC H home cursor */
#define CM_CHAR2 ESC_(Y)		/* ESC Y x y */
#define SO_CHAR ESC_(p) 		/* ESC p stand out */
#define SE_CHAR ESC_(q) 		/* ESC q stand out end */
#define HI_CHAR ESC_(Z) 		/* ESC Z hi intensity */
#define LO_CHAR ESC_(z) 		/* ESC z lo intensity */
#define US_CHAR ESC_(W) 		/* ESC W start underline */
#define UE_CHAR ESC_(w) 		/* ESC w stop underline */
#define SH_CHAR ESC_(s) 		/* ESC s status line on/off */
#define SAVE_CM ESC_(j) 		/* ESC j save cursor position */
#define RESTORE_CM ESC_(k)		/* ESC k restore cursor position */
#define AL_CHAR ESC_(L) 		/* ESC L insert line */
#define DL_CHAR ESC_(M) 		/* ESC M delete line */
#define IGN_CHAR	ESC_([) 	/* ESC [ ==> ESC */
#define CURSOR_OFFSET	' '            /* blank is normal offset value */

/*
 * the following defines specify the escape sequences used by the
 * ibm3101 emulator for the color support
 */

#define FR_GRND 	ESC_(U) 	/* ESC U inc foreground color */
#define BK_GRND 	ESC_(V) 	/* ESC V inc background color */
#define FR_DEC		ESC_(u) 	/* ESC U dec foreground color */
#define BK_DEC		ESC_(v) 	/* ESC V dec background color */
#define CT_CHAR 	ESC_(T) 	/* ESC T tab;red;green;blue; colr tab */
#define FG_CHAR 	ESC_(f) 	/* ESC f tab; change fg color */
#define BG_CHAR 	ESC_(b) 	/* ESC b tab; change bg color */
#define CL_SAVE 	ESC_(F) 	/* ESC F save current fg/bg entry */
#define CL_RSTR 	ESC_(B) 	/* ESC B restore old fg/bg entry */

#define BS_CHAR 	  ESC_(G)	/* ESC G blink/bgrnd intense	  PgUp*/
#define BE_CHAR 	  ESC_(E)	/* ESC E blink/bgrnd intense end  PgDn*/
#define REVERSE 	  ESC_(P)	/* ESC P reverse fgrnd and bgrnd   F6 */
#define BLINK_ENABLE	  ESC_(Q)	/* ESC Q enable blinking	   F7 */
#define BG_HI_ENABLE	  ESC_(R)	/* ESC R enable bgrnd hi intensity F8 */
#define CHG_DISPLAY_MODE  ESC_(<)	/* ESC < change display mode	   F10*/

/* defines for monopagemode in ibme_softc */
#define PAGEEOLCLR	0x02	/* if we are to clear to eol in page mode */
#define PAGEMODE	0x01	/* if in page mode */

/* defines for put_state in ibme_softc */
#define NORMAL		0	       /* next char is not part of a sequ */
#define CURSOR_Y	1	       /* next char y is part of ESC Y sequ */
#define CURSOR_X	2	       /* next char x is part of ESC Y sequ */
#define ESC_1		3	       /* first letter of escape sequence */
#define COLOR_FG	4	       /* next char is color spec for fg */
#define COLOR_BG	5	       /* next char is color spec for bg */
#define COLOR_TABLE1	6	       /* next char is color table entry */
#define COLOR_TAB_RED	7	       /* next char is color red for table */
#define COLOR_TAB_BLUE	8	       /* next char is color blue for table */
#define COLOR_TAB_GREEN 9	       /* next char is color green for table */

struct ibme_softc {
	int screen_length;
	int screen_x;		/* screen column 0=start of line */
	int screen_y;		/* screen line 0 = first line */
	int old_x, old_y;
	int put_state;		/* internal state for cursor motion etc. */
	int cursor_base;	/* base for cursor motion */
	int monopagemode;	/* non-scroll mode */
	int print_log;		/* log screen output */
	int lf_ibme_delay;	/* for slowing down the output */
	char screen_attr;	/* Normal Screen Character attribute */
	int put_status_offset;	/* Put status stuff */
	unsigned color; 	/* Temp storeage when reading in colors */
#define color_blue color
	unsigned color_green;	/* Temp storeage when reading in colors */
	unsigned color_red;	/* Temp storeage when reading in colors */
	unsigned color_tab;	/* Temp storeage when reading in colors */
	unsigned color_count;	/* number of digits entered */
	unsigned red;		/* what entry is red on this display */
	unsigned fg;		/* Foreground index into the color table */
	unsigned bg;		/* Background index into the color table */
	unsigned save_fg;	/* Saved Foreground index */
	unsigned save_bg;	/* Saved Background index */
} ibme_softc [NUMBER_CONS];

/* emulator state flags */
#define IBME_OPEN 0x1
#define IBME_INPUTC 0x2

/* color input defines */
#define MAX_COLOR_COUNT 8	/* number of hex digits in an unsigend */

/* normalize the color */
#define NORMALIZE_COLOR(color,count)	((color) << ((MAX_COLOR_COUNT-(count))*4))

