/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/cons/RCS/std_emul.c,v 1.4 1994/05/22 12:46:10 roger Exp $ */
/* $ACIS:std_emul.c 12.0$ */
/* $Source: /sys/rt/cons/RCS/std_emul.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rt/cons/RCS/std_emul.c,v 1.4 1994/05/22 12:46:10 roger Exp $";
#endif

#ifndef MINIROOT
#include <sys/param.h>
#include <sys/conf.h>
#include <sys/ioctl.h>
#include <sys/tty.h>

#include "rt/include/screen_conf.h"
#include "rt/cons/consdefs.h"
#include "rt/cons/std_emul.h"

#include "rt/cons/kls.h"

#ifdef ATR
#include "../ca/io.h"
#endif ATR

int lp_put();

stdoe_open(dev, tp, si)
dev_t dev;
register struct tty *tp;
register SCREEN_INFO *si;
{
	return (0);
}

stde_close(tp, si)
register struct tty *tp;
register SCREEN_INFO *si;
{
	register EMUL_INFO *ei = &si->ine;

	ei->flag = 0;
	ei->unit = 0;
	return (0);
}


stde_ioctl(tp, cmd, addr, si)
register struct tty *tp;
int cmd;
caddr_t addr;
register SCREEN_INFO *si;
{
	return (-1);

}

stde_select(dev, rw, si)
dev_t dev;
int rw;
register SCREEN_INFO *si;
{
	return (ttselect (dev, rw));
}


stde_write(tp, uio, si, ioflag)
register struct tty *tp;
struct uio *uio;
register SCREEN_INFO *si;
int ioflag;
{
	return ((*linesw[tp->t_line].l_write)(tp, uio, ioflag));
}


/*
 * output a character to the RAW screen
 * we look at the characters passing thru to see if 
 * they are something interesting before passing them through
 */
stde_putc(c, si, kern_flag)
register int c;
register SCREEN_INFO *si;
register kern_flag;
{
	/* Output Emulator Information */

	if (c == 07)
		beep();		/* ring the bell */
	else
		screen_putc (c, LITERAL_VIDEO, 
			FOREGROUND_COLOR, BACKGROUND_COLOR);
	/* log to printer */
	if ((screen_sw[WS].flags & CONSDEV_LOG) && lp_put(si, (c == '\t'?' ':c)))
		screen_sw[WS].flags &= ~CONSDEV_LOG; /* error - stop logging */
}

stde_put_status(si, pos, str)
register SCREEN_INFO *si;
register int pos;
register char *str;
{

/* this is called stde_put_status. The intent is to pass status to whichever
 * of the "smart" devices is the present screen. Presently, aed is the only one.
 * All aed emulation is within the microcode. For now, no switch table is used.
 * Modify by using an emulator switch table. (See the macro definition of
 * screen_putc in screen_conf.h)
 */

	screen_put_status(pos,str);
}

stde_color_table(entry,red,green,blue,flags,si)
unsigned entry,red,green,blue;
int flags;
SCREEN_INFO *si;
{
	screen_color_table(entry,red,green,blue,flags);
}
#endif /* !MINIROOT */

