/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/apio.h,v 1.2 1990/10/11 20:07:25 rayan Exp $ */
/* $ACIS:apio.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/apio.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidapio = "$Header: /usr/src/sys/rtio/RCS/apio.h,v 1.2 1990/10/11 20:07:25 rayan Exp $";
#endif


struct apioinfo
   {
   int apstatus;	/* returned status code */
   char apcmd;		/* expedited command */
   };

/*
 * ioctl command values
 */
#define APTEST   _IOR('a',0,struct apioinfo) /* test status */
#define APTESTRD _IOR('a',1,struct apioinfo) /* test status/read cmd */
#define APRDCMD  _IOR('a',2,struct apioinfo) /* read command */
#define APWRTCMD _IOW('a',3,struct apioinfo) /* write command */

/*
 * status codes that can be returned from APTEST, APTESTRD or APRDCMD
 */
#define APNOINFO 0	/* no status info or expedited cmd */
#define APDOWN 1 	/* sync or i/o error - please close the device */
#define APGOTDATA 2	/* read data is available - please read it */
#define APGOTCMD 3	/* expedited command is in apcmd */
#define APSYNCING 4	/* syncing in progress, line not up yet */
/* APRDCMD cannot get APNOINFO or APSYNCING as a status */

/*
 * Other ioctl codes allowed by the async data mode protocol are:
 * TIOCGETD, TIOCSETD, TIOCGETP, TIOCEXCL, TIOCNXCL
 */
