#include "cd.h"
#if NCD > 0 
/*
 * Copyright (C) 1994 Mark Dapoz, 
 *     		 Bergen Scientific Centre, Bergen, NORWAY
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms as is or as a source
 * for derivative work are permitted provided that the above copyright 
 * notice and this paragraph are  duplicated in all such forms and that 
 * any documentation, advertising materials, and other materials related
 * to such distribution and use acknowledge that the software was developed
 * at the Bergen Scientific Centre, Bergen, NORWAY.  The name of the
 * centre may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * SCSI CD-ROM driver
 *
 * $Source: /usr/src/sys/rtio/RCS/cd_sun.c,v $
 * $Revision: 1.3 $ $Date: 1994/05/07 14:57:13 $
 * $Author: md $ $State: Exp $
 *
 * $Log: cd_sun.c,v $
 * Revision 1.3  1994/05/07  14:57:13  md
 * Change #include statements to use system search path instead of absolute.
 *
 * Revision 1.2  1994/04/05  12:18:39  md
 * Changes to allow setting of uscsi_status structure member.
 *
 * Revision 1.1  1994/01/24  05:09:31  md
 * Initial revision
 *
 *
 */

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/errno.h>
#include <scsi/generic/commands.h>
#include <scsi/generic/mode.h>
#include <scsi/impl/uscsi.h>

parse_sun_uscsi(xs, data)
caddr_t xs;
caddr_t data;
{
    struct uscsi_cmd *scmd = (struct uscsi_cmd *)data;	/* uscsi info */
    int flag;

    flag = (scmd->uscsi_flags & USCSI_READ) ? B_READ : B_WRITE;

/*
    printf("parse_sun_uscsi: flag=%x, uscsi_cdb=%x, uscsi_cdblen=%d uscsi_buf=%x, uscsi_buflen=%d\n", flag, scmd->uscsi_cdb, scmd->uscsi_cdblen, scmd->uscsi_bufaddr, scmd->uscsi_buflen);
*/

    return do_sun_uscsi(xs, 
			scmd->uscsi_cdb, scmd->uscsi_cdblen,
			scmd->uscsi_bufaddr, scmd->uscsi_buflen,
			&scmd->uscsi_status, flag);
}
#endif /* NCD  > 0 */
