/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/dmavar.h,v 1.1 1988/12/09 22:50:51 md Exp $ */
/* $ACIS:dmavar.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/dmavar.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddmavar = "$Header: /usr/src/sys/rtio/RCS/dmavar.h,v 1.1 1988/12/09 22:50:51 md Exp $";
#endif

/* internal state flags iocc_hd->dh_state */
#define DMA_IDLE		 0 /* channel is free */
#define DMA_BUSY		 1 /* channel is in use */
#define DMA_EXCLUSIVE_QUEUED	 2 /* an exclusive request has been queued */
#define DMA_EXCLUSIVE_RUNNING	 4 /* an exclusive request is running */
#define DMA_RELEASE_PENDING	 8 /* an exclusive request is running */
#ifdef DEBUG
#define DMA_BAD_CHAN		 0x10 /* bad channel passed (debugging only)*/
#endif
#define DMA_STATES		"\20\5BadChan\4RelsePen\3XcluRun\2XcluQue\1Busy"

/* macros used by dma_map/dma_free_map for a 64 bit mask*/
#define	DMA_HI_BIT		0x80000000	/* high bit of an unsigned */
#define DMA_MASK_SIZE		(sizeof(unsigned)*8) /* size of dma_map bit mask */
#define DMA_ALL_BITS		0xffffffff	/* set all the bits of a mask */
#define DMA_SHIFT_LEFT(high,low) (high=(high<<1)|(low&DMA_HI_BIT?1:0), \
				 low=low<<1)
#define DMA_LEFT_MASK(size)	 ((1<<(size))-1)

/* Software return codes (for dma_setup) */
#define DMA_OK_RET	 0  /* request has been handled ok */
#define DMA_BUSY_RET	 1  /* channel is busy (retuned only for DM_CANTWAIT */
#define DMA_EXCLUSIVE_RET 2  /* channel is being used by EXCLUSIVE device */

/* dm_channel */
#define DMA_CHAN0   0	/* controller 1, channel 2 */
#define DMA_CHAN1   1	/* controller 1, channel 3 */
#define DMA_CHAN2   2	/* controller 1, channel 0 */
#define DMA_CHAN3   3	/* controller 1, channel 1 */
#define DMA_CHAN4   4	/* controller 2, channel 0 - cannont be used */
#define DMA_CHAN5   5	/* controller 2, channel 1 */
#define DMA_CHAN6   6	/* controller 2, channel 2 */
#define DMA_CHAN7   7	/* controller 2, channel 3 */
#define DMA_CHAN8   8	/* coprocessor channel, no page mode, no system dma */
#define DMA_END_CHAN	9 	/* flag for the last channel in a channel array */
#define DMA_MAX_CHAN	9	/* maximum number of channels */

/* tell anyone interested in the ros that the dma is in use */
char	dma_in_use;

/*
 * dma flags passed in iocc_ctrl->ic_flags
 *
 */

/* System DMA hardware flags */
#define DMA_AUTO_INIT	0x10	/* Autoinitialize count and addr regs on EOP */

#define DMA_INCREMENT	0x00	/* increment addr reg on for each byte */
#define DMA_DECREMENT	0x20	/* decrement addr reg on for each byte */

#define DMA_DEMAND	0x00	/* use System demand mode dma (3rd party) */
#define DMA_SINGLE	0x40	/* use System cycle stealing dma (3rd party) */
#define DMA_BLOCK	0x80	/* use System cycle burst dma (3rd party) */
#define DMA_CASCADE	0xc0	/* use Alternate controller dma (1st party) */

/* Alternate mode flags */
#define DMA_PAGE  	0x000		/* use page mode TCW's */
#define DMA_REGION	0x100		/* use region mode TCW's */
#define DMA_PHYSICAL	0x000		/* use physical addrs */
#define DMA_VIRTUAL	0x200		/* use virtual addrs */

/* Software control flags */
#define DMA_CANTINT	0x1000		/* device can't interupt, use dmaint */
#define DMA_EXCLUSIVE	0x2000		/* transfer is async (like DM_DEMAND) or
					 * is not likely to give up the channel
					 */
#define DMA_CANTWAIT	0x4000		/* don't queue request if channel is busy */

#define DMA_FLAGS	"\20\17CantWait\16Xclu\15NoInt\12Virtual\11Region\10Blk/Cas\7Sngl/Cas\5Dec\4AutoInit"

/*
 * defines for dma_map
 */

/* Invalid i/o address return from dma_map */
#define	DMA_INV_IOADDR	0xffffffff

