/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/hdreg.h,v 1.1 1988/12/09 22:51:31 md Exp $ */
/* $ACIS:hdreg.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/hdreg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidhddisk = "$Header: /usr/src/sys/rtio/RCS/hdreg.h,v 1.1 1988/12/09 22:51:31 md Exp $";
#endif

struct	hddevice {		/*	must cast data when used	*/
	u_char	data;		/*   0:	data register (actually u_short) */
	u_char	err;		/*   1:	error/pcmp register */
	u_char	sct;		/*   2:	sector count */
	u_char	sno;		/*   3:	sector number */
	u_char	cyll;		/*   4:	cylinder number lo */
	u_char	cylh;		/*   5:	cylinder number hi */
	u_char	sdh;		/*   6:	size/drive/head */
	u_char	stat;		/*   7:	status/cmd register */
	u_char	pad[510];	/*   8:	pad characters */
	u_char	intr;		/* 206:	interrupt-status/hard-file */
	u_char	pad1[505];	/* 207:	more padding */
	u_short	dma_err_a;	/* 400:	DMA error-A/command-stack */
	u_char	pad2[1];	/* 402:	yet more padding */
	u_char	mode;		/* 403:	mode control register */
	u_short	dma_err_b;	/* 404:	DMA error B register */
	u_short	dma_stat;	/* 406:	DMA status/command register */
};

/* Disk controller commands (written to register "stat" or "dma_stat") */
#define	DISKRSTR	0x10	/* Restore command */
#define	DISKRSTP	0x18	/* Restore + set parms command (dma mode) */
#define	DISKREAD	0x20	/* Read command */
#define	DISKNOTR		0x08	/* (DMA) read only to adapter buf */
#define	DISKWRIT	0x30	/* Write command */
#define	DISKNORE		0x01	/* No retries (read, writ & rdvr) */
#define	DISKECC			0x02	/* Data+7byteECC (read & writ 1 sect) */
#define	DISKRDVR	0x40	/* Read verify command */
#define	DISKFRMT	0x50	/* Format track command */
#define	DISKSEEK	0x70	/* Seek command */
#define	DISKDIAG	0x90	/* Diagnose command */
#define	DISKSETP	0x91	/* Set parameters command */
#define	DISKSETL	0x93	/* Set parameters command, long */
#define	DISKEBWR	0x98	/* reserved */
#define DISKESDI	0xe0	/* Initiate ESDI command */
#define DISKRBUF	0xe1	/* Read from adapter data buffer */
#define DISKWBUF	0xe2	/* Write to adapter data buffer */
#define	DISKRSTK	0xe4	/* Read stack command */
#define	DISKWSTK	0xe8	/* Write stack command */
#define DISKSHUT	0xf0	/* Shutdown command (leave DMA mode) */

/* Disk status (read from "stat") */
#define	DISKBUSY	0x80	/* Adapter busy */
#define	DISKRDY		0x40	/* Drive ready */
#define	DISKWFLT	0x20	/* Write fault */
#define	DISKDONE	0x10	/* Seek complete */
#define	DISKDRQ		0x08	/* Data request */
#define	DISKCORR	0x04	/* ECC correction */
#define	DISKINDX	0x02	/* Index marker */
#define	DISKERR		0x01	/* Error, read errstat */
#define HD_STAT_FMT	"\20\1ERROR\2INDEX-MARK\3ECC-CORRECTION\4DATA-REQ\5SEEK-DONE\6WRITE-FAULT\7DRIVE-READY\10BUSY"
/* Interrupt mask (bits we care about) */
#define DISKIMASK	(DISKERR|DISKWFLT|DISKDRQ|DISKBUSY|DISKRDY)

/* DMA Disk status (read from "dma_stat") */
#define DDISKERRCODE	0xff00	/* disk error code mask */
#define	DDISKBUSY	0x0080	/* Adapter busy */
#define	DDISKVALID	0x0040	/* valid status/interrupt */
#define	DDISKCORR	0x0020	/* retry corrected a hard error */
#define	DDISKDRIVE	0x0006	/* drive this status is for - mask */
#define	DDISKQPOS	0x0001	/* queue position status is for */
#define HDD_STAT_FMT	"\20\1COMMAND-QUEUE-ONE\2DRIVE-ONE\3DRIVE-TWO\4DRIVE-THREE\5RESERVED\6CORRECTED-DATA\7STATUS-VALID\10BUSY"

/* Disk errors (read from "err" or 1st byte of "dma_stat" */
#define	DISKBBLKA	0xC0	/* (DMA) Bad block detected alternate */
#define	DISKBBLK	0x80	/* Bad block detected */
#define	DISKCRC		0x40	/* Data CRC or ECC error */
#define	DISKINVC	0x24	/* (DMA) invalid command */
#define	DISKWRTP	0x21	/* (DMA) write parity */
#define	DISKWRTF	0x20	/* (DMA) write fault */
#define	DISKIDNF	0x10	/* ID not found */
#define	DISKADAP	0x08	/* (DMA) adapter error */
#define	DISKABRT	0x04	/* Command aborted */
#define	DISKTR00	0x02	/* TRack 000 error */
#define	DISKMAM		0x01	/* Missing data Address Mark */
#define	DISKNOERR	0x00	/* (DMA) no error */
#define HD_ERR_FMT	"\20\1MISSING-MARK\2TR000-ERROR\3CMD-ABORTED\4ADAPTER-ERROR\5ID-NOT-FOUND\6WRITE_FAULT?\7DATA-CRC\10BAD-BLOCK"

/* Writable bits in HFR (hard file register ) */
#define DISKHD3		0x08	/* Head select 3 = 1 */
#define DISKRWRT	0x08	/* Reduced write = 0 */
#define DISKADMA	0x08	/* Alternate DMA channel (HESDI in
				 * DMA mode only) */
#define DISKRSET	0x04	/* Reset WD1002 */
#define DISKDISI	0x02	/* Disable Interrupts */
#define DISKIRQ12	0x01	/* use IRQ 12 instead of 14 (ignored
				 * by old adapters) */
/*
 * Diagnose command errors (read from "err")
 * {} surround meanings for AT (ST506) adapters.
 * [] surround meanings for ESDI adapters.
 * () surround meanings for HESDI (EESDI) adapters.
 */
#define	DISKDIAGMASK	0x1f	/* mask to get the error code */
#define	DISKDIAGOK	0x01	/* no errors */
#define	DISKDIAGE2	0x02	/* {controller}[adapter device](control buf) */
#define	DISKDIAGE3	0x03	/* {sector buffer}[disk](data buffer) */
#define	DISKDIAGE4	0x04	/* {ECC device}[sector buffer] */
#define	DISKDIAGE5	0x05	/* {control processor}[ECC device] */
#define	DISKDIAGE6	0x06	/* [logic support device](gate array) */
#define	DISKDIAGE7	0x07	/* [control processor] */
#define	DISKDIAGE8	0x08	/* (AIC 010 - file controller) */
#define	DISKDIAGE10	0x0a	/* (8031 - file processor) */
#define	DISKDIAGE12	0x0c	/* (ROM) */
#define	DISKDIAGE14	0x0e	/* (stuck attention) */
#define	DISKDIAGE16	0x10	/* (device error bit stuck on) */

/* HESDI (EESDI) configuration info from "sno" register after a diagnose */
#define	DISKCFG64K	0x80	/* 64k adapter buffer (0=16k) */
#define	DISKCFGVEN	0x40	/* Vendor files (variable size sync & gap) */
#define	DISKCFGRDM	0x20	/* Read Defect Map supported */
#define	DISKCFG16M	0x10	/* 16Mhz adapter clock (0=12Mhz) */
#define	DISKCFGD3	0x08	/* Drive 3 selectable */
#define	DISKCFGD2	0x04	/* Drive 2 selectable */
#define	DISKCFGD1	0x02	/* Drive 1 selectable */
#define	DISKCFGD0	0x01	/* Drive 0 selectable */
