/* $Header: /sys/rt/dev/RCS/if_ub.c,v 1.6 1994/05/22 12:26:24 roger Exp $ */
/* $ACIS:if_un.c 9.0$ */
/* $Source: /sys/rt/dev/RCS/if_ub.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /sys/rt/dev/RCS/if_ub.c,v 1.6 1994/05/22 12:26:24 roger Exp $";
#endif lint

/*
 * Ungermann-Bass PC-NIC (Ethernet) Adapter  (4.3 driver)
 *
 * This code is derived from sources assigned to University of California.
 *
 * Multicast support added 11/22/93 by Tom Pusateri (pusateri@cs.duke.edu)
 * based on work done by Steven McCanne (mccanne@ee.lbl.gov) for bsd386.
 *
 * Modified 04/14/94 by Roger Florkowski (roger@wizards.austin.ibm.com)
 * to just set ALLMULTI by default, since there is no way (???) to set
 * hardware filters on multicast addresses.  XXX: Would be nice to 
 * "turn on" multicasting if someone has added some multicast addresses, 
 * and "turn it off" if they've deleted them.  
 */

#include "ub.h"
#if NUB > 0

#include <machine/pte.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/vmmac.h>
#include <sys/ioctl.h>
#include <sys/errno.h>

#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>

#ifdef INET
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#endif INET

#ifdef NS
#include <netns/ns.h>
#include <netns/ns_if.h>
#endif NS

#include <machine/io.h>
#include "rt/dev/if_ubreg.h"
#include "rt/include/ioccvar.h"
#include "rt/rt/debug.h"

#include "bpfilter.h"
#if NBPFILTER > 0
#include <net/bpf.h>
#include <net/bpfdesc.h>
#endif

#ifndef IF_QEMPTY
#define	IF_QEMPTY(ifq)		((ifq)->ifq_len == 0)
#endif

int	ubprobe(), ubattach();

caddr_t ubstd[] = { (caddr_t) 0xf4080000, (caddr_t) 0xf4088000,
	(caddr_t) 0xf4090000, (caddr_t) 0xf4098000, 0 };

struct	iocc_device *ubinfo[NUB];

int	ubint(), ubinit(), ubioctl(), ether_output(), ubreset(), ubstart();

struct	iocc_driver ubdriver =
	{ ubprobe, 0, ubattach, 0, ubstd, "ub", ubinfo,
		0, 0, ubint, UB_EADDROFF };

struct	mbuf *ubget();

/*
 * Ethernet software status per adapter.
 */
struct	ub_softc {
	struct	arpcom us_ac;		/* generic network interface stuff */
#define	us_if	us_ac.ac_if		/* ifnet struct */
#define	us_addr	us_ac.ac_enaddr		/* hardware (i.e. ethernet) address */
	short	us_nextpage;		/* next receive buffer page */
	short	us_xbuf;		/* in-use xmt buf (if output active) */
	short	us_xfull[2];		/* 1 => a full xmt buf */
	short	us_xstart[2];		/* start address used in ubstart */
} ub_softc[NUB];

#ifdef DEBUG
char ubdebug = 0;
#endif DEBUG

#ifdef ATR
#define move_window(window, addr)	{\
	int real_addr;\
	int new_window;\
	\
	window = get_128_window();\
	real_addr = 0xfffff & (int) addr;\
	new_window = real_addr & 0xe0000;\
	set_128_window(new_window);\
	addr = (struct ubdevice *) (real_addr - new_window);\
}

#define restore_window(window)	set_128_window(window)
#define bcopyin(from,to,len) bcopy((from)+pcif_128_fw,to,len)
#define bcopyout(from,to,len) bcopy(from,(to)+pcif_128_fw,len)
#endif ATR

#ifdef IBMRTPC
#define bcopyin bcopy
#define bcopyout bcopy
#endif IBMRTPC
/*
 *  ubprobe - try to generate an interrupt (to see if the board is there)
 */
ubprobe(p)
	register caddr_t p;
{
	register struct ubdevice *addr = (struct ubdevice *) p;
#ifdef ATR
	register int old_window;
	move_window(old_window, addr);
#endif ATR
	(void) ubzap(addr, (struct ifnet *)NULL);
	UB_GLOBIENB(0);			/* global interrrupt enable */
	MM_OUT(&addr->ub_csr, UB_GSFTINT);  /* generate software interrupt */
	PROBE_DELAY(100000);
	MM_OUT(&addr->ub_csr, 0);
#ifdef ATR
	restore_window(old_window);
#endif ATR
	return(PROBE_OK);
}

/*
 *  ubattach - make the interface available to the network software
 *  (if the auto-configuration software determines that the interface
 *  exists).  The system will initialize the interface when it is
 *  ready to accept packets.
 */
ubattach(iod)
	register struct iocc_device *iod;
{
	register struct ub_softc *us = &ub_softc[iod->iod_unit];
	register struct ifnet *ifp = &us->us_if;
	register struct ubdevice *addr = (struct ubdevice *) iod->iod_addr;
	register int i;
#ifdef ATR
	register int old_window;

	move_window(old_window, addr);
#endif ATR
	ifp->if_unit = iod->iod_unit;
	ifp->if_name = "ub";
	ifp->if_mtu = ETHERMTU;

	/*
	 * Read the ethernet address off the board.
	 * Save it and also write it to the edlc chip.
	 */
	for (i = 0; i < ETH_ADDR_SIZE; i++){
		  us->us_addr[i] = MM_IN(&addr->ub_eprom[UB_EADDROFF+i]);
		MM_OUT(&addr->ub_edlc.nodeID[i], us->us_addr[i]);
	}

        printf("ub%d: hardware address %s\n", ifp->if_unit,
                ether_sprintf(us->us_addr));
	ifp->if_init = ubinit;
	ifp->if_ioctl = ubioctl;
	ifp->if_output = ether_output;
	ifp->if_reset = ubreset;
        ifp->if_start = ubstart;
	ifp->if_flags = IFF_BROADCAST|IFF_NOTRAILERS|IFF_MULTICAST|IFF_ALLMULTI;

	ifp->if_snd.ifq_len = 0;
#if NBPFILTER > 0
	bpfattach(&us->us_if.if_bpf, ifp, DLT_EN10MB, sizeof(struct ether_header));
#endif
	if_attach(ifp);
	DEBUGF(ubdebug, printf("ub%d: attached\n", iod->iod_unit);)
#ifdef ATR
	restore_window(old_window);
#endif ATR
}

/*
 *  ubreset - reset interface
 */
ubreset(unit)
	register unsigned int unit;
{
	register struct iocc_device *iod;

	if (unit < NUB && (iod = ubinfo[unit]) != 0 && iod->iod_alive != 0){
		ub_softc[unit].us_if.if_flags &= ~IFF_RUNNING;
		DEBUGF(ubdebug, printf("ub%d: reset\n", unit);)
		ubinit(unit);
	}
}

/*
 *  ubinit - initialize interface, enable packet reception, start any
 *  pending writes
 */
ubinit(unit)
	register int unit;
{
	register struct ub_softc *us = &ub_softc[unit];
	register struct ifnet *ifp = &us->us_if;
	register int s;
	register struct ubdevice *addr;
	register int i;

	if (ifp->if_addrlist == (struct ifaddr *) 0){
		/* no address */
		return;
	}
	if ((ifp->if_flags & IFF_RUNNING) == 0){
#ifdef ATR
		int old_window;
#endif ATR

		addr = (struct ubdevice *) (ubinfo[unit]->iod_addr);
#ifdef ATR
		move_window(old_window, addr);
#endif ATR
		s = splimp();
		us->us_nextpage = ubzap(addr, ifp); /* initialize hardware */
			/* ubzap returns next receive page to be used */
		for (i = 0; i < ETH_ADDR_SIZE; i++){
			MM_OUT(&addr->ub_edlc.nodeID[i], us->us_addr[i]);
		}
		us->us_if.if_flags &= ~IFF_OACTIVE;	/* output not active */
		us->us_xfull[0] = us->us_xfull[1] = 0;
		/*  turn adapter on */
		ifp->if_flags |= IFF_RUNNING;
		MM_OUT(&addr->ub_csr, UB_PAVIENB);
			/* Allow packet available interrupts */
		UB_GLOBIENB(us->us_nextpage);	/* global interrrupt enable */
		if (!IF_QEMPTY(&ifp->if_snd))	/* anything on send queue */
			ubstart(ifp);
		splx(s);
#ifdef ATR
		restore_window(old_window);
#endif ATR
	}
	DEBUGF(ubdebug, printf("ub%d: init'ed\n", unit);)
}

/*
 * Start output on interface.  Get another datagram to send
 * off of the interface queue, and copy it to the interface
 * before starting the output.
 */
ubstart(ifp)
	struct ifnet *ifp;
{
        int unit = ifp->if_unit;
        register struct ub_softc *us = &ub_softc[unit];
	register int next_buf;
        struct ubdevice *addr;
        struct mbuf *m;

        if ((us->us_if.if_flags & IFF_RUNNING) == 0)
                return 0;
	if (us->us_xfull[0] == 0 || us->us_xfull[1] == 0) {/* empty xmit buf */
		if (us->us_xfull[0] == 0)
			next_buf = 0;
		else
			next_buf = 1;

		IF_DEQUEUE(&us->us_if.if_snd, m);
		if (m == 0)
			return (0);
		addr = (struct ubdevice *) (ubinfo[unit]->iod_addr);
		ubput(us, addr, m, next_buf);
		ubxmit(us, addr, next_buf);
		if (!IF_QEMPTY(&us->us_if.if_snd)
		    && us->us_xfull[1 - next_buf] == 0) {
			IF_DEQUEUE(&us->us_if.if_snd, m);
			if (m == 0)
				return (0);
			ubput(us, addr, m, 1 - next_buf);
		}
	}
	return 0;
}

/*
 *  ubxmit - start output from one of the adapter's 2 transmit buffers
 */
ubxmit(us, addr, xbuf)
	register struct ub_softc *us;
	register struct ubdevice *addr;
	register int xbuf;
{
	us->us_if.if_flags |= IFF_OACTIVE;
	us->us_xbuf = xbuf;
	UB_XMIT(addr, us->us_xstart[xbuf]);
	MM_OUT(&addr->ub_csr, UB_IENABLE); /* enable transmit done interrupt */
}

/*
 *  ubint - interrupt handler.  find the cause of the interrupt and
 *  dispatch an appropriate handler routine.
 */
ubint(unit)
	register int unit;
{
	register struct ub_softc *us = &ub_softc[unit];
	register struct ubdevice *addr =
	  (struct ubdevice *) ubinfo[unit]->iod_addr;
	register char status;
	register int rc = 1;
#ifdef ATR
	register int old_window;

	move_window(old_window, addr);
#endif ATR

	UB_DISABLE(us->us_nextpage);
	while ((status = ~MM_IN(&addr->ub_csr)) & UB_PAVINT){
		DEBUGF(ubdebug & 0x2, printf("ubint: unit = %d, csr = %b",
		  unit, status & 0xff, UB_CSRBITS);)
		ubrint(unit, us, addr);
		rc = 0;
	}
	if (status & UB_TXRINT){
		DEBUGF(ubdebug & 0x2, printf("ubint: unit = %d, csr = %b",
		  unit, status & 0xff, UB_CSRBITS);)
		ubxint(unit, us, addr);
		rc = 0;
	}
	UB_ENABLE(us->us_nextpage);
#ifdef ATR
	restore_window(old_window);
#endif ATR
	return(rc);
}

/*
 *  ubrint - interrupt handler for packet reception.
 *
 *  log error if error bits are latched,  examine packet to determine
 *  type, if can't determine packet length from type, drop packet.
 *  otherwise decapsulate packet based on type and pass to an appropriate
 *  higher-level input routine.
 */

ubrint(unit, us, addr)
	int unit;
	register struct ub_softc *us;
	register struct ubdevice *addr;
{
	register struct ether_header *eh;
	register struct mbuf *m;
	struct ifnet *ifp = &us->us_if;
	register int len;
	register int off;
	int resid;
	char status = MM_IN(&addr->ub_edlc.rstat);
	u_short ubgetushortatoff();

	MM_OUT(&addr->ub_edlc.rstat, status);	/* clear status */
	/* (the hardware xor's in the value of status setting rstat to 0) */
	DEBUGF(ubdebug & 0x2, printf(" rstat = %b", status, RS_BITS);)
	/*
	 *  Latch errors.  (Errors found correspond to packets
	 *  that were received prior to the current packet
	 *  since packet available interrupts are generated
	 *  for good packets only.)
	 */
	if (status & RS_ERR){
		DEBUGF(ubdebug, printf("ubrint: input error\n");)
		us->us_if.if_ierrors++;
	}
	us->us_if.if_ipackets++;

	/*
	 *  determine the length of the received packet.
	 */
	len = 0;
	off = us->us_nextpage;

#define BUMP(page)	if (++(page) == UB_NUMRBUFS) page = 0
	while ((MM_IN(&addr->ub_pram[us->us_nextpage]) & UB_LAST_PAGE) == 0){
		len += UB_RBUFSIZE;
		BUMP(us->us_nextpage);
	}
	len += (MM_IN(&addr->ub_pram[us->us_nextpage]) &
		UB_PAGE_LENGTH_MASK) + 1;
	BUMP(us->us_nextpage);
#undef BUMP
	DEBUGF(ubdebug & 0x2, printf(" len = %d ", len);)
	if (len > UB_XBSIZE){
		printf("ub%d: huge packet!\n",unit);
		goto chuckit;
	}
	us->us_if.if_ibytes += len;
	/*
	 * Process the packet
	 */
	eh = (struct ether_header *) &addr->ub_rcvbuf[off][0];
	DEBUGF(ubdebug & 0x2,
		{  char cbuf[6];
		printf(" from = ");
		bcopyin(eh->ether_shost, cbuf, sizeof(cbuf));
		ubprintethaddr(cbuf);
		printf("  to = ");
		bcopyin(eh->ether_dhost, cbuf, sizeof(cbuf));
		ubprintethaddr(cbuf);
		printf(" "); }
	)
	len -= sizeof(struct ether_header);
	eh->ether_type = ntohs((u_short) MM_INW(&eh->ether_type));
	/*
	 *  The ETHERTYPE_NTRAILER packet types starting at ETHERTYPE_TRAIL
	 *  have (type - ETHERTYPE_TRAIL) * 512 bytes of data followed by
	 *  a type field and then a (variable length) header
	 */
	if (eh->ether_type >= ETHERTYPE_TRAIL &&
	    eh->ether_type < ETHERTYPE_TRAIL+ETHERTYPE_NTRAILER){
		off = (eh->ether_type - ETHERTYPE_TRAIL) * 512;
		if (off >= ETHERMTU){
			goto chuckit;
		}
		eh->ether_type = ubgetushortatoff(addr, eh, off);
		resid = ubgetushortatoff(addr, eh, off + 2);
		if (off + resid > len){
			goto chuckit;
		}
		len = off + resid;
	} else {
		off = 0;
	}
	if (len == 0)
		goto chuckit;

	/*
	 *  pull packet off interface.  if off is non-zero, the
	 *  packet has a trailing "header".  ubget will move this
	 *  header to the front, but we still have to remove the
	 *  type and length fields from the front of the data.
	 */
	m = ubget(addr, (u_char *) eh, len, off, &us->us_if);

#if NBPFILTER > 0
	/*
	 * Check if there's a bpf filter listening on this interface.
	 * If so, hand off the raw packet to enet.  This is done here
	 * because otherwise we'd have to duplicate ubbcopy() semantics.
	 */
	if (us->us_if.if_bpf && m != 0) {
                struct mbuf m0;
                m0.m_len = sizeof (struct ether_header);
                m0.m_data = (caddr_t)eh;
                m0.m_next = m;

                /* Pass it up */
                bpf_mtap(us->us_if.if_bpf, &m0);

                /*
                 * Keep the packet if it's a broadcast or has our
                 * physical ethernet address (or if we support
                 * multicast and it's one).
                 */
		if (bcmp(eh->ether_dhost, us->us_addr,
					    sizeof(eh->ether_dhost)) != 0
		    && !(eh->ether_dhost[0] & 1)
		    && bcmp(eh->ether_dhost, etherbroadcastaddr,
					    sizeof etherbroadcastaddr) != 0) {
			m_freem(m);
			goto chuckit;
		}
	}
#endif

	/*
	 *  update the full page pointer and clear the packet available
	 *  flag if necessary.  update the fpp here to free the on-board
	 *  receive pages as soon as possible.
	 */
	ubupdatefpp(addr, us->us_nextpage);

        if (m)
                ether_input(&us->us_if, eh, m);
	return;
chuckit:
	ubupdatefpp(addr, us->us_nextpage);
}

/*
 *  ubxint -  interrupt handler for transmit ready
 */
ubxint(unit, us, addr)
	register int unit;
	register struct ub_softc *us;
	register struct ubdevice *addr;
{
	register char status;
	register int next_buf;

	/*
	 *  collect stats on last packet
	 */
	status = MM_IN(&addr->ub_edlc.xstat);
	MM_OUT(&addr->ub_edlc.xstat, status);	/* clear status bits */
	DEBUGF(ubdebug & 0x2, printf(" ubxint: xstat = %b\n",
	  status & 0xff, XS_BITS);)
	if (status & XS_16CL){
		us->us_if.if_collisions += 16;
		us->us_if.if_oerrors++;
		printf("ub%d: ethernet jammed\n", unit);
	}
	else if (status & XS_SHRT){
		us->us_if.if_oerrors++;
		printf( "ub%d: ethernet not responding (is it connected?)\n",
			unit);
	}
	else {
		us->us_if.if_opackets++;
		us->us_if.if_collisions += UB_NCOLL(addr);
		if (us->us_xbuf == 0){
			us->us_if.if_obytes += UB_XBSIZE
			  - us->us_xstart[0];
		} else {
			us->us_if.if_obytes += (UB_XBSIZE << 1)
			  - us->us_xstart[1];
		}
	}
	DEBUGF(ubdebug & 0x2,
	  printf(" ipkt = %d ierr = %d okt = %d oerr = %d coll = %d\n",
	    us->us_if.if_ipackets, us->us_if.if_ierrors,
	    us->us_if.if_opackets, us->us_if.if_oerrors,
	    us->us_if.if_collisions);)
	/*  mark the current transmit buffer empty */
	us->us_xfull[us->us_xbuf] = 0;
	/*  switch to the other transmit buffer */
	next_buf = 1 - us->us_xbuf;
	if (us->us_xfull[next_buf]){	/*  if it's full */
		ubxmit(us, addr, next_buf);	/* start output from it */
		if (!IF_QEMPTY(&us->us_if.if_snd)) {	/*if more on out queue*/
			struct mbuf *m;

			IF_DEQUEUE(&us->us_if.if_snd, m); /* fill empty buf */
			ubput(us, addr, m, 1 - next_buf);
		}
	}
	else {	/*  the other transmit buffer is empty */
		us->us_if.if_flags &= ~IFF_OACTIVE;
		MM_OUT(&addr->ub_csr, UB_PAVIENB);	/* Turn off TxRIENB */
	}
}

/*
 *  ubput -  copy packet from an  mbuf chain to one of the adapter's
 *  transmit buffers.  the packet is extended to the minimum legal
 *  size if necessary.  the extra bytes could be zeroed out to improve
 *  security but are not to maximize performance.
 */
ubput(us, addr, m, xbuf)
	struct ub_softc *us;
	struct ubdevice *addr;
	register struct mbuf *m;
	register int xbuf;
{
	register unsigned off;
	register struct mbuf *mp;
	register char *bp;
	register unsigned int len = 0;
	unsigned int pktlen;

	/*
	 *  compute packet length
	 */
	for (mp = m; mp; mp = mp->m_next){
		len += mp->m_len;
	}
	/* if packet too short, extend it */
	pktlen = MAX(len, ETHERMIN + sizeof(struct ether_header));
	/*
	 *  compute starting address in transmit buffer.  packets must be
	 *  "end_aligned".
	 */
	off = UB_XBSIZE - pktlen;
	if (xbuf == 1){		/* use the second buffer */
		off += UB_XBSIZE;	/* the 2 buffers are adjacent */
	}
	bp = ((char *)(addr->ub_xmtbuf)) + off;
	for (mp = m; mp; mp = mp->m_next){
		len = mp->m_len;
		bcopyout(mtod(mp, char *), bp, len);
		bp += len;
	}
	/* save starting address so interrupt handler can find it */
	us->us_xstart[xbuf] = off;  /* start address to be passed to adapter */
	us->us_xfull[xbuf] = 1;	/* mark buffer full */
	m_freem(m);
#if NBPFILTER > 0
	/* 
	 * If bpf is listening on this interface, let it 
	 * see the packet before we commit it to the wire.
	 */
	if (us->us_if.if_bpf)
		bpf_tap(us->us_if.if_bpf, ((char *)(addr->ub_xmtbuf)) + off, pktlen);
#endif
}

/*
 *  ubget - copy packet from adapter's receive buffers into a chain of mbufs
 *
 */
struct mbuf *
ubget(addr, ubbuf, totlen, off0, ifp)
	struct ubdevice *addr;
	u_char *ubbuf;
	register int totlen;
	int off0;
	struct ifnet *ifp;
{
	register struct mbuf *m;
	struct mbuf *top = 0;
	register struct mbuf **mp = &top;
	register int off = off0;
	register int len;
	register u_char *cp = ubbuf + sizeof(struct ether_header);

        if (off) {
                off += 2 * sizeof(u_short);
                totlen -= 2 *sizeof(u_short);
                cp += off;
        }

	MGETHDR(m, M_DONTWAIT, MT_DATA);
	if (m == 0)
		return 0;
	m->m_pkthdr.rcvif = ifp;
	m->m_pkthdr.len = totlen;
	m->m_len = MHLEN;

	while (totlen > 0){
		char *mcp;

		if (top) {
			MGET(m, M_DONTWAIT, MT_DATA);
			if (m == 0)
				goto bad;
			m->m_len = MLEN;
		}

		len = totlen;

		if (off) {	/* trailer exists */
			len -= off;
			cp += off;
		}

		if (len >= MINCLSIZE) {
			MCLGET(m, M_DONTWAIT);
			if (m->m_flags & M_EXT)
				m->m_len = len = min(len, MCLBYTES);
			else
				len = m->m_len;
		} else {
			/*
			 * Place initial small packet/header at end of mbuf.
			 */
			if (len < m->m_len) {
				if (top == 0 && len + max_linkhdr <= m->m_len)
					m->m_data += max_linkhdr;
				m->m_len = len;
			} else
				len = m->m_len;
		}

		mcp = mtod(m, char *);
		ubbcopy(addr, cp, mcp, len);
		cp += len;
		*mp = m;
		mp = &m->m_next;
		if (off == 0) {
			totlen -= len;
		} else {
			off += len;
			if (off == totlen){
				cp = ubbuf + sizeof(struct ether_header);
				off = 0;
				totlen = off0;
			}
		}
	}
	return(top);
bad:
	m_freem(top);
	return(0);
}


/*
 *  ioctl - process an ioctl request.
 */
ubioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	register int cmd;
	register caddr_t data;
{
	register struct ifaddr *ifa = (struct ifaddr *)data;
	register int s = splimp();
	register int error = 0;
	struct ub_softc *us = &ub_softc[ifp->if_unit];

	switch (cmd){
	case SIOCSIFADDR:
		ifp->if_flags |= IFF_UP;

		switch (ifa->ifa_addr->sa_family){
#ifdef INET
		case AF_INET:
			ubinit(ifp->if_unit);	/* before arpwhohas */
			((struct arpcom *) ifp)->ac_ipaddr =
			  IA_SIN(ifa)->sin_addr;
			arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
			break;
#endif INET
#ifdef NS
		case AF_NS:
		    {
			struct ns_addr *ina = &(IA_SNS(ifa)->sns_addr);
			struct ub_softc *us = &ub_softc[ifp->if_unit];

			if (ns_nullhost(*ina))
				ina->x_host = *(union ns_host *)(us->us_addr);
			else {
				ifp->if_flags &= ~IFF_RUNNING;
				bcopy((caddr_t) ina->x_host.c_host,
				  (caddr_t) us->us_addr, sizeof(us->us_addr));
				/*
				 *  the ubinit will set the hardware address
				 *  since the IFF_RUNNING flag is off
				 */
			}
			ubinit(ifp->if_unit);
			break;
		    }
#endif NS
		default:
			ubinit(ifp->if_unit);
			break;
		}
		break;
	case SIOCSIFFLAGS:
		if ((ifp->if_flags & IFF_UP) == 0 && (ifp->if_flags &
		  IFF_RUNNING)){
#ifdef ATR
			int old_window;
#endif ATR
			struct ubdevice *addr;

			addr = (struct ubdevice *) ubinfo[ifp->if_unit]->
				iod_addr;
#ifdef ATR
			move_window(old_window, addr);
#endif ATR
			(void) ubzap((struct ubdevice *) addr, ifp);
			ifp->if_flags &= ~IFF_RUNNING;
#ifdef ATR
			restore_window(old_window);
#endif ATR
		} else if ((ifp->if_flags & IFF_UP) && (ifp->if_flags &
		  IFF_RUNNING) == 0)
			ubinit(ifp->if_unit);
		break;

	case SIOCADDMULTI:
	case SIOCDELMULTI:
 		/*
 		 * Update our multicast list.
		 */
		error = (cmd == SIOCADDMULTI) ?
			ether_addmulti((struct ifreq *)data, &us->us_ac):
			ether_delmulti((struct ifreq *)data, &us->us_ac);

#ifdef notneeded
		if (error == ENETRESET) {
			/*
			 * Multicast list has changed; set the hardware filter
			 * accordingly.
			 */
			ubinit(ifp->if_unit);
			error = 0;
		}
#endif
		break;
	default:
		error = EINVAL;
	}
	splx(s);
	return(error);
}

/*
 *  ubzap - initialize adapter but don't enable it.
 *  returns page number of next receive page to be used.
 */
ubzap(addr, ifp)
	register struct ubdevice *addr;
	register struct ifnet *ifp;
{
	register int next;

	MM_OUT(&addr->ub_csr, 0);		/* disable interrupts */
	MM_OUT(&addr->ub_edlc.reset, RESET_ON);
		/* set reset bit while init'ing */
	MM_OUT(&addr->ub_edlc.rstat, RS_CLEAR);
	MM_OUT(&addr->ub_edlc.xstat, XS_CLEAR);
	MM_OUT(&addr->ub_edlc.rmask, 0);
	MM_OUT(&addr->ub_edlc.xmask, 0);

	if (ifp == NULL) {
		MM_OUT(&addr->ub_edlc.rmode, RM_NORMAL);
	} else if (ifp->if_flags & IFF_PROMISC) {
		MM_OUT(&addr->ub_edlc.rmode, RM_ALL);
	} else if (ifp->if_flags & IFF_ALLMULTI) {
		MM_OUT(&addr->ub_edlc.rmode, RM_MULT);
	} else {
		MM_OUT(&addr->ub_edlc.rmode, RM_NORMAL);
	}

	/*
	 *  the next line puts the transmitter in loopback mode so
	 *  that a spurious packet is not sent when the reset bit is
	 *  cleared.
	 */
	MM_OUT(&addr->ub_edlc.tmode, TM_NORMAL - TM_LBC);
	MM_OUT(&addr->ub_edlc.reset, RESET_OFF); /* clear reset bit */
	/*
	 *  clear the receive buffers.  assign the value in the empty
	 *  page pointer to the full page pointer and clear the packet
	 *  available flag.
	 */
	next = MM_IN(&addr->ub_fppepp) & UB_PAGE_MASK;
		/* clears the IKSYDK flag */
	MM_OUT(&addr->ub_fppepp, next);		/* fpp = epp */
	UB_CLRPAV(addr);		/* clear the PAV flag */
	/*
	 *  delay for a few milliseconds so that the "spurious" packet will
	 *  be gone before the transmitter gets out of loopback mode (so
	 *  that garbage won't be sent out on the ethernet)
	 */
	delay(5);
	MM_OUT(&addr->ub_edlc.tmode, TM_NORMAL);
		/* put transmitter in normal mode */
	DEBUGF(ubdebug & 0x2, printf("ubzap: zzzzapped!\n");)
	return(next);
}

/*
 *  ubupdatefpp - update adapter's full page pointer and clear packet available
 *  flag if appropriate
 */
ubupdatefpp(addr, nextpage)
	register struct ubdevice *addr;
	register int nextpage;
{
	if (nextpage == /* EPP */ (MM_IN(&addr->ub_fppepp) & UB_PAGE_MASK))
		UB_CLRPAV(addr);
	MM_OUT(&addr->ub_fppepp, nextpage);	/* set FPP */
}

/*
 *  ubbcopy - similar to bcopy but can deal with packets that wrap
 *  around from the high end of the adapter's receive buffer to the
 *  low end
 */
ubbcopy(addr, from, to, len)
	register struct ubdevice *addr;
	register char *from;
	register char *to;
	register int len;
{
	register char *high_end = &addr->ub_rcvbuf[UB_LASTRBUF][UB_RBUFSIZE];
	register int n;

	if (from + len <= high_end){
		bcopyin(from, to, len);
	}
	else if (from >= high_end){
		from -= sizeof(addr->ub_rcvbuf);
		bcopyin(from, to, len);
	} else {
		n = high_end - from;
		bcopyin(from, to, n);
		to += n;
		bcopyin((char *)addr->ub_rcvbuf, to, len - n);
	}
}

/*
 *  ubgetushortatoff - return the u_short at offset in the received packet,
 *  handling wrap-around in the receive buffer and conversion between network
 *  and host formats as necessary.
 */
u_short ubgetushortatoff(addr, eh, off)
	register struct ubdevice *addr;
	register struct ether_header *eh;
	register int off;
{
	register char *high_end = &addr->ub_rcvbuf[UB_LASTRBUF][UB_RBUFSIZE];
	register char *p;

	p = (caddr_t)(eh + 1) + off;
	if (p >= high_end){
		p -= sizeof(addr->ub_rcvbuf);
	}
	return(ntohs((u_short) MM_INW(p)));
}

/*
 *  ubprintethaddr - print an ethernet address
 */
ubprintethaddr(p)
	register char *p;
{
	register int i;

	for (i = 0; i < ETH_ADDR_SIZE; i++){
		if (i != 0) printf(":");
		printf("%x", *p++);
	}
}

#endif NUB > 0
