/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/dev/RCS/psp.c,v 1.11 1994/05/22 12:26:24 roger Exp $ */
/* $ACIS:psp.c 12.0$ */
/* $Source: /sys/rt/dev/RCS/psp.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rt/dev/RCS/psp.c,v 1.11 1994/05/22 12:26:24 roger Exp $";
#endif

/*
 *  Planar Serial Port Driver
 */

#include "psp.h"

#if NPSP > 0
#include <sys/param.h>
#include <sys/conf.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/systm.h>
#include <sys/uio.h>
#include <sys/file.h>
#include "rt/rt/debug.h"
#include "rt/dev/pspreg.h"
#include <machine/io.h>
#include <sys/buf.h>
#include "rt/include/ioccvar.h"
#include "rt/include/softint.h"
#include <sys/kernel.h>		/* for hz */

#define spl_psp() _spl3()

struct pspdevice pspdevs[] = {
	{
		(u_char *) 0xf0008001,	       /* control channel A */
		(u_char *) 0xf0008003,	       /* data    channel A */
		(u_char *) 0xf0008020,	       /* ext_reg channel A */
		(u_char *) 0xf0008060	       /* int_ack */
	},
	{
		(u_char *) 0xf0008000,	       /* control channel B */
		(u_char *) 0xf0008002,	       /* data    channel B */
		(u_char *) 0xf0008040,	       /* ext_reg channel B */
		(u_char *) 0xf0008060	       /* int_ack */
	}
};

#define	npspdevs	(sizeof(pspdevs)/sizeof(struct pspdevice))

#define PSP_SETBAUD(psp, code) \
	do { \
	   if ((code) != -1) { \
	      PSP_REG_SET((psp), W14, W14_DIS_BDG); \
	      PSP_REG_SET((psp), W13, ((code)>>8) & 0xff); \
	      PSP_REG_SET((psp), W12, (code) & 0xff); \
	      PSP_REG_SET((psp), W14, W14_EN_BDG); \
	   } \
	} while(0)

struct speedtab pspspeedtab[] = {
	{     0,	0x0000 },
	{    50,	0x077e },
	{    75,	0x04fe },
	{   110,	0x0366 },
	{   134,	0x02ca },
	{   150,	0x027e },
	{   200,	0x01de },
	{   300,	0x013e },
	{   600,	0x009e },
	{  1200,	0x004e },
	{  1800,	0x0033 },
	{  2400,	0x0026 },
	{  4800,	0x0012 },
	{  9600,	0x0008 },
	{ 19200,	0x0003 },
	{    -1,	 -1    }
};

#define PSPNPORTS	2			/* Number of ports per card */
#define PSPNREG		16		        /* Number of registers */
#define PSPMAXUNIT	(NPSP * PSPNPORTS)	/* Maximum number of units */
#define PSP_CHANA	0		        /* psp channel A */
#define PSP_CHANB	1		        /* psp channel B */
#define PSPUNITMASK(unit)	(1 << ((unit) & 3))	/* mask for unit */
#define	PSPUNIT(dev)	minor(dev)
#define	PSPUNIT_A(unit)	((unit) & (~0x1))
#define	PSPUNIT_B(unit)	((unit) | (0x1))


int pspstart(), pspattach(), pspprobe(), pspint(), pspmint();
int pspparam(), pspmctl();
int ttrstrt();

struct	tty psp_tty[PSPMAXUNIT];		/* tty structure for port */

int npsp = PSPMAXUNIT;				/* for pstat */

char pspsoftCAR;		       		/* carrier detect flags */

struct pspsoftc {
	struct	pspdevice psp_dev;		/* device structure for port */
#define	psp_control	psp_dev.control
#define	psp_data	psp_dev.data
#define	psp_extreg	psp_dev.ext_reg
#define	psp_intack	psp_dev.int_ack
	char	*psp_nextc;			/* pointer to output buffer */
	char	*psp_endc;			/* end-of-buf pointer */
	u_char	psp_write_regs[PSPNREG];	/* soft copy of write regs */
	u_char	psp_msr;			/* saved modem status */
	u_char	psp_needsoft;			/* set to 1 if need soft int */
	u_char	psp_flags;
	char	psp_delayc;			/* character for delay */
} pspsoftc[PSPMAXUNIT];

#define	PSPF_CLOSING	0x1
#define	PSPF_LIVE	0x2
#define	PSPF_HASDELAY	0x4
#define	PSPF_NOINPUT	0x8


/*
 * XXX debugging statistics
 */
struct pspstats {
	int overruntotal;
	int overrunthisopen;
	int modemints;
	int modemsame;
	int modemup;
	int modemdown;
	int modembreak;
} pspstats[PSPMAXUNIT];

/*
 * Macros for reading and writing registers
 */
#define	PSP_REG_SET(psp, reg, data) \
	do { \
		*((psp)->psp_control) = (reg); \
		(psp)->psp_write_regs[(reg)] = (data); \
		*((psp)->psp_control) = (psp)->psp_write_regs[(reg)]; \
	} while (0)

#define	PSP_REG_BIS(psp, reg, data) \
	do { \
		*((psp)->psp_control) = (reg); \
		(psp)->psp_write_regs[(reg)] |= (data); \
		*((psp)->psp_control) = (psp)->psp_write_regs[(reg)]; \
	} while (0)

#define	PSP_REG_BIC(psp, reg, data) \
	do { \
		*((psp)->psp_control) = (reg); \
		(psp)->psp_write_regs[(reg)] &= ~(data); \
		*((psp)->psp_control) = (psp)->psp_write_regs[(reg)]; \
	} while (0)

/* like PSP_REG_SET, but don't remember register state */
#define	PSP_REG_WRITE(psp, reg, data) \
	do { \
		*((psp)->psp_control) = (reg); \
		*((psp)->psp_control) = (data); \
	} while (0)

/* XXX this is shit */
#define	PSP_REG_GET(psp, reg) \
	((*((psp)->psp_control) = (reg)) \
		? *((psp)->psp_control) \
		: *((psp)->psp_control))

/* Get the state of the RTS bit */
#define	PSPRTS(psp)	((psp)->psp_write_regs[W5] & W5_RTS)

/*
 * Compute a timeout time based on the characters remaining in the
 * output list.
 */
#define	PSPOUTTIME(tp) \
	(hz + 3 * hz * tp->t_outq.c_cc / (2 * tp->t_ospeed / 10))

struct iocc_device *pspdinfo[NPSP];

struct iocc_driver pspdriver = { 
	/* probe, slave, attach, dgo, addr, dname, dinfo, mname, csr, intr */
	pspprobe, 0, pspattach, 0, 0, "psp", pspdinfo, 0, 0, pspint
};

/* find an address which is safe to touch and put it in pspstd */
/* caddr_t pspstd[] = { 0, 0, 0 }; */

/*
 * Pspprobe will try to generate an interrupt so that the system can
 * determine whether or not the adapters specified in the config file
 * are truly present.
 */
/* ARGSUSED */
pspprobe(addr)
	register caddr_t addr;
{
	register struct pspsoftc *pspa;
	register struct pspsoftc *pspb;
	int speed, test1;
	int c;

	/*
	 * Figure out which one we're using
	 */
	for (c = 0; c < npspdevs; c++)
		if (addr == (caddr_t)(pspdevs[c].control))
			break;
	if (c == npspdevs)
		return(PROBE_BAD);

	/*
	 * c is now a unit number.  Initialize addresses in both related
	 * units.
	 */
	pspa = &pspsoftc[PSPUNIT_A(c)];
	pspb = &pspsoftc[PSPUNIT_B(c)];
	pspa->psp_dev = pspdevs[PSPUNIT_A(c)];
	pspb->psp_dev = pspdevs[PSPUNIT_B(c)];

	/*
	 * make sure we're in sync with the chip
	 */
	c = *(pspa->psp_control);
	c = *(pspb->psp_control);

	/* initialize the 8530 both channels */
	PSP_REG_WRITE(pspa, W9, W9_RST_HARD);	/* hardware reset */

	/* zero W15 and read it back.  the contents should be zero */
	PSP_REG_WRITE(pspa, W15, 0); 
	test1 = PSP_REG_GET(pspa, R15);
	if (test1 != 0) {
		return(PROBE_BAD);
	}

	PSP_REG_WRITE(pspa, W11, W11_SCLK);	/* Clock register */
	PSP_REG_WRITE(pspb, W11, W11_SCLK);	/* Clock register */
	PSP_REG_WRITE(pspa, W13, W13_B0); 	/* load time const */
	PSP_REG_WRITE(pspa, W12, W12_B0);

	/* enable master interrupt */
	PSP_REG_WRITE(pspa, W9, W9_EN_MI);    

	/* enable external interrupts */
	PSP_REG_WRITE(pspa, W1, W1_EN_EI);  

        /* enable zero count interrupts, write the zero bits */
	/* read R15 again.  The zero bits should still be zero */
	PSP_REG_WRITE(pspa, W15, W15_EN_ZCI|0x5); 
	test1 = PSP_REG_GET(pspa, R15);
	if (test1 != W15_EN_ZCI) {
		PSP_REG_WRITE(pspa, W9, W9_RST_HARD);	/* hardware reset */
		return(PROBE_BAD);
	}

        /* enable baud rate generation */
	PSP_REG_WRITE(pspa, W14, W14_EN_BDG);
	PROBE_DELAY(100000);

        /* disable baud rate generation */
	PSP_REG_WRITE(pspa, W14, W14_DIS_BDG);  
	*(pspa->psp_intack) = (char) 0;  	    /* interrupt acknowlege */

	/* reset the interrupt which we have generated */
	PSP_REG_WRITE(pspa, W0, W0_RST_IUS);
	PSP_REG_WRITE(pspa, W9, W9_RST_HARD);		/* hardware reset */
	PSP_REG_SET(pspa, W11, W11_SCLK);		/* Clock register */
	PSP_REG_SET(pspb, W11, W11_SCLK);		/* Clock register */

	/* set baud to default speed */
	speed = ttspeedtab(TTYDEF_SPEED, pspspeedtab);
	PSP_SETBAUD(pspa, speed);
	PSP_SETBAUD(pspb, speed);

	PSP_REG_SET(pspa, W9, W9_EN_MI);
	PSP_REG_SET(pspb, W9, W9_EN_MI);
	return (PROBE_OK);
}


pspattach(iod)
	register struct iocc_device *iod;
{
	register struct tty *tp;
	register int port;
	register struct pspsoftc *psp;

	/* XXX this knows there is one psp only */
	for (port = 0, tp = &psp_tty[port] ; port < PSPNPORTS; port++, tp++) { 
		psp = &pspsoftc[port];
		tp->t_addr= (caddr_t)psp;
		tp->t_state = 0;
		psp->psp_needsoft = 0;
		psp->psp_flags = PSPF_LIVE;
	}
	pspsoftCAR = iod->iod_flags;   /* modem control flags  */
}


/*ARGSUSED*/
pspopen(dev, flag)
	dev_t dev;
{
	register struct tty *tp;
	register int unit = PSPUNIT(dev);
	register int s, error;
	register struct pspsoftc *psp;
	struct iocc_device *iod;

	if (unit >= PSPMAXUNIT || (iod=pspdinfo[0]) == 0 || iod->iod_alive==0)
		return (ENXIO);
	tp = &psp_tty[unit];
	if (tp->t_state & TS_XCLUDE && u.u_uid != 0)
		return (EBUSY);

	psp = (struct pspsoftc *)tp->t_addr;
	if (psp != &pspsoftc[unit]) {
		printf("pspopen: tp->t_addr (%x) != &pspsoftc[unit] (%x)\n",
		    (int)psp, (int)&pspsoftc[unit]);
		return(ENXIO);
	}

#ifdef notdef
	if (psp->psp_flags & PSPF_CLOSING) {
		error = ttywait(tp);		/* wait til complete */
		if (error)
			return (error);
	}
#endif

	/* if this is the first open, initiallize tty state to defaults */
	s = spl_psp();
	if ((tp->t_state & TS_ISOPEN) == 0) {
		int x;

		psp->psp_flags &= ~(PSPF_CLOSING|PSPF_HASDELAY|PSPF_NOINPUT);
		ttychars(tp);
		tp->t_oproc = pspstart;
		tp->t_param = pspparam;
		tp->t_dev = dev;
		tp->t_iflag = TTYDEF_IFLAG;
		tp->t_oflag = TTYDEF_OFLAG;
		tp->t_cflag = TTYDEF_CFLAG;
		tp->t_lflag = TTYDEF_LFLAG;
		tp->t_ospeed = tp->t_ispeed = TTYDEF_SPEED;
		pspparam(tp, &tp->t_termios);
		ttsetwater(tp);
		(void) pspmctl(unit, TIOCM_DTR|TIOCM_RTS, DMBIS);
		pspstats[unit].overrunthisopen = 0;
		PSP_REG_SET(psp, W15, W15_EN_DCD | W15_EN_BRK);
		PSP_REG_SET(psp, W1, W1_EN_EI|W1_RXI_ALL);
		psp->psp_msr = PSP_REG_GET(psp, R0);
		/* read status and character to clear old errors */
	    	x = *(psp->psp_data);		        /* read char */
	    	x = PSP_REG_GET(psp, R1);		/* read status */
		if (x & (R1_PE | R1_OR | R1_FE))	/* reset status? */
	   		PSP_REG_WRITE(psp, W0, W0_RST_ERR);
	} 

	if ((pspsoftCAR & PSPUNITMASK(unit)) || (psp->psp_msr & R0_DCD))
		tp->t_state |= TS_CARR_ON;
	while ((flag&O_NONBLOCK) == 0 && (tp->t_cflag&CLOCAL) == 0 &&
	    (tp->t_state & TS_CARR_ON) == 0) {
		tp->t_state |= TS_WOPEN;
		if (error = ttysleep(tp, (caddr_t)&tp->t_rawq, TTIPRI | PCATCH,
		    ttopen, 0)) {
			tp->t_state &= ~TS_WOPEN;
			return (error);
		}
	}
	if ((tp->t_state & TS_CARR_ON) == 0 && (tp->t_cflag & CLOCAL) == 0)
		psp->psp_flags |= PSPF_NOINPUT;
	else
		psp->psp_flags &= ~PSPF_NOINPUT;

	(void) splx(s);
	error = (*linesw[tp->t_line].l_open)(dev, tp);
	return (error);
}


/*ARGSUSED*/
pspclose(dev)
	dev_t dev;
{
	register int unit = PSPUNIT(dev);
	register struct tty *tp = &psp_tty[unit];
	register struct pspsoftc *psp = (struct pspsoftc *)tp->t_addr;
	int s;
	int pspcls();

	s = spl_psp();
	if (psp->psp_flags & PSPF_CLOSING)
		return(0);
	if (tp->t_outq.c_cc > 0) {
		psp->psp_flags |= PSPF_CLOSING;
		timeout(pspcls, tp, PSPOUTTIME(tp)); /* set timeout for close */
	}

	(*linesw[tp->t_line].l_close)(tp);
	PSP_REG_BIC(psp, W5, W5_BRK); /* reset break */

	if (tp->t_cflag&HUPCL || tp->t_state&TS_WOPEN ||
	    (tp->t_state&TS_ISOPEN)==0) {
		/* disable all interrupts */
		PSP_REG_SET(psp, W1, 0); 
		(void) pspmctl(unit, 0, DMSET);
		psp->psp_flags |= PSPF_NOINPUT;
	}
	if (psp->psp_flags & PSPF_CLOSING) {	/* close in progress */
		untimeout(pspcls, tp);		/* cancel the timeout */
	}
	psp->psp_flags &= ~(PSPF_CLOSING|PSPF_HASDELAY);
	(void) splx(s);
	ttyclose(tp);
	return (0);
}

/*
 * routine called when close takes longer than it should to flush output
 * and get things going again
 */
pspcls(tp)
register struct tty *tp;
{
	register int s = spl_psp();
	register struct pspsoftc *psp = (struct pspsoftc *)tp->t_addr;

	if (psp->psp_flags & PSPF_CLOSING) {	/* if close in progress */
		ttyflush(tp, FREAD|FWRITE);
		psp->psp_flags &= ~PSPF_CLOSING;
	}
	(void) splx(s);
}


/*ARGSUSED*/
pspread(dev, uio, flag)
	register dev_t dev;
	register struct uio *uio;
	int flag;
{
	register struct tty *tp = &psp_tty[PSPUNIT(dev)];
	register int l;

	l = (*linesw[tp->t_line].l_read)(tp, uio, flag);
	return (l);
}


/*ARGSUSED*/
pspwrite(dev, uio, flag)
	dev_t dev;
	struct uio *uio;
	int flag;
{
	register struct tty *tp = &psp_tty[PSPUNIT(dev)];

	return ((*linesw[tp->t_line].l_write)(tp, uio, flag));
}


/*ARGSUSED*/
pspioctl(dev, cmd, data, flag)
	dev_t dev;
	caddr_t data;
{
	register int unit = PSPUNIT(dev);
	register struct tty *tp = &psp_tty[unit];
	register struct pspsoftc *psp;
	register int error, s;

	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag);

	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, data, flag);
	if (error >= 0)
		return (error);

	psp = (struct pspsoftc *)tp->t_addr;
	s = spl_psp();
	switch (cmd) {
	case TIOCSBRK:
		PSP_REG_BIC(psp, W5, W5_BRK);
		break;

	case TIOCCBRK:
		PSP_REG_BIS(psp, W5, W5_BRK);
		break;

	case TIOCSDTR:
		(void) pspmctl(unit, TIOCM_DTR|TIOCM_RTS, DMBIS);
		break;

	case TIOCCDTR:
		(void) pspmctl(unit, TIOCM_DTR|TIOCM_RTS, DMBIC);
		break;

	case TIOCMSET:
	case TIOCMODS:
		(void) pspmctl(dev, *(int *)data, DMSET);
		break;

	case TIOCMBIS:
		(void) pspmctl(dev, *(int *)data, DMBIS);
		break;

	case TIOCMBIC:
		(void) pspmctl(dev, *(int *)data, DMBIC);
		break;

	case TIOCMGET:
	case TIOCMODG:
		*(int *)data = pspmctl(dev, 0, DMGET);
		break;

	default:
		(void) splx(s);
		return (ENOTTY);
	}
	(void) splx(s);
	return (0);
}


/*
 * Setting the psp parameters (baud rate, data length, etc...)
 */
pspparam(tp, t)
	register struct tty *tp;
	register struct termios *t;
{
	register char txbits, mode, rxbits;
	register int s;
	register struct pspsoftc *psp = (struct pspsoftc *)tp->t_addr;
	register int cflag = t->c_cflag;
	int ospeed = ttspeedtab(t->c_ospeed, pspspeedtab);

	if (ospeed < 0 || (t->c_ispeed && t->c_ispeed != t->c_ospeed))
		return(EINVAL);
	tp->t_ispeed = t->c_ispeed;
	tp->t_ospeed = t->c_ospeed;
	tp->t_cflag = cflag;

	s = spl_psp();
	if (ospeed == 0) {
		(void) pspmctl(tp->t_dev, 0, DMSET);	/* hang up line */
		(void) splx(s);
		return(0);
	}

	if (cflag & CLOCAL) {
		psp->psp_flags &= ~PSPF_NOINPUT;
	} else if ((tp->t_state & TS_CARR_ON) == 0) {
		psp->psp_flags |= PSPF_NOINPUT;
	}

	/* Set the baud rate and initial psp settings */
	switch (cflag&CSIZE) {
	case CS5:
		rxbits = W3_RX_5BITS | W3_EN_RX;
		txbits = W5_TX_5BITS | W5_EN_TX;
		break;
	case CS6:
		rxbits = W3_RX_6BITS | W3_EN_RX;
		txbits = W5_TX_6BITS | W5_EN_TX;
		break;
	case CS7:
		rxbits = W3_RX_7BITS | W3_EN_RX;
		txbits = W5_TX_7BITS | W5_EN_TX;
		break;
	case CS8:
		rxbits = W3_RX_8BITS | W3_EN_RX;
		txbits = W5_TX_8BITS | W5_EN_TX;
		break;
	}

	if (cflag & CCTS_OFLOW)	/* see if we need CTS flow control */
		rxbits |= W3_AUTO_CDCTS;
	txbits |= PSPRTS(psp);		/* must include RTS flag here */

	mode = W4_CLOCK16;
	if (cflag & PARENB) {
		mode |= W4_EN_PAR;
		if ((cflag & PARODD) == 0)
			mode |= W4_EVENP;
	}
	if (cflag & CSTOPB)
		mode |= W4_STOP2;
	else
		mode |= W4_STOP1;

	PSP_SETBAUD(psp, ospeed);
	PSP_REG_SET(psp, W4, mode); 	/* set the mode */
	PSP_REG_SET(psp, W3, rxbits);	/* then choose your options */
	PSP_REG_SET(psp, W5, txbits);
	(void) splx(s);
	return(0);
}


/* ARGSUSED */
pspint(ctlr)
	register int ctlr;
{
	register unsigned char port;
	register int didit_a, didit_b;
	register int totalints = 0;
	/* XXX this truly knows we only have two ports */
	register struct pspsoftc *psp_a = &pspsoftc[0];
	register struct pspsoftc *psp_b = &pspsoftc[1];

	*(psp_a->psp_intack) = (char) 0;	/* interrupt acknowlege */
	while ((port = PSP_REG_GET(psp_a, R3)) != 0) {
		didit_a = didit_b = 0;
		if (port & R3_RXIP_A) {
			psprint(psp_a, PSP_CHANA);
			didit_a++;
		}
		if (port & R3_RXIP_B) {
			psprint(psp_b, PSP_CHANB);
			didit_b++;
		}
		if (port & R3_EXIP_A) {
			pspmint(psp_a, PSP_CHANA);
			didit_a++;
		}
		if (port & R3_EXIP_B) {
			pspmint(psp_b, PSP_CHANB);
			didit_b++;
		}
		if (port & R3_TXIP_A) {
			pspxint(psp_a, PSP_CHANA);
			didit_a++;
		}
		if (port & R3_TXIP_B) {
			pspxint(psp_b, PSP_CHANB);
			didit_b++;
		}
		if (didit_a) PSP_REG_WRITE(psp_a, W0, W0_RST_IUS);
		if (didit_b) PSP_REG_WRITE(psp_b, W0, W0_RST_IUS);
		if (didit_a || didit_b)
			totalints++;
	}
	return (totalints == 0);
}


psprint(psp, unit)
	register struct pspsoftc *psp;
	register int unit;
{
	struct tty *tp = &psp_tty[unit];
	register char savelsr;
	register int c;
	char	exint_pending;

	exint_pending = (unit ? R3_EXIP_B : R3_EXIP_A);

	while ((PSP_REG_GET(psp, R0) & R0_DR) &&
	       ((PSP_REG_GET(&pspsoftc[0], R3) & exint_pending) == 0) ) {

	    	savelsr = PSP_REG_GET(psp, R1);		/* read status */
	    	c = *(psp->psp_data);	 	       /* read char */
		if (savelsr & (R1_PE | R1_OR | R1_FE)) {
	   		PSP_REG_WRITE(psp, W0, W0_RST_ERR);
		    	if (savelsr & R1_OR) {
				pspstats[unit].overrunthisopen++;
				pspstats[unit].overruntotal++;
				continue;
		    	}
		    	if (savelsr & R1_PE)
				c |= TTY_PE;
			if ( savelsr & R1_FE )
				c |= TTY_FE;
	    	}

		if ((psp->psp_flags & PSPF_NOINPUT) == 0)
			(*linesw[tp->t_line].l_rint)(c, tp);
	} /* end while */
}


/*
 * Got a transmitter empty interrupt;
 * the psp wants another character.
 */
pspxint(psp, unit)
	register struct pspsoftc *psp;
	int unit;
{
	register struct tty *tp = &psp_tty[unit];

	/*
	 * Reset transmitter interrupt
	 */
	PSP_REG_WRITE(psp, W0, W0_RST_TXIP);

	/*
	 * If we aren't busy this was spurious.  Just ignore it
	 */
	if ((tp->t_state & TS_BUSY) == 0)
		return;

	/*
	 * Loop sending data if we have any.  Otherwise schedule a
	 * soft interrupt.
	 */
	if (psp->psp_nextc < psp->psp_endc) {
		do {
			if ((PSP_REG_GET(psp, R0) & R0_TXE) == 0)
				return;			  /* more to do */
			*(psp->psp_data) = *(psp->psp_nextc);
			(psp->psp_nextc)++;
		} while (psp->psp_nextc < psp->psp_endc);
	} else {
		if (psp->psp_needsoft == 0) {
			psp->psp_needsoft = 1;
			setsoftPSP();
		}
	}
}

softpsp()
{
	register struct tty *tp;
	register int unit;
   	register int s;	
	register struct pspsoftc *psp;
 
	for (unit = 0; unit < PSPMAXUNIT; unit++) {
		if ((psp = &pspsoftc[unit])->psp_needsoft) {
			tp = &psp_tty[unit];
			s = spl_psp();
			PSP_REG_BIC(psp, W1, W1_EN_TXI); 
			tp->t_state &= ~TS_BUSY;
			psp->psp_needsoft = 0;
			psp->psp_endc = psp->psp_nextc;
			if (tp->t_state & TS_FLUSH)
				tp->t_state &= ~TS_FLUSH;
			else
				ndflush(&tp->t_outq,
				    psp->psp_nextc - tp->t_outq.c_cf);
			(void) splx(s);

			if (tp->t_line)
				(*linesw[tp->t_line].l_start)(tp);
			else
				pspstart(tp);
		}
	}
}


pspstart(tp)
	register struct tty *tp;
{
	register int s, c, n;
	register struct pspsoftc *psp = (struct pspsoftc *)tp->t_addr;

	s = spl_psp();
	if (tp->t_state & (TS_TIMEOUT | TS_BUSY | TS_TTSTOP)) {
		splx(s);
		return;
	}

	/*
	 * First stuff as many characters as we can out to the
	 * device.  This may suffice for single character echos.
	 */
	n = 0;
	if ((psp->psp_flags & PSPF_HASDELAY) == 0) {
		while (PSP_REG_GET(psp, R0) & R0_TXE) {
			c = getc(&tp->t_outq);
			if (c == -1)
				break;
			if (c & TTY_QUOTE) {
				/* Save timeout value and quit */
				psp->psp_delayc = (char) c;
				psp->psp_flags |= PSPF_HASDELAY;
				break;
			}
			/* If this is first character, turn on interrupt */
			if (n == 0) {
				PSP_REG_BIS(psp, W1, W1_EN_TXI);
				tp->t_state |= TS_BUSY;
			}
			*(psp->psp_data) = (char)c;
			n++;
		}
	}

	/*
	 * Awake sleepers if there are any
	 */
	if (tp->t_outq.c_cc <= tp->t_lowat) {
		if (tp->t_state & TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t) & tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}

	/*
	 * If we haven't sent anything do any delay.  Otherwise we'll
	 * get to it next time.
	 */
	if (psp->psp_flags & PSPF_HASDELAY) {
		if (n == 0) {
			timeout(ttrstrt, (caddr_t)tp,
			    ((int)psp->psp_delayc & 0177)+6);
			psp->psp_flags &= ~PSPF_HASDELAY;
			tp->t_state |= TS_TIMEOUT;
		}
		splx(s);
		return;
	}


	/*
	 * If we got here there was no pending delay.  Note that
	 * if n is non-zero, c still contains the last character
	 * sent.  If c isn't -1 there still may be characters
	 * left in the output queue.  See if there are.
	 *
	 * Note there is a problem with the 4.3 reno ndqb() in that
	 * it won't detect delays correctly.  What it really should
	 * do is return -1 if the next character is a delay, or the
	 * character count up to the next delay otherwise.  The code
	 * is written assuming this.
	 */
	psp->psp_endc = psp->psp_nextc;
	if (n > 0 && c != (-1)) {
		n = ndqb(&tp->t_outq, 0);
		if (n > 0) {
			psp->psp_nextc = tp->t_outq.c_cf;
			psp->psp_endc = psp->psp_nextc + n;
		}
	}
	(void) splx(s);
}


/*  
 *  When an external interrupt is generated, all of the interrupts are
 *  latched.  Break is the only one which generates an interrupt for 
 *  both the high-to-low and low-to-high transition.   This means it
 *  is necessary to save a copy of the old msr in memory, then read
 *  the current one and see which bits have changed.  The only
 *  interrupts enabled are BRK and DCD so we must check for both here.
 */
pspmint(psp, unit)
	register struct pspsoftc *psp;
	register int unit;
{
	register int c;
	register struct tty *tp = &psp_tty[unit];
	register u_char newmsr, msrdiff;

	newmsr = PSP_REG_GET(psp, R0);
	pspstats[unit].modemints++;

	msrdiff = psp->psp_msr ^ newmsr; /* interrupts which have changed */
	if (msrdiff == 0) {
		pspstats[unit].modemsame++;
		PSP_REG_WRITE(psp, W0, W0_RST_EI);
		return;
	}

	if ((msrdiff & R0_DCD) && (pspsoftCAR & PSPUNITMASK(unit)) == 0) {
		if (newmsr & R0_DCD) {
			pspstats[unit].modemup++;
			c = (*linesw[tp->t_line].l_modem)(tp, 1);
		} else {
			pspstats[unit].modemdown++;
			c = (*linesw[tp->t_line].l_modem)(tp, 0);
		}
		if (c == 0) {
			psp->psp_flags |= PSPF_NOINPUT;
		} else {
			psp->psp_flags &= ~PSPF_NOINPUT;
		}
	}
	if (msrdiff & R0_BRK & psp->psp_msr) {	/* 1 -> 0 transition */
						/* end of a break */
		c = *psp->psp_data;  		/* read extra null char */
		pspstats[unit].modembreak++;
		if ((psp->psp_flags & PSPF_NOINPUT) == 0)
			(*linesw[tp->t_line].l_rint)(TTY_FE, tp);
	}

	psp->psp_msr = newmsr; /* store away the newmsr for next interrupt */
	PSP_REG_WRITE(psp, W0, W0_RST_EI);
}


/*
 * Stop output on a line
 */
pspstop(tp, rw)
	register struct tty *tp;
	register int rw;
{
	register int s;
	register struct pspsoftc *psp;

	s = spl_psp();
	if (tp->t_state & TS_BUSY) {
		psp = (struct pspsoftc *)tp->t_addr;
		psp->psp_endc = psp->psp_nextc;
		if (rw & FWRITE)	/* If we're flushing the output */
			tp->t_state |= TS_FLUSH;
	}
	(void) splx(s);
}


/*
 * set/get modem control
 */
int
pspmctl(dev, bits, how)
	dev_t dev;
	int bits, how;
{
	register struct pspsoftc *psp;
	register int unit, status, extstat;
	int s;

	unit = PSPUNIT(dev);
	psp = &pspsoftc[unit];
	s = spl_psp();
	switch (how) {
	case DMSET:
		if (bits & TIOCM_DTR)
			*psp->psp_extreg = (char)EXT_DTR;
		else
			*psp->psp_extreg = (char)0;
		if (bits & TIOCM_RTS)
			PSP_REG_BIS(psp, W5, W5_RTS);
		else
			PSP_REG_BIC(psp, W5, W5_RTS);
		break;

	case DMBIS:
		if (bits & TIOCM_DTR)
			*psp->psp_extreg = (char)EXT_DTR;
		if (bits & TIOCM_RTS)
			PSP_REG_BIS(psp, W5, W5_RTS);
		break;

	case DMBIC:
		if (bits & TIOCM_DTR)
			*psp->psp_extreg = (char)0;
		if (bits & TIOCM_RTS)
			PSP_REG_BIC(psp, W5, W5_RTS);
		break;

	case DMGET:
		bits = 0;
		extstat = *psp->psp_extreg;
		status = PSP_REG_GET(psp, R0);
		if (extstat & EXT_DTR)
			bits |= TIOCM_DTR;
		if (extstat & EXT_DSR)
			bits |= TIOCM_DSR;
		if (extstat & EXT_RI)
			bits |= TIOCM_RI;
		if (PSPRTS(psp))
			bits |= TIOCM_RTS;
		if (status & R0_DCD)
			bits |= TIOCM_CD;
		if (status & R0_CTS)
			bits |= TIOCM_CTS;
		break;
	}
	(void) splx(s);
	return(bits);
}


pspselect(dev, rw)
	dev_t dev;
	int rw;
{
	return ttselect(dev, rw);
}


/*
 * called from ../rt/trap.c
 */
pspreset ()
{
	register struct pspsoftc *psp;
	register struct tty *tp;
	register int port;
	register int s, x;

	x = IN(CRRB);
	x &= RESET8530;		/* reset is forced active */
	OUT(CRRB, x);

	x = IN(CRRB);
	x |= RELEA8530;		/* reset is forced inactive */
	OUT(CRRB, x);

	for (port = 0, tp = &psp_tty[0] ; port < PSPNPORTS; port++, tp++) {
		psp = &pspsoftc[port];
		if (!(psp->psp_flags & PSPF_LIVE))
			continue;
		if ((port & 0x1) == 0)
			PSP_REG_SET(psp, W9, W9_RST_HARD);
		PSP_REG_WRITE(psp, W0, W0_RST_IUS);
		PSP_REG_SET(psp, W11, W11_SCLK); /* Clock register */
		if (tp->t_state & TS_ISOPEN) {	/* reset if already opened */
			pspparam(tp, &tp->t_termios);
			s = spl_psp();
			(void) pspmctl(port, TIOCM_RTS|TIOCM_DTR, DMSET);
			PSP_REG_SET(psp, W1, W1_RXI_ALL|W1_EN_EI);
			if (tp->t_state & TS_BUSY)
				PSP_REG_BIS(psp, W1, W1_EN_TXI);
			PSP_REG_SET(psp, W15, W15_EN_DCD|W15_EN_BRK);
			(void) splx(s);
		}
		PSP_REG_SET(psp, W9, W9_EN_MI);
	}
}

#endif NPSP
