/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/pspreg.h,v 1.1 1991/11/24 16:44:28 md Exp $ */
/* $ACIS:pspreg.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/pspreg.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidpspreg = "$Header: /usr/src/sys/rtio/RCS/pspreg.h,v 1.1 1991/11/24 16:44:28 md Exp $";
#endif

/*
 * This version includes the description of registers and bits 
 * related to asynchronous operation only 
 */

/* Bit definition for the external registers. Read function */

#define	EXT_DTR		0x01	/*  1= active  Data Terminal Ready   */
#define	EXT_DSR		0x02	/*  1= active  Data Set Ready        */
#define	EXT_RI		0x04	/*  1= active  Ring indicator        */
#define	EXT_DSRCHG	0x08	/*  0= DSR has changed or RI is active */
#define	EXT_DMATC	0x10	/*  0= Terminal count (DMA) */

/* Bit definition for the external registers.  Write function */
#define	EXT_EN_DMA01	0x02	/*  1= Enable DMA and use 
					DMA channel 0 for psp0
					DMA channel 1 for psp1      */
#define	EXT_EN_DMA23	0x04	/*  1= Enable DMA and use
					DMA channel 2 for psp0
					DMA channel 3 for psp1      */
#define EXT_CLR_DSR	0x08	/*  1= clear int. generated by DSR & RI */
#define	EXT_CLR_DMATC	0x10	/*  1= Clear int. generated by DMA_TC   */
#define	EXT_EN_LINE	0x20	/*  1= Enable int. DSR/RI, DMA_TC       */

/* Definitions needed for pspreset */
#define RESET8530	0xfe	    /* reset the 8530 chip */
#define RELEA8530	0x1	    /* release the 8530 chip */

/*
 * WRITE REGISTERS: W0, W1, W3, W4, W5, W9, W11, W12, W13, W14 W15 
 */

/* Bits in W0 - Commands Register */
#define	W0_RST_EI	0x10	/* reset EXT/STATUS interrupts */
#define	W0_RST_RXIP	0x20	/* enable Rx interrupt on next char */
#define W0_RST_TXIP 	0x28	/* reset transmit interrupt pending */
#define W0_RST_ERR	0x30	/* reset error (overrun, framming & parity) */
#define W0_RST_IUS	0x38	/* reset interrupt under service */

/* Bits in W1  - Transmit/Receive Interrupt and Data Transfer Mode Register */
#define W1_EN_EI	0x01	/* Enable external interrupts */
#define W1_EN_TXI	0x02	/* Enable transmitter interrupts */
#define W1_PARSPE	0x04	/* parity special */
#define W1_RXI_ALL	0x10	/* interrupt on all received characters */

/* Bits is W3 - Receiver Parameters and Control Register */
#define	W3_AUTO_CDCTS	0x20	/* enable CTS xmit control */
#define W3_RX_5BITS	0x00	/* Receive 5 bits */
#define W3_RX_7BITS	0x40	/* Receive 7 bits */
#define W3_RX_6BITS	0x80	/* Receive 6 bits */
#define W3_RX_8BITS	0xC0	/* Receive 8 bits */
#define	W3_EN_RX	0x01	/* Enable receiver */

/* Bits in W4 - Miscellaneous Transmit/Receive Parameters & Modes Register */
#define W4_EN_PAR	0x01	/* Enable parity  */
#define W4_EVENP	0x02	/* Even parity   */
#define W4_STOP1	0x04	/* One stop bit  */
#define W4_STOP2	0x0C	/* Two stop bits */
#define W4_CLOCK16	0x40	/* Clock rate = (16 x the data rate) */

/* Bits in W5 - Transmit Parameter and Controls Register */
#define	W5_TX_5BITS	0x00	/* Transmit 5 bits */
#define	W5_TX_6BITS	0x40	/* Transmit 6 bits */
#define	W5_TX_7BITS	0x20	/* Transmit 7 bits */
#define	W5_TX_8BITS	0x60	/* Transmit 8 bits */
#define W5_RTS		0x02	/* Request To Send */
#define W5_EN_TX	0x08	/* Enable transmitter */ 
#define W5_BRK		0x10	/* Send break */

/* Bits in W9 - Master Interupt Control Register */
#define W9_RST_B	0x40	/* reset channel B */
#define W9_RST_A	0x80	/* reset channel A */
#define W9_RST_HARD	0xC0	/* force hardware reset */
#define W9_EN_MI	0x08	/* Master Interrupt Enable */
#define W9_NOVECT	0x02	/* No vector in interrupt Acknoewlege Reg */

/* Bits in W11 - Clock Mode Control Register */
#define W11_SCLK	0x56	/* set both rec & trans clock to BR generator */

/* Bits in W12 - Lower Byte of Baud Rate Generator Time Constant */
#define W12_B0		0xff	/* 0 baud rate */

/* Bits in W13 - Upper Byte of Baud Rate Generator Time Constant */
#define W13_B0		0xff	/* 0 baud rate */

/* Bits in W14 - Control Baud Rate Generation */
#define W14_DIS_BDG	0x00	/* disable baud rate generation */
#define W14_EN_BDG	0x01	/* enable baud rate generation */

/* Bits in W15 - External/Status (modem) Interrupt Control Register */
#define W15_EN_ZCI	0x02	/* enable zero count interrupts */
#define W15_EN_DCD	0x08	/* enable carrier detect */
#define W15_EN_BRK	0x80	/* enable break detect */

/*
 * READ REGISTERS: R0, R1, and R3
 */

/* Bits in R0 - Transmit/receive buffer Status and External Status Register */
#define R0_DR		0x01	/* Data Ready (Receive Character Ready) */
#define R0_TXE		0x04	/* Transmitter empty */
#define R0_DCD		0x08	/* Carrier detect */
#define	R0_CTS		0x20	/* clear to send */
#define R0_BRK		0x80	/* Break */
#define R0_FMT		"\20\1DR\3TXE\4DCD\10BRK"

/* Bits in R1 - Special Receive Condition status Register */
#define	R1_ALL_SENT	0x01	/* all character have been transmitted */
#define R1_PE		0x10	/* Parity error */
#define R1_OR		0x20	/* Overrun error */
#define R1_FE		0x40	/* Framing error */
#define R1_FMT		"\20\1ALL_XMT\5PARITY_ERR\6OVERRUN\7FRAME_ERR"

/* Bits in R3 - Interrupt Pending Register */
#define R3_EXIP_B      0x01	/* Channel B External Interrupt Pending */
#define R3_TXIP_B      0x02	/* Channel B Transmit Interrupt Pending */
#define R3_RXIP_B      0x04	/* Channel B Receive  Interrupt Pending */
#define R3_EXIP_A      0x08	/* Channel A External Interrupt Pending */
#define R3_TXIP_A      0x10	/* Channel A Transmit Interrupt Pending */
#define R3_RXIP_A      0x20	/* Channel A Receive  Interrupt Pending */
#define R3_FMT		"\20\1EXIP_B\2TXIP_B\3RXIP_B\4EXIP_A\5TXIP_A\6RXIP_A"

/*
 * Planar serial port register definition
 */
struct pspdevice {
	 u_char volatile *control;
	 u_char volatile *data;
	 u_char volatile *ext_reg;
	 u_char volatile *int_ack;
};

#define REGMASK	0x0f

/* Write Registers */
#define W0 0
#define W1 1
#define W2 2
#define W3 3
#define W4 4
#define W5 5
#define W6 6
#define W7 7
#define W8 8
#define W9 9
#define W10 10
#define W11 11
#define W12 12
#define W13 13
#define W14 14
#define W15 15

/* Read Registers */
#define R0  0
#define R1  1
#define R2  2
#define R3  3
#define R4  4
#define R5  5
#define R6  6
#define R7  7
#define R8  8
#define R12 12
#define R13 13
#define R15 15
