/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/scsiconfig.h,v 1.1 1988/12/09 22:52:06 md Exp $ */
/* $ACIS:scsiconfig.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/scsiconfig.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidscsiconfig = "$Header: /usr/src/sys/rtio/RCS/scsiconfig.h,v 1.1 1988/12/09 22:52:06 md Exp $";
#endif

/*
 * the following defines and structures relate to the VRM 
 * minidisk directory 
 */

#define ENDLIST -1	/* end of list marker */
#define START_BLOCK(sectors)	((sectors)*4)	/* start of allocatable space */

struct miniheader {
	long number;		/* number of entries */
	long level;		/* revision level */
	short unused;		/* index of next unused entry */
	short lastused;		/* index of entry most recently used */
	short first;		/* first entry */
	short last;		/* last entry index */
	long bad_block;		/* first bad block */
	long bad_size;		/* number of bad blocks */
	long unused2;		/* reserved */
	long unused3;		/* reserved */
};

struct minidisk {
	short previous;		/* 0 link to previous entry */
	short next;		/* 2 line to next entry */
	char name[4];		/* 4 name of minidisk */
	unsigned :32;		/* 8 */
	long date;		/* 12 the date of creation */
	short iodn;		/* 16 the IODN used */
#define nextfree iodn		/* 	hokey way of doing it! */
	char blocksize;		/* 18 filesystem block size (bits 0-3) */
#define BLOCK_512	0
#define BLOCK_1024	1
#define BLOCK_2048	3
	char type;		/* 19 type flags */
#define TYPE_RESERVED	0x80	/* reserved */
#define TYPE_NOBADBLOCK	0x40	/* no bad block forwarding on this disk */
#define TYPE_PAGE	0x20	/* pageing space */
#define TYPE_FILE	0x10	/* AIX file system */
#define TYPE_AIX	0x08	/* AIX system minidisk */
#define TYPE_PC		0x04	/* coprocessor disk */
#define TYPE_VRM	0x02	/* VRM */
#define TYPE_IPL	0x01	/* IPL'able */
	long unused;		/* 20 */
	long start;		/* 24 start block of partition */
	long size;		/* 28 size of partition */
				/* 32 total length */
};
#define ISFREE(disk) ((disk)->iodn == 0)

#ifdef KERNEL
#define MAXDISKS 23		/* keep size down for kernel use */
#else
#define MAXDISKS 47		/* actual minidisk size */
#endif KERNEL

#define MINIDISK_BLOCK	3	/* starting block number of minidisk */
#define MINIDISK_BLOCK2(sectors)	((sectors)+14)	/* starting block number of minidisk copy */
#define BLOCK_SIZE	512
#define ROUND(a,b) (a+b-1)/b*b	/* round up to next unit of b */

struct minidirectory {
struct miniheader header;
struct minidisk minidisk[MAXDISKS];
};

#define MINISIZE	(ROUND(sizeof (struct minidirectory), BLOCK_SIZE))
