#! /bin/sh
# $Header: /sys/dist/bin/RCS/ls.sh,v 1.1 1988/12/09 22:53:11 md Exp $ 
# $ACIS:ls.sh 12.0$ 
# $Source: /sys/dist/bin/RCS/ls.sh,v $ 
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
mode="'--- --x -w- -wx r-- r-x rw- rwx '"
doneit=""
recurse=${recurse-yes}
RECURSE=${RECURSE}
stat=${stat-lstat}
for i
do
	case "$i" in
-d)	recurse=
	;;
-R)	RECURSE=yes
	;;
-L)	stat=stat
	;;
-i)	args="$args = \&4 ! 4 \; printf '%6d ' $ \; "
	;;
-l)	
	args="$args = \&8 ! 2 \; = \$ \>\> 12 \; = \$ \'\& 15 \; = '--c-d-b---l-s-' \'+ \$ \; = \$ ! 1 \; printf '%c' $ \; " # mode
	args="$args = \&8 ! 2 \; = \$ \>\> 6 \; = \$ \'\& 7 \; = \$ \<\< 2 \; = $mode \'+ \$ \; printf '%.3s' $ \; " # mode
	args="$args = \&8 ! 2 \; = \$ \>\> 3 \; = \$ \'\& 7 \; = \$ \<\< 2 \; = $mode \'+ \$ \; printf '%.3s' $ \; " # mode
	args="$args = \&8 ! 2 \; = \$ \'\& 7 \; = \$ \<\< 2 \; = $mode \'+ \$ \; printf '%.3s ' $ \; " # mode
#	args="$args = \&8 ! 2 \; = \$ \'\& 0777 \; printf '%3o ' $ \; " # mode
	args="$args = \&10 ! 2 \; printf '%2d ' $ \; " # links
	args="$args = \&12 ! 2 \; printf '%-7d ' $ \; " # owner
	args="$args = \&20 ! 4 \; printf '%9d ' $ \; " # size
	args="$args ctime \&24 \; = \$ \'\+ 4 \; printf '%.12s ' $ \; " # date
	;;
-v)	verbose=-v;;

*)
	doneit=$i
	eval "	/etc/syscall $verbose $stat $i \&0 \; = \&0 ! 2 \; $args printf '%s%c' $i 0xa"
	case "$recurse" in
	yes)
		if ( cd $i ) 2>/dev/null
		then
			( recurse=$RECURSE; cd $i ; set -$- * ; . $0 )
		fi
		;;
	esac
	;;
esac
done
case "$doneit" in
"")
	set -$- *
	case "$1" in 
	"*")	;;
	*)
		. $0 
		;;
	esac
	;;
esac
