#!/bin/sh
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header: /sys/dist/etc/RCS/mkconfig.sh,v 1.1 1988/12/09 22:53:22 md Exp $ 
# $ACIS:mkconfig.sh 12.0$ 
# $Source: /sys/dist/etc/RCS/mkconfig.sh,v $ 
# usage: mkconfig
#	create the appropriate rc.config file
CMD=`basename $0` 

hostname=${hostname-master}
network=${network-un0}
net_flags=${net_flags-''}
network_2=${network_2-''}
net_flags_2=${net_flags_2-''}
hostname_2=${hostname_2-''}
net_install_host=${net_install_host-master}
net_install_addr=${net_install_addr-''}
rc_start=${rc_start-''}
rc_end=${rc_end-''}
net_extra=${net_extra-''}
rc_local_start=${rc_local_start-''}
rc_local_end=${rc_local_end-''}
system_type=${system_type-full}
core_directory=${core_directory-/usr/tmp}
use_timed=${use_timed-no}
use_named=${use_named-yes}
use_rvd=${use_rvd-yes}
use_sendmail=${use_sendmail-yes}
use_afpa=${use_afpa-yes}
use_afs=${use_afs-yes}
use_nfs=${use_nfs-yes}
use_dfs=${use_dfs-yes}
domainname=${domainname-''}
yp_client=${yp_client-no}
yp_server=${yp_server-no}
yp_master=${yp_master-no}
use_biod=${use_biod-yes}
use_statd=${use_statd-no}
use_lockd=${use_lockd-no}
use_pp4216=${use_pp4216-yes}
use_lpd=${use_lpd-yes}
ipl_cpu=${ipl_cpu-''}

echo "\
# The hostname of the machine
hostname='$hostname'

# The network (un0 or lan0) used by the machine
network='$network'

# Additional flags to be passed to ifconfig
net_flags='$net_flags'

# The secondary network device on the machine
network_2='$network_2'

# Additional flags to be passed to ifconfig for the
# second network adapter
net_flags_2='$net_flags_2'

# The secondary hostname of the machine
hostname_2='$hostname_2'

# Name of the net_install_host.
net_install_host='$net_install_host'

# Hardware address of master's network card
net_install_addr='$net_install_addr'

# Do this at the beginning of /etc/rc
rc_start='$rc_start'

# Do this at the end of /etc/rc
rc_end='$rc_end'

# Do this after starting up the network
net_extra='$net_extra'

# Do this at the beginning of /etc/rc.local
rc_local_start='$rc_local_start'

# Do this at the end of /etc/rc.local
rc_local_end='$rc_local_end'

# Configuration of system:
#	full: local root and usr partitions
#	reduced: local root partition,
#		 usr partition via AFS
#	minimal: minimal local root partition,
#		 root partition via NFS,
#		 usr partition via AFS
#	nfsreduced: local root partition,
#		    usr partition via NFS
#	nfsminimal: minimal local root partition,
#		    root partition via NFS,
#		    usr partition via NFS
system_type='$system_type'

# Directory to save system dumps after kernel panics
core_directory='$core_directory'

# Do we use timed?
use_timed='$use_timed'

# Do we use named?
use_named='$use_named'

# Do we use rvd?
use_rvd='$use_rvd'

# Do we use sendmail?
use_sendmail='$use_sendmail'

# Do we load the afpa microcode?
use_afpa='$use_afpa'

# Do we start up afs?
use_afs='$use_afs'

# Do we use nfs?
use_nfs='$use_nfs'

# Do we use dfs?
use_dfs='$use_dfs'

# Set domain name to this
domainname='$domainname'

# Are we a yp client?
yp_client='$yp_client'

# Are we a yp server?
yp_server='$yp_server'

# Are we a yp master?
yp_master='$yp_master'

# Do we start up biod?
use_biod='$use_biod'

# Do we start up statd?
use_statd='$use_statd'

# Do we start up lockd?
use_lockd='$use_lockd'

# Do we load pp4216 microcode?
use_pp4216='$use_pp4216'

# Do we start up lpd?
use_lpd='$use_lpd'

# Do we ipl any secondary CPU(s)?
ipl_cpu='$ipl_cpu'"
